/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.sourceformatter.JavaClass;
import com.liferay.portal.tools.sourceformatter.JavaTerm;
import java.util.Comparator;
import java.util.List;

public class JavaTermComparator
implements Comparator<JavaTerm> {
    private boolean _ascending;

    public JavaTermComparator() {
        this(true);
    }

    public JavaTermComparator(boolean ascending) {
        this._ascending = ascending;
    }

    @Override
    public int compare(JavaTerm javaTerm1, JavaTerm javaTerm2) {
        int value = this.doCompare(javaTerm1, javaTerm2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    protected int compareParameterTypes(JavaTerm javaTerm1, JavaTerm javaTerm2) {
        List<String> parameterTypes2 = javaTerm2.getParameterTypes();
        if (parameterTypes2.isEmpty()) {
            return 1;
        }
        List<String> parameterTypes1 = javaTerm1.getParameterTypes();
        if (parameterTypes1.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < parameterTypes1.size(); ++i) {
            if (parameterTypes2.size() < i + 1) {
                return 1;
            }
            String parameterType1 = parameterTypes1.get(i);
            String parameterType2 = parameterTypes2.get(i);
            if (parameterTypes1.size() != parameterTypes2.size() && (parameterType1.equals(parameterType2.concat("...")) || parameterType2.equals(parameterType1.concat("...")))) continue;
            if (parameterType1.compareToIgnoreCase(parameterType2) != 0) {
                return parameterType1.compareToIgnoreCase(parameterType2);
            }
            if (parameterType1.compareTo(parameterType2) == 0) continue;
            return -parameterType1.compareTo(parameterType2);
        }
        return -1;
    }

    protected int doCompare(JavaTerm javaTerm1, JavaTerm javaTerm2) {
        int type2;
        int type1 = javaTerm1.getType();
        if (type1 != (type2 = javaTerm2.getType())) {
            return type1 - type2;
        }
        String name1 = javaTerm1.getName();
        String name2 = javaTerm2.getName();
        if (JavaClass.isInJavaTermTypeGroup(type1, JavaClass.TYPE_VARIABLE)) {
            if (StringUtil.isUpperCase((String)name1) && !StringUtil.isLowerCase((String)name1) && !StringUtil.isUpperCase((String)name2)) {
                return -1;
            }
            if (!StringUtil.isUpperCase((String)name1) && StringUtil.isUpperCase((String)name2) && !StringUtil.isLowerCase((String)name2)) {
                return 1;
            }
        }
        if (type1 == 20) {
            if (name2.equals("_log") || name2.equals("_logger")) {
                return 1;
            }
            if (name1.equals("_instance") || name1.equals("_log") || name1.equals("_logger")) {
                return -1;
            }
            if (name2.equals("_instance")) {
                return 1;
            }
        }
        if (name1.compareToIgnoreCase(name2) != 0) {
            NaturalOrderStringComparator naturalOrderStringComparator = new NaturalOrderStringComparator(true, false);
            return naturalOrderStringComparator.compare(name1, name2);
        }
        if (name1.compareTo(name2) != 0) {
            NaturalOrderStringComparator naturalOrderStringComparator = new NaturalOrderStringComparator(true, true);
            return -naturalOrderStringComparator.compare(name1, name2);
        }
        return this.compareParameterTypes(javaTerm1, javaTerm2);
    }
}

