/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.sourceformatter.JavaClass;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaTerm {
    private String _content;
    private int _lineCount;
    private String _name;
    private List<String> _parameterTypes;
    private Pattern _parameterTypesPattern = Pattern.compile("\t(private |protected |public )([\\s\\S]*?)\\(([\\s\\S]*?)\\)");
    private int _type;

    public JavaTerm(String name, int type, String content, int lineCount) {
        this._name = name;
        this._type = type;
        this._content = content;
        this._lineCount = lineCount;
    }

    public String getContent() {
        return this._content;
    }

    public int getLineCount() {
        return this._lineCount;
    }

    public String getName() {
        return this._name;
    }

    public List<String> getParameterTypes() {
        if (this._parameterTypes != null) {
            return this._parameterTypes;
        }
        this._parameterTypes = new ArrayList<String>();
        if (!JavaClass.isInJavaTermTypeGroup(this._type, JavaClass.TYPE_CONSTRUCTOR) && !JavaClass.isInJavaTermTypeGroup(this._type, JavaClass.TYPE_METHOD)) {
            return this._parameterTypes;
        }
        Matcher matcher = this._parameterTypesPattern.matcher(this._content);
        if (!matcher.find()) {
            return this._parameterTypes;
        }
        String parameters = matcher.group(3);
        if (Validator.isNull((String)parameters)) {
            return this._parameterTypes;
        }
        parameters = StringUtil.replace((String)parameters, (String[])new String[]{"\t", "\n"}, (String[])new String[]{"", " "});
        int x = 0;
        while ((x = (parameters = StringUtil.trim((String)parameters)).indexOf(" ")) != -1) {
            int y;
            String parameterType = parameters.substring(0, x);
            if (parameterType.equals("final")) {
                y = parameters.indexOf(" ", x + 1);
                if (y == -1) {
                    return this._parameterTypes;
                }
                parameterType = parameters.substring(x + 1, y);
            }
            this._parameterTypes.add(parameterType);
            y = parameters.indexOf(",");
            if (y == -1) {
                return this._parameterTypes;
            }
            parameters = parameters.substring(y + 1);
        }
        return this._parameterTypes;
    }

    public int getType() {
        return this._type;
    }

    public void setContent(String content) {
        this._content = content;
    }

    public void setLineCount(int lineCount) {
        this._lineCount = lineCount;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setParameterTypes(List<String> parameterTypes) {
        this._parameterTypes = parameterTypes;
    }

    public void setType(int type) {
        this._type = type;
    }
}

