/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.sourceformatter.BaseSourceProcessor;
import com.liferay.portal.tools.sourceformatter.JavaImportsFormatter;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import com.thoughtworks.qdox.parser.ParseException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaSourceProcessor
extends BaseSourceProcessor {
    private static Pattern _importsPattern = Pattern.compile("(^[ \t]*import\\s+.*;\n+)+", 8);
    private boolean _addMissingDeprecationReleaseVersion;
    private boolean _allowUseServiceUtilInServiceImpl;
    private Pattern _annotationPattern = Pattern.compile("\n(\t*)@(.+)\\(\n([\\s\\S]*?)\n(\t*)\\)");
    private final Pattern _camelCasePattern = Pattern.compile("([a-z])([A-Z0-9])");
    private Pattern _catchExceptionPattern = Pattern.compile("\n(\t+)catch \\((.+Exception) (.+)\\) \\{\n");
    private boolean _checkUnprocessedExceptions;
    private final Pattern _componentPropertyPattern = Pattern.compile("(?s)@Component\\(.*?\\sproperty = \\{(.*?)\\}");
    private Pattern _diamondOperatorPattern = Pattern.compile("(return|=)\n?(\t+| )new ([A-Za-z]+)(Map|Set|List)<(.+)>\\(\n*\t*(.*)\\);\n");
    private Pattern _fetchByPrimaryKeysMethodPattern = Pattern.compile("@Override\n\tpublic Map<(.+)> fetchByPrimaryKeys\\(");
    private List<String> _fitOnSingleLineExclusions;
    private List<String> _hibernateSQLQueryExclusions;
    private Set<String> _immutableFieldTypes;
    private Pattern _incorrectCloseCurlyBracePattern1 = Pattern.compile("\n(.+)\n\n(\t+)}\n");
    private Pattern _incorrectCloseCurlyBracePattern2 = Pattern.compile("(\t| )@?(class |enum |interface |new )");
    private Pattern _incorrectLineBreakPattern = Pattern.compile("\t(catch |else |finally |for |if |try |while ).*\\{\n\n\t+\\w");
    private List<String> _javaTermAccessLevelModifierExclusions;
    private List<String> _javaTermSortExclusions;
    private Pattern _lineBreakPattern = Pattern.compile("\\}(\\)+) \\{");
    private List<String> _lineLengthExclusions;
    private Pattern _logPattern = Pattern.compile("\n\tprivate static Log _log = LogFactoryUtil.getLog\\(\n*\t*(.+)\\.class\\)");
    private List<String> _proxyExclusions;
    private List<String> _secureRandomExclusions;
    private Pattern _stagedModelTypesPattern = Pattern.compile("StagedModelType\\(([a-zA-Z.]*(class|getClassName[\\(\\)]*))\\)");
    private List<String> _staticLogVariableExclusions;
    private List<String> _testAnnotationsExclusions;
    private Pattern _throwsSystemExceptionPattern = Pattern.compile("(\n\t+.*)throws(.*) SystemException(.*)( \\{|;\n)");
    private List<String> _upgradeServiceUtilExclusions;

    public static String stripJavaImports(String content, String packageDir, String className) throws IOException {
        Matcher matcher = _importsPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String imports = matcher.group();
        Set classes = ClassUtil.getClasses((Reader)new UnsyncStringReader(content), (String)className);
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(imports));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String importClass;
            int importY;
            int importX;
            String importPackage;
            if (!line.contains("import ") || (importPackage = line.substring((importX = line.indexOf(" ")) + 1, importY = line.lastIndexOf("."))).equals(packageDir) || importPackage.equals("java.lang") || !(importClass = line.substring(importY + 1, line.length() - 1)).equals("*") && !classes.contains(importClass)) continue;
            sb.append(line);
            sb.append("\n");
        }
        JavaImportsFormatter importsFormatter = new JavaImportsFormatter();
        imports = importsFormatter.format(sb.toString());
        content = content.substring(0, matcher.start()) + imports + content.substring(matcher.end());
        content = content.replaceFirst("(?m)^[ \t]*(package .*;)\\s*^[ \t]*import", "$1\n\nimport");
        content = content.replaceFirst("(?m)^[ \t]*((?:package|import) .*;)\\s*^[ \t]*/\\*\\*", "$1\n\n/**");
        return content;
    }

    protected static int getLeadingTabCount(String line) {
        int leadingTabCount = 0;
        while (line.startsWith("\t")) {
            line = line.substring(1);
            ++leadingTabCount;
        }
        return leadingTabCount;
    }

    protected static String sortAnnotations(String content, String indent) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        String line = null;
        String annotation = "";
        String previousAnnotation = "";
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.equals(indent + "}")) {
                return content;
            }
            if (StringUtil.count((String)line, (String)"\t") == indent.length()) {
                if (Validator.isNotNull((String)previousAnnotation) && previousAnnotation.compareTo(annotation) > 0) {
                    content = StringUtil.replaceFirst((String)content, (String)previousAnnotation, (String)annotation);
                    content = StringUtil.replaceLast((String)content, (String)annotation, (String)previousAnnotation);
                    return JavaSourceProcessor.sortAnnotations(content, indent);
                }
                if (line.startsWith(indent + "@")) {
                    if (Validator.isNotNull((String)annotation)) {
                        previousAnnotation = annotation;
                    }
                    annotation = line + "\n";
                    continue;
                }
                annotation = "";
                previousAnnotation = "";
                continue;
            }
            if (Validator.isNull((String)annotation)) {
                return content;
            }
            annotation = annotation + line + "\n";
        }
        return content;
    }

    protected String applyDiamondOperator(String content) {
        Matcher matcher = this._diamondOperatorPattern.matcher(content);
        while (matcher.find()) {
            String constructorParameter;
            String parameterType = matcher.group(5);
            if (parameterType.contains("Object") && Validator.isNotNull((String)(constructorParameter = matcher.group(6)))) continue;
            String match = matcher.group();
            String replacement = StringUtil.replaceFirst((String)match, (String)("<" + parameterType + ">"), (String)"<>");
            return StringUtil.replace((String)content, (String)match, (String)replacement);
        }
        return content;
    }

    protected void checkFinderCacheInterfaceMethod(String fileName, String content) {
        if (!fileName.endsWith("FinderImpl.java") || !content.contains("public static final FinderPath")) {
            return;
        }
        Matcher matcher = this._fetchByPrimaryKeysMethodPattern.matcher(content);
        if (!matcher.find()) {
            JavaSourceProcessor.processErrorMessage(fileName, "LPS-49552: Missing override of BasePersistenceImpl.fetchByPrimaryKeys(Set<Serializable>): " + fileName);
        }
    }

    protected String checkIfClause(String ifClause, String fileName, int lineCount) throws IOException {
        String ifClauseSingleLine = StringUtil.replace((String)ifClause, (String[])new String[]{"\t ", "\t", "(\n", "\n"}, (String[])new String[]{"\t", "", "(", " "});
        this.checkIfClauseParentheses(ifClauseSingleLine, fileName, lineCount);
        return this.checkIfClauseTabsAndSpaces(ifClause);
    }

    protected String checkIfClauseTabsAndSpaces(String ifClause) throws IOException {
        if (ifClause.contains("!(") || ifClause.contains("\t//")) {
            return ifClause;
        }
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(ifClause));
        String line = null;
        String previousLine = null;
        int previousLineLeadingWhiteSpace = 0;
        int lastCriteriumLineLeadingWhiteSpace = 0;
        int closeParenthesesCount = 0;
        int openParenthesesCount = 0;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            int expectedLeadingWhiteSpace;
            String originalLine = line;
            line = StringUtil.replace((String)line, (String)"\t", (String)"    ");
            int leadingWhiteSpace = line.length() - StringUtil.trimLeading((String)line).length();
            if (Validator.isNull(previousLine)) {
                lastCriteriumLineLeadingWhiteSpace = line.indexOf("(");
            } else if (previousLine.endsWith("|") || previousLine.endsWith("&") || previousLine.endsWith("^")) {
                expectedLeadingWhiteSpace = lastCriteriumLineLeadingWhiteSpace + openParenthesesCount - closeParenthesesCount;
                if (leadingWhiteSpace != expectedLeadingWhiteSpace) {
                    return this.fixIfClause(ifClause, originalLine, leadingWhiteSpace - expectedLeadingWhiteSpace);
                }
                lastCriteriumLineLeadingWhiteSpace = leadingWhiteSpace;
                closeParenthesesCount = 0;
                openParenthesesCount = 0;
            } else {
                expectedLeadingWhiteSpace = 0;
                if (previousLine.contains("\tif (")) {
                    expectedLeadingWhiteSpace = previousLineLeadingWhiteSpace + 8;
                } else if (previousLine.contains("\telse if (") || previousLine.contains("\twhile (")) {
                    expectedLeadingWhiteSpace = previousLineLeadingWhiteSpace + 12;
                }
                if (expectedLeadingWhiteSpace != 0 && leadingWhiteSpace != expectedLeadingWhiteSpace) {
                    return this.fixIfClause(ifClause, originalLine, leadingWhiteSpace - expectedLeadingWhiteSpace);
                }
            }
            if (line.endsWith(") {")) {
                return ifClause;
            }
            line = this.stripQuotes(line, '\"');
            line = this.stripQuotes(line, '\'');
            closeParenthesesCount += StringUtil.count((String)line, (String)")");
            openParenthesesCount += StringUtil.count((String)line, (String)"(");
            previousLine = originalLine;
            previousLineLeadingWhiteSpace = leadingWhiteSpace;
        }
        return ifClause;
    }

    protected String checkImmutableAndStaticableFieldTypes(String fileName, String packagePath, String className, String content) {
        if (!portalSource) {
            return content;
        }
        ClassLibrary classLibrary = new ClassLibrary();
        classLibrary.addClassLoader(JavaSourceProcessor.class.getClassLoader());
        JavaDocBuilder javaDocBuilder = new JavaDocBuilder(classLibrary);
        try {
            javaDocBuilder.addSource((Reader)new UnsyncStringReader(this.sanitizeContent(content)));
        }
        catch (ParseException pe) {
            System.err.println("Unable to parse " + fileName + ", " + pe.getMessage());
            return content;
        }
        JavaClass javaClass = javaDocBuilder.getClassByName(packagePath.concat(".").concat(className));
        String[] lines = null;
        for (JavaField javaField : javaClass.getFields()) {
            Type type = javaField.getType();
            String fieldTypeName = type.getFullyQualifiedName();
            if (this._immutableFieldTypes == null) {
                this._immutableFieldTypes = this.getImmutableFieldTypes();
            }
            if (!javaField.isPrivate() || !javaField.isFinal() || !this._immutableFieldTypes.contains(fieldTypeName)) continue;
            String oldName = javaField.getName();
            if (!type.isArray() && javaField.isStatic() && !oldName.equals("serialVersionUID")) {
                Matcher matcher = this._camelCasePattern.matcher(oldName);
                String newName = matcher.replaceAll("$1_$2");
                if ((newName = StringUtil.toUpperCase((String)newName)).charAt(0) != '_') {
                    newName = "_".concat(newName);
                }
                content = content.replaceAll("(?<=[\\W&&[^.\"]])(" + oldName + ")\\b", newName);
            }
            String initializationExpression = StringUtil.trim((String)javaField.getInitializationExpression());
            if (javaField.isStatic() || initializationExpression.isEmpty()) continue;
            if (lines == null) {
                lines = StringUtil.splitLines((String)content);
            }
            String line = lines[javaField.getLineNumber() - 1];
            String newLine = StringUtil.replace((String)line, (String)"private final", (String)"private static final");
            content = StringUtil.replace((String)content, (String)line, (String)newLine);
        }
        return content;
    }

    protected void checkLogLevel(String content, String fileName, String logLevel) {
        if (fileName.contains("Log")) {
            return;
        }
        Pattern pattern = Pattern.compile("\n(\t+)_log." + logLevel + "\\(");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String s;
            char c;
            int pos = matcher.start();
            while ((c = content.charAt((pos = content.lastIndexOf("\n\t", pos - 1)) + 2)) == '\t') {
            }
            String codeBlock = content.substring(pos, matcher.start());
            if (codeBlock.contains(s = "_log.is" + StringUtil.upperCaseFirstLetter((String)logLevel) + "Enabled()")) continue;
            int lineCount = StringUtil.count((String)content.substring(0, matcher.start(1)), (String)"\n");
            JavaSourceProcessor.processErrorMessage(fileName, "Use " + s + ": " + fileName + " " + ++lineCount);
        }
    }

    protected void checkRegexPattern(String regexPattern, String fileName, int lineCount) {
        int i = regexPattern.indexOf("Pattern.compile(");
        if (i == -1) {
            return;
        }
        regexPattern = regexPattern.substring(i + 16);
        i = (regexPattern = this.stripQuotes(regexPattern, '\"')).indexOf(",");
        regexPattern = i != -1 ? regexPattern.substring(0, i) : StringUtil.replaceLast((String)regexPattern, (String)");", (String)"");
        if (Validator.isNull((String)(regexPattern = StringUtil.replace((String)regexPattern, (String)"+", (String)"")))) {
            JavaSourceProcessor.processErrorMessage(fileName, "create pattern as global var: " + fileName + " " + lineCount);
        }
    }

    protected void checkSystemEventAnnotations(String content, String fileName) throws Exception {
        if (!portalSource || !fileName.endsWith("PortletDataHandler.java")) {
            return;
        }
        int pos = content.indexOf("setDeletionSystemEventStagedModelTypes");
        if (pos == -1) {
            return;
        }
        String deletionSystemEventStagedModelTypes = content.substring(pos, content.indexOf(");", pos));
        Matcher matcher = this._stagedModelTypesPattern.matcher(deletionSystemEventStagedModelTypes);
        while (matcher.find()) {
            String stagedModelTypeClassName = matcher.group(1);
            pos = stagedModelTypeClassName.indexOf(".class");
            if (pos == -1) {
                pos = stagedModelTypeClassName.indexOf("Constants");
            }
            if (pos == -1) {
                return;
            }
            String className = stagedModelTypeClassName.substring(0, pos);
            Pattern packageNamePattern = Pattern.compile("import (com\\.liferay\\.[a-zA-Z\\.]*)\\.model\\." + className + ";");
            Matcher packageNameMatcher = packageNamePattern.matcher(content);
            if (!packageNameMatcher.find()) {
                return;
            }
            StringBundler sb = new StringBundler(6);
            sb.append("./");
            sb.append(fileName.substring(0, fileName.indexOf("/src/") + 5));
            sb.append(StringUtil.replace((String)packageNameMatcher.group(1), (String)".", (String)"/"));
            sb.append("/service/impl/");
            sb.append(className);
            sb.append("LocalServiceImpl.java");
            String localServiceImplFileName = sb.toString();
            String localServiceImplContent = fileUtil.read(localServiceImplFileName);
            if (localServiceImplContent == null) {
                System.out.println("Unable to read " + localServiceImplFileName);
                return;
            }
            if (localServiceImplContent.contains("@SystemEvent")) continue;
            JavaSourceProcessor.processErrorMessage(fileName, "Missing deletion system event: " + localServiceImplFileName);
        }
    }

    protected void checkUnprocessedExceptions(String content, File file, String packagePath, String fileName) throws IOException {
        List<String> importedExceptionClassNames = null;
        JavaDocBuilder javaDocBuilder = null;
        int lineCount = 1;
        Matcher catchExceptionMatcher;
        while ((catchExceptionMatcher = this._catchExceptionPattern.matcher(content)).find()) {
            String packageName;
            String beforeCatchCode = content.substring(0, catchExceptionMatcher.start());
            lineCount = lineCount + StringUtil.count((String)beforeCatchCode, (String)"\n") + 1;
            String exceptionClassName = catchExceptionMatcher.group(2);
            String exceptionVariableName = catchExceptionMatcher.group(3);
            String tabs = catchExceptionMatcher.group(1);
            int pos = content.indexOf("\n" + tabs + "}", catchExceptionMatcher.end() - 1);
            String insideCatchCode = content.substring(catchExceptionMatcher.end(), pos + 1);
            Pattern exceptionVariablePattern = Pattern.compile("\\W" + exceptionVariableName + "\\W");
            Matcher exceptionVariableMatcher = exceptionVariablePattern.matcher(insideCatchCode);
            if (exceptionVariableMatcher.find()) {
                content = content.substring(catchExceptionMatcher.start() + 1);
                continue;
            }
            if (javaDocBuilder == null) {
                javaDocBuilder = new JavaDocBuilder();
                javaDocBuilder.addSource(file);
            }
            if (importedExceptionClassNames == null) {
                importedExceptionClassNames = this.getImportedExceptionClassNames(javaDocBuilder);
            }
            String originalExceptionClassName = exceptionClassName;
            if (!exceptionClassName.contains(".")) {
                for (String exceptionClass : importedExceptionClassNames) {
                    if (!exceptionClass.endsWith("." + exceptionClassName)) continue;
                    exceptionClassName = exceptionClass;
                    break;
                }
            }
            if (!exceptionClassName.contains(".")) {
                exceptionClassName = packagePath + "." + exceptionClassName;
            }
            JavaClass exceptionClass = javaDocBuilder.getClassByName(exceptionClassName);
            while ((packageName = exceptionClass.getPackageName()).contains("com.liferay")) {
                exceptionClassName = exceptionClass.getName();
                if (exceptionClassName.equals("PortalException") || exceptionClassName.equals("SystemException")) {
                    JavaSourceProcessor.processErrorMessage(fileName, "Unprocessed " + originalExceptionClassName + ": " + fileName + " " + lineCount);
                    break;
                }
                JavaClass exceptionSuperClass = exceptionClass.getSuperJavaClass();
                if (exceptionSuperClass == null) break;
                exceptionClass = exceptionSuperClass;
            }
            content = content.substring(catchExceptionMatcher.start() + 1);
        }
        return;
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        String logClassName;
        Matcher matcher;
        int packagePathY;
        if (this.isGenerated(content)) {
            return content;
        }
        String className = file.getName();
        int pos = className.lastIndexOf(".");
        className = className.substring(0, pos);
        String packagePath = fileName;
        int packagePathX = packagePath.indexOf("/src/");
        if (packagePathX == -1) {
            packagePathX = packagePath.indexOf("/integration/") + 8;
        }
        packagePath = packagePathX + 5 >= (packagePathY = packagePath.lastIndexOf("/")) ? "" : packagePath.substring(packagePathX + 5, packagePathY);
        if ((packagePath = StringUtil.replace((String)packagePath, (String)"/", (String)".")).endsWith(".model") && content.contains("extends " + className + "Model")) {
            return content;
        }
        String newContent = content;
        if (newContent.contains("$\n */")) {
            JavaSourceProcessor.processErrorMessage(fileName, "*: " + fileName);
            newContent = StringUtil.replace((String)newContent, (String)"$\n */", (String)"$\n *\n */");
        }
        if ((newContent = this.fixCopyright(newContent, absolutePath, fileName)).contains(className + ".java.html")) {
            JavaSourceProcessor.processErrorMessage(fileName, "Java2HTML: " + fileName);
        }
        if (newContent.contains(" * @author Raymond Aug") && !newContent.contains(" * @author Raymond Aug\u00e9")) {
            newContent = newContent.replaceFirst("Raymond Aug.++", "Raymond Aug\u00e9");
            JavaSourceProcessor.processErrorMessage(fileName, "UTF-8: " + fileName);
        }
        newContent = this.fixDataAccessConnection(className, newContent);
        newContent = this.fixSessionKey(fileName, newContent, sessionKeyPattern);
        newContent = StringUtil.replace((String)newContent, (String[])new String[]{"com.liferay.portal.PortalException", "com.liferay.portal.SystemException", "com.liferay.util.LocalizationUtil", "private static final Log _log"}, (String[])new String[]{"com.liferay.portal.kernel.exception.PortalException", "com.liferay.portal.kernel.exception.SystemException", "com.liferay.portal.kernel.util.LocalizationUtil", "private static Log _log"});
        newContent = StringUtil.replace((String)newContent, (String)" final static ", (String)" static final ");
        newContent = this.fixCompatClassImports(absolutePath, newContent);
        newContent = JavaSourceProcessor.stripJavaImports(newContent, packagePath, className);
        newContent = StringUtil.replace((String)newContent, (String[])new String[]{";\n/**", "\t/*\n\t *", "catch(", "else{", "if(", "for(", "while(", "List <", "){\n", "]{\n", ";;\n"}, (String[])new String[]{";\n\n/**", "\t/**\n\t *", "catch (", "else {", "if (", "for (", "while (", "List<", ") {\n", "] {\n", ";\n"});
        while ((matcher = this._incorrectLineBreakPattern.matcher(newContent)).find()) {
            newContent = StringUtil.replaceFirst((String)newContent, (String)"\n", (String)"", (int)matcher.start());
        }
        newContent = JavaSourceProcessor.sortAnnotations(newContent, "");
        matcher = this._logPattern.matcher(newContent);
        if (matcher.find() && !(logClassName = matcher.group(1)).equals(className)) {
            newContent = StringUtil.replaceLast((String)newContent, (String)(logClassName + ".class)"), (String)(className + ".class)"));
        }
        if (!JavaSourceProcessor.isExcluded(this._staticLogVariableExclusions, absolutePath)) {
            newContent = StringUtil.replace((String)newContent, (String)"private Log _log", (String)"private static Log _log");
        }
        if (newContent.contains("*/\npackage ")) {
            JavaSourceProcessor.processErrorMessage(fileName, "package: " + fileName);
        }
        if (!newContent.endsWith("\n\n}") && !newContent.endsWith("{\n}")) {
            JavaSourceProcessor.processErrorMessage(fileName, "}: " + fileName);
        }
        if (portalSource && !this._allowUseServiceUtilInServiceImpl && !className.equals("BaseServiceImpl") && className.endsWith("ServiceImpl") && newContent.contains("ServiceUtil.")) {
            JavaSourceProcessor.processErrorMessage(fileName, "ServiceUtil: " + fileName);
        }
        if (portalSource && !JavaSourceProcessor.isExcluded(this._upgradeServiceUtilExclusions, absolutePath) && fileName.contains("/portal/upgrade/") && !fileName.contains("/test/") && newContent.contains("ServiceUtil.")) {
            JavaSourceProcessor.processErrorMessage(fileName, "ServiceUtil: " + fileName);
        }
        if (!this.isRunsOutsidePortal(absolutePath) && !JavaSourceProcessor.isExcluded(this._proxyExclusions, absolutePath) && newContent.contains("import java.lang.reflect.Proxy;")) {
            JavaSourceProcessor.processErrorMessage(fileName, "Proxy: " + fileName);
        }
        if (newContent.contains("import edu.emory.mathcs.backport.java")) {
            JavaSourceProcessor.processErrorMessage(fileName, "edu.emory.mathcs.backport.java: " + fileName);
        }
        if (newContent.contains("import jodd.util.StringPool")) {
            JavaSourceProcessor.processErrorMessage(fileName, "jodd.util.StringPool: " + fileName);
        }
        if (newContent.contains("com.liferay.portal.kernel.util.UnmodifiableList")) {
            JavaSourceProcessor.processErrorMessage(fileName, "Use java.util.Collections.unmodifiableList instead of com.liferay.portal.kernel.util.UnmodifiableList: " + fileName);
        }
        int pos1 = -1;
        while ((pos1 = newContent.indexOf("\ttry {", pos1 + 1)) != -1) {
            int pos2 = newContent.indexOf("\ttry {", pos1 + 1);
            int pos3 = newContent.indexOf("\"select count(", pos1);
            if (pos2 != -1 && pos3 != -1 && pos2 < pos3) continue;
            int pos4 = newContent.indexOf("rs.getLong(1)", pos1);
            int pos5 = newContent.indexOf("\tfinally {", pos1);
            if (pos3 == -1 || pos4 == -1 || pos5 == -1) break;
            if (pos3 >= pos4 || pos4 >= pos5) continue;
            JavaSourceProcessor.processErrorMessage(fileName, "Use getInt(1) for count: " + fileName);
        }
        if (content.contains("implements ProcessCallable") && !content.contains("private static final long serialVersionUID")) {
            JavaSourceProcessor.processErrorMessage(fileName, "Assign ProcessCallable implementation a serialVersionUID: " + fileName);
        }
        this.checkLanguageKeys(fileName, newContent, languageKeyPattern);
        newContent = StringUtil.replace((String)newContent, (String)"\tfor (;;) {", (String)"\twhile (true) {");
        if (this._checkUnprocessedExceptions && !fileName.contains("/test/")) {
            this.checkUnprocessedExceptions(newContent, file, packagePath, fileName);
        }
        if (!JavaSourceProcessor.isExcluded(this._secureRandomExclusions, absolutePath) && !this.isRunsOutsidePortal(absolutePath) && content.contains("java.security.SecureRandom") && !content.contains("javax.crypto.KeyGenerator")) {
            JavaSourceProcessor.processErrorMessage(fileName, "Use SecureRandomUtil or com.liferay.portal.kernel.security.SecureRandom instead of java.security.SecureRandom: " + fileName);
        }
        this.checkLogLevel(newContent, fileName, "debug");
        this.checkLogLevel(newContent, fileName, "info");
        this.checkLogLevel(newContent, fileName, "trace");
        this.checkLogLevel(newContent, fileName, "warn");
        this.checkSystemEventAnnotations(newContent, fileName);
        if (fileName.contains("/upgrade/") && newContent.contains("LocaleUtil.getDefault()")) {
            JavaSourceProcessor.processErrorMessage(fileName, "Use UpgradeProcessUtil.getDefaultLanguageId(companyId) instead of LocaleUtil.getDefault(): " + fileName);
        }
        newContent = StringUtil.replace((String)newContent, (String)" static interface ", (String)" interface ");
        newContent = this.fixSystemExceptions(newContent);
        if (portalSource && fileName.contains("/test/integration/")) {
            newContent = StringUtil.replace((String)newContent, (String)"FinderCacheUtil.clearCache();", (String)"");
        }
        newContent = this.fixIncorrectParameterTypeForLanguageUtil(newContent, false, fileName);
        if (portalSource && fileName.contains("/portal-service/") && content.contains("import javax.servlet.jsp.")) {
            JavaSourceProcessor.processErrorMessage(fileName, "Never import javax.servlet.jsp.* from portal-service " + fileName);
        }
        newContent = this.checkImmutableAndStaticableFieldTypes(fileName, packagePath, className, newContent);
        this.checkFinderCacheInterfaceMethod(fileName, newContent);
        newContent = this.fixIncorrectEmptyLineBeforeCloseCurlyBrace(newContent, fileName);
        pos = newContent.indexOf("\npublic ");
        if (pos != -1) {
            String javaClassContent = newContent.substring(pos + 1);
            String beforeJavaClass = newContent.substring(0, pos + 1);
            int javaClassLineCount = StringUtil.count((String)beforeJavaClass, (String)"\n") + 1;
            newContent = this.formatJavaTerms(fileName, absolutePath, newContent, javaClassContent, javaClassLineCount, this._javaTermAccessLevelModifierExclusions, this._javaTermSortExclusions, this._testAnnotationsExclusions);
        }
        newContent = this.formatJava(fileName, absolutePath, newContent);
        return StringUtil.replace((String)newContent, (String)"\n\n\n", (String)"\n\n");
    }

    protected String fixDataAccessConnection(String className, String content) {
        int x = content.indexOf("package ");
        int y = content.indexOf(59, x);
        if (x == -1 || y == -1) {
            return content;
        }
        String packageName = content.substring(x + 8, y);
        if (!(packageName.startsWith("com.liferay.portal.kernel.upgrade") || packageName.startsWith("com.liferay.portal.kernel.verify") || packageName.startsWith("com.liferay.portal.upgrade") || packageName.startsWith("com.liferay.portal.verify"))) {
            return content;
        }
        content = StringUtil.replace((String)content, (String)"DataAccess.getConnection", (String)"DataAccess.getUpgradeOptimizedConnection");
        return content;
    }

    protected String fixIfClause(String ifClause, String line, int delta) {
        String newLine = line;
        String whiteSpace = "";
        int whiteSpaceLength = Math.abs(delta);
        while (whiteSpaceLength > 0) {
            if (whiteSpaceLength >= 4) {
                whiteSpace = whiteSpace + "\t";
                whiteSpaceLength -= 4;
                continue;
            }
            whiteSpace = whiteSpace + " ";
            --whiteSpaceLength;
        }
        if (delta > 0) {
            if (!line.contains("\t" + whiteSpace)) {
                newLine = StringUtil.replaceLast((String)newLine, (String)"\t", (String)"    ");
            }
            newLine = StringUtil.replaceLast((String)newLine, (String)("\t" + whiteSpace), (String)"\t");
        } else {
            newLine = StringUtil.replaceLast((String)newLine, (String)"\t", (String)("\t" + whiteSpace));
        }
        newLine = StringUtil.replaceLast((String)newLine, (String)"    ", (String)"\t");
        return StringUtil.replace((String)ifClause, (String)line, (String)newLine);
    }

    protected String fixIncorrectEmptyLineBeforeCloseCurlyBrace(String content, String fileName) {
        Matcher matcher1 = this._incorrectCloseCurlyBracePattern1.matcher(content);
        while (matcher1.find()) {
            String lastLine = StringUtil.trimLeading((String)matcher1.group(1));
            if (lastLine.startsWith("// ")) continue;
            String tabs = matcher1.group(2);
            int tabCount = tabs.length();
            int pos = matcher1.start();
            while (content.charAt((pos = content.lastIndexOf("\n" + tabs, pos - 1)) + tabCount + 1) == '\t') {
            }
            String codeBlock = content.substring(pos + 1, matcher1.end());
            String firstLine = codeBlock.substring(0, codeBlock.indexOf("\n"));
            Matcher matcher2 = this._incorrectCloseCurlyBracePattern2.matcher(firstLine);
            if (matcher2.find()) continue;
            return StringUtil.replaceFirst((String)content, (String)("\n\n" + tabs + "}\n"), (String)("\n" + tabs + "}\n"), (int)pos);
        }
        return content;
    }

    protected String fixSystemExceptions(String content) {
        Matcher matcher = this._throwsSystemExceptionPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String match = matcher.group();
        String replacement = null;
        String afterException = matcher.group(3);
        String beforeException = matcher.group(2);
        if (Validator.isNull((String)beforeException) && Validator.isNull((String)afterException)) {
            replacement = matcher.group(4);
            String beforeThrows = matcher.group(1);
            if (Validator.isNotNull((String)StringUtil.trim((String)beforeThrows))) {
                replacement = beforeThrows + replacement;
            }
        } else {
            replacement = Validator.isNull((String)beforeException) ? StringUtil.replaceFirst((String)match, (String)"SystemException, ", (String)"") : StringUtil.replaceFirst((String)match, (String)", SystemException", (String)"");
        }
        if (match.equals(replacement)) {
            return content;
        }
        return this.fixSystemExceptions(StringUtil.replaceFirst((String)content, (String)match, (String)replacement));
    }

    @Override
    protected void format() throws Exception {
        Collection<String> fileNames = null;
        if (portalSource) {
            fileNames = this.getPortalJavaFiles();
            this._checkUnprocessedExceptions = GetterUtil.getBoolean((String)System.getProperty("source.formatter.check.unprocessed.exceptions"));
        } else {
            fileNames = this.getPluginJavaFiles();
        }
        this._addMissingDeprecationReleaseVersion = GetterUtil.getBoolean((String)this.getProperty("add.missing.deprecation.release.version"));
        this._allowUseServiceUtilInServiceImpl = GetterUtil.getBoolean((String)this.getProperty("allow.use.service.util.in.service.impl"));
        this._fitOnSingleLineExclusions = this.getPropertyList("fit.on.single.line.excludes.files");
        this._hibernateSQLQueryExclusions = this.getPropertyList("hibernate.sql.query.excludes.files");
        this._javaTermAccessLevelModifierExclusions = this.getPropertyList("javaterm.access.level.modifier.excludes.files");
        this._javaTermSortExclusions = this.getPropertyList("javaterm.sort.excludes.files");
        this._lineLengthExclusions = this.getPropertyList("line.length.excludes.files");
        this._proxyExclusions = this.getPropertyList("proxy.excludes.files");
        this._secureRandomExclusions = this.getPropertyList("secure.random.excludes.files");
        this._staticLogVariableExclusions = this.getPropertyList("static.log.excludes.files");
        this._testAnnotationsExclusions = this.getPropertyList("test.annotations.excludes.files");
        this._upgradeServiceUtilExclusions = this.getPropertyList("upgrade.service.util.excludes.files");
        for (String fileName : fileNames) {
            this.format(fileName);
        }
    }

    protected String formatJava(String fileName, String absolutePath, String content) throws Exception {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));){
            String line = null;
            String previousLine = "";
            int lineCount = 0;
            int lineToSkipIfEmpty = 0;
            String ifClause = "";
            String packageName = "";
            String regexPattern = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String trimmedLine;
                ++lineCount;
                if ((line = this.trimLine(line, false)).startsWith("package ")) {
                    packageName = line.substring(8, line.length() - 1);
                }
                if (line.startsWith("import ")) {
                    String importPackageName;
                    int pos;
                    if (line.endsWith(".*;")) {
                        JavaSourceProcessor.processErrorMessage(fileName, "import: " + fileName + " " + lineCount);
                    }
                    if ((pos = line.lastIndexOf(".")) != -1 && (importPackageName = line.substring(7, pos)).equals(packageName)) continue;
                }
                if (line.contains("\tfor (") && line.contains(":") && !line.contains(" :")) {
                    line = StringUtil.replace((String)line, (String)":", (String)" :");
                }
                if (line.contains("PortalUtil.getClassNameId(") && fileName.endsWith("ServiceImpl.java")) {
                    JavaSourceProcessor.processErrorMessage(fileName, "Use classNameLocalService.getClassNameId: " + fileName + " " + lineCount);
                }
                if (!JavaSourceProcessor.isExcluded(this._hibernateSQLQueryExclusions, absolutePath) && line.contains("= session.createSQLQuery(") && content.contains("com.liferay.portal.kernel.dao.orm.Session")) {
                    line = StringUtil.replace((String)line, (String)"createSQLQuery", (String)"createSynchronizedSQLQuery");
                }
                if ((trimmedLine = StringUtil.trimLeading((String)(line = this.replacePrimitiveWrapperInstantiation(fileName, line, lineCount)))).startsWith("throw new IOException(") && line.contains("e.getMessage()")) {
                    line = StringUtil.replace((String)line, (String)".getMessage()", (String)"");
                }
                if (trimmedLine.contains("StopWatch stopWatch = null;")) {
                    JavaSourceProcessor.processErrorMessage(fileName, "Do not set stopwatch to null: " + fileName + " " + lineCount);
                }
                this.checkStringBundler(trimmedLine, fileName, lineCount);
                this.checkEmptyCollection(trimmedLine, fileName, lineCount);
                if (trimmedLine.startsWith("* @deprecated") && this._addMissingDeprecationReleaseVersion) {
                    if (!trimmedLine.startsWith("* @deprecated As of ")) {
                        line = StringUtil.replace((String)line, (String)"* @deprecated", (String)("* @deprecated As of " + this.getMainReleaseVersion()));
                    } else {
                        String version = trimmedLine.substring(20);
                        version = StringUtil.split((String)version, (String)" ")[0];
                        if (StringUtil.count((String)(version = StringUtil.replace((String)version, (String)",", (String)"")), (String)".") == 1) {
                            line = StringUtil.replaceFirst((String)line, (String)version, (String)(version + ".0"));
                        }
                    }
                }
                if (trimmedLine.startsWith("* @see ") && StringUtil.count((String)trimmedLine, (String)"@") > 1) {
                    JavaSourceProcessor.processErrorMessage(fileName, "Do not use @see with another annotation: " + fileName + " " + lineCount);
                }
                this.checkInefficientStringMethods(line, fileName, absolutePath, lineCount);
                if (trimmedLine.startsWith("=")) {
                    JavaSourceProcessor.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                }
                if (line.contains("ActionForm form")) {
                    JavaSourceProcessor.processErrorMessage(fileName, "Rename form to actionForm: " + fileName + " " + lineCount);
                }
                if (line.contains("ActionMapping mapping")) {
                    JavaSourceProcessor.processErrorMessage(fileName, "Rename mapping to ActionMapping: " + fileName + " " + lineCount);
                }
                if (fileName.contains("/upgrade/") && line.contains("rs.getDate(")) {
                    JavaSourceProcessor.processErrorMessage(fileName, "Use rs.getTimeStamp: " + fileName + " " + lineCount);
                }
                if (!trimmedLine.equals("{") && line.endsWith("{") && !line.endsWith(" {")) {
                    line = StringUtil.replaceLast((String)line, (String)"{", (String)" {");
                }
                line = this.sortExceptions(line);
                if (trimmedLine.startsWith("if (") || trimmedLine.startsWith("else if (") || trimmedLine.startsWith("while (") || Validator.isNotNull((String)ifClause)) {
                    ifClause = ifClause + line + "\n";
                    if (line.endsWith(") {")) {
                        String newIfClause = this.checkIfClause(ifClause, fileName, lineCount);
                        if (!ifClause.equals(newIfClause) && content.contains(ifClause)) {
                            String string = StringUtil.replace((String)content, (String)ifClause, (String)newIfClause);
                            return string;
                        }
                        ifClause = "";
                    } else if (line.endsWith(";")) {
                        ifClause = "";
                    }
                }
                if (trimmedLine.startsWith("Pattern ") || Validator.isNotNull((String)regexPattern)) {
                    regexPattern = regexPattern + trimmedLine;
                    if (trimmedLine.endsWith(");")) {
                        this.checkRegexPattern(regexPattern, fileName, lineCount);
                        regexPattern = "";
                    }
                }
                if (!trimmedLine.contains("//") && !trimmedLine.startsWith("*")) {
                    Matcher matcher;
                    int y;
                    int openParenthesisCount;
                    int closeParenthesisCount;
                    String strippedQuotesLine = this.stripQuotes(trimmedLine, '\"');
                    int x = 0;
                    while ((x = strippedQuotesLine.indexOf("=", x + 1)) != -1) {
                        char c = strippedQuotesLine.charAt(x - 1);
                        if (Character.isLetterOrDigit(c)) {
                            line = StringUtil.replace((String)line, (String)(c + "="), (String)(c + " ="));
                            break;
                        }
                        if (x == strippedQuotesLine.length() - 1) break;
                        c = strippedQuotesLine.charAt(x + 1);
                        if (!Character.isLetterOrDigit(c)) continue;
                        line = StringUtil.replace((String)line, (String)("=" + c), (String)("= " + c));
                        break;
                    }
                    while (trimmedLine.contains("\t")) {
                        line = StringUtil.replaceLast((String)line, (String)"\t", (String)" ");
                        trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"\t", (String)" ");
                    }
                    if (!(!line.contains("\t ") || previousLine.endsWith("&&") || previousLine.endsWith("||") || previousLine.contains("\t((") || previousLine.contains("\t<") || previousLine.contains("\t ") || previousLine.contains("\timplements ") || previousLine.contains("\tthrows "))) {
                        line = StringUtil.replace((String)line, (String)"\t ", (String)"\t");
                    }
                    while (trimmedLine.contains("  ") && !trimmedLine.contains("\"  ") && !fileName.contains("Test")) {
                        line = StringUtil.replaceLast((String)line, (String)"  ", (String)" ");
                        trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"  ", (String)" ");
                    }
                    if (!line.contains("\"")) {
                        String linePart;
                        int pos = line.indexOf(") ");
                        if (pos != -1 && Character.isLetter((linePart = line.substring(pos + 2)).charAt(0)) && !linePart.startsWith("default") && !linePart.startsWith("instanceof") && !linePart.startsWith("throws")) {
                            line = StringUtil.replaceLast((String)line, (String)(" " + linePart), (String)linePart);
                        }
                        if ((trimmedLine.startsWith("private ") || trimmedLine.startsWith("protected ") || trimmedLine.startsWith("public ")) && !line.contains("=") && line.contains(" (")) {
                            line = StringUtil.replace((String)line, (String)" (", (String)"(");
                        }
                        if (line.contains(" [")) {
                            line = StringUtil.replace((String)line, (String)" [", (String)"[");
                        }
                        int x2 = -1;
                        while (true) {
                            char previousChar;
                            char nextChar;
                            int posComma = line.indexOf(",", x2 + 1);
                            int posSemicolon = line.indexOf(";", x2 + 1);
                            if (posComma == -1 && posSemicolon == -1) break;
                            x2 = Math.min(posComma, posSemicolon);
                            if (x2 == -1) {
                                x2 = Math.max(posComma, posSemicolon);
                            }
                            if (line.length() > x2 + 1 && (nextChar = line.charAt(x2 + 1)) != '\'' && nextChar != ')' && nextChar != ' ' && nextChar != '*') {
                                line = StringUtil.insert((String)line, (String)" ", (int)(x2 + 1));
                            }
                            if (x2 <= 0 || (previousChar = line.charAt(x2 - 1)) != ' ') continue;
                            line = line.substring(0, x2 - 1).concat(line.substring(x2));
                        }
                    }
                    if ((line.contains(" && ") || line.contains(" || ")) && line.endsWith("(")) {
                        JavaSourceProcessor.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                    }
                    if (trimmedLine.endsWith("+") && !trimmedLine.startsWith("(")) {
                        int closeParenthesisCount2 = StringUtil.count((String)strippedQuotesLine, (String)")");
                        int openParenthesisCount2 = StringUtil.count((String)strippedQuotesLine, (String)"(");
                        if (openParenthesisCount2 > closeParenthesisCount2) {
                            JavaSourceProcessor.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                        }
                    }
                    if ((x = strippedQuotesLine.indexOf(", ")) != -1) {
                        int openParenthesisCount3;
                        String linePart = strippedQuotesLine.substring(0, x);
                        int closeParenthesisCount3 = StringUtil.count((String)linePart, (String)")");
                        if (closeParenthesisCount3 > (openParenthesisCount3 = StringUtil.count((String)linePart, (String)"("))) {
                            JavaSourceProcessor.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                        }
                    } else if (trimmedLine.endsWith(",") && !trimmedLine.startsWith("for (") && (closeParenthesisCount = StringUtil.count((String)strippedQuotesLine, (String)")")) < (openParenthesisCount = StringUtil.count((String)strippedQuotesLine, (String)"("))) {
                        JavaSourceProcessor.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                    }
                    if (line.contains(",") && !line.contains(")") && !line.contains(">") && !line.contains("\"") && line.endsWith("(")) {
                        JavaSourceProcessor.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                    }
                    if ((line.endsWith(" +") || line.endsWith(" -") || line.endsWith(" *") || line.endsWith(" /")) && (x = line.indexOf(" = ")) != -1 && ((y = line.indexOf("\"")) == -1 || x < y)) {
                        JavaSourceProcessor.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                    }
                    if (line.endsWith(" throws") || previousLine.endsWith("(") && line.contains(" throws ") && line.endsWith("{")) {
                        JavaSourceProcessor.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                    }
                    if (trimmedLine.startsWith(".") || line.endsWith(".") && line.contains("=")) {
                        JavaSourceProcessor.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                    }
                    if (trimmedLine.startsWith("}") && line.endsWith("{") && !(matcher = this._lineBreakPattern.matcher(trimmedLine)).find()) {
                        JavaSourceProcessor.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                    }
                }
                if (line.contains("    ") && !line.matches("\\s*\\*.*") && !fileName.endsWith("StringPool.java")) {
                    JavaSourceProcessor.processErrorMessage(fileName, "tab: " + fileName + " " + lineCount);
                }
                if (line.contains("  {") && !line.matches("\\s*\\*.*")) {
                    JavaSourceProcessor.processErrorMessage(fileName, "{:" + fileName + " " + lineCount);
                }
                Tuple combinedLines = null;
                int lineLength = this.getLineLength(line);
                if (!(line.startsWith("import ") || line.startsWith("package ") || line.matches("\\s*\\*.*") || fileName.endsWith("Table.java") && line.contains("String TABLE_SQL_CREATE = ") || fileName.endsWith("Table.java") && line.contains("String TABLE_SQL_DROP = ") || fileName.endsWith("Table.java") && line.contains(" index IX_"))) {
                    if (lineLength > 80) {
                        if (!JavaSourceProcessor.isExcluded(this._lineLengthExclusions, absolutePath, lineCount) && !this.isAnnotationParameter(content, trimmedLine)) {
                            JavaSourceProcessor.processErrorMessage(fileName, "> 80: " + fileName + " " + lineCount);
                        }
                    } else {
                        int lineLeadingTabCount = JavaSourceProcessor.getLeadingTabCount(line);
                        int previousLineLeadingTabCount = JavaSourceProcessor.getLeadingTabCount(previousLine);
                        if (!trimmedLine.startsWith("//")) {
                            int x;
                            if (previousLine.endsWith(",") && previousLine.contains("(") && !previousLine.contains("for (") && lineLeadingTabCount > previousLineLeadingTabCount) {
                                JavaSourceProcessor.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                            }
                            if (lineLeadingTabCount == previousLineLeadingTabCount && (previousLine.endsWith("=") || previousLine.endsWith("("))) {
                                JavaSourceProcessor.processErrorMessage(fileName, "tab: " + fileName + " " + lineCount);
                            }
                            if (Validator.isNotNull((String)trimmedLine)) {
                                if ((previousLine.endsWith(":") && previousLine.contains("\tfor ") || previousLine.endsWith("(") && previousLine.contains("\tif ")) && previousLineLeadingTabCount + 2 != lineLeadingTabCount) {
                                    JavaSourceProcessor.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                                }
                                if (previousLine.endsWith("{") && !trimmedLine.startsWith("}") && previousLineLeadingTabCount + 1 != lineLeadingTabCount) {
                                    JavaSourceProcessor.processErrorMessage(fileName, "tab: " + fileName + " " + lineCount);
                                }
                            }
                            if (previousLine.endsWith(".") && (x = trimmedLine.indexOf("(")) != -1 && this.getLineLength(previousLine) + x < 80 && (trimmedLine.endsWith("(") || trimmedLine.charAt(x + 1) != ')')) {
                                JavaSourceProcessor.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                            }
                            int diff = lineLeadingTabCount - previousLineLeadingTabCount;
                            if (trimmedLine.startsWith("throws ") && (diff == 0 || diff > 1)) {
                                JavaSourceProcessor.processErrorMessage(fileName, "tab: " + fileName + " " + lineCount);
                            }
                            if (diff == 2 && previousLineLeadingTabCount > 0 && line.endsWith(";") && !previousLine.contains("\ttry (")) {
                                line = StringUtil.replaceFirst((String)line, (String)"\t", (String)"");
                            }
                            if ((previousLine.contains(" class ") || previousLine.contains(" enum ")) && previousLine.endsWith("{") && Validator.isNotNull((String)line) && !trimmedLine.startsWith("}")) {
                                JavaSourceProcessor.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                            }
                        }
                        if (!JavaSourceProcessor.isExcluded(this._fitOnSingleLineExclusions, absolutePath, lineCount)) {
                            combinedLines = this.getCombinedLines(trimmedLine, previousLine, lineLeadingTabCount, previousLineLeadingTabCount);
                        }
                    }
                }
                if (combinedLines != null) {
                    previousLine = (String)combinedLines.getObject(0);
                    if (combinedLines.getSize() > 1) {
                        String linePart = (String)combinedLines.getObject(1);
                        boolean addToPreviousLine = (Boolean)combinedLines.getObject(2);
                        if (addToPreviousLine) {
                            previousLine = previousLine + linePart;
                            line = StringUtil.replaceFirst((String)line, (String)linePart, (String)"");
                        } else if (linePart.length() + lineLength <= 80 && (line.endsWith("{") || line.endsWith(";"))) {
                            previousLine = StringUtil.replaceLast((String)previousLine, (String)StringUtil.trim((String)linePart), (String)"");
                            line = StringUtil.replaceLast((String)line, (String)"\t", (String)("\t" + linePart));
                        } else {
                            JavaSourceProcessor.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                        }
                        sb.append(previousLine);
                        sb.append("\n");
                        previousLine = line;
                        continue;
                    }
                    if (!line.endsWith("{") || previousLine.contains(" class ")) continue;
                    lineToSkipIfEmpty = lineCount + 1;
                    continue;
                }
                if (lineCount > 1 && (Validator.isNotNull((String)previousLine) || lineToSkipIfEmpty != lineCount - 1)) {
                    sb.append(previousLine);
                    if (Validator.isNotNull((String)previousLine) && Validator.isNotNull((String)trimmedLine) && !previousLine.contains("/*") && !previousLine.endsWith("*/")) {
                        String trimmedPreviousLine = StringUtil.trimLeading((String)previousLine);
                        if (trimmedPreviousLine.startsWith("// ") && !trimmedLine.startsWith("// ") || !trimmedPreviousLine.startsWith("// ") && trimmedLine.startsWith("// ")) {
                            sb.append("\n");
                        } else if (!trimmedPreviousLine.endsWith("{") && !trimmedPreviousLine.endsWith(":") && (trimmedLine.startsWith("for (") || trimmedLine.startsWith("if ("))) {
                            sb.append("\n");
                        } else if (!(!previousLine.endsWith("\t}") || trimmedLine.startsWith("}") || trimmedLine.startsWith(")") || trimmedLine.startsWith("//") || trimmedLine.equals("*/") || trimmedLine.startsWith("catch ") || trimmedLine.startsWith("else ") || trimmedLine.startsWith("finally ") || trimmedLine.startsWith("while "))) {
                            sb.append("\n");
                        }
                    }
                    sb.append("\n");
                }
                previousLine = line;
            }
            sb.append(previousLine);
        }
        String newContent = sb.toString();
        if (newContent.endsWith("\n")) {
            newContent = newContent.substring(0, newContent.length() - 1);
        }
        return newContent;
    }

    protected Tuple getCombinedLines(String line, String previousLine, int lineTabCount, int previousLineTabCount) {
        String filePart;
        int pos;
        if (Validator.isNull((String)line) || Validator.isNull((String)previousLine)) {
            return null;
        }
        String trimmedPreviousLine = StringUtil.trimLeading((String)previousLine);
        if (line.startsWith("// ") || trimmedPreviousLine.startsWith("// ")) {
            return null;
        }
        if (previousLine.endsWith(" extends")) {
            return new Tuple(new Object[]{previousLine, "extends ", false});
        }
        if (previousLine.endsWith(" implements")) {
            return new Tuple(new Object[]{previousLine, "implements ", false});
        }
        if (line.startsWith("+ ") || line.startsWith("- ") || line.startsWith("|| ") || line.startsWith("&& ")) {
            int pos2 = line.indexOf(" ");
            String linePart = line.substring(0, pos2);
            return new Tuple(new Object[]{previousLine + " ", linePart, true});
        }
        int previousLineLength = this.getLineLength(previousLine);
        if (line.length() + previousLineLength < 80) {
            if (trimmedPreviousLine.startsWith("for ") && previousLine.endsWith(":") && line.endsWith("{")) {
                return new Tuple(new Object[]{previousLine + " " + line});
            }
            if ((previousLine.endsWith("=") || previousLine.endsWith(".") || trimmedPreviousLine.equals("return")) && line.endsWith(";")) {
                return new Tuple(new Object[]{previousLine + " " + line});
            }
            if ((trimmedPreviousLine.startsWith("if ") || trimmedPreviousLine.startsWith("else ")) && (previousLine.endsWith("||") || previousLine.endsWith("&&")) && line.endsWith("{")) {
                return new Tuple(new Object[]{previousLine + " " + line});
            }
            if ((line.startsWith("extends ") || line.startsWith("implements ") || line.startsWith("throws")) && (line.endsWith("{") || line.endsWith(";")) && lineTabCount == previousLineTabCount + 1) {
                return new Tuple(new Object[]{previousLine + " " + line});
            }
        }
        if (previousLine.endsWith("=") && line.endsWith(";")) {
            String tempLine = line;
            int pos3 = 0;
            while (true) {
                int closeParenthesisCount;
                if ((pos3 = tempLine.indexOf("-")) == -1) {
                    pos3 = tempLine.indexOf("+");
                }
                if (pos3 == -1) {
                    pos3 = tempLine.indexOf("/");
                }
                if (pos3 == -1) {
                    pos3 = tempLine.indexOf("*");
                }
                if (pos3 == -1) {
                    pos3 = tempLine.indexOf("||");
                }
                if (pos3 == -1) {
                    pos3 = tempLine.indexOf("&&");
                }
                if (pos3 == -1) break;
                String linePart = tempLine.substring(0, pos3);
                int openParenthesisCount = StringUtil.count((String)linePart, (String)"(");
                if (openParenthesisCount == (closeParenthesisCount = StringUtil.count((String)linePart, (String)")"))) {
                    return null;
                }
                tempLine = tempLine.substring(0, pos3) + tempLine.substring(pos3 + 1);
            }
            int x = line.indexOf("(");
            if (x == 0) {
                x = line.indexOf("(", 1);
            }
            if (x != -1) {
                char previousChar;
                int y = line.indexOf(")", x);
                int z = line.indexOf("\"");
                if (x + 1 != y && (z == -1 || z > x) && (previousChar = line.charAt(x - 1)) != ')' && previousChar != '(' && previousChar != ' ' && previousLineLength + 1 + x < 80) {
                    String linePart = line.substring(0, x + 1);
                    if (linePart.startsWith("(") && !linePart.contains(")")) {
                        return null;
                    }
                    return new Tuple(new Object[]{previousLine + " ", linePart, true});
                }
            }
        }
        if (previousLine.endsWith(",") && previousLineTabCount == lineTabCount && !previousLine.contains("}") && !line.endsWith("{")) {
            int x = line.indexOf(",");
            if (x != -1) {
                while (previousLineLength + 1 + x < 80) {
                    String linePart = line.substring(0, x + 1);
                    if (this.isValidJavaParameter(linePart)) {
                        if (line.equals(linePart)) {
                            return new Tuple(new Object[]{previousLine + " " + linePart});
                        }
                        return new Tuple(new Object[]{previousLine + " ", linePart + " ", true});
                    }
                    String partAfterComma = line.substring(x + 1);
                    int pos4 = partAfterComma.indexOf(",");
                    if (pos4 != -1) {
                        x = x + pos4 + 1;
                        continue;
                    }
                    break;
                }
            } else if (!(line.endsWith("(") || line.endsWith("+") || line.endsWith(".") || line.startsWith("new ") && line.endsWith("{") || line.length() + previousLineLength >= 80)) {
                return new Tuple(new Object[]{previousLine + " " + line});
            }
        }
        if (!previousLine.endsWith("(")) {
            return null;
        }
        if (StringUtil.count((String)previousLine, (String)"(") > 1 && (pos = trimmedPreviousLine.lastIndexOf("(", trimmedPreviousLine.length() - 2)) > 0 && Character.isLetterOrDigit(trimmedPreviousLine.charAt(pos - 1)) && !(filePart = trimmedPreviousLine.substring(pos + 1)).contains(")") && !filePart.contains("\"")) {
            return new Tuple(new Object[]{previousLine, filePart, false});
        }
        if (line.length() + previousLineLength > 80) {
            return null;
        }
        if (line.endsWith(";")) {
            return new Tuple(new Object[]{previousLine + line});
        }
        if (line.endsWith(",")) {
            String strippedQuotesLine = this.stripQuotes(line, '\"');
            int openParenthesisCount = StringUtil.count((String)strippedQuotesLine, (String)"(");
            int closeParenthesisCount = StringUtil.count((String)strippedQuotesLine, (String)")");
            if (closeParenthesisCount > openParenthesisCount) {
                return new Tuple(new Object[]{previousLine + line});
            }
        }
        if ((line.endsWith("{") && !line.startsWith("new ") || line.endsWith(")")) && (trimmedPreviousLine.startsWith("else ") || trimmedPreviousLine.startsWith("if ") || trimmedPreviousLine.startsWith("private ") || trimmedPreviousLine.startsWith("protected ") || trimmedPreviousLine.startsWith("public "))) {
            return new Tuple(new Object[]{previousLine + line});
        }
        return null;
    }

    protected Set<String> getImmutableFieldTypes() {
        Set immutableFieldTypes = SetUtil.fromArray((Object[])new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Class", "java.lang.Double", "java.lang.Float", "java.lang.Int", "java.lang.Long", "java.lang.Number", "java.lang.Short", "java.lang.String", "java.lang.reflect.Constructor", "java.lang.reflect.Field", "java.lang.reflect.Method"});
        immutableFieldTypes.addAll(this.getPropertyList("immutable.field.types"));
        return immutableFieldTypes;
    }

    protected List<String> getImportedExceptionClassNames(JavaDocBuilder javaDocBuilder) {
        ArrayList<String> exceptionClassNames = new ArrayList<String>();
        JavaSource javaSource = javaDocBuilder.getSources()[0];
        for (String importClassName : javaSource.getImports()) {
            if (!importClassName.endsWith("Exception") || exceptionClassNames.contains(importClassName)) continue;
            exceptionClassNames.add(importClassName);
        }
        return exceptionClassNames;
    }

    protected int getLineLength(String line) {
        int lineLength = 0;
        int tabLength = 4;
        for (char c : line.toCharArray()) {
            if (c == '\t') {
                for (int i = 0; i < tabLength; ++i) {
                    ++lineLength;
                }
                tabLength = 4;
                continue;
            }
            ++lineLength;
            if (--tabLength > 0) continue;
            tabLength = 4;
        }
        return lineLength;
    }

    protected Collection<String> getPluginJavaFiles() {
        TreeSet<String> fileNames = new TreeSet<String>();
        String[] excludes = new String[]{"**\\model\\*Clp.java", "**\\model\\impl\\*BaseImpl.java", "**\\model\\impl\\*Model.java", "**\\model\\impl\\*ModelImpl.java", "**\\service\\**\\service\\*Service.java", "**\\service\\**\\service\\*ServiceClp.java", "**\\service\\**\\service\\*ServiceFactory.java", "**\\service\\**\\service\\*ServiceUtil.java", "**\\service\\**\\service\\*ServiceWrapper.java", "**\\service\\**\\service\\ClpSerializer.java", "**\\service\\**\\service\\messaging\\*ClpMessageListener.java", "**\\service\\**\\service\\persistence\\*Finder.java", "**\\service\\**\\service\\persistence\\*Util.java", "**\\service\\base\\*ServiceBaseImpl.java", "**\\service\\base\\*ServiceClpInvoker.java", "**\\service\\http\\*JSONSerializer.java", "**\\service\\http\\*ServiceHttp.java", "**\\service\\http\\*ServiceJSON.java", "**\\service\\http\\*ServiceSoap.java"};
        String[] includes = new String[]{"**\\*.java"};
        fileNames.addAll(this.getFileNames(excludes, includes));
        return fileNames;
    }

    protected Collection<String> getPortalJavaFiles() {
        TreeSet<String> fileNames = new TreeSet<String>();
        String[] excludes = new String[]{"**\\*_IW.java", "**\\PropsValues.java", "**\\counter\\service\\**", "**\\jsp\\*", "**\\model\\impl\\*BaseImpl.java", "**\\model\\impl\\*Model.java", "**\\model\\impl\\*ModelImpl.java", "**\\portal\\service\\**", "**\\portal-client\\**", "**\\portal-web\\test\\**\\*Test.java", "**\\portlet\\**\\service\\**", "**\\test\\*-generated\\**", "**\\tools\\sourceformatter\\**"};
        String[] includes = new String[]{"**\\*.java"};
        fileNames.addAll(this.getFileNames(excludes, includes));
        excludes = new String[]{"**\\JavaDocFormatter.java", "**\\portal-client\\**", "**\\tools\\ext_tmpl\\**", "**\\*_IW.java", "**\\test\\**\\*PersistenceTest.java", "**\\tools\\sourceformatter\\**"};
        includes = new String[]{"**\\com\\liferay\\portal\\service\\ServiceContext*.java", "**\\model\\BaseModel.java", "**\\model\\impl\\BaseModelImpl.java", "**\\portal-test\\**\\portal\\service\\**\\*.java", "**\\service\\Base*.java", "**\\service\\PersistedModelLocalService*.java", "**\\service\\base\\PrincipalBean.java", "**\\service\\http\\*HttpTest.java", "**\\service\\http\\*SoapTest.java", "**\\service\\http\\TunnelUtil.java", "**\\service\\impl\\*.java", "**\\service\\jms\\*.java", "**\\service\\permission\\*.java", "**\\service\\persistence\\BasePersistence.java", "**\\service\\persistence\\BatchSession*.java", "**\\service\\persistence\\*FinderImpl.java", "**\\service\\persistence\\*Query.java", "**\\service\\persistence\\impl\\*.java", "**\\portal-impl\\test\\**\\*.java", "**\\util-bridges\\**\\*.java"};
        fileNames.addAll(this.getFileNames(excludes, includes));
        return fileNames;
    }

    protected boolean isAnnotationParameter(String content, String line) {
        if (!line.contains(" = ") && !line.startsWith("\"")) {
            return false;
        }
        Matcher matcher = this._annotationPattern.matcher(content);
        while (matcher.find()) {
            String annotationParameters = matcher.group(3);
            if (!annotationParameters.contains(line)) continue;
            return true;
        }
        return false;
    }

    protected boolean isGenerated(String content) {
        return content.contains("* @generated") || content.contains("$ANTLR");
    }

    protected boolean isValidJavaParameter(String javaParameter) {
        int quoteCount = StringUtil.count((String)javaParameter, (String)"\"");
        if (quoteCount % 2 == 1) {
            return false;
        }
        javaParameter = this.stripQuotes(javaParameter, '\"');
        int openParenthesisCount = StringUtil.count((String)javaParameter, (String)"(");
        int closeParenthesisCount = StringUtil.count((String)javaParameter, (String)")");
        int lessThanCount = StringUtil.count((String)javaParameter, (String)"<");
        int greaterThanCount = StringUtil.count((String)javaParameter, (String)">");
        int openCurlyBraceCount = StringUtil.count((String)javaParameter, (String)"{");
        int closeCurlyBraceCount = StringUtil.count((String)javaParameter, (String)"}");
        return openParenthesisCount == closeParenthesisCount && lessThanCount == greaterThanCount && openCurlyBraceCount == closeCurlyBraceCount;
    }

    protected String sanitizeContent(String content) {
        Matcher componentPropertyMatcher = this._componentPropertyPattern.matcher(content);
        if (!componentPropertyMatcher.find()) {
            return content;
        }
        String prefix = content.substring(0, componentPropertyMatcher.start(1));
        String postfix = content.substring(componentPropertyMatcher.end(1));
        return prefix.concat(postfix);
    }

    protected String sortExceptions(String line) {
        String exception;
        if (!line.endsWith("{") && !line.endsWith(";")) {
            return line;
        }
        int x = line.indexOf("throws ");
        if (x == -1) {
            return line;
        }
        String previousException = "";
        String[] exceptions = StringUtil.split((String)line.substring(x), (char)' ');
        for (int i = 1; i < exceptions.length && !(exception = exceptions[i]).equals("{"); ++i) {
            if (exception.endsWith(",") || exception.endsWith(";")) {
                exception = exception.substring(0, exception.length() - 1);
            }
            if (Validator.isNotNull((String)previousException) && previousException.compareToIgnoreCase(exception) > 0) {
                line = StringUtil.replace((String)line, (String)(previousException + ", " + exception), (String)(exception + ", " + previousException));
                return this.sortExceptions(line);
            }
            previousException = exception;
        }
        return line;
    }
}

