/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.sourceformatter.ImportPackage;
import com.liferay.portal.tools.sourceformatter.ImportsFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaImportsFormatter
extends ImportsFormatter {
    private static final Pattern _javaImportPattern = Pattern.compile("import( static)? ([^;]+);");

    @Override
    protected ImportPackage createImportPackage(String line) {
        Matcher matcher = _javaImportPattern.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        boolean isStatic = false;
        if (Validator.isNotNull((String)matcher.group(1))) {
            isStatic = true;
        }
        String importString = matcher.group(2);
        return new ImportPackage(importString, isStatic, line);
    }
}

