/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.sourceformatter.BaseSourceProcessor;
import com.liferay.portal.tools.sourceformatter.JavaSourceProcessor;
import com.liferay.portal.tools.sourceformatter.JavaTerm;
import com.liferay.portal.tools.sourceformatter.JavaTermComparator;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaClass {
    public static final int[] TYPE_CLASS = new int[]{24, 23, 16, 15, 8, 7};
    public static final int TYPE_CLASS_PRIVATE = 24;
    public static final int TYPE_CLASS_PRIVATE_STATIC = 23;
    public static final int TYPE_CLASS_PROTECTED = 16;
    public static final int TYPE_CLASS_PROTECTED_STATIC = 15;
    public static final int TYPE_CLASS_PUBLIC = 8;
    public static final int TYPE_CLASS_PUBLIC_STATIC = 7;
    public static final int[] TYPE_CONSTRUCTOR = new int[]{18, 10, 4};
    public static final int TYPE_CONSTRUCTOR_PRIVATE = 18;
    public static final int TYPE_CONSTRUCTOR_PROTECTED = 10;
    public static final int TYPE_CONSTRUCTOR_PUBLIC = 4;
    public static final int[] TYPE_METHOD = new int[]{19, 17, 11, 9, 5, 3};
    public static final int TYPE_METHOD_PRIVATE = 19;
    public static final int TYPE_METHOD_PRIVATE_STATIC = 17;
    public static final int TYPE_METHOD_PROTECTED = 11;
    public static final int TYPE_METHOD_PROTECTED_STATIC = 9;
    public static final int TYPE_METHOD_PUBLIC = 5;
    public static final int TYPE_METHOD_PUBLIC_STATIC = 3;
    public static final int TYPE_STATIC_BLOCK = 21;
    public static final int[] TYPE_VARIABLE = new int[]{22, 20, 14, 12, 6, 1};
    public static final int[] TYPE_VARIABLE_STATIC = new int[]{20, 12, 1};
    public static final int TYPE_VARIABLE_PRIVATE = 22;
    public static final int TYPE_VARIABLE_PRIVATE_STATIC = 20;
    public static final int TYPE_VARIABLE_PROTECTED = 14;
    public static final int TYPE_VARIABLE_PROTECTED_STATIC = 12;
    public static final int TYPE_VARIABLE_PUBLIC = 6;
    public static final int TYPE_VARIABLE_PUBLIC_STATIC = 1;
    private String _absolutePath;
    private Pattern _classPattern = Pattern.compile("(private |protected |public )(static )*class ([\\s\\S]*?) \\{\n");
    private String _content;
    private String _fileName;
    private String _indent;
    private int _lineCount;
    private List<JavaTerm> _staticBlocks;

    public JavaClass(String fileName, String absolutePath, String content, int lineCount, String indent) throws Exception {
        this._fileName = fileName;
        this._absolutePath = absolutePath;
        this._content = content;
        this._lineCount = lineCount;
        this._indent = indent;
        this._staticBlocks = new ArrayList<JavaTerm>();
    }

    public String formatJavaTerms(List<String> javaTermAccessLevelModifierExclusions, List<String> javaTermSortExclusions, List<String> testAnnotationsExclusions) throws Exception {
        Set<JavaTerm> javaTerms = this.getJavaTerms(javaTermAccessLevelModifierExclusions);
        if (javaTerms == null) {
            return this._content;
        }
        String originalContent = this._content;
        javaTerms = this.addStaticBlocks(javaTerms);
        if (!originalContent.equals(this._content)) {
            return this._content;
        }
        JavaTerm previousJavaTerm = null;
        for (JavaTerm javaTerm : javaTerms) {
            if (JavaClass.isInJavaTermTypeGroup(javaTerm.getType(), TYPE_CLASS)) {
                JavaClass innerClass;
                String newJavaTermContent;
                String javaTermContent = javaTerm.getContent();
                int pos = javaTermContent.indexOf("\n" + this._indent + "static {");
                if (pos != -1) {
                    javaTermContent = javaTermContent.substring(0, pos);
                }
                if (!javaTermContent.equals(newJavaTermContent = (innerClass = new JavaClass(this._fileName, this._absolutePath, javaTermContent, javaTerm.getLineCount(), this._indent + "\t")).formatJavaTerms(javaTermAccessLevelModifierExclusions, javaTermSortExclusions, testAnnotationsExclusions))) {
                    this._content = StringUtil.replace((String)this._content, (String)javaTermContent, (String)newJavaTermContent);
                    return this._content;
                }
            }
            this.sortJavaTerms(previousJavaTerm, javaTerm, javaTermSortExclusions);
            this.fixTabsAndIncorrectEmptyLines(javaTerm);
            this.formatAnnotations(javaTerm, testAnnotationsExclusions);
            if (!originalContent.equals(this._content)) {
                return this._content;
            }
            previousJavaTerm = javaTerm;
        }
        this.fixJavaTermsDividers(javaTerms, javaTermSortExclusions);
        return this._content;
    }

    protected static boolean isInJavaTermTypeGroup(int javaTermType, int[] javaTermTypeGroup) {
        for (int type : javaTermTypeGroup) {
            if (javaTermType != type) continue;
            return true;
        }
        return false;
    }

    protected Set<JavaTerm> addStaticBlocks(Set<JavaTerm> javaTerms) {
        TreeSet<JavaTerm> newJavaTerms = new TreeSet<JavaTerm>(new JavaTermComparator());
        for (JavaTerm javaTerm : javaTerms) {
            if (!JavaClass.isInJavaTermTypeGroup(javaTerm.getType(), TYPE_VARIABLE_STATIC)) {
                newJavaTerms.add(javaTerm);
                continue;
            }
            Iterator<JavaTerm> staticBlocksIterator = this._staticBlocks.iterator();
            while (staticBlocksIterator.hasNext()) {
                JavaTerm staticBlock = staticBlocksIterator.next();
                String staticBlockContent = staticBlock.getContent();
                if (!staticBlockContent.contains(javaTerm.getName())) continue;
                staticBlock.setType(javaTerm.getType() + 1);
                newJavaTerms.add(staticBlock);
                staticBlocksIterator.remove();
            }
            newJavaTerms.add(javaTerm);
        }
        if (!this._staticBlocks.isEmpty()) {
            newJavaTerms.addAll(this._staticBlocks);
        }
        return newJavaTerms;
    }

    protected void checkAnnotationForMethod(JavaTerm javaTerm, String annotation, String requiredMethodNameRegex, int requiredMethodType, String fileName) {
        String methodContent = javaTerm.getContent();
        String methodName = javaTerm.getName();
        Pattern pattern = Pattern.compile(requiredMethodNameRegex);
        Matcher matcher = pattern.matcher(methodName);
        if (methodContent.contains(this._indent + "@" + annotation + "\n") || methodContent.contains(this._indent + "@" + annotation + "(")) {
            if (!matcher.find()) {
                BaseSourceProcessor.processErrorMessage(fileName, "LPS-36303: Incorrect method name: " + methodName + " " + fileName);
            } else if (javaTerm.getType() != requiredMethodType) {
                BaseSourceProcessor.processErrorMessage(fileName, "LPS-36303: Incorrect method type for " + methodName + " " + fileName);
            }
        } else if (matcher.find() && !methodContent.contains(this._indent + "@Override")) {
            BaseSourceProcessor.processErrorMessage(fileName, "Annotation @" + annotation + " required for " + methodName + " " + fileName);
        }
    }

    protected void checkTestAnnotations(JavaTerm javaTerm) {
        int methodType = javaTerm.getType();
        if (methodType != 5 && methodType != 3) {
            return;
        }
        this.checkAnnotationForMethod(javaTerm, "After", "^.*tearDown\\z", 5, this._fileName);
        this.checkAnnotationForMethod(javaTerm, "AfterClass", "^.*tearDownClass\\z", 3, this._fileName);
        this.checkAnnotationForMethod(javaTerm, "Before", "^.*setUp\\z", 5, this._fileName);
        this.checkAnnotationForMethod(javaTerm, "BeforeClass", "^.*setUpClass\\z", 3, this._fileName);
        this.checkAnnotationForMethod(javaTerm, "Test", "^.*test", 5, this._fileName);
    }

    protected void fixJavaTermsDividers(Set<JavaTerm> javaTerms, List<String> javaTermSortExclusions) {
        JavaTerm previousJavaTerm = null;
        for (JavaTerm javaTerm : javaTerms) {
            if (previousJavaTerm == null) {
                previousJavaTerm = javaTerm;
                continue;
            }
            String javaTermContent = javaTerm.getContent();
            if (javaTermContent.startsWith(this._indent + "//")) {
                previousJavaTerm = javaTerm;
                continue;
            }
            String previousJavaTermContent = previousJavaTerm.getContent();
            if (previousJavaTermContent.startsWith(this._indent + "//")) {
                previousJavaTerm = javaTerm;
                continue;
            }
            String javaTermName = javaTerm.getName();
            if (BaseSourceProcessor.isExcluded(javaTermSortExclusions, this._absolutePath, javaTerm.getLineCount(), javaTermName)) {
                previousJavaTerm = javaTerm;
                continue;
            }
            String previousJavaTermName = previousJavaTerm.getName();
            boolean requiresEmptyLine = false;
            if (previousJavaTerm.getType() != javaTerm.getType()) {
                requiresEmptyLine = true;
            } else if (!JavaClass.isInJavaTermTypeGroup(javaTerm.getType(), TYPE_VARIABLE)) {
                requiresEmptyLine = true;
            } else if (StringUtil.isUpperCase((String)javaTermName) && !StringUtil.isLowerCase((String)javaTermName) || StringUtil.isUpperCase((String)previousJavaTermName) && !StringUtil.isLowerCase((String)previousJavaTermName)) {
                requiresEmptyLine = true;
            } else if (this.hasAnnotationCommentOrJavadoc(javaTermContent) || this.hasAnnotationCommentOrJavadoc(previousJavaTermContent)) {
                requiresEmptyLine = true;
            } else if (previousJavaTerm.getType() == 20 && (previousJavaTermName.equals("_instance") || previousJavaTermName.equals("_log") || previousJavaTermName.equals("_logger"))) {
                requiresEmptyLine = true;
            } else if (previousJavaTermContent.contains("\n\n\t") || javaTermContent.contains("\n\n\t")) {
                requiresEmptyLine = true;
            }
            if (requiresEmptyLine) {
                if (!this._content.contains("\n\n" + javaTermContent)) {
                    this._content = StringUtil.replace((String)this._content, (String)("\n" + javaTermContent), (String)("\n\n" + javaTermContent));
                    return;
                }
            } else if (this._content.contains("\n\n" + javaTermContent)) {
                this._content = StringUtil.replace((String)this._content, (String)("\n\n" + javaTermContent), (String)("\n" + javaTermContent));
                return;
            }
            previousJavaTerm = javaTerm;
        }
    }

    protected String fixLeadingTabs(String content, String line, int expectedTabCount) {
        int leadingTabCount = JavaSourceProcessor.getLeadingTabCount(line);
        String newLine = line;
        while (leadingTabCount != expectedTabCount) {
            if (leadingTabCount > expectedTabCount) {
                newLine = StringUtil.replaceFirst((String)newLine, (String)"\t", (String)"");
                --leadingTabCount;
                continue;
            }
            newLine = "\t" + newLine;
            ++leadingTabCount;
        }
        return StringUtil.replace((String)content, (String)line, (String)newLine);
    }

    protected void fixTabsAndIncorrectEmptyLines(JavaTerm javaTerm) {
        if (!JavaClass.isInJavaTermTypeGroup(javaTerm.getType(), TYPE_METHOD)) {
            return;
        }
        String javaTermContent = "\n" + javaTerm.getContent();
        Pattern methodNameAndParametersPattern = Pattern.compile("\n" + this._indent + "(private |protected |public )(.|\n)*?(\\{|;)\n");
        Matcher matcher = methodNameAndParametersPattern.matcher(javaTermContent);
        if (!matcher.find()) {
            return;
        }
        String methodNameAndParameters = matcher.group();
        String[] lines = StringUtil.splitLines((String)methodNameAndParameters);
        if (lines.length == 1) {
            String trimmedJavaTermContent;
            if (methodNameAndParameters.endsWith("{\n") && javaTermContent.contains(methodNameAndParameters + "\n") && !javaTermContent.contains(methodNameAndParameters + "\n" + this._indent + "\t" + "/*") && !javaTermContent.contains(methodNameAndParameters + "\n" + this._indent + "\t" + "// ") && !(trimmedJavaTermContent = StringUtil.trimTrailing((String)javaTermContent)).endsWith("\n\n" + this._indent + "}")) {
                this._content = StringUtil.replace((String)this._content, (String)(methodNameAndParameters + "\n"), (String)methodNameAndParameters);
            }
            return;
        }
        if (methodNameAndParameters.endsWith("{\n") && !javaTermContent.contains(methodNameAndParameters + "\n") && !javaTermContent.contains(methodNameAndParameters + this._indent + "}")) {
            this._content = StringUtil.replace((String)this._content, (String)methodNameAndParameters, (String)(methodNameAndParameters + "\n"));
        }
        boolean throwsException = methodNameAndParameters.contains(this._indent + "throws ");
        String newMethodNameAndParameters = methodNameAndParameters;
        int expectedTabCount = -1;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.contains(this._indent + "throws ")) {
                newMethodNameAndParameters = this.fixLeadingTabs(newMethodNameAndParameters, line, this._indent.length() + 1);
                break;
            }
            if (expectedTabCount == -1) {
                if (!line.endsWith("(")) continue;
                expectedTabCount = Math.max(JavaSourceProcessor.getLeadingTabCount(line), this._indent.length()) + 1;
                if (!throwsException || expectedTabCount != this._indent.length() + 1) continue;
                ++expectedTabCount;
                continue;
            }
            String previousLine = lines[i - 1];
            newMethodNameAndParameters = previousLine.endsWith(",") || previousLine.endsWith("(") ? this.fixLeadingTabs(newMethodNameAndParameters, line, expectedTabCount) : this.fixLeadingTabs(newMethodNameAndParameters, line, JavaSourceProcessor.getLeadingTabCount(previousLine) + 1);
        }
        this._content = StringUtil.replace((String)this._content, (String)methodNameAndParameters, (String)newMethodNameAndParameters);
    }

    protected void formatAnnotations(JavaTerm javaTerm, List<String> testAnnotationsExclusions) throws Exception {
        String newJavaTermContent;
        String javaTermContent;
        if (this._indent.length() == 1 && this._fileName.contains("/test/") && !BaseSourceProcessor.isExcluded(testAnnotationsExclusions, this._absolutePath) && !this._fileName.endsWith("TestCase.java")) {
            this.checkTestAnnotations(javaTerm);
        }
        if (!(javaTermContent = javaTerm.getContent()).equals(newJavaTermContent = JavaSourceProcessor.sortAnnotations(javaTermContent, this._indent))) {
            this._content = this._content.replace(javaTermContent, newJavaTermContent);
        }
    }

    protected String getClassName(String line) {
        int pos = line.indexOf(" extends ");
        if (pos == -1) {
            pos = line.indexOf(" implements ");
        }
        if (pos == -1) {
            pos = line.indexOf("{");
        }
        if (pos != -1) {
            line = line.substring(0, pos);
        }
        if ((pos = line.indexOf("<")) != -1) {
            line = line.substring(0, pos);
        }
        line = line.trim();
        pos = line.lastIndexOf(" ");
        return line.substring(pos + 1);
    }

    protected String getConstructorOrMethodName(String line, int pos) {
        line = line.substring(0, pos);
        int x = line.lastIndexOf(" ");
        return line.substring(x + 1);
    }

    protected Set<JavaTerm> getJavaTerms(List<String> javaTermAccessLevelModifierExclusions) throws Exception {
        TreeSet<JavaTerm> javaTerms = new TreeSet<JavaTerm>(new JavaTermComparator(false));
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(this._content));
        int index = 0;
        int lineCount = this._lineCount - 1;
        String line = null;
        JavaTerm javaTerm = null;
        String javaTermName = null;
        int javaTermLineCount = -1;
        int javaTermStartPosition = -1;
        int javaTermType = -1;
        int lastCommentOrAnnotationPos = -1;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String insideClass;
            Matcher matcher;
            ++lineCount;
            if (JavaSourceProcessor.getLeadingTabCount(line) != this._indent.length()) {
                index = index + line.length() + 1;
                continue;
            }
            if (line.startsWith(this._indent + "private ") || line.equals(this._indent + "private") || line.startsWith(this._indent + "protected ") || line.equals(this._indent + "protected") || line.startsWith(this._indent + "public ") || line.equals(this._indent + "public") || line.equals(this._indent + "static {")) {
                Tuple tuple = this.getJavaTermTuple(line, this._content, index);
                if (tuple == null) {
                    return null;
                }
                int javaTermEndPosition = 0;
                javaTermEndPosition = lastCommentOrAnnotationPos == -1 ? index : lastCommentOrAnnotationPos;
                if (javaTermStartPosition != -1 && javaTermEndPosition < this._content.length()) {
                    String javaTermContent = this._content.substring(javaTermStartPosition, javaTermEndPosition);
                    if (!this.isValidJavaTerm(javaTermContent)) {
                        return null;
                    }
                    if (Validator.isNotNull((String)javaTermName)) {
                        javaTerm = new JavaTerm(javaTermName, javaTermType, javaTermContent, javaTermLineCount);
                        if (javaTermType == 21) {
                            this._staticBlocks.add(javaTerm);
                        } else {
                            javaTerms.add(javaTerm);
                        }
                    }
                }
                javaTermLineCount = lineCount;
                javaTermName = (String)tuple.getObject(0);
                javaTermStartPosition = javaTermEndPosition;
                javaTermType = (Integer)tuple.getObject(1);
                lastCommentOrAnnotationPos = -1;
            } else if (this.hasAnnotationCommentOrJavadoc(line)) {
                if (lastCommentOrAnnotationPos == -1) {
                    lastCommentOrAnnotationPos = index;
                }
            } else if (!(line.startsWith(this._indent + "}") || line.startsWith(this._indent + ")") || line.startsWith(this._indent + "extends") || line.startsWith(this._indent + "implements") || BaseSourceProcessor.isExcluded(javaTermAccessLevelModifierExclusions, this._absolutePath, lineCount) || !(matcher = this._classPattern.matcher(this._content)).find() || !(insideClass = this._content.substring(matcher.end())).contains(line))) {
                BaseSourceProcessor.processErrorMessage(this._fileName, "Missing access level modifier: " + this._fileName + " " + lineCount);
            }
            index = index + line.length() + 1;
        }
        if (javaTermStartPosition != -1) {
            int javaTermEndPosition = this._content.lastIndexOf("}") - this._indent.length();
            String javaTermContent = this._content.substring(javaTermStartPosition, javaTermEndPosition);
            if (!this.isValidJavaTerm(javaTermContent)) {
                return null;
            }
            javaTerm = new JavaTerm(javaTermName, javaTermType, javaTermContent, javaTermLineCount);
            if (javaTermType == 21) {
                this._staticBlocks.add(javaTerm);
            } else {
                javaTerms.add(javaTerm);
            }
        }
        return javaTerms;
    }

    protected Tuple getJavaTermTuple(String line, String content, int index) {
        int posStartNextLine = index;
        while (!line.endsWith("{") && !line.endsWith(";")) {
            posStartNextLine = content.indexOf("\n", posStartNextLine) + 1;
            int posEndNextline = content.indexOf("\n", posStartNextLine);
            String nextLine = content.substring(posStartNextLine, posEndNextline);
            nextLine = StringUtil.trimLeading((String)nextLine);
            if (line.endsWith("(")) {
                line = line + nextLine;
                continue;
            }
            line = line + " " + nextLine;
        }
        line = StringUtil.replace((String)line, (String)" synchronized ", (String)" ");
        int pos = line.indexOf("(");
        if (line.startsWith(this._indent + "public static ")) {
            if (line.contains(" class ") || line.contains(" enum ")) {
                return new Tuple(new Object[]{this.getClassName(line), 7});
            }
            if (line.contains("=") || line.endsWith(";") && pos == -1) {
                return new Tuple(new Object[]{this.getVariableName(line), 1});
            }
            if (pos != -1) {
                return new Tuple(new Object[]{this.getConstructorOrMethodName(line, pos), 3});
            }
        } else if (line.startsWith(this._indent + "public ")) {
            if (line.contains(" @interface ") || line.contains(" class ") || line.contains(" enum ") || line.contains(" interface ")) {
                return new Tuple(new Object[]{this.getClassName(line), 8});
            }
            if (line.contains("=") || line.endsWith(";") && pos == -1) {
                return new Tuple(new Object[]{this.getVariableName(line), 6});
            }
            if (pos != -1) {
                int spaceCount = StringUtil.count((String)line.substring(0, pos), (String)" ");
                if (spaceCount == 1) {
                    return new Tuple(new Object[]{this.getConstructorOrMethodName(line, pos), 4});
                }
                if (spaceCount > 1) {
                    return new Tuple(new Object[]{this.getConstructorOrMethodName(line, pos), 5});
                }
            }
        } else if (line.startsWith(this._indent + "protected static ")) {
            if (line.contains(" class ") || line.contains(" enum ")) {
                return new Tuple(new Object[]{this.getClassName(line), 15});
            }
            if (line.contains("=") || line.endsWith(";") && pos == -1) {
                return new Tuple(new Object[]{this.getVariableName(line), 12});
            }
            if (pos != -1) {
                return new Tuple(new Object[]{this.getConstructorOrMethodName(line, pos), 9});
            }
        } else {
            if (line.startsWith(this._indent + "protected ")) {
                if (line.contains(" @interface ") || line.contains(" class ") || line.contains(" enum ") || line.contains(" interface ")) {
                    return new Tuple(new Object[]{this.getClassName(line), 16});
                }
                if (pos != -1 && !line.contains("=")) {
                    int spaceCount = StringUtil.count((String)line.substring(0, pos), (String)" ");
                    if (spaceCount == 1) {
                        return new Tuple(new Object[]{this.getConstructorOrMethodName(line, pos), 10});
                    }
                    if (spaceCount > 1) {
                        return new Tuple(new Object[]{this.getConstructorOrMethodName(line, pos), 11});
                    }
                }
                return new Tuple(new Object[]{this.getVariableName(line), 14});
            }
            if (line.startsWith(this._indent + "private static ")) {
                if (line.contains(" class ") || line.contains(" enum ")) {
                    return new Tuple(new Object[]{this.getClassName(line), 23});
                }
                if (line.contains("=") || line.endsWith(";") && pos == -1) {
                    return new Tuple(new Object[]{this.getVariableName(line), 20});
                }
                if (pos != -1) {
                    return new Tuple(new Object[]{this.getConstructorOrMethodName(line, pos), 17});
                }
            } else if (line.startsWith(this._indent + "private ")) {
                if (line.contains(" @interface ") || line.contains(" class ") || line.contains(" enum ") || line.contains(" interface ")) {
                    return new Tuple(new Object[]{this.getClassName(line), 24});
                }
                if (line.contains("=") || line.endsWith(";") && pos == -1) {
                    return new Tuple(new Object[]{this.getVariableName(line), 22});
                }
                if (pos != -1) {
                    int spaceCount = StringUtil.count((String)line.substring(0, pos), (String)" ");
                    if (spaceCount == 1) {
                        return new Tuple(new Object[]{this.getConstructorOrMethodName(line, pos), 18});
                    }
                    if (spaceCount > 1) {
                        return new Tuple(new Object[]{this.getConstructorOrMethodName(line, pos), 19});
                    }
                }
            } else if (line.startsWith(this._indent + "static {")) {
                return new Tuple(new Object[]{"static", 21});
            }
        }
        return null;
    }

    protected String getVariableName(String line) {
        int x = line.indexOf("=");
        int y = line.lastIndexOf(" ");
        if (x != -1) {
            line = line.substring(0, x);
            line = StringUtil.trim((String)line);
            y = line.lastIndexOf(" ");
            return line.substring(y + 1);
        }
        if (line.endsWith(";")) {
            return line.substring(y + 1, line.length() - 1);
        }
        return "";
    }

    protected boolean hasAnnotationCommentOrJavadoc(String s) {
        return s.startsWith(this._indent + "@") || s.startsWith(this._indent + "/") || s.startsWith(this._indent + " *");
    }

    protected boolean isValidJavaTerm(String content) {
        if (content.startsWith(this._indent + "static {")) {
            return true;
        }
        while (!(content.startsWith(this._indent + "private") || content.startsWith(this._indent + "protected") || content.startsWith(this._indent + "public"))) {
            content = content.substring(content.indexOf("\n") + 1);
        }
        int indentLinesCount = StringUtil.count((String)content, (String)("\n" + this._indent)) - StringUtil.count((String)content, (String)("\n" + this._indent + "\t"));
        if ((content = StringUtil.trim((String)content)).endsWith("}") && (indentLinesCount == 1 || (indentLinesCount == 2 || indentLinesCount == 3) && content.contains("\n" + this._indent + "static {"))) {
            return true;
        }
        return content.endsWith("};") && indentLinesCount == 1 || content.endsWith(";") && indentLinesCount == 0;
    }

    protected void sortJavaTerms(JavaTerm previousJavaTerm, JavaTerm javaTerm, List<String> javaTermSortExclusions) {
        if (previousJavaTerm == null) {
            return;
        }
        String javaTermName = javaTerm.getName();
        if (BaseSourceProcessor.isExcluded(javaTermSortExclusions, this._absolutePath, -1, javaTermName)) {
            return;
        }
        if (previousJavaTerm.getLineCount() <= javaTerm.getLineCount()) {
            return;
        }
        String previousJavaTermName = previousJavaTerm.getName();
        String javaTermNameLowerCase = StringUtil.toLowerCase((String)javaTermName);
        String previousJavaTermNameLowerCase = StringUtil.toLowerCase((String)previousJavaTermName);
        if (!(this._fileName.contains("persistence") && (previousJavaTermName.startsWith("doCount") && javaTermName.startsWith("doCount") || previousJavaTermName.startsWith("doFind") && javaTermName.startsWith("doFind") || previousJavaTermNameLowerCase.startsWith("count") && javaTermNameLowerCase.startsWith("count") || previousJavaTermNameLowerCase.startsWith("filter") && javaTermNameLowerCase.startsWith("filter") || previousJavaTermNameLowerCase.startsWith("find") && javaTermNameLowerCase.startsWith("find") || previousJavaTermNameLowerCase.startsWith("join") && javaTermNameLowerCase.startsWith("join")))) {
            this._content = StringUtil.replaceFirst((String)this._content, (String)("\n" + javaTerm.getContent()), (String)("\n" + previousJavaTerm.getContent()));
            this._content = StringUtil.replaceLast((String)this._content, (String)("\n" + previousJavaTerm.getContent()), (String)("\n" + javaTerm.getContent()));
        }
    }
}

