/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.sourceformatter.BaseSourceProcessor;
import com.liferay.portal.tools.sourceformatter.JSPImportsFormatter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _TAG_LIBRARIES = new String[]{"aui", "c", "html", "jsp", "liferay-portlet", "liferay-security", "liferay-theme", "liferay-ui", "liferay-util", "portlet", "struts", "tiles"};
    private Set<String> _checkedForIncludesFileNames = new HashSet<String>();
    private List<String> _duplicateImportClassNames = new ArrayList<String>();
    private List<String> _importClassNames = new ArrayList<String>();
    private Map<String, Integer> _importCountMap = new HashMap<String, Integer>();
    private Pattern _importsPattern = Pattern.compile("page import=\"(.+)\"");
    private Set<String> _includeFileNames = new HashSet<String>();
    private Pattern _javaClassPattern = Pattern.compile("\n(private|protected|public).* class ([\\s\\S]*?)\n\\}\n");
    private Map<String, String> _jspContents = new HashMap<String, String>();
    private Pattern _jspImportPattern = Pattern.compile("(<.*\n*page.import=\".*>\n*)+", 8);
    private Pattern _jspIncludeFilePattern = Pattern.compile("/.*[.]jsp[f]?");
    private boolean _moveFrequentlyUsedImportsToCommonInit;
    private boolean _stripJSPImports = true;
    private Pattern _taglibLanguageKeyPattern1 = Pattern.compile("(?:confirmation|label|(?:M|m)essage|message key|names|title)=\"[^A-Z<=%\\[\\s]+\"");
    private Pattern _taglibLanguageKeyPattern2 = Pattern.compile("(aui:)(?:input|select|field-wrapper) (?!.*label=(?:'|\").+(?:'|\").*name=\"[^<=%\\[\\s]+\")(?!.*name=\"[^<=%\\[\\s]+\".*title=(?:'|\").+(?:'|\"))(?!.*name=\"[^<=%\\[\\s]+\".*type=\"hidden\").*name=\"([^<=%\\[\\s]+)\"");
    private Pattern _taglibLanguageKeyPattern3 = Pattern.compile("(liferay-ui:)(?:input-resource) .*id=\"([^<=%\\[\\s]+)\"(?!.*title=(?:'|\").+(?:'|\"))");
    private List<String> _unusedVariablesExclusions;
    private Pattern _xssPattern = Pattern.compile("\\s+([^\\s]+)\\s*=\\s*(Bean)?ParamUtil\\.getString\\(");

    protected void addImportCounts(String content) {
        Matcher matcher = this._importsPattern.matcher(content);
        while (matcher.find()) {
            String importName = matcher.group(1);
            int count = 0;
            if (this._importCountMap.containsKey(importName)) {
                count = this._importCountMap.get(importName);
            } else {
                int pos = importName.lastIndexOf(".");
                String importClassName = importName.substring(pos + 1);
                if (this._importClassNames.contains(importClassName)) {
                    this._duplicateImportClassNames.add(importClassName);
                } else {
                    this._importClassNames.add(importClassName);
                }
            }
            this._importCountMap.put(importName, count + 1);
        }
    }

    protected void addJSPIncludeFileNames(String fileName) {
        int y;
        String content = this._jspContents.get(fileName);
        if (Validator.isNull((String)content)) {
            return;
        }
        int x = 0;
        while ((x = content.indexOf("<%@ include file=", x)) != -1 && (x = content.indexOf("\"", x)) != -1 && (y = content.indexOf("\"", x + 1)) != -1) {
            String includeFileName = content.substring(x + 1, y);
            Matcher matcher = this._jspIncludeFilePattern.matcher(includeFileName);
            if (!matcher.find()) {
                throw new RuntimeException("Invalid include " + includeFileName);
            }
            if (!(!(includeFileName = this.buildFullPathIncludeFileName(fileName, includeFileName)).endsWith("jsp") && !includeFileName.endsWith("jspf") || includeFileName.endsWith("html/common/init.jsp") || includeFileName.endsWith("html/portlet/init.jsp") || includeFileName.endsWith("html/taglib/init.jsp") || this._includeFileNames.contains(includeFileName))) {
                this._includeFileNames.add(includeFileName);
            }
            x = y;
        }
    }

    protected void addJSPReferenceFileNames(String fileName) {
        block0: for (Map.Entry<String, String> entry : this._jspContents.entrySet()) {
            String sharedPath;
            String referenceFileName = entry.getKey();
            if (this._includeFileNames.contains(referenceFileName) || Validator.isNull((String)(sharedPath = fileName.substring(0, StringUtil.startsWithWeight((String)referenceFileName, (String)fileName)))) || !sharedPath.contains("/")) continue;
            if (!sharedPath.endsWith("/")) {
                sharedPath = sharedPath.substring(0, sharedPath.lastIndexOf(47) + 1);
            }
            String content = null;
            int x = -1;
            while ((x = sharedPath.indexOf(47, x + 1)) != -1) {
                if (content == null) {
                    content = entry.getValue();
                }
                if (!content.contains("<%@ include file=\"" + fileName.substring(x))) continue;
                this._includeFileNames.add(referenceFileName);
                continue block0;
            }
        }
    }

    protected void addJSPUnusedImports(String fileName, List<String> importLines, List<String> unneededImports) {
        for (String importLine : importLines) {
            int x = importLine.indexOf("\"");
            int y = importLine.indexOf("\"", x + 1);
            if (x == -1 || y == -1) continue;
            String className = importLine.substring(x + 1, y);
            className = className.substring(className.lastIndexOf(".") + 1);
            String regex = "[^A-Za-z0-9_\"]" + className + "[^A-Za-z0-9_\"]";
            if (!this.hasUnusedJSPTerm(fileName, regex, "class")) continue;
            unneededImports.add(importLine);
        }
    }

    protected String buildFullPathIncludeFileName(String fileName, String includeFileName) {
        String topLevelDirName = null;
        int x = includeFileName.indexOf(47, 1);
        if (x != -1) {
            topLevelDirName = includeFileName.substring(1, x);
        }
        String path = fileName;
        int y;
        while ((y = path.lastIndexOf(47)) != -1) {
            String fullPathIncludeFileName;
            if ((Validator.isNull((String)topLevelDirName) || path.equals(topLevelDirName) || path.endsWith("/" + topLevelDirName)) && this._jspContents.containsKey(fullPathIncludeFileName = path.substring(0, y) + includeFileName) && !fullPathIncludeFileName.equals(fileName)) {
                return fullPathIncludeFileName;
            }
            path = path.substring(0, y);
        }
        return "";
    }

    protected boolean checkTaglibVulnerability(String jspContent, String vulnerability) {
        int pos1 = -1;
        do {
            if ((pos1 = jspContent.indexOf(vulnerability, pos1 + 1)) == -1) continue;
            int pos2 = jspContent.lastIndexOf(60, pos1);
            while (pos2 > 0 && jspContent.charAt(pos2 + 1) == '%') {
                pos2 = jspContent.lastIndexOf(60, pos2 - 1);
            }
            String tagContent = jspContent.substring(pos2, pos1);
            if (tagContent.startsWith("<aui:") || tagContent.startsWith("<liferay-portlet:") || tagContent.startsWith("<liferay-util:") || tagContent.startsWith("<portlet:")) continue;
            return true;
        } while (pos1 != -1);
        return false;
    }

    protected void checkXSS(String fileName, String jspContent) {
        Matcher matcher = this._xssPattern.matcher(jspContent);
        while (matcher.find()) {
            String documentIdVulnerability;
            String inlineStringVulnerability3;
            String inlineStringVulnerability2;
            String inlineStringVulnerability1;
            String inputVulnerability;
            boolean xssVulnerable = false;
            String jspVariable = matcher.group(1);
            String anchorVulnerability = " href=\"<%= " + jspVariable + " %>";
            if (this.checkTaglibVulnerability(jspContent, anchorVulnerability)) {
                xssVulnerable = true;
            }
            if (this.checkTaglibVulnerability(jspContent, inputVulnerability = " value=\"<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(inlineStringVulnerability1 = "'<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(inlineStringVulnerability2 = "(\"<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(inlineStringVulnerability3 = " \"<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(documentIdVulnerability = ".<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (!xssVulnerable) continue;
            JSPSourceProcessor.processErrorMessage(fileName, "(xss): " + fileName + " (" + jspVariable + ")");
        }
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        String newContent = this.formatJSP(fileName, absolutePath, content);
        newContent = StringUtil.replace((String)newContent, (String[])new String[]{"<br/>", "\"/>", "\" >", "@page import", "\"%>", ")%>", "else{", "for(", "function (", "if(", "javascript: ", "while(", "){\n", ";;\n", "\n\n\n"}, (String[])new String[]{"<br />", "\" />", "\">", "@ page import", "\" %>", ") %>", "else {", "for (", "function(", "if (", "javascript:", "while (", ") {\n", ";\n", "\n\n"});
        newContent = this.fixCompatClassImports(absolutePath, newContent);
        if (this._stripJSPImports && !this._jspContents.isEmpty()) {
            try {
                newContent = this.stripJSPImports(fileName, newContent);
            }
            catch (RuntimeException re) {
                this._stripJSPImports = false;
            }
        }
        if (portalSource && content.contains("page import=") && !fileName.contains("init.jsp") && !fileName.contains("init-ext.jsp") && !fileName.contains("/taglib/aui/") && !fileName.endsWith("touch.jsp") && (fileName.endsWith(".jspf") || content.contains("include file="))) {
            JSPSourceProcessor.processErrorMessage(fileName, "move imports to init.jsp: " + fileName);
        }
        newContent = this.fixCopyright(newContent, absolutePath, fileName);
        if ((newContent = StringUtil.replace((String)newContent, (String[])new String[]{"alert('<%= LanguageUtil.", "alert(\"<%= LanguageUtil.", "confirm('<%= LanguageUtil.", "confirm(\"<%= LanguageUtil."}, (String[])new String[]{"alert('<%= UnicodeLanguageUtil.", "alert(\"<%= UnicodeLanguageUtil.", "confirm('<%= UnicodeLanguageUtil.", "confirm(\"<%= UnicodeLanguageUtil."})).contains("    ") && !fileName.matches(".*template.*\\.vm$")) {
            JSPSourceProcessor.processErrorMessage(fileName, "tab: " + fileName);
        }
        if (fileName.endsWith("init.jsp") || fileName.endsWith("init.jspf")) {
            boolean compressImports;
            int x = newContent.indexOf("<%@ page import=");
            int y = newContent.lastIndexOf("<%@ page import=");
            y = newContent.indexOf("%>", y);
            if (x != -1 && y != -1 && y > x && (compressImports = true)) {
                String imports = newContent.substring(x, y);
                imports = StringUtil.replace((String)imports, (String[])new String[]{"%>\r\n<%@ ", "%>\n<%@ "}, (String[])new String[]{"%><%@\r\n", "%><%@\n"});
                newContent = newContent.substring(0, x) + imports + newContent.substring(y);
            }
        }
        newContent = this.fixSessionKey(fileName, newContent, sessionKeyPattern);
        newContent = this.fixSessionKey(fileName, newContent, taglibSessionKeyPattern);
        this.checkLanguageKeys(fileName, newContent, languageKeyPattern);
        this.checkLanguageKeys(fileName, newContent, this._taglibLanguageKeyPattern1);
        this.checkLanguageKeys(fileName, newContent, this._taglibLanguageKeyPattern2);
        this.checkLanguageKeys(fileName, newContent, this._taglibLanguageKeyPattern3);
        this.checkXSS(fileName, newContent);
        newContent = this.fixIncorrectParameterTypeForLanguageUtil(newContent, true, fileName);
        Matcher matcher = this._javaClassPattern.matcher(newContent);
        if (matcher.find()) {
            String javaClassContent = matcher.group();
            javaClassContent = javaClassContent.substring(1);
            String beforeJavaClass = newContent.substring(0, matcher.start() + 1);
            int javaClassLineCount = StringUtil.count((String)beforeJavaClass, (String)"\n") + 1;
            newContent = this.formatJavaTerms(fileName, absolutePath, newContent, javaClassContent, javaClassLineCount, null, null, null);
        }
        if (!content.equals(newContent)) {
            this._jspContents.put(fileName, newContent);
        }
        return newContent;
    }

    @Override
    protected void format() throws Exception {
        this._moveFrequentlyUsedImportsToCommonInit = GetterUtil.getBoolean((String)this.getProperty("move.frequently.used.imports.to.common.init"));
        this._unusedVariablesExclusions = this.getPropertyList("jsp.unused.variables.excludes.files");
        String[] excludes = new String[]{"**\\null.jsp", "**\\tools\\**"};
        String[] includes = new String[]{"**\\*.jsp", "**\\*.jspf", "**\\*.vm"};
        List<String> fileNames = this.getFileNames(excludes, includes);
        Pattern pattern = Pattern.compile("\\s*@\\s*include\\s*file=['\"](.*)['\"]");
        for (String fileName : fileNames) {
            File file = new File("./" + fileName);
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            String absolutePath = this.getAbsolutePath(file);
            String content = fileUtil.read(file);
            Matcher matcher = pattern.matcher(content);
            String newContent = content;
            while (matcher.find()) {
                newContent = StringUtil.replaceFirst((String)newContent, (String)matcher.group(), (String)("@ include file=\"" + matcher.group(1) + "\""), (int)matcher.start());
            }
            this.processFormattedFile(file, fileName, content, newContent);
            if (portalSource && this._moveFrequentlyUsedImportsToCommonInit && fileName.endsWith("/init.jsp") && !absolutePath.contains("/modules/") && !fileName.endsWith("/common/init.jsp")) {
                this.addImportCounts(content);
            }
            this._jspContents.put(fileName, newContent);
        }
        if (portalSource && this._moveFrequentlyUsedImportsToCommonInit) {
            this.moveFrequentlyUsedImportsToCommonInit(4);
        }
        for (String fileName : fileNames) {
            this.format(fileName);
        }
    }

    protected String formatJSP(String fileName, String absolutePath, String content) throws IOException {
        StringBundler sb = new StringBundler();
        String currentAttributeAndValue = null;
        String previousAttribute = null;
        String previousAttributeAndValue = null;
        String currentException = null;
        String previousException = null;
        boolean hasUnsortedExceptions = false;
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));){
            this._checkedForIncludesFileNames = new HashSet<String>();
            this._includeFileNames = new HashSet<String>();
            int lineCount = 0;
            String line = null;
            String previousLine = "";
            boolean readAttributes = false;
            boolean javaSource = false;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String includeFileName;
                Matcher matcher;
                int y;
                int x;
                ++lineCount;
                if (portalSource && this.hasUnusedTaglib(fileName, line)) continue;
                if (!fileName.contains("jsonw") || !fileName.endsWith("action.jsp")) {
                    line = this.trimLine(line, false);
                }
                if (line.contains("<aui:button ") && line.contains("type=\"button\"")) {
                    JSPSourceProcessor.processErrorMessage(fileName, "aui:button " + fileName + " " + lineCount);
                }
                if (line.contains("debugger.")) {
                    JSPSourceProcessor.processErrorMessage(fileName, "debugger " + fileName + " " + lineCount);
                }
                String trimmedLine = StringUtil.trimLeading((String)line);
                String trimmedPreviousLine = StringUtil.trimLeading((String)previousLine);
                this.checkStringBundler(trimmedLine, fileName, lineCount);
                this.checkEmptyCollection(trimmedLine, fileName, lineCount);
                if (trimmedLine.equals("<%") || trimmedLine.equals("<%!")) {
                    javaSource = true;
                } else if (trimmedLine.equals("%>")) {
                    javaSource = false;
                }
                if (javaSource || trimmedLine.contains("<%= ")) {
                    this.checkInefficientStringMethods(line, fileName, absolutePath, lineCount);
                }
                if (javaSource && portalSource && !JSPSourceProcessor.isExcluded(this._unusedVariablesExclusions, absolutePath, lineCount) && !this._jspContents.isEmpty() && this.hasUnusedVariable(fileName, trimmedLine)) continue;
                if (line.contains(".sendRedirect(") && !fileName.endsWith("_jsp.jsp")) {
                    JSPSourceProcessor.processErrorMessage(fileName, "Do not use sendRedirect in jsp: " + fileName + " " + lineCount);
                }
                if (!trimmedLine.equals("%>") && line.contains("%>") && !line.contains("--%>") && !line.contains(" %>")) {
                    line = StringUtil.replace((String)line, (String)"%>", (String)" %>");
                }
                if (line.contains("<%=") && !line.contains("<%= ")) {
                    line = StringUtil.replace((String)line, (String)"<%=", (String)"<%= ");
                }
                if (trimmedPreviousLine.equals("%>") && Validator.isNotNull((String)line) && !trimmedLine.equals("-->")) {
                    sb.append("\n");
                } else if (Validator.isNotNull((String)previousLine) && !trimmedPreviousLine.equals("<!--") && trimmedLine.equals("<%")) {
                    sb.append("\n");
                } else {
                    String lineBeforePreviousLine;
                    if (trimmedPreviousLine.equals("<%") && Validator.isNull((String)line)) continue;
                    if (trimmedPreviousLine.equals("<%") && trimmedLine.startsWith("//")) {
                        sb.append("\n");
                    } else if (Validator.isNull((String)previousLine) && trimmedLine.equals("%>") && sb.index() > 2 && !(lineBeforePreviousLine = sb.stringAt(sb.index() - 3)).startsWith("//")) {
                        sb.setIndex(sb.index() - 1);
                    }
                }
                if ((trimmedLine.startsWith("if (") || trimmedLine.startsWith("else if (") || trimmedLine.startsWith("while (")) && trimmedLine.endsWith(") {")) {
                    this.checkIfClauseParentheses(trimmedLine, fileName, lineCount);
                }
                if (readAttributes) {
                    if (!trimmedLine.startsWith("/") && !trimmedLine.startsWith(">")) {
                        int pos = trimmedLine.indexOf("=");
                        if (pos != -1) {
                            String attribute = trimmedLine.substring(0, pos);
                            if (!(trimmedLine.endsWith("'") || trimmedLine.endsWith(">") || trimmedLine.endsWith("\""))) {
                                JSPSourceProcessor.processErrorMessage(fileName, "attribute: " + fileName + " " + lineCount);
                                readAttributes = false;
                            } else if (trimmedLine.endsWith("'") && !trimmedLine.contains("\"")) {
                                line = StringUtil.replace((String)line, (String)"'", (String)"\"");
                                readAttributes = false;
                            } else if (Validator.isNotNull(previousAttribute)) {
                                if (!this.isAttributName(attribute) && !attribute.startsWith("<")) {
                                    JSPSourceProcessor.processErrorMessage(fileName, "attribute: " + fileName + " " + lineCount);
                                    readAttributes = false;
                                } else if (Validator.isNull(previousAttributeAndValue) && previousAttribute.compareTo(attribute) > 0) {
                                    previousAttributeAndValue = previousLine;
                                    currentAttributeAndValue = line;
                                }
                            }
                            if (!readAttributes) {
                                previousAttribute = null;
                                previousAttributeAndValue = null;
                            } else {
                                previousAttribute = attribute;
                            }
                        }
                    } else {
                        previousAttribute = null;
                        readAttributes = false;
                    }
                }
                if (!hasUnsortedExceptions) {
                    int y2;
                    int x2 = line.indexOf("<liferay-ui:error exception=\"<%=");
                    if (x2 != -1 && (y2 = line.indexOf(".class %>", x2)) != -1) {
                        currentException = line.substring(x2, y2);
                        if (Validator.isNotNull((String)previousException) && previousException.compareTo(currentException) > 0) {
                            currentException = line;
                            previousException = previousLine;
                            hasUnsortedExceptions = true;
                        }
                    }
                    if (!hasUnsortedExceptions) {
                        previousException = currentException;
                        currentException = null;
                    }
                }
                if (trimmedLine.startsWith("<") && !trimmedLine.startsWith("<%") && !trimmedLine.startsWith("<!")) {
                    if (!trimmedLine.contains(">") && !trimmedLine.contains(" ")) {
                        readAttributes = true;
                    } else {
                        line = this.sortAttributes(fileName, line, lineCount, true);
                    }
                }
                if (!trimmedLine.contains("//") && !trimmedLine.startsWith("*")) {
                    while (trimmedLine.contains("\t")) {
                        line = StringUtil.replaceLast((String)line, (String)"\t", (String)" ");
                        trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"\t", (String)" ");
                    }
                    while (trimmedLine.contains("  ") && !trimmedLine.contains("\"  ") && !fileName.endsWith(".vm")) {
                        line = StringUtil.replaceLast((String)line, (String)"  ", (String)" ");
                        trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"  ", (String)" ");
                    }
                }
                if (!fileName.endsWith("/touch.jsp") && (x = line.indexOf("<%@ include file")) != -1 && (y = line.indexOf("\"", (x = line.indexOf("\"", x)) + 1)) != -1 && !(matcher = this._jspIncludeFilePattern.matcher(includeFileName = line.substring(x + 1, y))).find()) {
                    JSPSourceProcessor.processErrorMessage(fileName, "include: " + fileName + " " + lineCount);
                }
                previousLine = line = this.replacePrimitiveWrapperInstantiation(fileName, line, lineCount);
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        content = this.formatTaglibQuotes(fileName, content, "\"");
        content = this.formatTaglibQuotes(fileName, content, "'");
        if (Validator.isNotNull(previousAttributeAndValue)) {
            content = StringUtil.replaceFirst((String)content, (String)(previousAttributeAndValue + "\n" + currentAttributeAndValue), (String)(currentAttributeAndValue + "\n" + previousAttributeAndValue));
        }
        if (hasUnsortedExceptions) {
            if (StringUtil.count((String)content, currentException) > 1 || StringUtil.count((String)content, previousException) > 1) {
                JSPSourceProcessor.processErrorMessage(fileName, "unsorted exceptions: " + fileName);
            } else {
                content = StringUtil.replaceFirst((String)content, previousException, currentException);
                content = StringUtil.replaceLast((String)content, currentException, previousException);
            }
        }
        return content;
    }

    protected String formatTaglibQuotes(String fileName, String content, String quoteType) {
        String quoteFix = "'";
        if (quoteFix.equals(quoteType)) {
            quoteFix = "\"";
        }
        Pattern pattern = Pattern.compile(this.getTaglibRegex(quoteType));
        Matcher matcher = pattern.matcher(content);
        block0: while (matcher.find()) {
            String beforeResult;
            int x = content.indexOf(quoteType + "<%=", matcher.start());
            int y = content.indexOf("%>" + quoteType, x);
            while (x != -1 && y != -1 && !(beforeResult = content.substring(matcher.start(), x)).contains(" />\"")) {
                String result = content.substring(x + 1, y + 2);
                if (result.contains(quoteType)) {
                    int lineCount = 1;
                    char[] contentCharArray = content.toCharArray();
                    for (int i = 0; i < x; ++i) {
                        if (contentCharArray[i] != '\n') continue;
                        ++lineCount;
                    }
                    if (!result.contains(quoteFix)) {
                        StringBundler sb = new StringBundler(5);
                        sb.append(content.substring(0, x));
                        sb.append(quoteFix);
                        sb.append(result);
                        sb.append(quoteFix);
                        sb.append(content.substring(y + 3, content.length()));
                        content = sb.toString();
                    } else {
                        JSPSourceProcessor.processErrorMessage(fileName, "taglib: " + fileName + " " + lineCount);
                    }
                }
                if ((x = content.indexOf(quoteType + "<%=", y)) > matcher.end()) continue block0;
                y = content.indexOf("%>" + quoteType, x);
            }
        }
        return content;
    }

    protected List<String> getJSPDuplicateImports(String fileName, String content, List<String> importLines) {
        ArrayList<String> duplicateImports = new ArrayList<String>();
        for (String importLine : importLines) {
            int y;
            int x = content.indexOf("<%@ include file=");
            if (x == -1 || (y = content.indexOf("<%@ page import=")) == -1 || x >= y || !this.isJSPDuplicateImport(fileName, importLine, false)) continue;
            duplicateImports.add(importLine);
        }
        return duplicateImports;
    }

    protected String getTaglibRegex(String quoteType) {
        StringBuilder sb = new StringBuilder();
        sb.append("<(");
        for (int i = 0; i < _TAG_LIBRARIES.length; ++i) {
            sb.append(_TAG_LIBRARIES[i]);
            sb.append("|");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("):([^>]|%>)*");
        sb.append(quoteType);
        sb.append("<%=.*");
        sb.append(quoteType);
        sb.append(".*%>");
        sb.append(quoteType);
        sb.append("([^>]|%>)*>");
        return sb.toString();
    }

    protected String getVariableName(String line) {
        if (!line.endsWith(";") || line.startsWith("//")) {
            return null;
        }
        String variableName = null;
        int x = line.indexOf(" = ");
        if (x == -1) {
            int y = line.lastIndexOf(" ");
            if (y != -1) {
                variableName = line.substring(y + 1, line.length() - 1);
            }
        } else {
            int y = (line = line.substring(0, x)).lastIndexOf(" ");
            if (y != -1) {
                variableName = line.substring(y + 1);
            }
        }
        if (Validator.isVariableName(variableName)) {
            return variableName;
        }
        return null;
    }

    protected boolean hasUnusedJSPTerm(String fileName, String regex, String type) {
        this._includeFileNames.add(fileName);
        HashSet<String> checkedForUnusedJSPTerm = new HashSet<String>();
        return !this.isJSPTermRequired(fileName, regex, type, checkedForUnusedJSPTerm);
    }

    protected boolean hasUnusedTaglib(String fileName, String line) {
        if (!line.startsWith("<%@ taglib uri=")) {
            return false;
        }
        int x = line.indexOf(" prefix=");
        if (x == -1) {
            return false;
        }
        x = line.indexOf("\"", x);
        int y = line.indexOf("\"", x + 1);
        if (x == -1 || y == -1) {
            return false;
        }
        String taglibPrefix = line.substring(x + 1, y);
        String regex = "<" + taglibPrefix + ":";
        return this.hasUnusedJSPTerm(fileName, regex, "taglib");
    }

    protected boolean hasUnusedVariable(String fileName, String line) {
        if (line.contains(": ")) {
            return false;
        }
        String variableName = this.getVariableName(line);
        if (Validator.isNull((String)variableName) || variableName.equals("false") || variableName.equals("true")) {
            return false;
        }
        String regex = "[^A-Za-z0-9_\"]" + variableName + "[^A-Za-z0-9_\"]";
        return this.hasUnusedJSPTerm(fileName, regex, "variable");
    }

    protected boolean isJSPDuplicateImport(String fileName, String importLine, boolean checkFile) {
        String content = this._jspContents.get(fileName);
        if (Validator.isNull((String)content)) {
            return false;
        }
        int x = importLine.indexOf("page");
        if (x == -1) {
            return false;
        }
        if (checkFile && content.contains(importLine.substring(x))) {
            return true;
        }
        int y = content.indexOf("<%@ include file=");
        if (y == -1) {
            return false;
        }
        if ((y = content.indexOf("\"", y)) == -1) {
            return false;
        }
        int z = content.indexOf("\"", y + 1);
        if (z == -1) {
            return false;
        }
        String includeFileName = content.substring(y + 1, z);
        includeFileName = this.buildFullPathIncludeFileName(fileName, includeFileName);
        return this.isJSPDuplicateImport(includeFileName, importLine, true);
    }

    protected boolean isJSPTermRequired(String fileName, String regex, String type, Set<String> checkedForUnusedJSPTerm) {
        String[] includeFileNamesArray;
        if (checkedForUnusedJSPTerm.contains(fileName)) {
            return false;
        }
        checkedForUnusedJSPTerm.add(fileName);
        String content = this._jspContents.get(fileName);
        if (Validator.isNull((String)content)) {
            return false;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find() && (!type.equals("variable") || checkedForUnusedJSPTerm.size() > 1 || matcher.find())) {
            return true;
        }
        if (!this._checkedForIncludesFileNames.contains(fileName)) {
            this.addJSPIncludeFileNames(fileName);
            if (fileName.endsWith("init.jsp") || fileName.endsWith("init.jspf") || fileName.contains("init-ext.jsp")) {
                this.addJSPReferenceFileNames(fileName);
            }
        }
        this._checkedForIncludesFileNames.add(fileName);
        for (String includeFileName : includeFileNamesArray = this._includeFileNames.toArray(new String[this._includeFileNames.size()])) {
            if (checkedForUnusedJSPTerm.contains(includeFileName) || !this.isJSPTermRequired(includeFileName, regex, type, checkedForUnusedJSPTerm)) continue;
            return true;
        }
        return false;
    }

    protected void moveFrequentlyUsedImportsToCommonInit(int minCount) throws IOException {
        if (this._importCountMap.isEmpty()) {
            return;
        }
        String commonInitFileName = "portal-web/docroot/html/common/init.jsp";
        File commonInitFile = null;
        String commonInitFileContent = null;
        int x = -1;
        for (Map.Entry<String, Integer> importCount : this._importCountMap.entrySet()) {
            int y;
            String importName;
            String importClassName;
            Integer count = importCount.getValue();
            if (count < minCount || this._duplicateImportClassNames.contains(importClassName = (importName = importCount.getKey()).substring((y = importName.lastIndexOf(".")) + 1))) continue;
            if (commonInitFileContent == null) {
                commonInitFile = new File(commonInitFileName);
                commonInitFileContent = fileUtil.read(commonInitFile);
                x = commonInitFileContent.indexOf("<%@ page import");
            }
            commonInitFileContent = StringUtil.insert((String)commonInitFileContent, (String)("<%@ page import=\"" + importName + "\" %>\n"), (int)x);
        }
        if (commonInitFileContent != null) {
            fileUtil.write(commonInitFile, commonInitFileContent);
            this._jspContents.put(commonInitFileName, commonInitFileContent);
        }
    }

    protected String stripJSPImports(String fileName, String content) throws IOException {
        String afterImports;
        if ((fileName = fileName.replace('\\', '/')).endsWith("init-ext.jsp")) {
            return content;
        }
        Matcher matcher = this._jspImportPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String imports = matcher.group();
        imports = StringUtil.replace((String)imports, (String[])new String[]{"%><%@\r\n", "%><%@\n"}, (String[])new String[]{"%>\r\n<%@ ", "%>\n<%@ "});
        ArrayList<String> importLines = new ArrayList<String>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(imports));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (!line.contains("import=")) continue;
            importLines.add(line);
        }
        List<String> unneededImports = this.getJSPDuplicateImports(fileName, content, importLines);
        this.addJSPUnusedImports(fileName, importLines, unneededImports);
        for (String unneededImport : unneededImports) {
            imports = StringUtil.replace((String)imports, (String)unneededImport, (String)"");
        }
        JSPImportsFormatter importsFormatter = new JSPImportsFormatter();
        imports = importsFormatter.format(imports);
        String beforeImports = content.substring(0, matcher.start());
        if (Validator.isNull((String)imports)) {
            beforeImports = StringUtil.replaceLast((String)beforeImports, (String)"\n", (String)"");
        }
        if (Validator.isNull((String)(afterImports = content.substring(matcher.end())))) {
            imports = StringUtil.replaceLast((String)imports, (String)"\n", (String)"");
            content = beforeImports + imports;
            return content;
        }
        content = beforeImports + imports + "\n" + afterImports;
        return content;
    }
}

