/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.sourceformatter.BaseSourceProcessor;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSSSourceProcessor
extends BaseSourceProcessor {
    private Pattern _commentPattern = Pattern.compile("/\\* -+(.+)-+ \\*/");
    private Pattern _hexColorPattern = Pattern.compile("#([0-9a-f]+)[\\( ;,]");

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        String newContent = this.trimContent(content, false);
        newContent = this.fixComments(newContent);
        return this.fixHexColors(newContent);
    }

    protected String fixComments(String content) {
        Matcher matcher = this._commentPattern.matcher(content);
        while (matcher.find()) {
            String[] words = StringUtil.split((String)matcher.group(1), (char)' ');
            for (int i = 1; i < words.length; ++i) {
                String word;
                String previousWord = words[i - 1];
                if (previousWord.endsWith(".") || previousWord.equals("/") || (word = words[i]).length() <= 1 || !Character.isUpperCase(word.charAt(0)) || !StringUtil.isLowerCase((String)word.substring(1))) continue;
                content = StringUtil.replaceFirst((String)content, (String)word, (String)StringUtil.toLowerCase((String)word), (int)matcher.start());
            }
        }
        return content;
    }

    protected String fixHexColors(String content) {
        Matcher matcher = this._hexColorPattern.matcher(content);
        while (matcher.find()) {
            String hexColor = matcher.group(1);
            if (Validator.isNumber((String)hexColor) || hexColor.length() < 3) continue;
            content = StringUtil.replace((String)content, (String)hexColor, (String)StringUtil.toUpperCase((String)hexColor));
        }
        return content;
    }

    @Override
    protected void format() throws Exception {
        String[] excludes = new String[]{"**\\.ivy\\**", "**\\.sass-cache\\**", "**\\aui_deprecated.css", "**\\expected\\**", "**\\js\\aui\\**", "**\\js\\editor\\**", "**\\js\\misc\\**", "**\\VAADIN\\**"};
        String[] includes = new String[]{"**\\*.css"};
        List<String> fileNames = this.getFileNames(excludes, includes);
        for (String fileName : fileNames) {
            this.format(fileName);
        }
    }
}

