/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.sourceformatter.JavaClass;
import com.liferay.portal.tools.sourceformatter.SourceFormatterHelper;
import com.liferay.portal.tools.sourceformatter.SourceMismatchException;
import com.liferay.portal.tools.sourceformatter.SourceProcessor;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.xml.SAXReaderImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.DirectoryScanner;

public abstract class BaseSourceProcessor
implements SourceProcessor {
    protected static final String BASEDIR = "./";
    protected static Pattern attributeNamePattern = Pattern.compile("[a-z]+[-_a-zA-Z0-9]*");
    protected static Pattern emptyCollectionPattern = Pattern.compile("Collections\\.EMPTY_(LIST|MAP|SET)");
    protected static FileImpl fileUtil = FileImpl.getInstance();
    protected static Pattern languageKeyPattern = Pattern.compile("LanguageUtil.(?:get|format)\\([^;%]+|Liferay.Language.get\\('([^']+)");
    protected static boolean portalSource;
    protected static SAXReaderImpl saxReaderUtil;
    protected static Pattern sessionKeyPattern;
    protected static SourceFormatterHelper sourceFormatterHelper;
    protected static Pattern taglibSessionKeyPattern;
    private static Map<String, List<String>> _errorMessagesMap;
    private static boolean _printErrors;
    private boolean _autoFix;
    private Map<String, String> _compatClassNamesMap;
    private String _copyright;
    private String[] _excludes;
    private SourceMismatchException _firstSourceMismatchException;
    private String _mainReleaseVersion;
    private String _oldCopyright;
    private Properties _portalLanguageProperties;
    private Properties _properties;
    private List<String> _runOutsidePortalExclusions;
    private boolean _usePortalCompatImport;

    public BaseSourceProcessor() {
        portalSource = this._isPortalSource();
        try {
            this._properties = this._getProperties();
        }
        catch (Exception e) {
            ReflectionUtil.throwException((Throwable)e);
        }
    }

    @Override
    public void format(boolean useProperties, boolean printErrors, boolean autoFix) throws Exception {
        this._init(useProperties, printErrors, autoFix);
        this.format();
        sourceFormatterHelper.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(String fileName, boolean useProperties, boolean printErrors, boolean autoFix) throws Exception {
        try {
            this._init(useProperties, printErrors, autoFix);
            String string = this.format(fileName);
            return string;
        }
        finally {
            sourceFormatterHelper.close();
        }
    }

    @Override
    public List<String> getErrorMessages() {
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : _errorMessagesMap.entrySet()) {
            errorMessages.addAll((Collection<String>)entry.getValue());
        }
        return errorMessages;
    }

    @Override
    public SourceMismatchException getFirstSourceMismatchException() {
        return this._firstSourceMismatchException;
    }

    protected static boolean isExcluded(List<String> exclusions, String absolutePath) {
        return BaseSourceProcessor.isExcluded(exclusions, absolutePath, -1);
    }

    protected static boolean isExcluded(List<String> exclusions, String absolutePath, int lineCount) {
        return BaseSourceProcessor.isExcluded(exclusions, absolutePath, lineCount, null);
    }

    protected static boolean isExcluded(List<String> exclusions, String absolutePath, int lineCount, String javaTermName) {
        if (ListUtil.isEmpty(exclusions)) {
            return false;
        }
        String absolutePathWithJavaTermName = null;
        if (Validator.isNotNull((String)javaTermName)) {
            absolutePathWithJavaTermName = absolutePath + "@" + javaTermName;
        }
        String absolutePathWithLineCount = null;
        if (lineCount > 0) {
            absolutePathWithLineCount = absolutePath + "@" + lineCount;
        }
        for (String exclusion : exclusions) {
            if (!absolutePath.endsWith(exclusion) && (absolutePathWithJavaTermName == null || !absolutePathWithJavaTermName.endsWith(exclusion)) && (absolutePathWithLineCount == null || !absolutePathWithLineCount.endsWith(exclusion))) continue;
            return true;
        }
        return false;
    }

    protected static void processErrorMessage(String fileName, String message) {
        List<String> errorMessages = _errorMessagesMap.get(fileName);
        if (errorMessages == null) {
            errorMessages = new ArrayList<String>();
        }
        errorMessages.add(message);
        _errorMessagesMap.put(fileName, errorMessages);
    }

    protected void checkEmptyCollection(String line, String fileName, int lineCount) {
        Matcher matcher = emptyCollectionPattern.matcher(line);
        if (matcher.find()) {
            String collectionType = TextFormatter.format((String)matcher.group(1), (int)9);
            BaseSourceProcessor.processErrorMessage(fileName, "Use Collections.empty" + collectionType + "(): " + fileName + " " + lineCount);
        }
    }

    protected void checkIfClauseParentheses(String ifClause, String fileName, int lineCount) {
        int quoteCount = StringUtil.count((String)ifClause, (String)"\"");
        if (quoteCount % 2 == 1) {
            return;
        }
        ifClause = this.stripQuotes(ifClause, '\"');
        if ((ifClause = this.stripQuotes(ifClause, '\'')).contains("//") || ifClause.contains("/*") || ifClause.contains("*/")) {
            return;
        }
        if (this.hasRedundantParentheses(ifClause, "||", "&&") || this.hasRedundantParentheses(ifClause, "&&", "||")) {
            BaseSourceProcessor.processErrorMessage(fileName, "redundant parentheses: " + fileName + " " + lineCount);
        }
        ifClause = this.stripRedundantParentheses(ifClause);
        int level = 0;
        int max = StringUtil.count((String)ifClause, (String)"(");
        int previousParenthesisPos = -1;
        int[] levels = new int[max];
        for (int i = 0; i < ifClause.length(); ++i) {
            String s;
            char c = ifClause.charAt(i);
            if (c != '(' && c != ')') continue;
            if (previousParenthesisPos != -1 && this.hasMissingParentheses(s = ifClause.substring(previousParenthesisPos + 1, i))) {
                BaseSourceProcessor.processErrorMessage(fileName, "missing parentheses: " + fileName + " " + lineCount);
            }
            previousParenthesisPos = i;
            if (c == '(') {
                levels[level] = i;
                ++level;
                continue;
            }
            int posOpenParenthesis = levels[level - 1];
            if (level > 1) {
                String s2;
                char nextChar = ifClause.charAt(i + 1);
                char previousChar = ifClause.charAt(posOpenParenthesis - 1);
                if (!Character.isLetterOrDigit(nextChar) && nextChar != '.' && !Character.isLetterOrDigit(previousChar) && this.hasRedundantParentheses(s2 = ifClause.substring(posOpenParenthesis + 1, i))) {
                    BaseSourceProcessor.processErrorMessage(fileName, "redundant parentheses: " + fileName + " " + lineCount);
                }
                if (previousChar == '(' && nextChar == ')') {
                    BaseSourceProcessor.processErrorMessage(fileName, "redundant parentheses: " + fileName + " " + lineCount);
                }
            }
            --level;
        }
    }

    protected void checkInefficientStringMethods(String line, String fileName, String absolutePath, int lineCount) {
        if (this.isRunsOutsidePortal(absolutePath)) {
            return;
        }
        String methodName = "toLowerCase";
        int pos = line.indexOf(".toLowerCase()");
        if (pos == -1) {
            methodName = "toUpperCase";
            pos = line.indexOf(".toUpperCase()");
        }
        if (pos == -1 && !line.contains("StringUtil.equalsIgnoreCase(")) {
            methodName = "equalsIgnoreCase";
            pos = line.indexOf(".equalsIgnoreCase(");
        }
        if (pos != -1) {
            BaseSourceProcessor.processErrorMessage(fileName, "Use StringUtil." + methodName + ": " + fileName + " " + lineCount);
        }
    }

    protected void checkLanguageKeys(String fileName, String content, Pattern pattern) throws IOException {
        String fileExtension = fileUtil.getExtension(fileName);
        if (!portalSource || fileExtension.equals("vm")) {
            return;
        }
        if (this._portalLanguageProperties == null) {
            this._portalLanguageProperties = new Properties();
            ClassLoader classLoader = BaseSourceProcessor.class.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("content/Language.properties");
            this._portalLanguageProperties.load(inputStream);
        }
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String[] languageKeys;
            for (String languageKey : languageKeys = this.getLanguageKeys(matcher)) {
                Properties languageProperties;
                if (Validator.isNumber((String)languageKey) || languageKey.endsWith("-") || languageKey.endsWith("[") || languageKey.endsWith(".") || languageKey.endsWith("_") || languageKey.startsWith("-") || languageKey.startsWith("[") || languageKey.startsWith("{") || languageKey.startsWith(".") || languageKey.startsWith("_") || this._portalLanguageProperties.containsKey(languageKey) || (languageProperties = this.getLanguageProperties(fileName)) != null && languageProperties.containsKey(languageKey)) continue;
                BaseSourceProcessor.processErrorMessage(fileName, "missing language key: " + languageKey + " " + fileName);
            }
        }
    }

    protected void checkStringBundler(String line, String fileName, int lineCount) {
        String[] lineParts;
        if (!line.startsWith("sb.append(") && !line.contains("SB.append(") || !line.endsWith(");")) {
            return;
        }
        int pos = line.indexOf(".append(");
        line = line.substring(pos + 8, line.length() - 2);
        if (!(line = this.stripQuotes(line, '\"')).contains(" + ")) {
            return;
        }
        for (String linePart : lineParts = StringUtil.split((String)line, (String)" + ")) {
            int openParenthesesCount;
            int closeParenthesesCount = StringUtil.count((String)linePart, (String)")");
            if (closeParenthesesCount != (openParenthesesCount = StringUtil.count((String)linePart, (String)"("))) {
                return;
            }
            if (!Validator.isNumber((String)linePart)) continue;
            return;
        }
        BaseSourceProcessor.processErrorMessage(fileName, "plus: " + fileName + " " + lineCount);
    }

    protected abstract String doFormat(File var1, String var2, String var3, String var4) throws Exception;

    protected String fixCompatClassImports(String absolutePath, String content) throws IOException {
        if (portalSource || !this._usePortalCompatImport || absolutePath.contains("/ext-") || absolutePath.contains("/portal-compat-shared/")) {
            return content;
        }
        Map<String, String> compatClassNamesMap = this.getCompatClassNamesMap();
        String newContent = content;
        for (Map.Entry<String, String> entry : compatClassNamesMap.entrySet()) {
            Matcher matcher;
            String compatClassName = entry.getKey();
            String extendedClassName = entry.getValue();
            Pattern pattern = Pattern.compile(extendedClassName + "\\W");
            while ((matcher = pattern.matcher(newContent)).find()) {
                newContent = newContent.substring(0, matcher.start()) + compatClassName + newContent.substring(matcher.end() - 1);
            }
        }
        return newContent;
    }

    protected String fixCopyright(String content, String absolutePath, String fileName) throws IOException {
        int x;
        if (this._copyright == null) {
            this._copyright = this.getContent("copyright.txt", 4);
        }
        String copyright = this._copyright;
        if (fileName.endsWith(".vm") || Validator.isNull((String)copyright)) {
            return content;
        }
        if (this._oldCopyright == null) {
            this._oldCopyright = this.getContent("old-copyright.txt", 4);
        }
        if (Validator.isNotNull((String)this._oldCopyright) && content.contains(this._oldCopyright)) {
            content = StringUtil.replace((String)content, (String)this._oldCopyright, (String)copyright);
            BaseSourceProcessor.processErrorMessage(fileName, "old (c): " + fileName);
        }
        if (!content.contains(copyright)) {
            String customCopyright = this.getCustomCopyright(absolutePath);
            if (Validator.isNotNull((String)customCopyright)) {
                copyright = customCopyright;
            }
            if (!content.contains(copyright)) {
                BaseSourceProcessor.processErrorMessage(fileName, "(c): " + fileName);
            }
        }
        if (fileName.endsWith(".jsp") || fileName.endsWith(".jspf")) {
            content = StringUtil.replace((String)content, (String)("<%\n" + copyright + "\n%>"), (String)("<%--\n" + copyright + "\n--%>"));
        }
        if ((x = content.indexOf("* Copyright (c) 2000-")) == -1) {
            return content;
        }
        int y = content.indexOf("Liferay", x);
        String contentCopyrightYear = content.substring(x, y);
        x = copyright.indexOf("* Copyright (c) 2000-");
        if (x == -1) {
            return content;
        }
        y = copyright.indexOf("Liferay", x);
        String copyrightYear = copyright.substring(x, y);
        return StringUtil.replace((String)content, (String)contentCopyrightYear, (String)copyrightYear);
    }

    protected String fixIncorrectParameterTypeForLanguageUtil(String content, boolean autoFix, String fileName) {
        if (portalSource) {
            return content;
        }
        String expectedParameter = this.getProperty("languageutil.expected.parameter");
        String incorrectParameter = this.getProperty("languageutil.incorrect.parameter");
        if (!content.contains("LanguageUtil.format(" + incorrectParameter + ", ") && !content.contains("LanguageUtil.get(" + incorrectParameter + ", ")) {
            return content;
        }
        if (autoFix) {
            content = StringUtil.replace((String)content, (String[])new String[]{"LanguageUtil.format(" + incorrectParameter + ", ", "LanguageUtil.get(" + incorrectParameter + ", "}, (String[])new String[]{"LanguageUtil.format(" + expectedParameter + ", ", "LanguageUtil.get(" + expectedParameter + ", "});
        } else {
            BaseSourceProcessor.processErrorMessage(fileName, "(Unicode)LanguageUtil.format/get methods require " + expectedParameter + " parameter instead of " + incorrectParameter + " " + fileName);
        }
        return content;
    }

    protected String fixSessionKey(String fileName, String content, Pattern pattern) {
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String newContent = content;
        do {
            String match = matcher.group();
            String s = null;
            if (pattern.equals(sessionKeyPattern)) {
                s = ",";
            } else if (pattern.equals(taglibSessionKeyPattern)) {
                s = "key=";
            }
            int x = match.indexOf(s);
            if (x == -1) continue;
            String substring = match.substring(x += s.length()).trim();
            String quote = "";
            if (substring.startsWith("'")) {
                quote = "'";
            } else {
                if (!substring.startsWith("\"")) continue;
                quote = "\"";
            }
            int y = match.indexOf(quote, x);
            int z = match.indexOf(quote, y + 1);
            if (y == -1 || z == -1) continue;
            String prefix = match.substring(0, y + 1);
            String suffix = match.substring(z);
            String oldKey = match.substring(y + 1, z);
            boolean alphaNumericKey = true;
            for (char c : oldKey.toCharArray()) {
                if (Validator.isChar((char)c) || Validator.isDigit((char)c) || c == '-' || c == '_') continue;
                alphaNumericKey = false;
            }
            if (!alphaNumericKey) continue;
            String newKey = TextFormatter.format((String)oldKey, (int)14);
            if ((newKey = TextFormatter.format((String)newKey, (int)12)).equals(oldKey)) continue;
            String oldSub = prefix.concat(oldKey).concat(suffix);
            String newSub = prefix.concat(newKey).concat(suffix);
            newContent = StringUtil.replaceFirst((String)newContent, (String)oldSub, (String)newSub);
        } while (matcher.find());
        return newContent;
    }

    protected abstract void format() throws Exception;

    protected String format(File file, String fileName, String absolutePath, String content) throws Exception {
        _errorMessagesMap.remove(fileName);
        String newContent = this.doFormat(file, fileName, absolutePath, content);
        newContent = StringUtil.replace((String)newContent, (String)"\r", (String)"");
        if (content.equals(newContent)) {
            return content;
        }
        return this.format(file, fileName, absolutePath, newContent);
    }

    protected String format(String fileName) throws Exception {
        File file = new File(BASEDIR + fileName);
        fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
        String absolutePath = this.getAbsolutePath(file);
        String content = fileUtil.read(file);
        String newContent = this.format(file, fileName, absolutePath, content);
        this.processFormattedFile(file, fileName, content, newContent);
        return newContent;
    }

    protected String formatJavaTerms(String fileName, String absolutePath, String content, String javaClassContent, int javaClassLineCount, List<String> javaTermAccessLevelModifierExclusions, List<String> javaTermSortExclusions, List<String> testAnnotationsExclusions) throws Exception {
        JavaClass javaClass = new JavaClass(fileName, absolutePath, javaClassContent, javaClassLineCount, "\t");
        String newJavaClassContent = javaClass.formatJavaTerms(javaTermAccessLevelModifierExclusions, javaTermSortExclusions, testAnnotationsExclusions);
        if (!javaClassContent.equals(newJavaClassContent)) {
            return StringUtil.replaceFirst((String)content, (String)javaClassContent, (String)newJavaClassContent);
        }
        return content;
    }

    protected String getAbsolutePath(File file) {
        String absolutePath = fileUtil.getAbsolutePath(file);
        return StringUtil.replace((String)absolutePath, (String)"/./", (String)"/");
    }

    protected Map<String, String> getCompatClassNamesMap() throws IOException {
        String fileName;
        if (this._compatClassNamesMap != null) {
            return this._compatClassNamesMap;
        }
        HashMap<String, String> compatClassNamesMap = new HashMap<String, String>();
        String[] includes = new String[]{"**\\portal-compat-shared\\src\\com\\liferay\\compat\\**\\*.java"};
        String basedir = BASEDIR;
        List<Object> fileNames = new ArrayList();
        for (int i = 0; i < 3 && (fileNames = this.getFileNames(basedir, new String[0], includes)).isEmpty(); ++i) {
            basedir = "../" + basedir;
        }
        Iterator i$ = fileNames.iterator();
        while (i$.hasNext() && (fileName = (String)i$.next()).startsWith("shared")) {
            File file = new File(basedir + fileName);
            String content = fileUtil.read(file);
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            fileName = StringUtil.replace((String)fileName, (String)"/", (String)".");
            int pos = fileName.indexOf("com.");
            String compatClassName = fileName.substring(pos);
            compatClassName = compatClassName.substring(0, compatClassName.length() - 5);
            String extendedClassName = StringUtil.replace((String)compatClassName, (String)"compat.", (String)"");
            if (!content.contains("extends " + extendedClassName)) continue;
            compatClassNamesMap.put(compatClassName, extendedClassName);
        }
        this._compatClassNamesMap = compatClassNamesMap;
        return this._compatClassNamesMap;
    }

    protected String getContent(String fileName, int level) throws IOException {
        String content;
        File file = this.getFile(fileName, level);
        if (file != null && Validator.isNotNull((String)(content = fileUtil.read(file)))) {
            return content;
        }
        return "";
    }

    protected String getCustomCopyright(String absolutePath) throws IOException {
        int x = absolutePath.length();
        while ((x = absolutePath.lastIndexOf("/", x)) != -1) {
            String copyright = fileUtil.read(absolutePath.substring(0, x + 1) + "copyright.txt");
            if (Validator.isNotNull((String)copyright)) {
                return copyright;
            }
            --x;
        }
        return null;
    }

    protected File getFile(String fileName, int level) {
        for (int i = 0; i < level; ++i) {
            if (fileUtil.exists(fileName)) {
                return new File(fileName);
            }
            fileName = "../" + fileName;
        }
        return null;
    }

    protected List<String> getFileNames(String basedir, String[] excludes, String[] includes) {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        if (this._excludes != null) {
            excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])this._excludes);
        }
        directoryScanner.setExcludes(excludes);
        directoryScanner.setIncludes(includes);
        return sourceFormatterHelper.scanForFiles(directoryScanner);
    }

    protected List<String> getFileNames(String[] excludes, String[] includes) {
        return this.getFileNames(BASEDIR, excludes, includes);
    }

    protected String[] getLanguageKeys(Matcher matcher) {
        int groupCount = matcher.groupCount();
        if (groupCount == 1) {
            String languageKey = matcher.group(1);
            if (Validator.isNotNull((String)languageKey)) {
                return new String[]{languageKey};
            }
        } else if (groupCount == 2) {
            String languageKey = matcher.group(2);
            languageKey = TextFormatter.format((String)languageKey, (int)15);
            return new String[]{languageKey};
        }
        StringBundler sb = new StringBundler();
        String match = matcher.group();
        int count = 0;
        block5: for (int i = 0; i < match.length(); ++i) {
            char c = match.charAt(i);
            switch (c) {
                case ')': {
                    if (count <= 1) {
                        return new String[0];
                    }
                    --count;
                    continue block5;
                }
                case '(': {
                    ++count;
                    continue block5;
                }
                case '\"': {
                    if (count > 1) continue block5;
                    while (i < match.length()) {
                        if (match.charAt(++i) == '\"') {
                            String languageKey = sb.toString();
                            if (match.startsWith("names")) {
                                return StringUtil.split((String)languageKey);
                            }
                            return new String[]{languageKey};
                        }
                        sb.append(match.charAt(i));
                    }
                    continue block5;
                }
            }
        }
        return new String[0];
    }

    protected Properties getLanguageProperties(String fileName) {
        StringBundler sb = new StringBundler(4);
        int pos = fileName.indexOf("/docroot/");
        sb.append(BASEDIR);
        if (pos != -1) {
            sb.append(fileName.substring(0, pos + 9));
            sb.append("WEB-INF/src/");
        } else {
            pos = fileName.indexOf("/src/");
            if (pos == -1) {
                return null;
            }
            sb.append(fileName.substring(0, pos + 5));
        }
        sb.append("content/Language.properties");
        try {
            Properties properties = new Properties();
            FileInputStream inputStream = new FileInputStream(sb.toString());
            properties.load(inputStream);
            return properties;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getMainReleaseVersion() {
        if (this._mainReleaseVersion != null) {
            return this._mainReleaseVersion;
        }
        String releaseVersion = ReleaseInfo.getVersion();
        int pos = releaseVersion.lastIndexOf(".");
        this._mainReleaseVersion = releaseVersion.substring(0, pos) + ".0";
        return this._mainReleaseVersion;
    }

    protected String getProperty(String key) {
        return this._properties.getProperty(key);
    }

    protected List<String> getPropertyList(String key) {
        return ListUtil.fromString((String)GetterUtil.getString((String)this.getProperty(key)), (String)",");
    }

    protected boolean hasMissingParentheses(String s) {
        boolean containsMathOperator;
        if (Validator.isNull((String)s)) {
            return false;
        }
        boolean containsAndOperator = s.contains("&&");
        boolean containsOrOperator = s.contains("||");
        if (containsAndOperator && containsOrOperator) {
            return true;
        }
        boolean containsCompareOperator = s.contains(" == ") || s.contains(" != ") || s.contains(" < ") || s.contains(" > ") || s.contains(" =< ") || s.contains(" => ") || s.contains(" <= ") || s.contains(" >= ");
        boolean bl = containsMathOperator = s.contains(" = ") || s.contains(" - ") || s.contains(" + ") || s.contains(" & ") || s.contains(" % ") || s.contains(" * ") || s.contains(" / ");
        return containsCompareOperator && (containsAndOperator || containsOrOperator || containsMathOperator && !s.contains("["));
    }

    protected boolean hasRedundantParentheses(String s) {
        if (!s.contains("&&") && !s.contains("||")) {
            int y;
            int x = 0;
            while ((x = s.indexOf(")")) != -1 && (y = s.substring(0, x).lastIndexOf("(")) != -1) {
                s = s.substring(0, y) + s.substring(x + 1);
            }
        }
        return Validator.isNotNull((String)s) && !s.contains(" ");
    }

    protected boolean hasRedundantParentheses(String s, String operator1, String operator2) {
        String[] parts = StringUtil.split((String)s, (String)operator1);
        if (parts.length < 3) {
            return false;
        }
        for (int i = 1; i < parts.length - 1; ++i) {
            int openParenthesesCount;
            int closeParenthesesCount;
            String part = parts[i];
            if (part.contains(operator2) || part.contains("!(") || Math.abs((closeParenthesesCount = StringUtil.count((String)part, (String)")")) - (openParenthesesCount = StringUtil.count((String)part, (String)"("))) != 1) continue;
            return true;
        }
        return false;
    }

    protected boolean isAttributName(String attributeName) {
        if (Validator.isNull((String)attributeName)) {
            return false;
        }
        Matcher matcher = attributeNamePattern.matcher(attributeName);
        return matcher.matches();
    }

    protected boolean isRunsOutsidePortal(String absolutePath) {
        if (this._runOutsidePortalExclusions == null) {
            this._runOutsidePortalExclusions = this.getPropertyList("run.outside.portal.excludes");
        }
        for (String runOutsidePortalExclusions : this._runOutsidePortalExclusions) {
            if (!absolutePath.contains(runOutsidePortalExclusions)) continue;
            return true;
        }
        return false;
    }

    protected void processFormattedFile(File file, String fileName, String content, String newContent) throws IOException {
        List<String> errorMessages;
        if (_printErrors && (errorMessages = _errorMessagesMap.get(fileName)) != null) {
            for (String errorMessage : errorMessages) {
                sourceFormatterHelper.printError(fileName, errorMessage);
            }
        }
        if (content.equals(newContent)) {
            return;
        }
        if (this._autoFix) {
            fileUtil.write(file, newContent);
        } else if (this._firstSourceMismatchException == null) {
            this._firstSourceMismatchException = new SourceMismatchException(fileName, content, newContent);
        }
        if (_printErrors) {
            sourceFormatterHelper.printError(fileName, file);
        }
    }

    protected String replacePrimitiveWrapperInstantiation(String fileName, String line, int lineCount) {
        return line;
    }

    protected String sortAttributes(String fileName, String line, int lineCount, boolean allowApostropheDelimeter) {
        String s = line;
        int x = s.indexOf(" ");
        if (x == -1) {
            return line;
        }
        s = s.substring(x + 1);
        String previousAttribute = null;
        String previousAttributeAndValue = null;
        boolean wrongOrder = false;
        x = 0;
        while ((x = s.indexOf("=")) != -1 && s.length() > x + 1) {
            int lessThanCount;
            int greaterThanCount;
            int startJavaCodeSignCount;
            int endJavaCodeSignCount;
            char delimeter;
            String attribute = s.substring(0, x);
            if (!this.isAttributName(attribute)) {
                return line;
            }
            if (Validator.isNotNull(previousAttribute) && previousAttribute.compareTo(attribute) > 0) {
                wrongOrder = true;
            }
            if ((delimeter = (s = s.substring(x + 1)).charAt(0)) != '\'' && delimeter != '\"') {
                if (delimeter != '&') {
                    BaseSourceProcessor.processErrorMessage(fileName, "delimeter: " + fileName + " " + lineCount);
                }
                return line;
            }
            s = s.substring(1);
            String value = null;
            int y = -1;
            do {
                if ((y = s.indexOf(delimeter, y + 1)) != -1 && s.length() > y + 1) continue;
                return line;
            } while (!((value = s.substring(0, y)).startsWith("<%") ? (endJavaCodeSignCount = StringUtil.count((String)value, (String)"%>")) == (startJavaCodeSignCount = StringUtil.count((String)value, (String)"<%")) : (greaterThanCount = StringUtil.count((String)value, (String)">")) == (lessThanCount = StringUtil.count((String)value, (String)"<"))));
            if (delimeter == '\'') {
                if (!value.contains("\"")) {
                    line = StringUtil.replace((String)line, (String)("'" + value + "'"), (String)("\"" + value + "\""));
                    return this.sortAttributes(fileName, line, lineCount, allowApostropheDelimeter);
                }
                if (!allowApostropheDelimeter) {
                    String newValue = StringUtil.replace((String)value, (String)"\"", (String)"&quot;");
                    line = StringUtil.replace((String)line, (String)("'" + value + "'"), (String)("\"" + newValue + "\""));
                    return this.sortAttributes(fileName, line, lineCount, allowApostropheDelimeter);
                }
            }
            StringBundler sb = new StringBundler(5);
            sb.append(attribute);
            sb.append("=");
            sb.append(delimeter);
            sb.append(value);
            sb.append(delimeter);
            String currentAttributeAndValue = sb.toString();
            if (wrongOrder) {
                if (StringUtil.count((String)line, (String)currentAttributeAndValue) == 1 && StringUtil.count((String)line, previousAttributeAndValue) == 1) {
                    line = StringUtil.replaceFirst((String)line, previousAttributeAndValue, (String)currentAttributeAndValue);
                    line = StringUtil.replaceLast((String)line, (String)currentAttributeAndValue, (String)previousAttributeAndValue);
                    return this.sortAttributes(fileName, line, lineCount, allowApostropheDelimeter);
                }
                return line;
            }
            if ((s = s.substring(y + 1)).startsWith(">")) {
                x = s.indexOf(" ");
                if (x == -1) {
                    return line;
                }
                s = s.substring(x + 1);
                previousAttribute = null;
                previousAttributeAndValue = null;
                continue;
            }
            s = StringUtil.trimLeading((String)s);
            previousAttribute = attribute;
            previousAttributeAndValue = currentAttributeAndValue;
        }
        return line;
    }

    protected String stripLine(String s, char startDelimeter, char endDelimeter) {
        boolean insideDelimeters = false;
        int level = 0;
        StringBundler sb = new StringBundler();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (insideDelimeters) {
                if (c == endDelimeter) {
                    if (level > 0) {
                        --level;
                        continue;
                    }
                    if (c > '\u0001' && s.charAt(i - 1) == '\\' && s.charAt(i - 2) != '\\') continue;
                    insideDelimeters = false;
                    continue;
                }
                if (c != startDelimeter) continue;
                ++level;
                continue;
            }
            if (c == startDelimeter) {
                insideDelimeters = true;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected String stripQuotes(String s, char delimeter) {
        return this.stripLine(s, delimeter, delimeter);
    }

    protected String stripRedundantParentheses(String s) {
        int x = 0;
        while (true) {
            x = s.indexOf("(", x + 1);
            int y = s.indexOf(")", x);
            if (x == -1 || y == -1) {
                return s;
            }
            String linePart = s.substring(x + 1, y);
            if (!Validator.isAlphanumericName((String)(linePart = StringUtil.replace((String)linePart, (String)",", (String)""))) && !Validator.isNull((String)linePart)) continue;
            s = s.substring(0, x) + s.substring(y + 1);
        }
    }

    protected String trimContent(String content, boolean allowLeadingSpaces) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                sb.append(this.trimLine(line, allowLeadingSpaces));
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    protected String trimLine(String line, boolean allowLeadingSpaces) {
        if (line.trim().length() == 0) {
            return "";
        }
        line = StringUtil.trimTrailing((String)line);
        if (allowLeadingSpaces || !line.startsWith(" ") || line.startsWith(" *")) {
            return line;
        }
        if (!line.startsWith("    ")) {
            while (line.startsWith(" ")) {
                line = StringUtil.replaceFirst((String)line, (String)" ", (String)"");
            }
        } else {
            int pos = 0;
            String temp = line;
            while (temp.startsWith("    ")) {
                line = StringUtil.replaceFirst((String)line, (String)"    ", (String)"\t");
                temp = line.substring(++pos);
            }
        }
        return line;
    }

    private String[] _getExcludes() {
        List excludesList = ListUtil.fromString((String)GetterUtil.getString((String)System.getProperty("source.formatter.excludes")));
        excludesList.addAll(this.getPropertyList("source.formatter.excludes"));
        String[] includes = new String[]{"**\\source_formatter.ignore"};
        List<String> ignoreFileNames = this.getFileNames(new String[0], includes);
        for (String ignoreFileName : ignoreFileNames) {
            excludesList.add(ignoreFileName.substring(0, ignoreFileName.length() - 23) + "**");
        }
        return excludesList.toArray(new String[excludesList.size()]);
    }

    private Properties _getProperties() throws Exception {
        int i;
        String fileName = "source-formatter.properties";
        Properties properties = new Properties();
        ArrayList<Properties> propertiesList = new ArrayList<Properties>();
        int level = 2;
        if (portalSource) {
            level = 3;
        }
        for (i = 0; i <= level; ++i) {
            try {
                FileInputStream inputStream = new FileInputStream(fileName);
                Properties props = new Properties();
                props.load(inputStream);
                propertiesList.add(props);
            }
            catch (FileNotFoundException fnfe) {
                // empty catch block
            }
            fileName = "../" + fileName;
        }
        if (propertiesList.isEmpty()) {
            return properties;
        }
        properties = (Properties)propertiesList.get(0);
        if (propertiesList.size() == 1) {
            return properties;
        }
        for (i = 1; i < propertiesList.size(); ++i) {
            Properties props = (Properties)propertiesList.get(i);
            Enumeration<?> enu = props.propertyNames();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                String value = props.getProperty(key);
                if (Validator.isNull((String)value)) continue;
                if (key.contains("excludes")) {
                    String existingValue = properties.getProperty(key);
                    if (Validator.isNotNull((String)existingValue)) {
                        value = existingValue + "," + value;
                    }
                    properties.put(key, value);
                    continue;
                }
                if (properties.containsKey(key)) continue;
                properties.put(key, value);
            }
        }
        return properties;
    }

    private void _init(boolean useProperties, boolean printErrors, boolean autoFix) throws Exception {
        _errorMessagesMap = new HashMap<String, List<String>>();
        sourceFormatterHelper = new SourceFormatterHelper(useProperties);
        sourceFormatterHelper.init();
        this._autoFix = autoFix;
        this._excludes = this._getExcludes();
        _printErrors = printErrors;
        this._usePortalCompatImport = GetterUtil.getBoolean((String)this.getProperty("use.portal.compat.import"));
    }

    private boolean _isPortalSource() {
        return this.getFile("portal-impl", 4) != null;
    }

    static {
        saxReaderUtil = SAXReaderImpl.getInstance();
        sessionKeyPattern = Pattern.compile("SessionErrors.(?:add|contains|get)\\([^;%&|!]+|".concat("SessionMessages.(?:add|contains|get)\\([^;%&|!]+"), 8);
        taglibSessionKeyPattern = Pattern.compile("<liferay-ui:error [^>]+>|<liferay-ui:success [^>]+>", 8);
        _errorMessagesMap = new HashMap<String, List<String>>();
    }
}

