/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.seleniumbuilder;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.tools.seleniumbuilder.SeleniumBuilderFileUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.DirectoryScanner;

public class SeleniumBuilderContext {
    private static Pattern _pattern = Pattern.compile("public [a-z]* [A-Za-z0-9_]*\\(.*?\\)");
    private Map<String, String> _actionClassNames = new HashMap<String, String>();
    private Map<String, String> _actionFileNames = new HashMap<String, String>();
    private Map<String, String> _actionJavaFileNames = new HashMap<String, String>();
    private Set<String> _actionNames = new HashSet<String>();
    private Map<String, String> _actionPackageNames = new HashMap<String, String>();
    private Map<String, Element> _actionRootElements = new HashMap<String, Element>();
    private Map<String, String> _actionSimpleClassNames = new HashMap<String, String>();
    private Map<String, String> _functionClassNames = new HashMap<String, String>();
    private Map<String, String> _functionFileNames = new HashMap<String, String>();
    private Map<String, String> _functionJavaFileNames = new HashMap<String, String>();
    private Map<String, Integer> _functionLocatorCounts = new HashMap<String, Integer>();
    private Set<String> _functionNames = new HashSet<String>();
    private Map<String, String> _functionPackageNames = new HashMap<String, String>();
    private Map<String, String> _functionReturnTypes = new HashMap<String, String>();
    private Map<String, Element> _functionRootElements = new HashMap<String, Element>();
    private Map<String, String> _functionSimpleClassNames = new HashMap<String, String>();
    private Map<String, String> _macroClassNames = new HashMap<String, String>();
    private Map<String, String> _macroFileNames = new HashMap<String, String>();
    private Map<String, String> _macroJavaFileNames = new HashMap<String, String>();
    private Set<String> _macroNames = new HashSet<String>();
    private Map<String, String> _macroPackageNames = new HashMap<String, String>();
    private Map<String, Element> _macroRootElements = new HashMap<String, Element>();
    private Map<String, String> _macroSimpleClassNames = new HashMap<String, String>();
    private Map<String, String> _pathClassNames = new HashMap<String, String>();
    private Map<String, String> _pathFileNames = new HashMap<String, String>();
    private Map<String, String> _pathJavaFileNames = new HashMap<String, String>();
    private Set<String> _pathNames = new HashSet<String>();
    private Map<String, String> _pathPackageNames = new HashMap<String, String>();
    private Map<String, Element> _pathRootElements = new HashMap<String, Element>();
    private Map<String, String> _pathSimpleClassNames = new HashMap<String, String>();
    private SeleniumBuilderFileUtil _seleniumBuilderFileUtil;
    private Map<String, Integer> _seleniumParameterCounts = new HashMap<String, Integer>();
    private Map<String, String> _testCaseClassNames = new HashMap<String, String>();
    private Map<String, Set<String>> _testCaseCommandNames = new HashMap<String, Set<String>>();
    private Map<String, String> _testCaseFileNames = new HashMap<String, String>();
    private Map<String, String> _testCaseHTMLFileNames = new HashMap<String, String>();
    private Map<String, String> _testCaseJavaFileNames = new HashMap<String, String>();
    private Set<String> _testCaseNames = new HashSet<String>();
    private Map<String, String> _testCasePackageNames = new HashMap<String, String>();
    private Map<String, Element> _testCaseRootElements = new HashMap<String, Element>();
    private Map<String, String> _testCaseSimpleClassNames = new HashMap<String, String>();

    public SeleniumBuilderContext(SeleniumBuilderFileUtil seleniumBuilderFileUtil) throws Exception {
        this(seleniumBuilderFileUtil, "com/liferay/portalweb/portal/util/liferayselenium/");
    }

    public SeleniumBuilderContext(SeleniumBuilderFileUtil seleniumBuilderFileUtil, String liferaySeleniumDirName) throws Exception {
        String[] seleniumFileNames;
        String[] fileNames;
        this._seleniumBuilderFileUtil = seleniumBuilderFileUtil;
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(seleniumBuilderFileUtil.getBaseDirName());
        directoryScanner.setIncludes(new String[]{"**\\*.action", "**\\*.function", "**\\*.macro", "**\\*.path", "**\\*.testcase"});
        directoryScanner.scan();
        for (String fileName : fileNames = directoryScanner.getIncludedFiles()) {
            this.addFile(fileName);
        }
        for (String seleniumFileName : seleniumFileNames = new String[]{liferaySeleniumDirName + "LiferaySelenium.java", liferaySeleniumDirName + "SeleniumWrapper.java"}) {
            String content = this._seleniumBuilderFileUtil.getNormalizedContent(seleniumFileName);
            Matcher matcher = _pattern.matcher(content);
            while (matcher.find()) {
                String methodSignature = matcher.group();
                int x = methodSignature.indexOf(" ", 7);
                int y = methodSignature.indexOf("(");
                String seleniumCommandName = methodSignature.substring(x + 1, y);
                int count = 0;
                int z = methodSignature.indexOf(")");
                String parameters = methodSignature.substring(y + 1, z);
                if (!parameters.equals("")) {
                    count = StringUtil.count((String)parameters, (String)",") + 1;
                }
                this._seleniumParameterCounts.put(seleniumCommandName, count);
            }
        }
        this._seleniumParameterCounts.put("open", 1);
    }

    public void addFile(String fileName) throws Exception {
        if ((fileName = this._normalizeFileName(fileName)).endsWith(".action")) {
            String actionName = this._getName(fileName);
            if (this._actionFileNames.containsKey(actionName)) {
                this._seleniumBuilderFileUtil.throwValidationException(1008, fileName, actionName);
            }
            this._actionFileNames.put(actionName, fileName);
            this._actionNames.add(actionName);
            this._actionRootElements.put(actionName, this._getRootElement(fileName));
        } else if (fileName.endsWith(".function")) {
            String functionName = this._getName(fileName);
            this._functionClassNames.put(functionName, this._getClassName(fileName));
            this._functionFileNames.put(functionName, fileName);
            this._functionJavaFileNames.put(functionName, this._getJavaFileName(fileName));
            Element rootElement = this._getRootElement(fileName);
            this._functionLocatorCounts.put(functionName, this._getLocatorCount(rootElement));
            if (this._functionNames.contains(functionName)) {
                this._seleniumBuilderFileUtil.throwValidationException(1008, fileName, functionName);
            }
            this._functionNames.add(functionName);
            this._functionPackageNames.put(functionName, this._getPackageName(fileName));
            this._functionReturnTypes.put(functionName, this._getReturnType(functionName));
            this._functionRootElements.put(functionName, rootElement);
            this._functionSimpleClassNames.put(functionName, this._getSimpleClassName(fileName));
        } else if (fileName.endsWith(".macro")) {
            String macroName = this._getName(fileName);
            this._macroClassNames.put(macroName, this._getClassName(fileName));
            this._macroFileNames.put(macroName, fileName);
            this._macroJavaFileNames.put(macroName, this._getJavaFileName(fileName));
            if (this._macroNames.contains(macroName)) {
                this._seleniumBuilderFileUtil.throwValidationException(1008, fileName, macroName);
            }
            this._macroNames.add(macroName);
            this._macroPackageNames.put(macroName, this._getPackageName(fileName));
            this._macroSimpleClassNames.put(macroName, this._getSimpleClassName(fileName));
            this._macroRootElements.put(macroName, this._getRootElement(fileName));
        } else if (fileName.endsWith(".path")) {
            String pathName = this._getName(fileName);
            this._actionClassNames.put(pathName, this._getClassName(fileName, "Action"));
            this._actionJavaFileNames.put(pathName, this._getJavaFileName(fileName, "Action"));
            this._actionNames.add(pathName);
            this._actionPackageNames.put(pathName, this._getPackageName(fileName));
            this._actionSimpleClassNames.put(pathName, this._getSimpleClassName(fileName, "Action"));
            this._pathClassNames.put(pathName, this._getClassName(fileName));
            this._pathFileNames.put(pathName, fileName);
            this._pathJavaFileNames.put(pathName, this._getJavaFileName(fileName));
            if (this._pathNames.contains(pathName)) {
                this._seleniumBuilderFileUtil.throwValidationException(1008, fileName, pathName);
            }
            this._pathNames.add(pathName);
            this._pathPackageNames.put(pathName, this._getPackageName(fileName));
            this._pathRootElements.put(pathName, this._getRootElement(fileName));
            this._pathSimpleClassNames.put(pathName, this._getSimpleClassName(fileName));
        } else if (fileName.endsWith(".testcase")) {
            String testCaseName = this._getName(fileName);
            this._testCaseClassNames.put(testCaseName, this._getClassName(fileName));
            Element rootElement = this._getRootElement(fileName);
            this._testCaseCommandNames.put(testCaseName, this._getTestCaseCommandNames(rootElement));
            this._testCaseFileNames.put(testCaseName, fileName);
            this._testCaseHTMLFileNames.put(testCaseName, this._getHTMLFileName(fileName));
            this._testCaseJavaFileNames.put(testCaseName, this._getJavaFileName(fileName));
            if (this._testCaseNames.contains(testCaseName)) {
                this._seleniumBuilderFileUtil.throwValidationException(1008, fileName, testCaseName);
            }
            this._testCaseNames.add(testCaseName);
            this._testCasePackageNames.put(testCaseName, this._getPackageName(fileName));
            this._testCaseRootElements.put(testCaseName, rootElement);
            this._testCaseSimpleClassNames.put(testCaseName, this._getSimpleClassName(fileName));
        } else {
            throw new IllegalArgumentException("Invalid file " + fileName);
        }
    }

    public String getActionClassName(String actionName) {
        return this._actionClassNames.get(actionName);
    }

    public String getActionFileName(String actionName) {
        return this._actionFileNames.get(actionName);
    }

    public String getActionJavaFileName(String actionName) {
        return this._actionJavaFileNames.get(actionName);
    }

    public Set<String> getActionNames() {
        return this._actionNames;
    }

    public String getActionPackageName(String actionName) {
        return this._actionPackageNames.get(actionName);
    }

    public Element getActionRootElement(String actionName) {
        return this._actionRootElements.get(actionName);
    }

    public String getActionSimpleClassName(String actionName) {
        return this._actionSimpleClassNames.get(actionName);
    }

    public String getFunctionClassName(String functionName) {
        return this._functionClassNames.get(functionName);
    }

    public String getFunctionFileName(String functionName) {
        return this._functionFileNames.get(functionName);
    }

    public String getFunctionJavaFileName(String functionName) {
        return this._functionJavaFileNames.get(functionName);
    }

    public int getFunctionLocatorCount(String functionName) {
        return this._functionLocatorCounts.get(functionName);
    }

    public Set<String> getFunctionNames() {
        return this._functionNames;
    }

    public String getFunctionPackageName(String functionName) {
        return this._functionPackageNames.get(functionName);
    }

    public String getFunctionReturnType(String functionName) {
        return this._functionReturnTypes.get(functionName);
    }

    public Element getFunctionRootElement(String functionName) {
        return this._functionRootElements.get(functionName);
    }

    public String getFunctionSimpleClassName(String functionName) {
        return this._functionSimpleClassNames.get(functionName);
    }

    public String getMacroClassName(String macroName) {
        return this._macroClassNames.get(macroName);
    }

    public Set<Element> getMacroCommandElements(String macroName) {
        HashSet<Element> commandElementsSet = new HashSet<Element>();
        Element macroRootElement = this.getMacroRootElement(macroName);
        List macroCommandElements = macroRootElement.elements("command");
        String extendsName = macroRootElement.attributeValue("extends");
        if (extendsName != null) {
            Element extendsRootElement = this.getMacroRootElement(extendsName);
            List extendsCommandElements = extendsRootElement.elements("command");
            Set<String> commandNames = this.getMacroCommandNames(macroName);
            block0: for (String commandName : commandNames) {
                boolean macroElementFound = false;
                for (Element macroCommandElement : macroCommandElements) {
                    String macroCommandName = macroCommandElement.attributeValue("name");
                    if (!commandName.equals(macroCommandName)) continue;
                    commandElementsSet.add(macroCommandElement);
                    macroElementFound = true;
                    break;
                }
                if (macroElementFound) continue;
                for (Element extendsCommandElement : extendsCommandElements) {
                    String extendsCommandName = extendsCommandElement.attributeValue("name");
                    if (!commandName.equals(extendsCommandName)) continue;
                    commandElementsSet.add(extendsCommandElement);
                    continue block0;
                }
            }
        } else {
            commandElementsSet.addAll(macroCommandElements);
        }
        return commandElementsSet;
    }

    public Set<String> getMacroCommandNames(String macroName) {
        TreeSet<String> commandNames = new TreeSet<String>();
        Element macroRootElement = this.getMacroRootElement(macroName);
        List macroCommandElements = macroRootElement.elements("command");
        for (Element macroCommandElement : macroCommandElements) {
            commandNames.add(macroCommandElement.attributeValue("name"));
        }
        String extendsName = macroRootElement.attributeValue("extends");
        if (extendsName != null) {
            Element extendsRootElement = this.getMacroRootElement(extendsName);
            List extendsCommandElements = extendsRootElement.elements("command");
            for (Element extendsCommandElement : extendsCommandElements) {
                commandNames.add(extendsCommandElement.attributeValue("name"));
            }
        }
        return commandNames;
    }

    public String getMacroFileName(String macroName) {
        return this._macroFileNames.get(macroName);
    }

    public String getMacroJavaFileName(String macroName) {
        return this._macroJavaFileNames.get(macroName);
    }

    public Set<String> getMacroNames() {
        return this._macroNames;
    }

    public String getMacroPackageName(String macroName) {
        return this._macroPackageNames.get(macroName);
    }

    public Element getMacroRootElement(String macroName) {
        return this._macroRootElements.get(macroName);
    }

    public String getMacroSimpleClassName(String macroName) {
        return this._macroSimpleClassNames.get(macroName);
    }

    public String getPath(Element rootElement, String locatorKey) {
        String pathName = "";
        Element bodyElement = rootElement.element("body");
        Element tableElement = bodyElement.element("table");
        Element tbodyElement = tableElement.element("tbody");
        List trElements = tbodyElement.elements();
        for (Element trElement : trElements) {
            List tdElements = trElement.elements("td");
            Element pathLocatorElement = (Element)tdElements.get(1);
            Element pathLocatorKeyElement = (Element)tdElements.get(0);
            String pathLocatorKey = pathLocatorKeyElement.getText();
            if (pathLocatorKey.equals(locatorKey)) {
                return pathLocatorElement.getText();
            }
            if (!pathLocatorKey.equals("EXTEND_ACTION_PATH")) continue;
            pathName = pathLocatorElement.getText();
        }
        if (Validator.isNotNull((String)pathName)) {
            Element pathRootElement = this.getPathRootElement(pathName);
            return this.getPath(pathRootElement, locatorKey);
        }
        return locatorKey;
    }

    public String getPathClassName(String pathName) {
        return this._pathClassNames.get(pathName);
    }

    public String getPathFileName(String pathName) {
        return this._pathFileNames.get(pathName);
    }

    public String getPathJavaFileName(String pathName) {
        return this._pathJavaFileNames.get(pathName);
    }

    public Set<String> getPathLocatorKeys(Element rootElement) {
        HashSet<String> pathLocatorKeys = new HashSet<String>();
        Element bodyElement = rootElement.element("body");
        Element tableElement = bodyElement.element("table");
        Element tbodyElement = tableElement.element("tbody");
        List trElements = tbodyElement.elements();
        for (Element trElement : trElements) {
            List tdElements = trElement.elements("td");
            Element pathLocatorKeyElement = (Element)tdElements.get(0);
            String pathLocatorKey = pathLocatorKeyElement.getText();
            if (pathLocatorKey.equals("EXTEND_ACTION_PATH")) {
                Element pathLocatorElement = (Element)tdElements.get(1);
                String pathName = pathLocatorElement.getText();
                Element pathRootElement = this.getPathRootElement(pathName);
                pathLocatorKeys.addAll(this.getPathLocatorKeys(pathRootElement));
                continue;
            }
            pathLocatorKeys.add(pathLocatorKey);
        }
        return pathLocatorKeys;
    }

    public Set<String> getPathNames() {
        return this._pathNames;
    }

    public String getPathPackageName(String pathName) {
        return this._pathPackageNames.get(pathName);
    }

    public Element getPathRootElement(String pathName) {
        return this._pathRootElements.get(pathName);
    }

    public String getPathSimpleClassName(String pathName) {
        return this._pathSimpleClassNames.get(pathName);
    }

    public int getSeleniumParameterCount(String seleniumCommandName) {
        return this._seleniumParameterCounts.get(seleniumCommandName);
    }

    public String getTestCaseClassName(String testCaseName) {
        return this._testCaseClassNames.get(testCaseName);
    }

    public Set<String> getTestCaseCommandNames(String testCaseName) {
        Element testCaseRootElement = this.getTestCaseRootElement(testCaseName);
        String extendedTestCaseName = testCaseRootElement.attributeValue("extends");
        if (extendedTestCaseName != null) {
            Set<String> extendedTestCaseCommandNames = this._testCaseCommandNames.get(extendedTestCaseName);
            Set<String> currentTestCaseCommandNames = this._testCaseCommandNames.get(testCaseName);
            currentTestCaseCommandNames.addAll(extendedTestCaseCommandNames);
            return currentTestCaseCommandNames;
        }
        return this._testCaseCommandNames.get(testCaseName);
    }

    public String getTestCaseFileName(String testCaseName) {
        return this._testCaseFileNames.get(testCaseName);
    }

    public String getTestCaseHTMLFileName(String testCaseName) {
        return this._testCaseHTMLFileNames.get(testCaseName);
    }

    public String getTestCaseJavaFileName(String testCaseName) {
        return this._testCaseJavaFileNames.get(testCaseName);
    }

    public Set<String> getTestCaseNames() {
        return this._testCaseNames;
    }

    public String getTestCasePackageName(String testCaseName) {
        return this._testCasePackageNames.get(testCaseName);
    }

    public Element getTestCaseRootElement(String testCaseName) {
        return this._testCaseRootElements.get(testCaseName);
    }

    public String getTestCaseSimpleClassName(String testCaseName) {
        return this._testCaseSimpleClassNames.get(testCaseName);
    }

    public void validateActionElements(String actionName) {
        String actionFileName = this.getActionFileName(actionName);
        Element rootElement = this.getActionRootElement(actionName);
        if (rootElement == null) {
            return;
        }
        if (!this._pathNames.contains(actionName)) {
            this._seleniumBuilderFileUtil.throwValidationException(2002, actionFileName, actionName);
        }
        List<Element> caseElements = this._seleniumBuilderFileUtil.getAllChildElements(rootElement, "case");
        for (Element caseElement : caseElements) {
            this._validateLocatorKeyElement(actionFileName, actionName, caseElement);
        }
        List<Element> commandElements = this._seleniumBuilderFileUtil.getAllChildElements(rootElement, "command");
        HashSet<String> commandElementNames = new HashSet<String>();
        for (Element commandElement : commandElements) {
            String commandName = commandElement.attributeValue("name");
            if (commandElementNames.contains(commandName)) {
                this._seleniumBuilderFileUtil.throwValidationException(1009, actionFileName, commandElement, commandName);
            }
            commandElementNames.add(commandName);
            if (this._isFunctionName(commandName)) continue;
            this._seleniumBuilderFileUtil.throwValidationException(2001, actionFileName, commandElement, commandName);
        }
        List<Element> executeElements = this._seleniumBuilderFileUtil.getAllChildElements(rootElement, "execute");
        for (Element executeElement : executeElements) {
            this._validateFunctionElement(actionFileName, executeElement);
        }
    }

    public void validateElements(String fileName) {
        String name = this._getName(fileName);
        if (fileName.endsWith(".action")) {
            this.validateActionElements(name);
        } else if (fileName.endsWith(".function")) {
            this.validateFunctionElements(name);
        } else if (fileName.endsWith(".macro")) {
            this.validateMacroElements(name);
        } else if (fileName.endsWith(".testcase")) {
            this.validateTestCaseElements(name);
        }
    }

    public void validateFunctionElements(String functionName) {
        Element rootElement = this.getFunctionRootElement(functionName);
        if (rootElement == null) {
            return;
        }
        String functionFileName = this.getFunctionFileName(functionName);
        List<Element> commandElements = this._seleniumBuilderFileUtil.getAllChildElements(rootElement, "command");
        HashSet<String> commandElementNames = new HashSet<String>();
        for (Element commandElement : commandElements) {
            String commandName = commandElement.attributeValue("name");
            if (commandElementNames.contains(commandName)) {
                this._seleniumBuilderFileUtil.throwValidationException(1009, functionFileName, commandElement, commandName);
                continue;
            }
            commandElementNames.add(commandName);
        }
        List<Element> conditionAndExecuteElements = this._seleniumBuilderFileUtil.getAllChildElements(rootElement, "condition");
        conditionAndExecuteElements.addAll(this._seleniumBuilderFileUtil.getAllChildElements(rootElement, "execute"));
        for (Element conditionAndExecuteElement : conditionAndExecuteElements) {
            String function = conditionAndExecuteElement.attributeValue("function");
            String selenium = conditionAndExecuteElement.attributeValue("selenium");
            if (function != null) {
                this._validateFunctionElement(functionFileName, conditionAndExecuteElement);
                continue;
            }
            if (selenium == null) continue;
            this._validateSeleniumElement(functionFileName, conditionAndExecuteElement);
        }
    }

    public void validateMacroElements(String macroName) {
        Element rootElement = this.getMacroRootElement(macroName);
        if (rootElement == null) {
            return;
        }
        String macroFileName = this.getMacroFileName(macroName);
        String extendsName = rootElement.attributeValue("extends");
        if (extendsName != null) {
            Element extendsRootElement;
            if (!this._macroNames.contains(extendsName)) {
                this._seleniumBuilderFileUtil.throwValidationException(1006, macroFileName, rootElement, "extends");
            }
            if (macroName.equals(extendsName)) {
                this._seleniumBuilderFileUtil.throwValidationException(1006, macroFileName, rootElement, "extends");
            }
            if ((extendsRootElement = this.getMacroRootElement(extendsName)).attributeValue("extends") != null) {
                this._seleniumBuilderFileUtil.throwValidationException(1006, macroFileName, rootElement, "extends");
            }
        }
        this.validateVarElements(rootElement, macroFileName);
        List<Element> commandElements = this._seleniumBuilderFileUtil.getAllChildElements(rootElement, "command");
        HashSet<String> commandElementNames = new HashSet<String>();
        for (Element commandElement : commandElements) {
            String commandName = commandElement.attributeValue("name");
            if (commandElementNames.contains(commandName)) {
                this._seleniumBuilderFileUtil.throwValidationException(1009, macroFileName, commandElement, commandName);
                continue;
            }
            commandElementNames.add(commandName);
        }
        List<Element> conditionAndExecuteElements = this._seleniumBuilderFileUtil.getAllChildElements(rootElement, "condition");
        conditionAndExecuteElements.addAll(this._seleniumBuilderFileUtil.getAllChildElements(rootElement, "execute"));
        for (Element conditionAndExecuteElement : conditionAndExecuteElements) {
            String action = conditionAndExecuteElement.attributeValue("action");
            String macro = conditionAndExecuteElement.attributeValue("macro");
            if (action != null) {
                this._validateActionElement(macroFileName, conditionAndExecuteElement);
                continue;
            }
            if (macro == null) continue;
            this._validateMacroElement(macroFileName, conditionAndExecuteElement);
        }
    }

    public void validateTestCaseElements(String testCaseName) {
        Element rootElement = this.getTestCaseRootElement(testCaseName);
        if (rootElement == null) {
            return;
        }
        String testCaseFileName = this.getTestCaseFileName(testCaseName);
        String extendedTestCase = rootElement.attributeValue("extends");
        if (extendedTestCase != null && (!this._testCaseNames.contains(extendedTestCase) || testCaseName.equals(extendedTestCase))) {
            this._seleniumBuilderFileUtil.throwValidationException(1006, testCaseFileName, rootElement, "extends");
        }
        this.validateVarElements(rootElement, testCaseFileName);
        List<Element> commandElements = this._seleniumBuilderFileUtil.getAllChildElements(rootElement, "command");
        HashSet<String> commandElementNames = new HashSet<String>();
        for (Element commandElement : commandElements) {
            String commandName = commandElement.attributeValue("name");
            if (commandElementNames.contains(commandName)) {
                this._seleniumBuilderFileUtil.throwValidationException(1009, testCaseFileName, commandElement, commandName);
                continue;
            }
            commandElementNames.add(commandName);
        }
        List<Element> executeElements = this._seleniumBuilderFileUtil.getAllChildElements(rootElement, "execute");
        for (Element executeElement : executeElements) {
            String action = executeElement.attributeValue("action");
            String macro = executeElement.attributeValue("macro");
            String testCase = executeElement.attributeValue("test-case");
            if (action != null) {
                this._validateActionElement(testCaseFileName, executeElement);
                continue;
            }
            if (macro != null) {
                this._validateMacroElement(testCaseFileName, executeElement);
                continue;
            }
            if (testCase == null) continue;
            this._validateTestCaseElement(testCaseFileName, executeElement, rootElement);
        }
    }

    public void validateVarElements(Element rootElement, String fileName) {
        List<Element> varElements = this._seleniumBuilderFileUtil.getAllChildElements(rootElement, "var");
        for (Element varElement : varElements) {
            String varLocatorKey = varElement.attributeValue("locator-key");
            String varPath = varElement.attributeValue("path");
            if (!Validator.isNotNull((String)varLocatorKey) || !Validator.isNotNull((String)varPath)) continue;
            if (!this._pathRootElements.containsKey(varPath)) {
                this._seleniumBuilderFileUtil.throwValidationException(1014, fileName, varElement, varPath);
            }
            if (this._isValidLocatorKey(varPath, null, varLocatorKey)) continue;
            this._seleniumBuilderFileUtil.throwValidationException(1010, fileName, varElement, varLocatorKey);
        }
    }

    private String _getClassName(String fileName) {
        return this._seleniumBuilderFileUtil.getClassName(fileName);
    }

    private String _getClassName(String fileName, String classSuffix) {
        return this._seleniumBuilderFileUtil.getClassName(fileName, classSuffix);
    }

    private String _getHTMLFileName(String fileName) {
        return this._seleniumBuilderFileUtil.getHTMLFileName(fileName);
    }

    private String _getJavaFileName(String fileName) {
        return this._seleniumBuilderFileUtil.getJavaFileName(fileName);
    }

    private String _getJavaFileName(String fileName, String classSuffix) {
        return this._seleniumBuilderFileUtil.getJavaFileName(fileName, classSuffix);
    }

    private int _getLocatorCount(Element rootElement) throws Exception {
        return this._seleniumBuilderFileUtil.getLocatorCount(rootElement);
    }

    private String _getName(String fileName) {
        return this._seleniumBuilderFileUtil.getName(fileName);
    }

    private String _getPackageName(String fileName) {
        return this._seleniumBuilderFileUtil.getPackageName(fileName);
    }

    private String _getReturnType(String name) throws Exception {
        return this._seleniumBuilderFileUtil.getReturnType(name);
    }

    private Element _getRootElement(String fileName) throws Exception {
        return this._seleniumBuilderFileUtil.getRootElement(fileName);
    }

    private String _getSimpleClassName(String fileName) {
        return this._seleniumBuilderFileUtil.getSimpleClassName(fileName);
    }

    private String _getSimpleClassName(String fileName, String classSuffix) {
        return this._seleniumBuilderFileUtil.getSimpleClassName(fileName, classSuffix);
    }

    private Set<String> _getTestCaseCommandNames(Element rootElement) {
        List<Element> commandElements = this._seleniumBuilderFileUtil.getAllChildElements(rootElement, "command");
        TreeSet<String> commandNames = new TreeSet<String>();
        for (Element commandElement : commandElements) {
            commandNames.add(commandElement.attributeValue("name"));
        }
        return commandNames;
    }

    private boolean _isActionName(String name) {
        for (String actionName : this._actionNames) {
            if (!actionName.equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean _isFunctionCommand(String name, String command) {
        if (!this._isFunctionName(name)) {
            return false;
        }
        Element rootElement = this.getFunctionRootElement(name);
        List<Element> commandElements = this._seleniumBuilderFileUtil.getAllChildElements(rootElement, "command");
        for (Element commandElement : commandElements) {
            String commandName = commandElement.attributeValue("name");
            if (!commandName.equals(command)) continue;
            return true;
        }
        return false;
    }

    private boolean _isFunctionName(String name) {
        for (String functionName : this._functionNames) {
            if (!functionName.equals(StringUtil.upperCaseFirstLetter((String)name))) continue;
            return true;
        }
        return false;
    }

    private boolean _isMacroCommand(String name, String command) {
        if (!this._isMacroName(name)) {
            return false;
        }
        Set<Element> commandElements = this.getMacroCommandElements(name);
        for (Element commandElement : commandElements) {
            String commandName = commandElement.attributeValue("name");
            if (!commandName.equals(command)) continue;
            return true;
        }
        return false;
    }

    private boolean _isMacroName(String name) {
        for (String macroName : this._macroNames) {
            if (!macroName.equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean _isSeleniumCommand(String command) {
        return this._seleniumParameterCounts.containsKey(command);
    }

    private boolean _isValidLocatorKey(String actionName, String caseComparator, String locatorKey) {
        Element pathRootElement = this.getPathRootElement(actionName);
        Set<String> pathLocatorKeys = this.getPathLocatorKeys(pathRootElement);
        String[] partialKeys = new String[]{};
        if (locatorKey.contains("${") && locatorKey.contains("}")) {
            caseComparator = "partial";
            partialKeys = locatorKey.split("\\$\\{[^}]*?\\}");
        }
        for (String pathLocatorKey : pathLocatorKeys) {
            if (caseComparator == null) {
                if (!pathLocatorKey.equals(locatorKey)) continue;
                return true;
            }
            if (caseComparator.equals("contains") && pathLocatorKey.contains(locatorKey)) {
                return true;
            }
            if (caseComparator.equals("endsWith") && pathLocatorKey.endsWith(locatorKey)) {
                return true;
            }
            if (caseComparator.equals("partial")) {
                boolean containsAll = true;
                for (String s : partialKeys) {
                    if (pathLocatorKey.contains(s)) continue;
                    containsAll = false;
                }
                if (!containsAll) continue;
                return true;
            }
            if (!caseComparator.equals("startsWith") || !pathLocatorKey.startsWith(locatorKey)) continue;
            return true;
        }
        return false;
    }

    private String _normalizeFileName(String fileName) {
        return this._seleniumBuilderFileUtil.normalizeFileName(fileName);
    }

    private void _validateActionElement(String fileName, Element element) {
        String actionCommand;
        String actionName;
        String action = element.attributeValue("action");
        int x = action.indexOf("#");
        if (x == -1) {
            this._seleniumBuilderFileUtil.throwValidationException(1006, fileName, element, "action");
        }
        if (!this._isActionName(actionName = action.substring(0, x))) {
            this._seleniumBuilderFileUtil.throwValidationException(1011, fileName, element, "action", actionName);
        }
        if (!this._isFunctionName(actionCommand = action.substring(x + 1))) {
            this._seleniumBuilderFileUtil.throwValidationException(1012, fileName, element, "action", actionCommand);
        }
        this._validateLocatorKeyElement(fileName, actionName, element);
    }

    private void _validateFunctionElement(String fileName, Element element) {
        String functionCommand;
        String functionName;
        String function = element.attributeValue("function");
        int x = function.indexOf("#");
        if (x == -1) {
            this._seleniumBuilderFileUtil.throwValidationException(1006, fileName, element, "function");
        }
        if (!this._isFunctionName(functionName = function.substring(0, x))) {
            this._seleniumBuilderFileUtil.throwValidationException(1011, fileName, element, "function", functionName);
        }
        if (!this._isFunctionCommand(functionName, functionCommand = function.substring(x + 1))) {
            this._seleniumBuilderFileUtil.throwValidationException(1012, fileName, element, "function", functionCommand);
        }
    }

    private void _validateLocatorKeyElement(String fileName, String actionName, Element element) {
        String comparator = element.attributeValue("comparator");
        List attributes = element.attributes();
        for (Attribute attribute : attributes) {
            String attributeValue;
            String attributeName = attribute.getName();
            if (!attributeName.startsWith("locator-key") || this._isValidLocatorKey(actionName, comparator, attributeValue = attribute.getValue())) continue;
            this._seleniumBuilderFileUtil.throwValidationException(1010, fileName, element, attributeValue);
        }
    }

    private void _validateMacroElement(String fileName, Element element) {
        String macroCommand;
        String macroName;
        String macro = element.attributeValue("macro");
        int x = macro.indexOf("#");
        if (x == -1) {
            this._seleniumBuilderFileUtil.throwValidationException(1006, fileName, element, "macro");
        }
        if (!this._isMacroName(macroName = macro.substring(0, x))) {
            this._seleniumBuilderFileUtil.throwValidationException(1011, fileName, element, "macro", macroName);
        }
        if (!this._isMacroCommand(macroName, macroCommand = macro.substring(x + 1))) {
            this._seleniumBuilderFileUtil.throwValidationException(1012, fileName, element, "macro", macroCommand);
        }
    }

    private void _validateSeleniumElement(String fileName, Element element) {
        String selenium = element.attributeValue("selenium");
        if (!this._isSeleniumCommand(selenium)) {
            this._seleniumBuilderFileUtil.throwValidationException(1012, fileName, element, "selenium", selenium);
        }
    }

    private void _validateTestCaseElement(String fileName, Element element, Element rootElement) {
        String testCase = element.attributeValue("test-case");
        int x = testCase.indexOf("#");
        String testCaseCommand = testCase.substring(x + 1);
        String extendedTestCase = rootElement.attributeValue("extends");
        if (extendedTestCase != null) {
            Element extendedTestCaseRootElement = this.getTestCaseRootElement(extendedTestCase);
            if (testCaseCommand.equals("set-up")) {
                Element extendedTestCaseSetUpElement = extendedTestCaseRootElement.element("set-up");
                if (extendedTestCaseSetUpElement == null) {
                    this._seleniumBuilderFileUtil.throwValidationException(1006, fileName, element, "test-case");
                }
            } else if (testCaseCommand.equals("tear-down")) {
                Element extendedTestCaseTearDownElement = extendedTestCaseRootElement.element("tear-down");
                if (extendedTestCaseTearDownElement == null) {
                    this._seleniumBuilderFileUtil.throwValidationException(1006, fileName, element, "test-case");
                }
            } else {
                Set<String> extendedTestCaseCommandNames = this._testCaseCommandNames.get(extendedTestCase);
                if (!extendedTestCaseCommandNames.contains(testCaseCommand)) {
                    this._seleniumBuilderFileUtil.throwValidationException(1006, fileName, element, "test-case");
                }
            }
        } else {
            this._seleniumBuilderFileUtil.throwValidationException(1004, fileName, rootElement, new String[]{"extends"});
        }
    }
}

