/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.seleniumbuilder;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.ToolDependencies;
import com.liferay.portal.tools.seleniumbuilder.ActionConverter;
import com.liferay.portal.tools.seleniumbuilder.FunctionConverter;
import com.liferay.portal.tools.seleniumbuilder.MacroConverter;
import com.liferay.portal.tools.seleniumbuilder.PathConverter;
import com.liferay.portal.tools.seleniumbuilder.SeleniumBuilderContext;
import com.liferay.portal.tools.seleniumbuilder.SeleniumBuilderFileUtil;
import com.liferay.portal.tools.seleniumbuilder.TestCaseConverter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class SeleniumBuilder {
    private SeleniumBuilderContext _seleniumBuilderContext;
    private SeleniumBuilderFileUtil _seleniumBuilderFileUtil;

    public static void main(String[] args) throws Exception {
        ToolDependencies.wireBasic();
        new SeleniumBuilder(args);
    }

    public SeleniumBuilder(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String baseDirName = arguments.get("selenium.base.dir");
        String projectDirName = arguments.get("project.dir");
        this._seleniumBuilderFileUtil = new SeleniumBuilderFileUtil(baseDirName, projectDirName);
        this._seleniumBuilderContext = new SeleniumBuilderContext(this._seleniumBuilderFileUtil);
        Set<String> actionNames = this._seleniumBuilderContext.getActionNames();
        for (String actionName : actionNames) {
            this._seleniumBuilderContext.validateActionElements(actionName);
        }
        Set<String> functionNames = this._seleniumBuilderContext.getFunctionNames();
        for (String functionName : functionNames) {
            this._seleniumBuilderContext.validateFunctionElements(functionName);
        }
        Set<String> macroNames = this._seleniumBuilderContext.getMacroNames();
        for (String macroName : macroNames) {
            this._seleniumBuilderContext.validateMacroElements(macroName);
        }
        Set<String> testCaseNames = this._seleniumBuilderContext.getTestCaseNames();
        for (String testCaseName : testCaseNames) {
            this._seleniumBuilderContext.validateTestCaseElements(testCaseName);
        }
        Set types = SetUtil.fromArray((Object[])StringUtil.split((String)arguments.get("selenium.types")));
        if (types.contains("action")) {
            ActionConverter actionConverter = new ActionConverter(this._seleniumBuilderContext, this._seleniumBuilderFileUtil);
            for (String actionName : actionNames) {
                actionConverter.convert(actionName);
            }
        }
        if (types.contains("function")) {
            FunctionConverter functionConverter = new FunctionConverter(this._seleniumBuilderContext, this._seleniumBuilderFileUtil);
            for (String functionName : functionNames) {
                functionConverter.convert(functionName);
            }
        }
        if (types.contains("macro")) {
            MacroConverter macroConverter = new MacroConverter(this._seleniumBuilderContext, this._seleniumBuilderFileUtil);
            for (String macroName : macroNames) {
                macroConverter.convert(macroName);
            }
        }
        if (types.contains("path")) {
            PathConverter pathConverter = new PathConverter(this._seleniumBuilderContext, this._seleniumBuilderFileUtil);
            Set<String> pathNames = this._seleniumBuilderContext.getPathNames();
            for (String pathName : pathNames) {
                pathConverter.convert(pathName);
            }
        }
        if (types.contains("testcase")) {
            TestCaseConverter testCaseConverter = new TestCaseConverter(this._seleniumBuilderContext, this._seleniumBuilderFileUtil);
            String testClass = arguments.get("test.class");
            if (!testClass.equals("${test.class}")) {
                Element rootElement;
                String extendsTestCaseName;
                String testCaseCommandName = null;
                String testCaseName = null;
                if (testClass.contains("#")) {
                    String[] testClassParts = StringUtil.split((String)testClass, (String)"#");
                    testCaseCommandName = testClassParts[1];
                    testCaseName = testClassParts[0];
                } else {
                    testCaseName = testClass;
                }
                if (testCaseCommandName != null && testCaseCommandName.startsWith("test")) {
                    testCaseCommandName = StringUtil.replaceFirst((String)testCaseCommandName, (String)"test", (String)"");
                }
                if (testCaseName.endsWith("TestCase")) {
                    testCaseName = StringUtil.replaceLast((String)testCaseName, (String)"TestCase", (String)"");
                }
                if ((extendsTestCaseName = (rootElement = this._seleniumBuilderContext.getTestCaseRootElement(testCaseName)).attributeValue("extends")) != null) {
                    testCaseConverter.convert(extendsTestCaseName, testCaseCommandName);
                }
                testCaseConverter.convert(testCaseName, testCaseCommandName);
            }
        }
        this._writeTestCaseMethodNamesFile();
        this._writeTestCasePropertiesFile();
        System.out.println("\nThere are " + this._getTestCaseMethodCount() + " test cases.");
    }

    private int _getTestCaseMethodCount() {
        int testCaseCount = 0;
        Set<String> testCaseNames = this._seleniumBuilderContext.getTestCaseNames();
        for (String testCaseName : testCaseNames) {
            Element rootElement = this._seleniumBuilderContext.getTestCaseRootElement(testCaseName);
            if (GetterUtil.getBoolean((String)rootElement.attributeValue("ignore"))) continue;
            String extendsTestCaseName = rootElement.attributeValue("extends");
            if (extendsTestCaseName != null) {
                Element extendsRootElement = this._seleniumBuilderContext.getTestCaseRootElement(extendsTestCaseName);
                List<Element> commandElements = this._seleniumBuilderFileUtil.getAllChildElements(extendsRootElement, "command");
                testCaseCount += commandElements.size();
            }
            List<Element> commandElements = this._seleniumBuilderFileUtil.getAllChildElements(rootElement, "command");
            testCaseCount += commandElements.size();
        }
        return testCaseCount;
    }

    private boolean _isCommandNameOverridden(Element rootElement, String commandName) {
        List<Element> commandElements = this._seleniumBuilderFileUtil.getAllChildElements(rootElement, "command");
        for (Element commandElement : commandElements) {
            if (!commandName.equals(commandElement.attributeValue("name"))) continue;
            return true;
        }
        return false;
    }

    private boolean _isIgnoreCommandName(Element rootElement, String commandName) {
        String ignoreCommandNamesString = rootElement.attributeValue("ignore-command-names");
        if (ignoreCommandNamesString == null) {
            return false;
        }
        Object[] ignoreCommandNames = StringUtil.split((String)ignoreCommandNamesString);
        ignoreCommandNamesString = StringUtil.replace((String)ignoreCommandNamesString, (String[])new String[]{" ", "\n", "\t"}, (String[])new String[]{"", "", ""});
        return ArrayUtil.contains((Object[])ignoreCommandNames, (Object)commandName);
    }

    private void _writeTestCaseMethodNamesFile() throws Exception {
        String[] productNames;
        String componentName;
        TreeMap<String, Set<Object>> testCaseMethodNameMap = new TreeMap<String, Set<Object>>();
        Set<String> testCaseNames = this._seleniumBuilderContext.getTestCaseNames();
        for (String testCaseName : testCaseNames) {
            String extendsTestCaseName;
            Element rootElement = this._seleniumBuilderContext.getTestCaseRootElement(testCaseName);
            if (GetterUtil.getBoolean((String)rootElement.attributeValue("ignore"))) continue;
            componentName = rootElement.attributeValue("component-name");
            Set<String> compontentTestCaseMethodNames = new TreeSet();
            if (testCaseMethodNameMap.containsKey(componentName)) {
                compontentTestCaseMethodNames = (Set)testCaseMethodNameMap.get(componentName);
            }
            if ((extendsTestCaseName = rootElement.attributeValue("extends")) != null) {
                Element extendsRootElement = this._seleniumBuilderContext.getTestCaseRootElement(extendsTestCaseName);
                List<Element> commandElements = this._seleniumBuilderFileUtil.getAllChildElements(extendsRootElement, "command");
                for (Element commandElement : commandElements) {
                    String commandName = commandElement.attributeValue("name");
                    if (this._isCommandNameOverridden(rootElement, commandName) || this._isIgnoreCommandName(rootElement, commandName)) continue;
                    String testCaseMethodName = testCaseName + "TestCase#test" + commandName;
                    compontentTestCaseMethodNames.add(testCaseMethodName);
                }
            }
            List<Element> commandElements = this._seleniumBuilderFileUtil.getAllChildElements(rootElement, "command");
            for (Element commandElement : commandElements) {
                String testCaseMethodName = testCaseName + "TestCase#test" + commandElement.attributeValue("name");
                String knownIssues = commandElement.attributeValue("known-issues");
                if (knownIssues != null) {
                    String knownIssuesComponent = "portal-known-issues";
                    if (componentName.startsWith("marketplace")) {
                        knownIssuesComponent = "marketplace-known-issues";
                    } else if (componentName.startsWith("social-office")) {
                        knownIssuesComponent = "social-office-known-issues";
                    }
                    Set<String> knownIssuesTestCaseMethodNames = new TreeSet<String>();
                    if (testCaseMethodNameMap.containsKey(knownIssuesComponent)) {
                        knownIssuesTestCaseMethodNames = (Set)testCaseMethodNameMap.get(knownIssuesComponent);
                    }
                    knownIssuesTestCaseMethodNames.add(testCaseMethodName);
                    testCaseMethodNameMap.put(knownIssuesComponent, knownIssuesTestCaseMethodNames);
                    continue;
                }
                compontentTestCaseMethodNames.add(testCaseMethodName);
            }
            if (compontentTestCaseMethodNames.isEmpty()) continue;
            testCaseMethodNameMap.put(componentName, compontentTestCaseMethodNames);
        }
        List<String> componentNames = this._seleniumBuilderFileUtil.getComponentNames();
        StringBundler sb = new StringBundler();
        Iterator<String> i$ = componentNames.iterator();
        while (i$.hasNext()) {
            String componentNameKey = componentName = i$.next();
            componentName = StringUtil.replace((String)componentName, (String)"-", (String)"_");
            componentName = StringUtil.upperCase((String)componentName);
            sb.append(componentName);
            sb.append("_TEST_CASE_METHOD_NAMES=");
            if (testCaseMethodNameMap.containsKey(componentNameKey)) {
                Set compontentTestCaseMethodNames = (Set)testCaseMethodNameMap.get(componentNameKey);
                String testCaseMethodNamesString = StringUtil.merge((Object[])compontentTestCaseMethodNames.toArray(new String[compontentTestCaseMethodNames.size()]), (String)" ");
                sb.append(testCaseMethodNamesString);
                sb.append("\n");
                continue;
            }
            sb.append("PortalSmokeTestCase#testSmoke\n");
        }
        sb.append("\n");
        for (String productName : productNames = new String[]{"marketplace", "portal", "social-office"}) {
            TreeSet productTestCaseMethodNames = new TreeSet();
            String productKey = productName;
            productName = StringUtil.replace((String)productName, (String)"-", (String)"_");
            productName = StringUtil.upperCase((String)productName);
            sb.append(productName);
            sb.append("_TEST_CASE_METHOD_NAMES=");
            for (String componentName2 : componentNames) {
                if (!componentName2.startsWith(productKey) || !testCaseMethodNameMap.containsKey(componentName2)) continue;
                productTestCaseMethodNames.addAll((Collection)testCaseMethodNameMap.get(componentName2));
            }
            if (!productTestCaseMethodNames.isEmpty()) {
                String testCaseMethodNamesString = StringUtil.merge((Object[])productTestCaseMethodNames.toArray(new String[productTestCaseMethodNames.size()]), (String)" ");
                sb.append(testCaseMethodNamesString);
                sb.append("\n");
                continue;
            }
            sb.append("PortalSmokeTestCase#testSmoke\n");
        }
        this._seleniumBuilderFileUtil.writeFile("../../../test.case.method.names.properties", sb.toString(), false);
    }

    private void _writeTestCasePropertiesFile() throws Exception {
        TreeSet<String> testCaseProperties = new TreeSet<String>();
        Set<String> testCaseNames = this._seleniumBuilderContext.getTestCaseNames();
        for (String testCaseName : testCaseNames) {
            Element rootElement = this._seleniumBuilderContext.getTestCaseRootElement(testCaseName);
            List rootPropertyElements = rootElement.elements("property");
            StringBundler sb = new StringBundler();
            sb.append(testCaseName);
            sb.append("TestCase.all.testray.testcase.product.edition=CE");
            testCaseProperties.add(sb.toString());
            for (Element rootPropertyElement : rootPropertyElements) {
                sb = new StringBundler();
                sb.append(testCaseName);
                sb.append("TestCase.all.");
                String rootPropertyName = rootPropertyElement.attributeValue("name");
                sb.append(rootPropertyName);
                sb.append("=");
                sb.append(rootPropertyElement.attributeValue("value"));
                testCaseProperties.add(sb.toString());
                String rootPropertyDelimiter = rootPropertyElement.attributeValue("delimiter");
                if (rootPropertyDelimiter == null || !rootPropertyName.equals("ignore.errors")) continue;
                sb = new StringBundler();
                sb.append(testCaseName);
                sb.append("TestCase.all.");
                sb.append(rootPropertyName);
                sb.append(".delimiter=");
                sb.append(rootPropertyDelimiter);
                testCaseProperties.add(sb.toString());
            }
            List<Element> commandElements = this._seleniumBuilderFileUtil.getAllChildElements(rootElement, "command");
            for (Element commandElement : commandElements) {
                List<Element> commandPropertyElements = this._seleniumBuilderFileUtil.getAllChildElements(commandElement, "property");
                for (Element commandPropertyElement : commandPropertyElements) {
                    sb = new StringBundler();
                    sb.append(testCaseName);
                    sb.append("TestCase.test");
                    sb.append(commandElement.attributeValue("name"));
                    sb.append(".");
                    sb.append(commandPropertyElement.attributeValue("name"));
                    sb.append("=");
                    sb.append(commandPropertyElement.attributeValue("value"));
                    testCaseProperties.add(sb.toString());
                }
                sb = new StringBundler();
                sb.append(testCaseName);
                sb.append("TestCase.test");
                sb.append(commandElement.attributeValue("name"));
                sb.append(".testray.testcase.description=");
                if (commandElement.attributeValue("description") != null) {
                    sb.append(commandElement.attributeValue("description"));
                }
                testCaseProperties.add(sb.toString());
                sb = new StringBundler();
                sb.append(testCaseName);
                sb.append("TestCase.test");
                sb.append(commandElement.attributeValue("name"));
                sb.append(".testray.testcase.name=");
                sb.append(testCaseName);
                sb.append("#");
                sb.append(commandElement.attributeValue("name"));
                testCaseProperties.add(sb.toString());
                sb = new StringBundler();
                sb.append(testCaseName);
                sb.append("TestCase.test");
                sb.append(commandElement.attributeValue("name"));
                sb.append(".testray.testcase.priority=");
                sb.append(commandElement.attributeValue("priority"));
                testCaseProperties.add(sb.toString());
            }
        }
        String testCasePropertiesString = StringUtil.merge((Object[])testCaseProperties.toArray(new String[testCaseProperties.size()]), (String)"\n");
        this._seleniumBuilderFileUtil.writeFile("../../../test.generated.properties", testCasePropertiesString, false);
    }
}

