/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sass;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.dynamiccss.RTLCSSUtil;
import com.liferay.portal.tools.SassToCssBuilder;
import com.liferay.portal.tools.sass.SassExecutorUtil;
import com.liferay.portal.tools.sass.SassFileWithMediaQuery;
import com.liferay.portal.tools.sass.SassFragment;
import com.liferay.portal.tools.sass.SassString;
import com.liferay.portal.util.AggregateUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class SassFile
implements Callable<Void>,
SassFragment {
    private static final String _BASE_URL = "@base_url@";
    private static final String _CSS_COMMENT_BEGIN = "/*";
    private static final String _CSS_COMMENT_END = "*/";
    private static final String _CSS_IMPORT_BEGIN = "@import url(";
    private static final String _CSS_IMPORT_END = ");";
    private String _baseDir;
    private String _docrootDirName;
    private long _elapsedTime;
    private String _fileName;
    private String _ltrContent;
    private String _rtlContent;
    private List<SassFragment> _sassFragments = new ArrayList<SassFragment>();

    public SassFile(String docrootDirName, String fileName) {
        this._docrootDirName = docrootDirName;
        this._fileName = fileName;
        int pos = fileName.lastIndexOf(47);
        this._baseDir = pos != -1 ? fileName.substring(0, pos + 1) : "";
    }

    @Override
    public Void call() throws Exception {
        long start = System.currentTimeMillis();
        File file = new File(this._docrootDirName, this._fileName);
        if (!file.exists()) {
            return null;
        }
        String content = FileUtil.read((File)file);
        int pos = 0;
        StringBundler sb = new StringBundler();
        while (true) {
            int commentX = content.indexOf(_CSS_COMMENT_BEGIN, pos);
            int commentY = content.indexOf(_CSS_COMMENT_END, commentX + _CSS_COMMENT_BEGIN.length());
            int importX = content.indexOf(_CSS_IMPORT_BEGIN, pos);
            int importY = content.indexOf(_CSS_IMPORT_END, importX + _CSS_IMPORT_BEGIN.length());
            if (importX == -1 || importY == -1) break;
            if (commentX != -1 && commentY != -1 && commentX < importX && commentY > importX) {
                sb.append(content.substring(pos, commentY += _CSS_COMMENT_END.length()));
                pos = commentY;
                continue;
            }
            sb.append(content.substring(pos, importX));
            String mediaQuery = "";
            int mediaQueryImportX = content.indexOf(41, importX + _CSS_IMPORT_BEGIN.length());
            int mediaQueryImportY = content.indexOf(59, importX + _CSS_IMPORT_BEGIN.length());
            String importFileName = null;
            if (importY != mediaQueryImportX) {
                mediaQuery = content.substring(mediaQueryImportX + 1, mediaQueryImportY);
                importFileName = content.substring(importX + _CSS_IMPORT_BEGIN.length(), mediaQueryImportX);
            } else {
                importFileName = content.substring(importX + _CSS_IMPORT_BEGIN.length(), importY);
            }
            if (!importFileName.isEmpty()) {
                if (importFileName.charAt(0) != '/') {
                    importFileName = this._fixRelativePath(this._baseDir.concat(importFileName));
                }
                SassFile importSassFile = SassExecutorUtil.execute(this._docrootDirName, importFileName);
                if (Validator.isNotNull((String)mediaQuery)) {
                    this._sassFragments.add(new SassFileWithMediaQuery(importSassFile, mediaQuery));
                } else {
                    this._sassFragments.add(importSassFile);
                }
            }
            if (Validator.isNotNull((String)mediaQuery)) {
                pos = mediaQueryImportY + 1;
                continue;
            }
            pos = importY + _CSS_IMPORT_END.length();
        }
        sb.append(content.substring(pos));
        this._addSassString(this._fileName, sb.toString());
        String rtlCustomFileName = SassToCssBuilder.getRtlCustomFileName(this._fileName);
        File rtlCustomFile = new File(this._docrootDirName, rtlCustomFileName);
        if (rtlCustomFile.exists()) {
            this._addSassString(rtlCustomFileName, FileUtil.read((File)rtlCustomFile));
        }
        this._elapsedTime = System.currentTimeMillis() - start;
        return null;
    }

    @Override
    public String getLtrContent() {
        if (this._ltrContent != null) {
            return this._ltrContent;
        }
        StringBundler sb = new StringBundler(this._sassFragments.size());
        for (SassFragment sassFragment : this._sassFragments) {
            String ltrContent = sassFragment.getLtrContent();
            if (sassFragment instanceof SassFile) {
                SassFile sassFile = (SassFile)sassFragment;
                String baseURL = _BASE_URL.concat(sassFile._baseDir);
                ltrContent = AggregateUtil.updateRelativeURLs(ltrContent, baseURL);
            }
            sb.append(ltrContent);
        }
        this._ltrContent = sb.toString();
        return this._ltrContent;
    }

    @Override
    public String getRtlContent() {
        if (this._rtlContent != null) {
            return this._rtlContent;
        }
        StringBundler sb = new StringBundler(this._sassFragments.size());
        for (SassFragment sassFragment : this._sassFragments) {
            String rtlContent = sassFragment.getRtlContent();
            if (sassFragment instanceof SassFile) {
                SassFile sassFile = (SassFile)sassFragment;
                String baseURL = _BASE_URL.concat(sassFile._baseDir);
                rtlContent = AggregateUtil.updateRelativeURLs(rtlContent, baseURL);
            }
            sb.append(rtlContent);
        }
        this._rtlContent = sb.toString();
        return this._rtlContent;
    }

    public String toString() {
        StringBundler sb = new StringBundler(5);
        sb.append("Parsed ");
        sb.append(this._fileName);
        sb.append(" in ");
        sb.append(this._elapsedTime);
        sb.append("ms");
        return sb.toString();
    }

    public void writeCacheFiles() throws Exception {
        File ltrCacheFile = new File(this._docrootDirName, SassToCssBuilder.getCacheFileName(this._fileName, ""));
        FileUtil.write((File)ltrCacheFile, (String)this.getLtrContent());
        File ltrFile = new File(this._docrootDirName, this._fileName);
        ltrCacheFile.setLastModified(ltrFile.lastModified());
        String rtlFileName = SassToCssBuilder.getRtlCustomFileName(this._fileName);
        if (RTLCSSUtil.isExcludedPath(this._fileName)) {
            return;
        }
        File rtlCacheFile = new File(this._docrootDirName, SassToCssBuilder.getCacheFileName(rtlFileName, ""));
        FileUtil.write((File)rtlCacheFile, (String)this.getRtlContent());
        rtlCacheFile.setLastModified(ltrFile.lastModified());
    }

    private void _addSassString(String fileName, String sassContent) throws Exception {
        if ((sassContent = sassContent.trim()).isEmpty()) {
            return;
        }
        this._sassFragments.add(new SassString(fileName, sassContent));
    }

    private String _fixRelativePath(String fileName) {
        String[] paths = StringUtil.split((String)fileName, (char)'/');
        StringBundler sb = new StringBundler(paths.length * 2);
        for (String path : paths) {
            if (path.isEmpty() || path.equals(".")) continue;
            if (path.equals("..") && sb.length() >= 2) {
                sb.setIndex(sb.index() - 2);
                continue;
            }
            sb.append("/");
            sb.append(path);
        }
        return sb.toString();
    }
}

