/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sass;

import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.scripting.ruby.RubyExecutor;
import com.liferay.portal.tools.sass.SassFile;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jruby.RubyArray;
import org.jruby.RubyException;
import org.jruby.embed.ScriptingContainer;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;

public class SassExecutorUtil {
    private static final String _TMP_DIR = SystemProperties.get((String)"java.io.tmpdir");
    private static final int _WAIT_MINTUES = 30;
    private static String _docrootDirName;
    private static Exception _exception;
    private static ExecutorService _executorService;
    private static Thread _mainThread;
    private static String _portalCommonDirName;
    private static ConcurrentMap<String, SassFile> _sassFileCache;
    private static ScriptingContainer _scriptingContainer;
    private static Object _scriptObject;

    public static SassFile execute(String docrootDirName, String fileName) {
        SassFile sassFile = (SassFile)_sassFileCache.get(fileName);
        if (sassFile != null) {
            return sassFile;
        }
        sassFile = new SassFile(docrootDirName, fileName);
        SassFile previousSassFile = _sassFileCache.putIfAbsent(fileName, sassFile);
        if (previousSassFile != null) {
            sassFile = previousSassFile;
        } else {
            _executorService.submit(sassFile);
        }
        return sassFile;
    }

    public static void init(String docrootDirName, String portalCommonDirName) throws IOException {
        _executorService = Executors.newFixedThreadPool(2, (ThreadFactory)new NamedThreadFactory("SassExecutor", 5, SassExecutorUtil.class.getClassLoader()));
        _mainThread = Thread.currentThread();
        _docrootDirName = docrootDirName;
        _portalCommonDirName = portalCommonDirName;
        RubyExecutor rubyExecutor = new RubyExecutor();
        rubyExecutor.setExecuteInSeparateThread(false);
        _scriptingContainer = rubyExecutor.getScriptingContainer();
        String rubyScript = StringUtil.read((ClassLoader)SassExecutorUtil.class.getClassLoader(), (String)"com/liferay/portal/servlet/filters/dynamiccss/dependencies/main.rb");
        _scriptObject = _scriptingContainer.runScriptlet(rubyScript);
    }

    public static String parse(String fileName, String content) {
        String filePath;
        String cssThemePath = filePath = _docrootDirName.concat(fileName);
        int pos = filePath.lastIndexOf("/css/");
        if (pos >= 0) {
            cssThemePath = filePath.substring(0, pos + 4);
        }
        try {
            return (String)_scriptingContainer.callMethod(_scriptObject, "process", new Object[]{content, _portalCommonDirName, filePath, cssThemePath, _TMP_DIR, false}, String.class);
        }
        catch (Exception e) {
            if (e instanceof RaiseException) {
                RaiseException raiseException = (RaiseException)((Object)e);
                RubyException rubyException = raiseException.getException();
                System.err.println(String.valueOf(rubyException.message.toJava(String.class)));
                IRubyObject iRubyObject = rubyException.getBacktrace();
                RubyArray rubyArray = (RubyArray)iRubyObject.toJava(RubyArray.class);
                for (int i = 0; i < rubyArray.size(); ++i) {
                    Object object = rubyArray.get(i);
                    System.err.println(String.valueOf(object));
                }
            } else {
                e.printStackTrace();
            }
            _exception = new Exception("Unable to parse " + fileName, e);
            _mainThread.interrupt();
            return content;
        }
    }

    public static void persist() throws Exception {
        _executorService.shutdown();
        try {
            if (!_executorService.awaitTermination(30L, TimeUnit.MINUTES)) {
                System.err.println("Abort processing Sass files after waiting 30 minutes");
            }
        }
        catch (InterruptedException ie) {
            if (_exception == null) {
                throw ie;
            }
            throw _exception;
        }
        for (SassFile sassFile : _sassFileCache.values()) {
            sassFile.writeCacheFiles();
            System.out.println(sassFile);
        }
    }

    static {
        _sassFileCache = new ConcurrentHashMap<String, SassFile>();
    }
}

