/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.samplesqlbuilder;

import com.liferay.portal.dao.db.MySQLDB;
import com.liferay.portal.freemarker.FreeMarkerUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.io.CharPipe;
import com.liferay.portal.kernel.io.OutputStreamWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncTeeWriter;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SortedProperties;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolDependencies;
import com.liferay.portal.tools.samplesqlbuilder.DataFactory;
import com.liferay.portal.tools.samplesqlbuilder.SampleMySQLDB;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SampleSQLBuilder {
    private static final int _PIPE_BUFFER_SIZE = 0x1000000;
    private static final int _WRITER_BUFFER_SIZE = 16384;
    private String[] _csvFileNames;
    private DataFactory _dataFactory;
    private String _dbType;
    private volatile Exception _freemarkerException;
    private int _optimizeBufferSize;
    private String _outputDir;
    private String _script;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ToolDependencies.wireBasic();
        Reader reader = null;
        try {
            SortedProperties properties = new SortedProperties();
            reader = new FileReader(args[0]);
            properties.load(reader);
            DataFactory dataFactory = new DataFactory((Properties)properties);
            new SampleSQLBuilder((Properties)properties, dataFactory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampleSQLBuilder(Properties properties, DataFactory dataFactory) throws Exception {
        this._dbType = properties.getProperty("sample.sql.db.type");
        this._csvFileNames = StringUtil.split((String)properties.getProperty("sample.sql.output.csv.file.names"));
        this._optimizeBufferSize = GetterUtil.getInteger((String)properties.getProperty("sample.sql.optimize.buffer.size"));
        this._outputDir = properties.getProperty("sample.sql.output.dir");
        this._script = properties.getProperty("sample.sql.script");
        this._dataFactory = dataFactory;
        Reader reader = this.generateSQL();
        File tempDir = new File(this._outputDir, "temp");
        tempDir.mkdirs();
        try {
            this.compressSQL(reader, tempDir);
            boolean outputMerge = GetterUtil.getBoolean((String)properties.getProperty("sample.sql.output.merge"));
            if (outputMerge) {
                File sqlFile = new File(this._outputDir, "sample-" + this._dbType + ".sql");
                FileUtil.delete((File)sqlFile);
                this.mergeSQL(tempDir, sqlFile);
            } else {
                File outputDir = new File(this._outputDir, "output");
                FileUtil.deltree((File)outputDir);
                if (!tempDir.renameTo(outputDir)) {
                    FileUtil.copyDirectory((File)tempDir, (File)outputDir);
                }
            }
        }
        finally {
            FileUtil.deltree((File)tempDir);
        }
        StringBundler sb = new StringBundler();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith("sample.sql")) continue;
            String value = properties.getProperty(key);
            sb.append(key);
            sb.append("=");
            sb.append(value);
            sb.append("\n");
        }
        FileUtil.write((File)new File(this._outputDir, "benchmarks-actual.properties"), (String)sb.toString());
    }

    protected void compressSQL(DB db, File directory, Map<String, Writer> insertSQLWriters, Map<String, StringBundler> sqls, String insertSQL) throws IOException {
        String tableName = insertSQL.substring(0, insertSQL.indexOf(32));
        int index = insertSQL.indexOf(" values ") + 8;
        StringBundler sb = sqls.get(tableName);
        if (sb == null || sb.index() == 0) {
            sb = new StringBundler();
            sqls.put(tableName, sb);
            sb.append("insert into ");
            sb.append(insertSQL.substring(0, index));
            sb.append("\n");
        } else {
            sb.append(",\n");
        }
        String values = insertSQL.substring(index, insertSQL.length() - 1);
        sb.append(values);
        if (sb.index() >= this._optimizeBufferSize) {
            sb.append(";\n");
            insertSQL = db.buildSQL(sb.toString());
            sb.setIndex(0);
            this.writeToInsertSQLFile(directory, tableName, insertSQLWriters, insertSQL);
        }
    }

    protected void compressSQL(Reader reader, File dir) throws Exception {
        DB db = DBFactoryUtil.getDB((String)this._dbType);
        if (db instanceof MySQLDB) {
            db = new SampleMySQLDB();
        }
        HashMap<String, Writer> insertSQLWriters = new HashMap<String, Writer>();
        HashMap<String, StringBundler> insertSQLs = new HashMap<String, StringBundler>();
        ArrayList<String> miscSQLs = new ArrayList<String>();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(reader);){
            String s = null;
            while (this._freemarkerException == null && (s = unsyncBufferedReader.readLine()) != null) {
                if ((s = s.trim()).length() <= 0) continue;
                if (s.startsWith("insert into ")) {
                    this.compressSQL(db, dir, insertSQLWriters, insertSQLs, s.substring(12));
                    continue;
                }
                miscSQLs.add(s);
            }
        }
        if (this._freemarkerException != null) {
            throw new Exception("Unable to process freemarker template ", this._freemarkerException);
        }
        for (Map.Entry entry : insertSQLs.entrySet()) {
            String tableName = (String)entry.getKey();
            StringBundler sb = (StringBundler)entry.getValue();
            if (sb.index() == 0) continue;
            String insertSQL = db.buildSQL(sb.toString());
            this.writeToInsertSQLFile(dir, tableName, insertSQLWriters, insertSQL);
            Writer insertSQLWriter = (Writer)insertSQLWriters.remove(tableName);
            Throwable throwable = null;
            try {
                insertSQLWriter.write(";\n");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (insertSQLWriter == null) continue;
                if (throwable != null) {
                    try {
                        insertSQLWriter.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                insertSQLWriter.close();
            }
        }
        var8_8 = null;
        try (FileWriter miscSQLWriter = new FileWriter(new File(dir, "misc.sql"));){
            for (String miscSQL : miscSQLs) {
                miscSQL = db.buildSQL(miscSQL);
                miscSQLWriter.write(miscSQL);
                miscSQLWriter.write("\n");
            }
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
    }

    protected Writer createFileWriter(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream);
        return this.createUnsyncBufferedWriter((Writer)writer);
    }

    protected Writer createUnsyncBufferedWriter(Writer writer) {
        return new UnsyncBufferedWriter(writer, 16384){

            public void flush() {
            }
        };
    }

    protected Reader generateSQL() {
        final CharPipe charPipe = new CharPipe(0x1000000);
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Writer sampleSQLWriter = null;
                Map<String, Object> context = null;
                try {
                    sampleSQLWriter = new UnsyncTeeWriter(SampleSQLBuilder.this.createUnsyncBufferedWriter(charPipe.getWriter()), SampleSQLBuilder.this.createFileWriter(new File(SampleSQLBuilder.this._outputDir, "sample.sql")));
                    context = SampleSQLBuilder.this.getContext();
                    FreeMarkerUtil.process(SampleSQLBuilder.this._script, context, sampleSQLWriter);
                }
                catch (Exception e) {
                    SampleSQLBuilder.this._freemarkerException = e;
                }
                finally {
                    for (String csvFileName : SampleSQLBuilder.this._csvFileNames) {
                        Writer csvWriter = (Writer)context.get(csvFileName + "CSVWriter");
                        try {
                            csvWriter.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                    if (sampleSQLWriter != null) {
                        try {
                            sampleSQLWriter.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                    charPipe.close();
                }
            }
        };
        thread.start();
        return charPipe.getReader();
    }

    protected Map<String, Object> getContext() throws Exception {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("dataFactory", this._dataFactory);
        for (String csvFileName : this._csvFileNames) {
            Writer csvWriter = this.createFileWriter(new File(this._outputDir, csvFileName + ".csv"));
            context.put(csvFileName + "CSVWriter", csvWriter);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getProperties(String[] args) throws Exception {
        Reader reader = null;
        try {
            SortedProperties properties = new SortedProperties();
            reader = new FileReader(args[0]);
            properties.load(reader);
            SortedProperties sortedProperties = properties;
            return sortedProperties;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    protected void mergeSQL(File inputDir, File outputSQLFile) throws IOException {
        FileOutputStream outputSQLFileOutputStream = new FileOutputStream(outputSQLFile);
        try (FileChannel outputFileChannel = outputSQLFileOutputStream.getChannel();){
            File miscSQLFile = null;
            for (File inputFile : inputDir.listFiles()) {
                String inputFileName = inputFile.getName();
                if (inputFileName.equals("misc.sql")) {
                    miscSQLFile = inputFile;
                    continue;
                }
                this.mergeSQL(inputFile, outputFileChannel);
            }
            if (miscSQLFile != null) {
                this.mergeSQL(miscSQLFile, outputFileChannel);
            }
        }
    }

    protected void mergeSQL(File inputFile, FileChannel outputFileChannel) throws IOException {
        FileInputStream inputFileInputStream = new FileInputStream(inputFile);
        try (FileChannel inputFileChannel = inputFileInputStream.getChannel();){
            inputFileChannel.transferTo(0L, inputFileChannel.size(), outputFileChannel);
        }
        inputFile.delete();
    }

    protected void writeToInsertSQLFile(File dir, String tableName, Map<String, Writer> insertSQLWriters, String insertSQL) throws IOException {
        Writer insertSQLWriter = insertSQLWriters.get(tableName);
        if (insertSQLWriter == null) {
            File file = new File(dir, tableName + ".sql");
            insertSQLWriter = this.createFileWriter(file);
            insertSQLWriters.put(tableName, insertSQLWriter);
        }
        insertSQLWriter.write(insertSQL);
    }
}

