/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.sourceformatter.XMLSourceProcessor;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.xml.SAXReaderImpl;
import java.io.File;
import java.util.Map;
import org.apache.tools.ant.DirectoryScanner;

public class XMLAttributesSorter {
    private static FileImpl _fileUtil = FileImpl.getInstance();
    private static SAXReaderImpl _saxReaderUtil = SAXReaderImpl.getInstance();

    public static void main(String[] args) {
        try {
            new XMLAttributesSorter(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XMLAttributesSorter(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String fileName = arguments.get("sort.xml.file.name");
        if (Validator.isNull((String)fileName) || fileName.startsWith("$")) {
            System.out.println("Specify file name");
            return;
        }
        String basedir = "./";
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        directoryScanner.setIncludes(new String[]{"**\\" + fileName});
        directoryScanner.scan();
        String[] fileNames = directoryScanner.getIncludedFiles();
        if (fileNames.length == 0) {
            System.out.println("No files found with name=" + fileName);
            return;
        }
        for (String fullFileName : fileNames) {
            File file = new File(basedir + fullFileName);
            fullFileName = StringUtil.replace((String)fullFileName, (String)"\\", (String)"/");
            String content = _fileUtil.read(file);
            String newContent = this.sortAttributes(content);
            if (content.equals(newContent = XMLSourceProcessor.formatXML(newContent))) continue;
            _fileUtil.write(file, newContent);
            System.out.println(fullFileName);
        }
    }

    protected String sortAttributes(String content) throws Exception {
        Document document = _saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        rootElement.sortAttributes(true);
        return document.formattedString();
    }
}

