/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.tools.ToolDependencies;
import com.liferay.util.xml.XMLFormatter;
import java.util.List;

public class WebXML23Converter {
    public static void main(String[] args) {
        ToolDependencies.wireBasic();
        if (args.length != 2) {
            throw new IllegalArgumentException();
        }
        new WebXML23Converter(args[0], args[1]);
    }

    public WebXML23Converter(String input, String output) {
        try {
            String webXML24 = FileUtil.read((String)input);
            Document document = SAXReaderUtil.read((String)webXML24);
            Element rootElement = document.getRootElement();
            double version = GetterUtil.getDouble((String)rootElement.attributeValue("version"));
            if (version != 2.4) {
                System.out.println("Do not convert web.xml because it is not Servlet 2.4");
                return;
            }
            System.out.println("Convert web.xml because it is Servlet 2.4");
            List filterMappingElements = rootElement.elements("filter-mapping");
            for (Element filterMappingElement : filterMappingElements) {
                List dispatcherElements = filterMappingElement.elements("dispatcher");
                for (Element dispatcherElement : dispatcherElements) {
                    dispatcherElement.detach();
                }
            }
            String webXML23 = document.formattedString();
            int x = webXML23.indexOf("<web-app");
            int y = webXML23.indexOf(">", x);
            webXML23 = webXML23.substring(0, x) + "<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" \"http://java.sun.com/dtd/web-app_2_3.dtd\"><web-app>" + webXML23.substring(y + 1);
            webXML23 = StringUtil.replace((String)webXML23, (String[])new String[]{"<jsp-config>", "</jsp-config>"}, (String[])new String[]{"", ""});
            webXML23 = XMLFormatter.toString((String)webXML23);
            FileUtil.write((String)output, (String)webXML23);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

