/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.tools.ToolDependencies;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tools.ant.DirectoryScanner;

public class TLDFormatter {
    public static void main(String[] args) {
        try {
            ToolDependencies.wireBasic();
            TLDFormatter._formatTLD();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void _formatTLD() throws Exception {
        String basedir = "./util-taglib/src/META-INF/";
        if (!FileUtil.exists((String)basedir)) {
            return;
        }
        ArrayList list = new ArrayList();
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(basedir);
        ds.setExcludes(new String[]{"**\\liferay-portlet-ext.tld"});
        ds.setIncludes(new String[]{"**\\*.tld"});
        ds.scan();
        list.addAll(ListUtil.fromArray((Object[])ds.getIncludedFiles()));
        String[] files = list.toArray(new String[list.size()]);
        for (int i = 0; i < files.length; ++i) {
            File file = new File(basedir + files[i]);
            String content = FileUtil.read((File)file);
            Document document = SAXReaderUtil.read((Reader)new UnsyncStringReader(StringUtil.replace((String)content, (String)"xml/ns/j2ee/web-jsptaglibrary_2_0.xsd", (String)"dtd/web-jsptaglibrary_1_2.dtd")));
            Element root = document.getRootElement();
            TLDFormatter._sortElements(root, "tag", "name");
            List tagEls = root.elements("tag");
            for (Element tagEl : tagEls) {
                TLDFormatter._sortElements(tagEl, "attribute", "name");
                Element dynamicAttributesEl = tagEl.element("dynamic-attributes");
                if (dynamicAttributesEl == null) continue;
                dynamicAttributesEl.detach();
                tagEl.add(dynamicAttributesEl);
            }
            String newContent = document.formattedString();
            int x = newContent.indexOf("<tlib-version");
            int y = newContent.indexOf("</taglib>");
            newContent = newContent.substring(x, y);
            x = content.indexOf("<tlib-version");
            y = content.indexOf("</taglib>");
            newContent = content.substring(0, x) + newContent + content.substring(y);
            if (content.equals(newContent)) continue;
            FileUtil.write((File)file, (String)newContent);
            System.out.println(file);
        }
    }

    private static void _sortElements(Element parentElement, String name, String sortBy) {
        TreeMap<String, Element> map = new TreeMap<String, Element>();
        List elements = parentElement.elements(name);
        for (Element element : elements) {
            map.put(element.elementText(sortBy), element);
            element.detach();
        }
        for (Map.Entry entry : map.entrySet()) {
            Element element = (Element)entry.getValue();
            parentElement.add(element);
        }
    }
}

