/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.FastDateFormatFactory;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.dynamiccss.RTLCSSUtil;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.sass.SassExecutorUtil;
import com.liferay.portal.util.FastDateFormatFactoryImpl;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.Portal;
import com.liferay.portal.util.PortalImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.DirectoryScanner;

public class SassToCssBuilder {
    public static File getCacheFile(String fileName) {
        return SassToCssBuilder.getCacheFile(fileName, "");
    }

    public static File getCacheFile(String fileName, String suffix) {
        return new File(SassToCssBuilder.getCacheFileName(fileName, suffix));
    }

    public static String getCacheFileName(String fileName, String suffix) {
        String cacheFileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
        int x = cacheFileName.lastIndexOf("/");
        int y = cacheFileName.lastIndexOf(".");
        return cacheFileName.substring(0, x + 1) + ".sass-cache/" + cacheFileName.substring(x + 1, y) + suffix + cacheFileName.substring(y);
    }

    public static String getRtlCustomFileName(String fileName) {
        int pos = fileName.lastIndexOf(".");
        return fileName.substring(0, pos) + "_rtl" + fileName.substring(pos);
    }

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        ArrayList<String> dirNames = new ArrayList<String>();
        String dirName = arguments.get("sass.dir");
        if (Validator.isNotNull((String)dirName)) {
            dirNames.add(dirName);
        } else {
            int i = 0;
            while (Validator.isNotNull((String)(dirName = arguments.get("sass.dir." + i)))) {
                dirNames.add(dirName);
                ++i;
            }
        }
        String docrootDirName = arguments.get("sass.docroot.dir");
        String portalCommonDirName = arguments.get("sass.portal.common.dir");
        new SassToCssBuilder(dirNames, docrootDirName, portalCommonDirName);
    }

    public static String parseStaticTokens(String content) {
        return StringUtil.replace((String)content, (String[])new String[]{"@model_hints_constants_text_display_height@", "@model_hints_constants_text_display_width@", "@model_hints_constants_textarea_display_height@", "@model_hints_constants_textarea_display_width@"}, (String[])new String[]{"15", "210", "100", "500"});
    }

    public SassToCssBuilder(List<String> dirNames, String docrootDirName, String portalCommonDirName) throws Exception {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        this._initUtil(classLoader);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String dirName : dirNames) {
            this._collectSassFiles(fileNames, dirName, docrootDirName);
        }
        SassExecutorUtil.init(docrootDirName, portalCommonDirName);
        for (String fileName : fileNames) {
            SassExecutorUtil.execute(docrootDirName, fileName);
        }
        SassExecutorUtil.persist();
    }

    private void _collectSassFiles(List<String> fileNames, String dirName, String docrootDirName) throws Exception {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        String basedir = docrootDirName.concat(dirName);
        directoryScanner.setBasedir(basedir);
        directoryScanner.setExcludes(new String[]{"**\\_diffs\\**", "**\\.sass-cache*\\**", "**\\.sass_cache_*\\**", "**\\_sass_cache_*\\**", "**\\_styled\\**", "**\\_unstyled\\**"});
        directoryScanner.setIncludes(new String[]{"**\\*.css"});
        directoryScanner.scan();
        String[] fileNamesArray = directoryScanner.getIncludedFiles();
        if (!this._isModified(basedir, fileNamesArray)) {
            return;
        }
        for (String fileName : fileNamesArray) {
            if (fileName.contains("_rtl")) continue;
            fileNames.add(this._normalizeFileName(dirName, fileName));
        }
    }

    private void _initUtil(ClassLoader classLoader) {
        FastDateFormatFactoryUtil fastDateFormatFactoryUtil = new FastDateFormatFactoryUtil();
        fastDateFormatFactoryUtil.setFastDateFormatFactory((FastDateFormatFactory)new FastDateFormatFactoryImpl());
        FileUtil fileUtil = new FileUtil();
        fileUtil.setFile((com.liferay.portal.kernel.util.File)new FileImpl());
        PortalClassLoaderUtil.setClassLoader((ClassLoader)classLoader);
        PortalUtil portalUtil = new PortalUtil();
        portalUtil.setPortal((Portal)new PortalImpl());
        PropsUtil.setProps((Props)new PropsImpl());
        RTLCSSUtil.init();
    }

    private boolean _isModified(String dirName, String[] fileNames) throws Exception {
        for (String fileName : fileNames) {
            if (fileName.contains("_rtl")) continue;
            fileName = this._normalizeFileName(dirName, fileName);
            File file = new File(fileName);
            File cacheFile = SassToCssBuilder.getCacheFile(fileName);
            if (file.lastModified() == cacheFile.lastModified()) continue;
            return true;
        }
        return false;
    }

    private String _normalizeFileName(String dirName, String fileName) {
        return StringUtil.replace((String)(dirName + "/" + fileName), (String[])new String[]{"\\", "//"}, (String[])new String[]{"/", "/"});
    }
}

