/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.OutputStreamWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.microsofttranslator.MicrosoftTranslatorException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.ToolDependencies;
import com.liferay.portlet.translator.model.Translation;
import com.liferay.portlet.translator.util.TranslationWebCacheItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class LangBuilder {
    public static final String AUTOMATIC_COPY = " (Automatic Copy)";
    public static final String AUTOMATIC_TRANSLATION = " (Automatic Translation)";
    private String _langDir;
    private String _langFile;
    private boolean _langTranslate;
    private Properties _portalLanguageProperties;
    private Properties _renameKeys;

    public static void main(String[] args) {
        ToolDependencies.wireBasic();
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        System.setProperty("line.separator", "\n");
        String langDir = arguments.get("lang.dir");
        String langFile = arguments.get("lang.file");
        boolean langPlugin = GetterUtil.getBoolean((String)arguments.get("lang.plugin"));
        boolean langTranslate = GetterUtil.getBoolean((String)arguments.get("lang.translate"), (boolean)true);
        try {
            new LangBuilder(langDir, langFile, langPlugin, langTranslate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LangBuilder(String langDir, String langFile, boolean langPlugin, boolean langTranslate) throws Exception {
        File renameKeysFile;
        this._langDir = langDir;
        this._langFile = langFile;
        this._langTranslate = langTranslate;
        if (langPlugin) {
            this._portalLanguageProperties = new Properties();
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("content/Language.properties");
            this._portalLanguageProperties.load(inputStream);
        }
        if ((renameKeysFile = new File(this._langDir + "/rename.properties")).exists()) {
            this._renameKeys = PropertiesUtil.load((String)FileUtil.read((File)renameKeysFile));
        }
        String content = this._orderProperties(new File(this._langDir + "/" + this._langFile + ".properties"));
        this._orderProperties(new File(this._langDir + "/" + this._langFile + "_en_AU.properties"));
        this._orderProperties(new File(this._langDir + "/" + this._langFile + "_en_GB.properties"));
        this._orderProperties(new File(this._langDir + "/" + this._langFile + "_fr_CA.properties"));
        this._createProperties(content, "ar");
        this._createProperties(content, "eu");
        this._createProperties(content, "bg");
        this._createProperties(content, "ca");
        this._createProperties(content, "zh_CN");
        this._createProperties(content, "zh_TW");
        this._createProperties(content, "hr");
        this._createProperties(content, "cs");
        this._createProperties(content, "da");
        this._createProperties(content, "nl");
        this._createProperties(content, "nl_BE", "nl");
        this._createProperties(content, "et");
        this._createProperties(content, "fi");
        this._createProperties(content, "fr");
        this._createProperties(content, "gl");
        this._createProperties(content, "de");
        this._createProperties(content, "el");
        this._createProperties(content, "iw");
        this._createProperties(content, "hi_IN");
        this._createProperties(content, "hu");
        this._createProperties(content, "in");
        this._createProperties(content, "it");
        this._createProperties(content, "ja");
        this._createProperties(content, "ko");
        this._createProperties(content, "lo");
        this._createProperties(content, "lt");
        this._createProperties(content, "nb");
        this._createProperties(content, "fa");
        this._createProperties(content, "pl");
        this._createProperties(content, "pt_BR");
        this._createProperties(content, "pt_PT", "pt_BR");
        this._createProperties(content, "ro");
        this._createProperties(content, "ru");
        this._createProperties(content, "sr_RS");
        this._createProperties(content, "sr_RS_latin");
        this._createProperties(content, "sk");
        this._createProperties(content, "sl");
        this._createProperties(content, "es");
        this._createProperties(content, "sv");
        this._createProperties(content, "tr");
        this._createProperties(content, "uk");
        this._createProperties(content, "vi");
    }

    private void _createProperties(String content, String languageId) throws IOException {
        this._createProperties(content, languageId, null);
    }

    private void _createProperties(String content, String languageId, String parentLanguageId) throws IOException {
        File parentPropertiesFile;
        File propertiesFile = new File(this._langDir + "/" + this._langFile + "_" + languageId + ".properties");
        Properties properties = new Properties();
        if (propertiesFile.exists()) {
            properties = PropertiesUtil.load((InputStream)new FileInputStream(propertiesFile), (String)"UTF-8");
        }
        Properties parentProperties = null;
        if (parentLanguageId != null && (parentPropertiesFile = new File(this._langDir + "/" + this._langFile + "_" + parentLanguageId + ".properties")).exists()) {
            parentProperties = new Properties();
            parentProperties = PropertiesUtil.load((InputStream)new FileInputStream(parentPropertiesFile), (String)"UTF-8");
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
             UnsyncBufferedWriter unsyncBufferedWriter = new UnsyncBufferedWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(propertiesFile), "UTF-8"));){
            boolean firstLine = true;
            int state = 0;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                int pos = (line = line.trim()).indexOf("=");
                if (pos != -1) {
                    String renameKey;
                    String key = line.substring(0, pos);
                    String value = line.substring(pos + 1);
                    if (state == 1 && !key.startsWith("lang.") || state == 2 && !key.startsWith("javax.portlet.") || state == 3 && !key.startsWith("category.") || state == 4 && !key.startsWith("model.resource.") || state == 5 && !key.startsWith("action.") || state == 7 && !key.startsWith("country.") || state == 8 && !key.startsWith("currency.") || state == 9 && !key.startsWith("language.") || state != 9 && key.startsWith("language.")) {
                        throw new RuntimeException("File " + languageId + " with state " + state + " has key " + key);
                    }
                    String translatedText = properties.getProperty(key);
                    if (translatedText == null && parentProperties != null) {
                        translatedText = parentProperties.getProperty(key);
                    }
                    if (translatedText == null && this._renameKeys != null && (renameKey = this._renameKeys.getProperty(key)) != null && (translatedText = properties.getProperty(key)) == null && parentProperties != null) {
                        translatedText = parentProperties.getProperty(key);
                    }
                    if (translatedText != null) {
                        if (translatedText.contains("Babel Fish") || translatedText.contains("Yahoo! - 999")) {
                            translatedText = "";
                        } else if (translatedText.endsWith(AUTOMATIC_COPY)) {
                            translatedText = value + AUTOMATIC_COPY;
                        }
                    }
                    if (translatedText == null || translatedText.equals("")) {
                        if (line.contains("{") || line.contains("<")) {
                            translatedText = value + AUTOMATIC_COPY;
                        } else if (line.contains("[")) {
                            pos = line.indexOf("[");
                            String baseKey = line.substring(0, pos);
                            String translatedBaseKey = properties.getProperty(baseKey);
                            translatedText = Validator.isNotNull((String)translatedBaseKey) ? translatedBaseKey : value + AUTOMATIC_COPY;
                        } else if (key.equals("lang.dir")) {
                            translatedText = "ltr";
                        } else if (key.equals("lang.line.begin")) {
                            translatedText = "left";
                        } else if (key.equals("lang.line.end")) {
                            translatedText = "right";
                        } else if (languageId.equals("el") && (key.equals("enabled") || key.equals("on") || key.equals("on-date"))) {
                            translatedText = "";
                        } else if (languageId.equals("es") && key.equals("am")) {
                            translatedText = "";
                        } else if (languageId.equals("fi") && (key.equals("on") || key.equals("the"))) {
                            translatedText = "";
                        } else if (languageId.equals("it") && key.equals("am")) {
                            translatedText = "";
                        } else if (languageId.equals("ja") && (key.equals("any") || key.equals("anytime") || key.equals("down") || key.equals("on") || key.equals("on-date") || key.equals("the"))) {
                            translatedText = "";
                        } else if (languageId.equals("ko") && key.equals("the")) {
                            translatedText = "";
                        } else {
                            translatedText = this._translate("en", languageId, key, value, 0);
                            if (Validator.isNull((String)translatedText)) {
                                translatedText = value + AUTOMATIC_COPY;
                            } else if (!key.startsWith("country.") && !key.startsWith("language.")) {
                                translatedText = translatedText + AUTOMATIC_TRANSLATION;
                            }
                        }
                    }
                    if (!Validator.isNotNull((String)translatedText)) continue;
                    if (translatedText.contains("Babel Fish") || translatedText.contains("Yahoo! - 999")) {
                        throw new IOException("IP was blocked because of over usage. Please use another IP.");
                    }
                    translatedText = this._fixTranslation(translatedText);
                    if (firstLine) {
                        firstLine = false;
                    } else {
                        unsyncBufferedWriter.newLine();
                    }
                    unsyncBufferedWriter.write(key + "=" + translatedText);
                    unsyncBufferedWriter.flush();
                    continue;
                }
                if (line.startsWith("## Language settings")) {
                    if (state == 1) {
                        throw new RuntimeException(languageId);
                    }
                    state = 1;
                } else if (line.startsWith("## Portlet descriptions and titles")) {
                    if (state == 2) {
                        throw new RuntimeException(languageId);
                    }
                    state = 2;
                } else if (line.startsWith("## Category titles")) {
                    if (state == 3) {
                        throw new RuntimeException(languageId);
                    }
                    state = 3;
                } else if (line.startsWith("## Model resources")) {
                    if (state == 4) {
                        throw new RuntimeException(languageId);
                    }
                    state = 4;
                } else if (line.startsWith("## Action names")) {
                    if (state == 5) {
                        throw new RuntimeException(languageId);
                    }
                    state = 5;
                } else if (line.startsWith("## Messages")) {
                    if (state == 6) {
                        throw new RuntimeException(languageId);
                    }
                    state = 6;
                } else if (line.startsWith("## Country")) {
                    if (state == 7) {
                        throw new RuntimeException(languageId);
                    }
                    state = 7;
                } else if (line.startsWith("## Currency")) {
                    if (state == 8) {
                        throw new RuntimeException(languageId);
                    }
                    state = 8;
                } else if (line.startsWith("## Language")) {
                    if (state == 9) {
                        throw new RuntimeException(languageId);
                    }
                    state = 9;
                }
                if (firstLine) {
                    firstLine = false;
                } else {
                    unsyncBufferedWriter.newLine();
                }
                unsyncBufferedWriter.write(line);
                unsyncBufferedWriter.flush();
            }
        }
    }

    private String _fixEnglishTranslation(String key, String value) {
        if (value.contains(" this ")) {
            if (!(value.contains(".") || value.contains("?") || value.contains(":") || key.equals("the-url-of-the-page-comparing-this-page-content-with-the-previous-version"))) {
                value = StringUtil.replace((String)value, (String)" this ", (String)" This ");
            }
        } else {
            value = StringUtil.replace((String)value, (String)" From ", (String)" from ");
        }
        return value;
    }

    private String _fixTranslation(String value) {
        value = StringUtil.replace((String)value.trim(), (String[])new String[]{"  ", "<b>", "</b>", "<i>", "</i>", " url ", "&#39;", "&#39 ;", "&quot;", "&quot ;", "ReCaptcha", "Captcha"}, (String[])new String[]{" ", "<strong>", "</strong>", "<em>", "</em>", " URL ", "'", "'", "\"", "\"", "reCAPTCHA", "CAPTCHA"});
        return value;
    }

    private String _orderProperties(File propertiesFile) throws IOException {
        if (!propertiesFile.exists()) {
            return null;
        }
        String content = FileUtil.read((File)propertiesFile);
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
             UnsyncBufferedWriter unsyncBufferedWriter = new UnsyncBufferedWriter((Writer)new FileWriter(propertiesFile));){
            TreeMap<String, String> messages = new TreeMap<String, String>((Comparator<String>)new NaturalOrderStringComparator(true, true));
            boolean begin = false;
            boolean firstLine = true;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                int pos = line.indexOf("=");
                if (pos != -1) {
                    String key = line.substring(0, pos);
                    String value = line.substring(pos + 1);
                    if (Validator.isNotNull((String)value)) {
                        String portalValue;
                        value = this._fixTranslation(line.substring(pos + 1));
                        value = this._fixEnglishTranslation(key, value);
                        if (this._portalLanguageProperties != null && value.equals(portalValue = String.valueOf(this._portalLanguageProperties.get(key)))) {
                            System.out.println("Duplicate key " + key);
                        }
                        messages.put(key, value);
                    }
                } else {
                    if (begin && line.equals("")) {
                        this._sortAndWrite(unsyncBufferedWriter, messages, firstLine);
                    }
                    if (line.equals("")) {
                        boolean bl = begin = !begin;
                    }
                    if (firstLine) {
                        firstLine = false;
                    } else {
                        unsyncBufferedWriter.newLine();
                    }
                    unsyncBufferedWriter.write(line);
                }
                unsyncBufferedWriter.flush();
            }
            if (!messages.isEmpty()) {
                this._sortAndWrite(unsyncBufferedWriter, messages, firstLine);
            }
        }
        return FileUtil.read((File)propertiesFile);
    }

    private void _sortAndWrite(UnsyncBufferedWriter unsyncBufferedWriter, Map<String, String> messages, boolean firstLine) throws IOException {
        boolean firstEntry = true;
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            if (!firstLine || !firstEntry) {
                unsyncBufferedWriter.newLine();
            }
            firstEntry = false;
            unsyncBufferedWriter.write(entry.getKey() + "=" + entry.getValue());
        }
        messages.clear();
    }

    private String _translate(String fromLanguageId, String toLanguageId, String key, String fromText, int limit) {
        if (toLanguageId.equals("ar") || toLanguageId.equals("eu") || toLanguageId.equals("bg") || toLanguageId.equals("ca") || toLanguageId.equals("hr") || toLanguageId.equals("cs") || toLanguageId.equals("da") || toLanguageId.equals("et") || toLanguageId.equals("fi") || toLanguageId.equals("gl") || toLanguageId.equals("de") || toLanguageId.equals("iw") || toLanguageId.equals("hi") || toLanguageId.equals("hu") || toLanguageId.equals("in") || toLanguageId.equals("lo") || toLanguageId.equals("lt") || toLanguageId.equals("nb") || toLanguageId.equals("fa") || toLanguageId.equals("pl") || toLanguageId.equals("ro") || toLanguageId.equals("ru") || toLanguageId.equals("sr_RS") || toLanguageId.equals("sr_RS_latin") || toLanguageId.equals("sk") || toLanguageId.equals("sl") || toLanguageId.equals("sv") || toLanguageId.equals("tr") || toLanguageId.equals("uk") || toLanguageId.equals("vi")) {
            return null;
        }
        if (!this._langTranslate) {
            return null;
        }
        if (limit == 3) {
            return null;
        }
        String toText = null;
        try {
            StringBundler sb = new StringBundler(8);
            sb.append("Translating ");
            sb.append(fromLanguageId);
            sb.append("_");
            sb.append(toLanguageId);
            sb.append(" ");
            sb.append(key);
            sb.append(" ");
            sb.append(fromText);
            System.out.println(sb.toString());
            TranslationWebCacheItem wci = new TranslationWebCacheItem(fromLanguageId, toLanguageId, fromText);
            Translation translation = (Translation)wci.convert("");
            toText = translation.getToText();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof MicrosoftTranslatorException) {
                System.out.println(cause.getClass().getName() + ": " + cause.getMessage());
            }
            e.printStackTrace();
        }
        if (toText == null) {
            return this._translate(fromLanguageId, toLanguageId, key, fromText, ++limit);
        }
        return toText;
    }
}

