/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.javadocformatter.SinceJava;
import com.liferay.portal.tools.servicebuilder.ServiceBuilder;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.xml.SAXReaderImpl;
import com.liferay.util.xml.DocUtil;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.AbstractBaseJavaEntity;
import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.Annotation;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import com.thoughtworks.qdox.model.annotation.AnnotationValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.DirectoryScanner;

public class JavadocFormatter {
    private static final double _LOWEST_SUPPORTED_JAVA_VERSION = 1.7;
    private static FileImpl _fileUtil = FileImpl.getInstance();
    private static SAXReaderImpl _saxReaderUtil = SAXReaderImpl.getInstance();
    private boolean _initializeMissingJavadocs;
    private String _inputDir;
    private Map<String, Tuple> _javadocxXmlTuples = new HashMap<String, Tuple>();
    private Properties _languageProperties;
    private File _languagePropertiesFile;
    private String _outputFilePrefix;
    private Pattern _paragraphTagPattern = Pattern.compile("(^.*?(?=\n\n|$)+|(?<=<p>\n).*?(?=\n</p>))", 32);
    private boolean _updateJavadocs;

    public static void main(String[] args) {
        try {
            new JavadocFormatter(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JavadocFormatter(String[] args) throws Exception {
        String update;
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String init = arguments.get("javadoc.init");
        if (Validator.isNotNull((String)init) && !init.startsWith("$")) {
            this._initializeMissingJavadocs = GetterUtil.getBoolean((String)init);
        }
        this._inputDir = GetterUtil.getString((String)arguments.get("javadoc.input.dir"));
        if (this._inputDir.startsWith("$")) {
            this._inputDir = "./";
        }
        if (!this._inputDir.endsWith("/")) {
            this._inputDir = this._inputDir + "/";
        }
        System.out.println("Input directory is " + this._inputDir);
        String[] limits = StringUtil.split((String)arguments.get("javadoc.limit"), (String)",");
        this._outputFilePrefix = GetterUtil.getString((String)arguments.get("javadoc.output.file.prefix"));
        if (this._outputFilePrefix.startsWith("$")) {
            this._outputFilePrefix = "javadocs";
        }
        if (Validator.isNotNull((String)(update = arguments.get("javadoc.update"))) && !update.startsWith("$")) {
            this._updateJavadocs = GetterUtil.getBoolean((String)update);
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(this._inputDir);
        directoryScanner.setExcludes(new String[]{"**\\classes\\**", "**\\portal-client\\**"});
        for (String limit : limits) {
            ArrayList<String> includes = new ArrayList<String>();
            if (Validator.isNotNull((String)limit) && !limit.startsWith("$")) {
                String[] limitArray;
                System.out.println("Limit on " + limit);
                for (String curLimit : limitArray = StringUtil.split((String)limit, (char)'/')) {
                    includes.add("**\\" + StringUtil.replace((String)curLimit, (String)".", (String)"\\") + "\\**\\*.java");
                    includes.add("**\\" + curLimit + ".java");
                }
            } else {
                includes.add("**\\*.java");
            }
            directoryScanner.setIncludes(includes.toArray(new String[includes.size()]));
            directoryScanner.scan();
            String[] fileNames = StringPool.EMPTY_ARRAY;
            fileNames = directoryScanner.getIncludedFiles();
            if (fileNames.length == 0 && Validator.isNotNull((String)limit) && !limit.startsWith("$")) {
                StringBundler sb = new StringBundler("Limit file not found: ");
                sb.append(limit);
                if (limit.contains(".")) {
                    sb.append(" Specify limit filename without package path or ");
                    sb.append("file type suffix.");
                }
                System.out.println(sb.toString());
            }
            this._languagePropertiesFile = new File("src/content/Language.properties");
            if (this._languagePropertiesFile.exists()) {
                this._languageProperties = new Properties();
                this._languageProperties.load(new FileInputStream(this._languagePropertiesFile.getAbsolutePath()));
            }
            for (String fileName : fileNames) {
                fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
                try {
                    this._format(fileName);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to format file " + fileName, e);
                }
            }
        }
        for (Map.Entry<String, Tuple> entry : this._javadocxXmlTuples.entrySet()) {
            String newJavadocsRuntimeXmlContent;
            Tuple tuple = entry.getValue();
            File javadocsXmlFile = (File)tuple.getObject(1);
            String oldJavadocsXmlContent = (String)tuple.getObject(2);
            Document javadocsXmlDocument = (Document)tuple.getObject(3);
            Element javadocsXmlRootElement = javadocsXmlDocument.getRootElement();
            javadocsXmlRootElement.sortElementsByChildElement("javadoc", "type");
            String newJavadocsXmlContent = javadocsXmlDocument.formattedString();
            if (!oldJavadocsXmlContent.equals(newJavadocsXmlContent)) {
                _fileUtil.write(javadocsXmlFile, newJavadocsXmlContent);
            }
            this._detachUnnecessaryTypes(javadocsXmlRootElement);
            File javadocsRuntimeXmlFile = new File(StringUtil.replaceLast((String)javadocsXmlFile.toString(), (String)"-all.xml", (String)"-rt.xml"));
            String oldJavadocsRuntimeXmlContent = "";
            if (javadocsRuntimeXmlFile.exists()) {
                oldJavadocsRuntimeXmlContent = _fileUtil.read(javadocsRuntimeXmlFile);
            }
            if (oldJavadocsRuntimeXmlContent.equals(newJavadocsRuntimeXmlContent = javadocsXmlDocument.compactString())) continue;
            _fileUtil.write(javadocsRuntimeXmlFile, newJavadocsRuntimeXmlContent);
        }
    }

    private List<Tuple> _addAncestorJavaClassTuples(JavaClass javaClass, List<Tuple> ancestorJavaClassTuples) {
        Type[] implementz;
        JavaClass superJavaClass = javaClass.getSuperJavaClass();
        if (superJavaClass != null) {
            ancestorJavaClassTuples.add(new Tuple(new Object[]{superJavaClass}));
            ancestorJavaClassTuples = this._addAncestorJavaClassTuples(superJavaClass, ancestorJavaClassTuples);
        }
        for (Type implement : implementz = javaClass.getImplements()) {
            Type[] actualTypeArguments = implement.getActualTypeArguments();
            JavaClass implementedInterface = implement.getJavaClass();
            if (actualTypeArguments == null) {
                ancestorJavaClassTuples.add(new Tuple(new Object[]{implementedInterface}));
            } else {
                ancestorJavaClassTuples.add(new Tuple(new Object[]{implementedInterface, actualTypeArguments}));
            }
            ancestorJavaClassTuples = this._addAncestorJavaClassTuples(implementedInterface, ancestorJavaClassTuples);
        }
        return ancestorJavaClassTuples;
    }

    private void _addClassCommentElement(Element rootElement, JavaClass javaClass) {
        String comment = this._getCDATA((AbstractJavaEntity)javaClass);
        if (comment.startsWith("Copyright (c)")) {
            comment = "";
        }
        if (Validator.isNull((String)comment)) {
            return;
        }
        Element commentElement = rootElement.addElement("comment");
        commentElement.addCDATA(comment);
    }

    private String _addDeprecatedTag(String comment, AbstractBaseJavaEntity abstractBaseJavaEntity, String indent) {
        if (comment == null) {
            return null;
        }
        if (!comment.contains("* @deprecated ") || ServiceBuilder.hasAnnotation(abstractBaseJavaEntity, "Deprecated")) {
            return comment;
        }
        return comment + indent + "@Deprecated\n";
    }

    private void _addDocletElements(Element parentElement, AbstractJavaEntity abstractJavaEntity, String name) throws Exception {
        DocletTag[] docletTags;
        for (DocletTag docletTag : docletTags = abstractJavaEntity.getTagsByName(name)) {
            String value = docletTag.getValue();
            value = this._trimMultilineText(value);
            value = StringUtil.replace((String)value, (String)" </", (String)"</");
            Element element = parentElement.addElement(name);
            element.addCDATA(value);
        }
        if (docletTags.length == 0 && name.equals("author")) {
            Element element = parentElement.addElement(name);
            element.addCDATA("Brian Wing Shun Chan");
        }
    }

    private String _addDocletTags(Element parentElement, String[] tagNames, String indent, boolean publicAccess) {
        ArrayList<String> allTagNames = new ArrayList<String>();
        ArrayList<String> customTagNames = new ArrayList<String>();
        ArrayList<String> requiredTagNames = new ArrayList<String>();
        for (String tagName : tagNames) {
            List elements = parentElement.elements(tagName);
            for (Element element : elements) {
                Element commentElement = element.element("comment");
                String comment = null;
                comment = commentElement != null ? commentElement.getText() : element.getText();
                if (tagName.equals("param") || tagName.equals("return") || tagName.equals("throws")) {
                    if (Validator.isNotNull((String)comment)) {
                        requiredTagNames.add(tagName);
                    } else if (tagName.equals("param")) {
                        if (GetterUtil.getBoolean((String)element.elementText("required"))) {
                            requiredTagNames.add(tagName);
                        }
                    } else if (tagName.equals("throws") && GetterUtil.getBoolean((String)element.elementText("required"))) {
                        requiredTagNames.add(tagName);
                    }
                } else {
                    customTagNames.add(tagName);
                }
                allTagNames.add(tagName);
            }
        }
        int maxTagNameLength = 0;
        ArrayList<String> maxTagNameLengthTags = new ArrayList<String>();
        if (this._initializeMissingJavadocs) {
            maxTagNameLengthTags.addAll(allTagNames);
        } else if (this._updateJavadocs) {
            if (!requiredTagNames.isEmpty()) {
                maxTagNameLengthTags.addAll(allTagNames);
            } else {
                maxTagNameLengthTags.addAll(customTagNames);
                maxTagNameLengthTags.addAll(requiredTagNames);
            }
        } else {
            maxTagNameLengthTags.addAll(customTagNames);
            maxTagNameLengthTags.addAll(requiredTagNames);
        }
        for (String name : maxTagNameLengthTags) {
            if (name.length() <= maxTagNameLength) continue;
            maxTagNameLength = name.length();
        }
        String tagNameIndent = this._getSpacesIndent(maxTagNameLength += 2);
        StringBundler sb = new StringBundler();
        for (String tagName : tagNames) {
            List elements = parentElement.elements(tagName);
            for (Element element : elements) {
                Element commentElement = element.element("comment");
                String comment = null;
                comment = commentElement != null ? commentElement.getText() : element.getText();
                String elementName = element.elementText("name");
                if (Validator.isNotNull((String)comment)) {
                    comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                    sb.append(comment);
                    continue;
                }
                if (this._initializeMissingJavadocs && publicAccess) {
                    comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                    sb.append(comment);
                    continue;
                }
                if (this._updateJavadocs && publicAccess) {
                    if (!(tagName.equals("param") || tagName.equals("return") || tagName.equals("throws"))) {
                        comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                        sb.append(comment);
                        continue;
                    }
                    if (requiredTagNames.isEmpty()) continue;
                    comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                    sb.append(comment);
                    continue;
                }
                if (!(tagName.equals("param") || tagName.equals("return") || tagName.equals("throws"))) {
                    comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                    sb.append(comment);
                    continue;
                }
                if (!tagName.equals("param") && !tagName.equals("return") && !tagName.equals("throws") || !GetterUtil.getBoolean((String)element.elementText("required"))) continue;
                elementName = element.elementText("name");
                comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                sb.append(comment);
            }
        }
        return sb.toString();
    }

    private void _addFieldElement(Element rootElement, JavaField javaField) throws Exception {
        Element fieldElement = rootElement.addElement("field");
        DocUtil.add((Element)fieldElement, (String)"name", (String)javaField.getName());
        String comment = this._getCDATA((AbstractJavaEntity)javaField);
        if (Validator.isNotNull((String)comment)) {
            Element commentElement = fieldElement.addElement("comment");
            commentElement.addCDATA(comment);
        }
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "version");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "see");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "since");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "deprecated");
    }

    private void _addMethodElement(Element rootElement, JavaMethod javaMethod) throws Exception {
        Element methodElement = rootElement.addElement("method");
        DocUtil.add((Element)methodElement, (String)"name", (String)javaMethod.getName());
        String comment = this._getCDATA((AbstractJavaEntity)javaMethod);
        if (Validator.isNotNull((String)comment)) {
            Element commentElement = methodElement.addElement("comment");
            commentElement.addCDATA(this._getCDATA((AbstractJavaEntity)javaMethod));
        }
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "version");
        this._addParamElements(methodElement, javaMethod);
        this._addReturnElement(methodElement, javaMethod);
        this._addThrowsElements(methodElement, javaMethod);
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "see");
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "since");
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "deprecated");
    }

    private void _addParamElement(Element methodElement, JavaParameter javaParameter, DocletTag[] paramDocletTags) {
        String name = javaParameter.getName();
        String value = null;
        for (DocletTag paramDocletTag : paramDocletTags) {
            String curValue = paramDocletTag.getValue();
            if (!curValue.equals(name) && !curValue.startsWith(name + " ")) continue;
            value = curValue;
            break;
        }
        Element paramElement = methodElement.addElement("param");
        DocUtil.add((Element)paramElement, (String)"name", (String)name);
        DocUtil.add((Element)paramElement, (String)"type", (String)this._getTypeValue(javaParameter));
        if (value != null) {
            value = value.substring(name.length());
            DocUtil.add((Element)paramElement, (String)"required", (boolean)true);
        }
        value = this._trimMultilineText(value);
        Element commentElement = paramElement.addElement("comment");
        commentElement.addCDATA(value);
    }

    private void _addParamElements(Element methodElement, JavaMethod javaMethod) {
        JavaParameter[] javaParameters = javaMethod.getParameters();
        DocletTag[] paramDocletTags = javaMethod.getTagsByName("param");
        for (JavaParameter javaParameter : javaParameters) {
            this._addParamElement(methodElement, javaParameter, paramDocletTags);
        }
    }

    private void _addReturnElement(Element methodElement, JavaMethod javaMethod) throws Exception {
        Type returns = javaMethod.getReturns();
        if (returns == null) {
            return;
        }
        String returnsValue = returns.getValue();
        if (returnsValue.equals("void")) {
            return;
        }
        Element returnElement = methodElement.addElement("return");
        DocletTag[] returnDocletTags = javaMethod.getTagsByName("return");
        String comment = "";
        if (returnDocletTags.length > 0) {
            DocletTag returnDocletTag = returnDocletTags[0];
            comment = GetterUtil.getString((String)returnDocletTag.getValue());
            DocUtil.add((Element)returnElement, (String)"required", (boolean)true);
        }
        comment = this._trimMultilineText(comment);
        Element commentElement = returnElement.addElement("comment");
        commentElement.addCDATA(comment);
    }

    private void _addThrowsElement(Element methodElement, Type exceptionType, DocletTag[] throwsDocletTags) {
        JavaClass javaClass = exceptionType.getJavaClass();
        String name = javaClass.getName();
        String value = null;
        for (DocletTag throwsDocletTag : throwsDocletTags) {
            String curValue = throwsDocletTag.getValue();
            if (!curValue.startsWith(name)) continue;
            value = curValue;
            break;
        }
        Element throwsElement = methodElement.addElement("throws");
        DocUtil.add((Element)throwsElement, (String)"name", (String)name);
        DocUtil.add((Element)throwsElement, (String)"type", (String)exceptionType.getValue());
        if (value != null) {
            value = value.substring(name.length());
            DocUtil.add((Element)throwsElement, (String)"required", (boolean)true);
        }
        value = this._trimMultilineText(value);
        Element commentElement = throwsElement.addElement("comment");
        commentElement.addCDATA(this._getCDATA(value));
    }

    private void _addThrowsElements(Element methodElement, JavaMethod javaMethod) {
        Type[] exceptionTypes = javaMethod.getExceptions();
        DocletTag[] throwsDocletTags = javaMethod.getTagsByName("throws");
        for (Type exceptionType : exceptionTypes) {
            this._addThrowsElement(methodElement, exceptionType, throwsDocletTags);
        }
    }

    private String _assembleTagComment(String tagName, String elementName, String comment, String indent, String tagNameIndent) {
        String indentAndTagName = indent + "@" + tagName;
        if (Validator.isNotNull((String)elementName)) {
            comment = Validator.isNotNull((String)comment) ? elementName + " " + comment : elementName;
            comment = this._wrapText(comment, indent + tagNameIndent);
            comment = indentAndTagName + comment.substring(indentAndTagName.length());
        } else if (Validator.isNotNull((String)comment)) {
            comment = this._wrapText(comment, indent + tagNameIndent);
            comment = indentAndTagName + comment.substring(indentAndTagName.length());
        } else {
            comment = indentAndTagName + "\n";
        }
        return comment;
    }

    private void _detachUnnecessaryTypes(Element rootElement) {
        List elements = rootElement.elements();
        for (Element element : elements) {
            String type = element.elementText("type");
            if (type.contains(".service.") && type.endsWith("ServiceImpl")) continue;
            element.detach();
        }
    }

    private void _format(String fileName) throws Exception {
        String originalContent = new String(Files.readAllBytes(Paths.get(this._inputDir + fileName, new String[0])), "UTF-8");
        if (fileName.endsWith("JavadocFormatter.java") || fileName.endsWith("SourceFormatter.java") || this._hasGeneratedTag(originalContent)) {
            return;
        }
        JavaClass javaClass = this._getJavaClass(fileName, (Reader)new UnsyncStringReader(originalContent));
        String javadocLessContent = this._removeJavadocFromJava(javaClass, originalContent);
        Document document = this._getJavadocDocument(javaClass);
        this._updateJavadocsXmlFile(fileName, javaClass, document);
        this._updateJavaFromDocument(fileName, originalContent, javadocLessContent, document);
    }

    private String _formatCDATA(String cdata) {
        cdata = cdata.replaceAll("(?s)\\s*<(p|[ou]l)>\\s*(.*?)\\s*</\\1>\\s*", "\n\n<$1>\n$2\n</$1>\n\n");
        cdata = cdata.replaceAll("(?s)\\s*<li>\\s*(.*?)\\s*</li>\\s*", "\n<li>\n$1\n</li>\n");
        cdata = StringUtil.replace((String)cdata, (String)"</li>\n\n<li>", (String)"</li>\n<li>");
        cdata = cdata.replaceAll("\n\\s+\n", "\n\n");
        cdata = cdata.replaceAll(" +", " ");
        Matcher matcher = this._paragraphTagPattern.matcher(cdata);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String trimmed = this._trimMultilineText(matcher.group());
            trimmed = StringUtil.replace((String)trimmed, (String)"$", (String)"\\$");
            matcher.appendReplacement(sb, trimmed);
        }
        matcher.appendTail(sb);
        cdata = sb.toString();
        return cdata.trim();
    }

    private String _formatInlines(String text) {
        text = text.replaceAll("[?@param id](?i)\\bid(s)?\\b", " ID$1");
        text = text.replaceAll("(?i)(?<!<code>|\\w)(null|false|true)(?!\\w)", "<code>$1</code>");
        return text;
    }

    private String _getCDATA(AbstractJavaEntity abstractJavaEntity) {
        return this._getCDATA(abstractJavaEntity.getComment());
    }

    private String _getCDATA(String cdata) {
        StringBundler sb = new StringBundler();
        if (cdata == null || cdata.isEmpty()) {
            return "";
        }
        int cdataBeginIndex = 0;
        while (!cdata.isEmpty()) {
            boolean startsWithTableTag;
            boolean hasTableTag;
            int preTagIndex = cdata.indexOf("<pre>");
            int tableTagIndex = cdata.indexOf("<table>");
            boolean hasPreTag = preTagIndex != -1;
            boolean bl = hasTableTag = tableTagIndex != -1;
            if (!hasPreTag && !hasTableTag) {
                sb.append(this._formatCDATA(cdata));
                break;
            }
            boolean startsWithPreTag = preTagIndex == 0;
            boolean bl2 = startsWithTableTag = tableTagIndex == 0;
            if (startsWithPreTag || startsWithTableTag) {
                sb.append("\n");
                String tagName = null;
                tagName = preTagIndex == 0 ? "pre" : "table";
                String startTag = "<" + tagName + ">";
                String endTag = "</" + tagName + ">";
                int startTagLength = startTag.length();
                int endTagLength = endTag.length();
                int endTagIndex = cdata.indexOf(endTag, startTagLength - 1);
                sb.append(cdata.substring(0, endTagIndex + endTagLength));
                sb.append("\n");
                cdataBeginIndex = endTagIndex + endTagLength;
            } else {
                int startTagIndex = 0;
                startTagIndex = hasPreTag && hasTableTag ? (preTagIndex < tableTagIndex ? preTagIndex : tableTagIndex) : (hasPreTag && !hasTableTag ? preTagIndex : tableTagIndex);
                sb.append(this._formatCDATA(cdata.substring(0, startTagIndex)));
                cdataBeginIndex = startTagIndex;
            }
            cdata = cdata.substring(cdataBeginIndex);
        }
        cdata = sb.toString();
        return cdata.trim();
    }

    private String _getClassName(String fileName) {
        int pos = fileName.indexOf("src/");
        if (pos == -1 && (pos = fileName.indexOf("test/integration/")) != -1) {
            pos = fileName.indexOf("integration/", pos);
        }
        if (pos == -1 && (pos = fileName.indexOf("test/unit/")) != -1) {
            pos = fileName.indexOf("unit/", pos);
        }
        if (pos == -1) {
            pos = fileName.indexOf("test/");
        }
        if (pos == -1) {
            pos = fileName.indexOf("service/");
        }
        if (pos == -1) {
            throw new RuntimeException(fileName);
        }
        pos = fileName.indexOf("/", pos);
        String srcFile = fileName.substring(pos + 1, fileName.length());
        return StringUtil.replace((String)srcFile.substring(0, srcFile.length() - 5), (String)"/", (String)".");
    }

    private String _getFieldKey(Element fieldElement) {
        return fieldElement.elementText("name");
    }

    private String _getFieldKey(JavaField javaField) {
        return javaField.getName();
    }

    private String _getIndent(String[] lines, AbstractBaseJavaEntity abstractBaseJavaEntity) {
        String line = lines[abstractBaseJavaEntity.getLineNumber() - 1];
        String indent = "";
        for (char c : line.toCharArray()) {
            if (!Character.isWhitespace(c)) break;
            indent = indent + c;
        }
        return indent;
    }

    private int _getIndentLength(String indent) {
        int indentLength = 0;
        for (char c : indent.toCharArray()) {
            if (c == '\t') {
                indentLength += 4;
                continue;
            }
            ++indentLength;
        }
        return indentLength;
    }

    private JavaClass _getJavaClass(String fileName, Reader reader) throws Exception {
        String className = this._getClassName(fileName);
        JavaDocBuilder javadocBuilder = new JavaDocBuilder();
        if (reader == null) {
            File file = new File(fileName);
            if (!file.exists()) {
                return null;
            }
            javadocBuilder.addSource(file);
        } else {
            javadocBuilder.addSource(reader);
        }
        return javadocBuilder.getClassByName(className);
    }

    private String _getJavaClassComment(Element rootElement, JavaClass javaClass) {
        String docletTags;
        StringBundler sb = new StringBundler();
        String indent = "";
        sb.append("/**\n");
        String comment = rootElement.elementText("comment");
        if (Validator.isNotNull((String)comment)) {
            sb.append(this._wrapText(comment, indent + " * "));
        }
        if (Validator.isNotNull((String)(docletTags = this._addDocletTags(rootElement, new String[]{"author", "version", "see", "since", "serial", "deprecated"}, indent + " * ", this._hasPublicModifier((AbstractJavaEntity)javaClass))))) {
            if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
                sb.append(" *\n");
            }
            sb.append(docletTags);
        }
        sb.append(" */\n");
        return sb.toString();
    }

    private int _getJavaClassLineNumber(JavaClass javaClass) {
        int lineNumber = javaClass.getLineNumber();
        Annotation[] annotations = javaClass.getAnnotations();
        if (annotations.length == 0) {
            return lineNumber;
        }
        for (Annotation annotation : annotations) {
            int annotationLineNumber = annotation.getLineNumber();
            Map propertyMap = annotation.getPropertyMap();
            if (propertyMap.isEmpty()) {
                --annotationLineNumber;
            }
            if (annotationLineNumber >= lineNumber) continue;
            lineNumber = annotationLineNumber;
        }
        return lineNumber;
    }

    private Document _getJavadocDocument(JavaClass javaClass) throws Exception {
        JavaField[] javaFields;
        JavaMethod[] javaMethods;
        Element rootElement = _saxReaderUtil.createElement("javadoc");
        Document document = _saxReaderUtil.createDocument(rootElement);
        DocUtil.add((Element)rootElement, (String)"name", (String)javaClass.getName());
        DocUtil.add((Element)rootElement, (String)"type", (String)javaClass.getFullyQualifiedName());
        this._addClassCommentElement(rootElement, javaClass);
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "author");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "version");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "see");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "since");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "serial");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "deprecated");
        for (JavaMethod javaMethod : javaMethods = javaClass.getMethods()) {
            this._addMethodElement(rootElement, javaMethod);
        }
        for (JavaField javaField : javaFields = javaClass.getFields()) {
            this._addFieldElement(rootElement, javaField);
        }
        return document;
    }

    private Tuple _getJavadocsXmlTuple(String fileName) throws Exception {
        File file = new File(this._inputDir + fileName);
        String absolutePath = file.getAbsolutePath();
        absolutePath = StringUtil.replace((String)absolutePath, (String)"\\", (String)"/");
        absolutePath = StringUtil.replace((String)absolutePath, (String)"/./", (String)"/");
        int pos = absolutePath.indexOf("/portal-impl/src/");
        String srcDirName = null;
        if (pos != -1) {
            srcDirName = absolutePath.substring(0, pos + 17);
        }
        if (srcDirName == null) {
            pos = absolutePath.indexOf("/portal-kernel/src/");
            if (pos == -1) {
                pos = absolutePath.indexOf("/portal-service/src/");
            }
            if (pos == -1) {
                pos = absolutePath.indexOf("/util-bridges/src/");
            }
            if (pos == -1) {
                pos = absolutePath.indexOf("/util-java/src/");
            }
            if (pos == -1) {
                pos = absolutePath.indexOf("/util-taglib/src/");
            }
            if (pos != -1) {
                srcDirName = absolutePath.substring(0, pos) + "/portal-impl/src/";
            }
        }
        if (srcDirName == null && (pos = absolutePath.indexOf("/WEB-INF/src/")) != -1) {
            srcDirName = absolutePath.substring(0, pos + 13);
        }
        if (srcDirName == null) {
            return null;
        }
        Tuple tuple = this._javadocxXmlTuples.get(srcDirName);
        if (tuple != null) {
            return tuple;
        }
        File javadocsXmlFile = new File(srcDirName, "META-INF/" + this._outputFilePrefix + "-all.xml");
        if (!javadocsXmlFile.exists()) {
            _fileUtil.write(javadocsXmlFile, "<?xml version=\"1.0\"?>\n\n<javadocs>\n</javadocs>");
        }
        String javadocsXmlContent = _fileUtil.read(javadocsXmlFile);
        Document javadocsXmlDocument = _saxReaderUtil.read(javadocsXmlContent);
        tuple = new Tuple(new Object[]{srcDirName, javadocsXmlFile, javadocsXmlContent, javadocsXmlDocument});
        this._javadocxXmlTuples.put(srcDirName, tuple);
        return tuple;
    }

    private String _getJavaFieldComment(Map<String, Element> fieldElementsMap, JavaField javaField, String indent) {
        String docletTags;
        String fieldKey = this._getFieldKey(javaField);
        Element fieldElement = fieldElementsMap.get(fieldKey);
        if (fieldElement == null) {
            return null;
        }
        StringBundler sb = new StringBundler();
        sb.append(indent);
        sb.append("/**\n");
        String comment = fieldElement.elementText("comment");
        if (Validator.isNotNull((String)comment)) {
            sb.append(this._wrapText(comment, indent + " * "));
        }
        if (Validator.isNotNull((String)(docletTags = this._addDocletTags(fieldElement, new String[]{"version", "see", "since", "deprecated"}, indent + " * ", this._hasPublicModifier((AbstractJavaEntity)javaField))))) {
            if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
                sb.append(indent);
                sb.append(" *\n");
            }
            sb.append(docletTags);
        }
        sb.append(indent);
        sb.append(" */\n");
        if (!this._initializeMissingJavadocs && Validator.isNull((String)comment) && Validator.isNull((String)docletTags)) {
            return null;
        }
        if (!this._hasPublicModifier((AbstractJavaEntity)javaField) && Validator.isNull((String)comment) && Validator.isNull((String)docletTags)) {
            return null;
        }
        return sb.toString();
    }

    private String _getJavaMethodComment(Map<String, Element> methodElementsMap, JavaMethod javaMethod, String indent) {
        String docletTags;
        String methodKey = this._getMethodKey(javaMethod);
        Element methodElement = methodElementsMap.get(methodKey);
        if (methodElement == null) {
            return null;
        }
        StringBundler sb = new StringBundler();
        sb.append(indent);
        sb.append("/**\n");
        String comment = methodElement.elementText("comment");
        if (Validator.isNotNull((String)comment)) {
            sb.append(this._wrapText(comment, indent + " * "));
        }
        if (Validator.isNotNull((String)(docletTags = this._addDocletTags(methodElement, new String[]{"version", "param", "return", "throws", "see", "since", "deprecated"}, indent + " * ", this._hasPublicModifier((AbstractJavaEntity)javaMethod))))) {
            if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
                sb.append(indent);
                sb.append(" *\n");
            }
            sb.append(docletTags);
        }
        sb.append(indent);
        sb.append(" */\n");
        if (!this._initializeMissingJavadocs && Validator.isNull((String)comment) && Validator.isNull((String)docletTags)) {
            return null;
        }
        if (!this._hasPublicModifier((AbstractJavaEntity)javaMethod) && Validator.isNull((String)comment) && Validator.isNull((String)docletTags)) {
            return null;
        }
        return sb.toString();
    }

    private String _getMethodKey(Element methodElement) {
        StringBundler sb = new StringBundler();
        sb.append(methodElement.elementText("name"));
        sb.append("(");
        List paramElements = methodElement.elements("param");
        for (Element paramElement : paramElements) {
            sb.append(paramElement.elementText("name"));
            sb.append("|");
            sb.append(paramElement.elementText("type"));
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private String _getMethodKey(JavaMethod javaMethod) {
        JavaParameter[] javaParameters;
        StringBundler sb = new StringBundler();
        sb.append(javaMethod.getName());
        sb.append("(");
        for (JavaParameter javaParameter : javaParameters = javaMethod.getParameters()) {
            sb.append(javaParameter.getName());
            sb.append("|");
            sb.append(this._getTypeValue(javaParameter));
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private String _getSpacesIndent(int length) {
        String indent = "";
        for (int i = 0; i < length; ++i) {
            indent = indent + " ";
        }
        return indent;
    }

    private String _getTypeValue(JavaParameter javaParameter) {
        Type type = javaParameter.getType();
        String typeValue = type.getValue();
        if (type.isArray()) {
            typeValue = typeValue + "[]";
        }
        return typeValue;
    }

    private boolean _hasGeneratedTag(String content) {
        return content.contains("* @generated") || content.contains("$ANTLR");
    }

    private boolean _hasPublicModifier(AbstractJavaEntity abstractJavaEntity) {
        String[] modifiers = abstractJavaEntity.getModifiers();
        if (modifiers == null) {
            return false;
        }
        for (String modifier : modifiers) {
            if (!modifier.equals("public")) continue;
            return true;
        }
        return false;
    }

    private boolean _isOverrideMethod(JavaClass javaClass, JavaMethod javaMethod, Collection<Tuple> ancestorJavaClassTuples) {
        if (javaMethod.isConstructor() || javaMethod.isPrivate() || javaMethod.isStatic() || this._overridesHigherJavaAPIVersion(javaMethod)) {
            return false;
        }
        String methodName = javaMethod.getName();
        JavaParameter[] javaParameters = javaMethod.getParameters();
        Type[] types = new Type[javaParameters.length];
        for (int i = 0; i < javaParameters.length; ++i) {
            types[i] = javaParameters[i].getType();
        }
        for (Tuple ancestorJavaClassTuple : ancestorJavaClassTuples) {
            JavaClass ancestorJavaClass = (JavaClass)ancestorJavaClassTuple.getObject(0);
            JavaMethod ancestorJavaMethod = null;
            if (ancestorJavaClassTuple.getSize() > 1) {
                Type[] ancestorActualTypeArguments = (Type[])ancestorJavaClassTuple.getObject(1);
                Type[] genericTypes = new Type[types.length];
                for (int i = 0; i < types.length; ++i) {
                    Type type = types[i];
                    String typeValue = type.getValue();
                    boolean useGenericType = false;
                    for (int j = 0; j < ancestorActualTypeArguments.length; ++j) {
                        if (!typeValue.equals(ancestorActualTypeArguments[j].getValue())) continue;
                        useGenericType = true;
                        break;
                    }
                    genericTypes[i] = useGenericType ? new Type("java.lang.Object") : type;
                }
                ancestorJavaMethod = ancestorJavaClass.getMethodBySignature(methodName, genericTypes);
            } else {
                ancestorJavaMethod = ancestorJavaClass.getMethodBySignature(methodName, types);
            }
            if (ancestorJavaMethod == null) continue;
            boolean samePackage = false;
            JavaPackage ancestorJavaPackage = ancestorJavaClass.getPackage();
            if (ancestorJavaPackage != null) {
                samePackage = ancestorJavaPackage.equals((Object)javaClass.getPackage());
            }
            if (samePackage) {
                return !ancestorJavaMethod.isPrivate();
            }
            return ancestorJavaMethod.isProtected() || ancestorJavaMethod.isPublic();
        }
        return false;
    }

    private boolean _overridesHigherJavaAPIVersion(JavaMethod javaMethod) {
        Annotation[] annotations = javaMethod.getAnnotations();
        if (annotations == null) {
            return false;
        }
        for (Annotation annotation : annotations) {
            AnnotationValue annotationValue;
            double sinceJava;
            Type type = annotation.getType();
            JavaClass javaClass = type.getJavaClass();
            String javaClassName = javaClass.getFullyQualifiedName();
            if (!javaClassName.equals(SinceJava.class.getName()) || !((sinceJava = GetterUtil.getDouble((Object)(annotationValue = annotation.getProperty("value")).getParameterValue())) > 1.7)) continue;
            return true;
        }
        return false;
    }

    private String _removeJavadocFromJava(JavaClass javaClass, String content) {
        JavaField[] javaFields;
        JavaMethod[] javaMethods;
        HashSet<Integer> lineNumbers = new HashSet<Integer>();
        lineNumbers.add(this._getJavaClassLineNumber(javaClass));
        for (JavaMethod javaMethod : javaMethods = javaClass.getMethods()) {
            lineNumbers.add(javaMethod.getLineNumber());
        }
        for (JavaField javaField : javaFields = javaClass.getFields()) {
            lineNumbers.add(javaField.getLineNumber());
        }
        String[] lines = StringUtil.splitLines((String)content);
        Iterator i$ = lineNumbers.iterator();
        block2: while (i$.hasNext()) {
            int pos;
            String line;
            int lineNumber = (Integer)i$.next();
            if (lineNumber == 0 || (line = lines[pos = lineNumber - 2]) == null || !(line = line.trim()).endsWith("*/")) continue;
            while (true) {
                lines[pos] = null;
                if (line.startsWith("/**") || line.startsWith("/*")) continue block2;
                line = lines[--pos].trim();
            }
        }
        StringBundler sb = new StringBundler(content.length());
        for (String line : lines) {
            if (line == null) continue;
            sb.append(line);
            sb.append("\n");
        }
        content = sb.toString();
        return content.trim();
    }

    private String _trimMultilineText(String text) {
        String[] lines = StringUtil.splitLines((String)text);
        StringBundler sb = new StringBundler();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            sb.append(line);
            if (line.endsWith("(") || i >= lines.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    private void _updateJavadocsXmlFile(String fileName, JavaClass javaClass, Document javaClassDocument) throws Exception {
        String javaClassFullyQualifiedName = javaClass.getFullyQualifiedName();
        Tuple javadocsXmlTuple = this._getJavadocsXmlTuple(fileName);
        if (javadocsXmlTuple == null) {
            return;
        }
        Document javadocsXmlDocument = (Document)javadocsXmlTuple.getObject(3);
        Element javadocsXmlRootElement = javadocsXmlDocument.getRootElement();
        List javadocElements = javadocsXmlRootElement.elements("javadoc");
        for (Element javadocElement : javadocElements) {
            String type = javadocElement.elementText("type");
            if (!type.equals(javaClassFullyQualifiedName)) continue;
            Element javaClassRootElement = javaClassDocument.getRootElement();
            if (Validator.equals((Object)javadocElement.formattedString(), (Object)javaClassRootElement.formattedString())) {
                return;
            }
            javadocElement.detach();
            break;
        }
        javadocsXmlRootElement.add(javaClassDocument.getRootElement());
    }

    private void _updateJavaFromDocument(String fileName, String originalContent, String javadocLessContent, Document document) throws Exception {
        JavaField[] javaFields;
        JavaMethod[] javaMethods;
        String[] lines = StringUtil.splitLines((String)javadocLessContent);
        JavaClass javaClass = this._getJavaClass(fileName, (Reader)new UnsyncStringReader(javadocLessContent));
        this._updateLanguageProperties(document, javaClass.getName());
        List<Tuple> ancestorJavaClassTuples = new ArrayList<Tuple>();
        ancestorJavaClassTuples = this._addAncestorJavaClassTuples(javaClass, ancestorJavaClassTuples);
        Element rootElement = document.getRootElement();
        TreeMap<Integer, String> commentsMap = new TreeMap<Integer, String>();
        String javaClassComment = this._getJavaClassComment(rootElement, javaClass);
        javaClassComment = this._addDeprecatedTag(javaClassComment, (AbstractBaseJavaEntity)javaClass, "");
        commentsMap.put(this._getJavaClassLineNumber(javaClass), javaClassComment);
        HashMap<String, Element> methodElementsMap = new HashMap<String, Element>();
        List methodElements = rootElement.elements("method");
        for (Element methodElement : methodElements) {
            String methodKey = this._getMethodKey(methodElement);
            methodElementsMap.put(methodKey, methodElement);
        }
        for (JavaMethod javaMethod : javaMethods = javaClass.getMethods()) {
            if (commentsMap.containsKey(javaMethod.getLineNumber())) continue;
            String indent = this._getIndent(lines, (AbstractBaseJavaEntity)javaMethod);
            String javaMethodComment = this._getJavaMethodComment(methodElementsMap, javaMethod, indent);
            javaMethodComment = this._addDeprecatedTag(javaMethodComment, (AbstractBaseJavaEntity)javaMethod, indent);
            if (!ServiceBuilder.hasAnnotation((AbstractBaseJavaEntity)javaMethod, "Override") && this._isOverrideMethod(javaClass, javaMethod, ancestorJavaClassTuples)) {
                String overrideLine = indent + "@Override\n";
                javaMethodComment = Validator.isNotNull((String)javaMethodComment) ? javaMethodComment + overrideLine : overrideLine;
            }
            commentsMap.put(javaMethod.getLineNumber(), javaMethodComment);
        }
        HashMap<String, Element> fieldElementsMap = new HashMap<String, Element>();
        List fieldElements = rootElement.elements("field");
        for (Element fieldElement : fieldElements) {
            String fieldKey = this._getFieldKey(fieldElement);
            fieldElementsMap.put(fieldKey, fieldElement);
        }
        for (JavaField javaField : javaFields = javaClass.getFields()) {
            if (commentsMap.containsKey(javaField.getLineNumber())) continue;
            String indent = this._getIndent(lines, (AbstractBaseJavaEntity)javaField);
            String javaFieldComment = this._getJavaFieldComment(fieldElementsMap, javaField, indent);
            javaFieldComment = this._addDeprecatedTag(javaFieldComment, (AbstractBaseJavaEntity)javaField, indent);
            commentsMap.put(javaField.getLineNumber(), javaFieldComment);
        }
        StringBundler sb = new StringBundler(javadocLessContent.length());
        for (int lineNumber = 1; lineNumber <= lines.length; ++lineNumber) {
            String line = lines[lineNumber - 1];
            String comments = (String)commentsMap.get(lineNumber);
            if (comments != null) {
                sb.append(comments);
            }
            sb.append(line);
            sb.append("\n");
        }
        String formattedContent = sb.toString();
        if (!originalContent.equals(formattedContent = formattedContent.trim())) {
            File file = new File(this._inputDir + fileName);
            _fileUtil.write(file, formattedContent.getBytes("UTF-8"));
            System.out.println("Writing " + file);
        }
    }

    private void _updateLanguageProperties(Document document, String className) throws IOException {
        if (this._languageProperties == null) {
            return;
        }
        int index = className.indexOf("ServiceImpl");
        if (index <= 0) {
            return;
        }
        StringBundler sb = new StringBundler();
        sb.append(Character.toLowerCase(className.charAt(0)));
        for (int i = 1; i < index; ++i) {
            char c = className.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i + 1 < index && Character.isLowerCase(className.charAt(i + 1))) {
                    sb.append('-');
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        sb.append("-service-help");
        String key = sb.toString();
        String value = this._languageProperties.getProperty(key);
        if (value == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        String comment = rootElement.elementText("comment");
        if (comment == null || value.equals(comment)) {
            return;
        }
        index = comment.indexOf("\n\n");
        value = index != -1 ? comment.substring(0, index) : comment;
        this._updateLanguageProperties(key, value);
    }

    private void _updateLanguageProperties(String key, String value) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new FileReader(this._languagePropertiesFile));){
            boolean begin = false;
            boolean firstLine = true;
            String linePrefix = key + "=";
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.equals("")) {
                    boolean bl = begin = !begin;
                }
                if (firstLine) {
                    firstLine = false;
                } else {
                    sb.append("\n");
                }
                if (line.startsWith(linePrefix)) {
                    sb.append(linePrefix);
                    sb.append(value);
                    continue;
                }
                sb.append(line);
            }
        }
        var5_5 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this._languagePropertiesFile, false), "UTF-8");){
            sb.writeTo((Writer)writer);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        System.out.println("Updating " + this._languagePropertiesFile + " key " + key);
    }

    private String _wrapText(String text, int indentLength, String exclude) {
        StringBuffer sb = new StringBuffer();
        StringBundler regexSB = new StringBundler("(?<=^|</");
        regexSB.append(exclude);
        regexSB.append(">).+?(?=$|<");
        regexSB.append(exclude);
        regexSB.append(">)");
        Pattern pattern = Pattern.compile(regexSB.toString(), 32);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String wrapped = this._formatInlines(matcher.group());
            wrapped = StringUtil.wrap((String)wrapped, (int)(80 - indentLength), (String)"\n");
            matcher.appendReplacement(sb, wrapped);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String _wrapText(String text, String indent) {
        int indentLength = this._getIndentLength(indent);
        if (text.contains("<pre>")) {
            text = this._wrapText(text, indentLength, "pre");
        } else if (text.contains("<table>")) {
            text = this._wrapText(text, indentLength, "table");
        } else {
            text = this._formatInlines(text);
            text = StringUtil.wrap((String)text, (int)(80 - indentLength), (String)"\n");
        }
        text = text.replaceAll("(?m)^", indent);
        text = text.replaceAll("(?m) +$", "");
        return text;
    }
}

