/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.tools.ToolDependencies;
import java.io.File;

public class EARBuilder {
    public static void main(String[] args) {
        ToolDependencies.wireBasic();
        if (args.length != 3) {
            throw new IllegalArgumentException();
        }
        new EARBuilder(args[0], StringUtil.split((String)args[1]), args[2]);
    }

    public EARBuilder(String originalApplicationXML, String[] pluginFileNames, String portalContextPath) {
        try {
            Document document = SAXReaderUtil.read((File)new File(originalApplicationXML));
            Element rootElement = document.getRootElement();
            for (String pluginFileName : pluginFileNames) {
                Element moduleElement = rootElement.addElement("module");
                Element webElement = moduleElement.addElement("web");
                Element webURIElement = webElement.addElement("web-uri");
                webURIElement.addText(pluginFileName);
                Element contextRootElement = webElement.addElement("context-root");
                String contextRoot = this._getContextRoot(pluginFileName, portalContextPath);
                contextRootElement.addText(contextRoot);
            }
            FileUtil.write((String)originalApplicationXML, (String)document.formattedString(), (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String _getContextRoot(String pluginFileName, String portalContextPath) {
        String contextRoot = pluginFileName;
        int pos = contextRoot.lastIndexOf(".war");
        if (pos != -1) {
            contextRoot = contextRoot.substring(0, pos);
        }
        if (contextRoot.equals("liferay-portal")) {
            contextRoot = portalContextPath;
            if (contextRoot.equals("/")) {
                contextRoot = "";
            } else if (contextRoot.startsWith("/")) {
                contextRoot = contextRoot.substring(1);
            }
        }
        return "/".concat(contextRoot);
    }
}

