/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.DummyOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.util.FileImpl;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.derby.tools.ij;

public class DBLoader {
    private static FileImpl _fileUtil = FileImpl.getInstance();
    private String _databaseName;
    private String _databaseType;
    private String _fileName;
    private String _sqlDir;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void loadHypersonic(Connection con, String fileName) throws Exception {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new FileReader(fileName));){
            StringBundler sb = new StringBundler();
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.startsWith("//")) continue;
                sb.append(line);
                if (!line.endsWith(";")) continue;
                String sql = sb.toString();
                sql = StringUtil.replace((String)sql, (String[])new String[]{"\\\"", "\\\\", "\\n", "\\r"}, (String[])new String[]{"\"", "\\", "\\u000a", "\\u000a"});
                sb.setIndex(0);
                try {
                    PreparedStatement ps = con.prepareStatement(sql);
                    Throwable throwable = null;
                    try {
                        ps.executeUpdate();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ps == null) continue;
                        if (throwable != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        ps.close();
                    }
                }
                catch (Exception e) {
                    System.out.println(sql);
                    throw e;
                    return;
                }
            }
        }
    }

    public static void main(String[] args) {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String databaseName = arguments.get("db.database.name");
        String databaseType = arguments.get("db.database.type");
        String sqlDir = arguments.get("db.sql.dir");
        String fileName = arguments.get("db.file.name");
        new DBLoader(databaseName, databaseType, sqlDir, fileName);
    }

    public DBLoader(String databaseName, String databaseType, String sqlDir, String fileName) {
        try {
            this._databaseName = databaseName;
            this._databaseType = databaseType;
            this._sqlDir = sqlDir;
            this._fileName = fileName;
            if (this._databaseType.equals("derby")) {
                this._loadDerby();
            } else if (this._databaseType.equals("hypersonic")) {
                this._loadHypersonic();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadDerby() throws Exception {
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        try (Connection con = null;){
            con = DriverManager.getConnection("jdbc:derby:" + this._sqlDir + "/" + this._databaseName + ";create=true", "", "");
            if (Validator.isNull((String)this._fileName)) {
                this._loadDerby(con, this._sqlDir + "/portal/portal-derby.sql");
                this._loadDerby(con, this._sqlDir + "/indexes.sql");
            } else {
                this._loadDerby(con, this._sqlDir + "/" + this._fileName);
            }
        }
        try {
            con = DriverManager.getConnection("jdbc:derby:" + this._sqlDir + "/" + this._databaseName + ";shutdown=true", "", "");
        }
        catch (SQLException sqle) {
            String sqlState = sqle.getSQLState();
            if (!sqlState.equals("08006")) {
                throw sqle;
            }
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
    }

    private void _loadDerby(Connection con, String fileName) throws Exception {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(_fileUtil.read(fileName)));){
            StringBundler sb = new StringBundler();
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.startsWith("--")) continue;
                sb.append(line);
                if (!line.endsWith(";")) continue;
                String sql = sb.toString();
                sql = StringUtil.replace((String)sql, (String[])new String[]{"\\'", "\\\"", "\\\\", "\\n", "\\r"}, (String[])new String[]{"''", "\"", "\\", "\n", "\r"});
                sql = sql.substring(0, sql.length() - 1);
                sb.setIndex(0);
                if (sql.startsWith("commit")) continue;
                ij.runScript((Connection)con, (InputStream)new UnsyncByteArrayInputStream(sql.getBytes("UTF-8")), (String)"UTF-8", (OutputStream)new DummyOutputStream(), (String)"UTF-8");
            }
        }
    }

    private void _loadHypersonic() throws Exception {
        Class.forName("org.hsqldb.jdbcDriver");
        try (Connection con = DriverManager.getConnection("jdbc:hsqldb:" + this._sqlDir + "/" + this._databaseName + ";shutdown=true", "sa", "");){
            if (Validator.isNull((String)this._fileName)) {
                DBLoader.loadHypersonic(con, this._sqlDir + "/portal/portal-hypersonic.sql");
                DBLoader.loadHypersonic(con, this._sqlDir + "/indexes.sql");
            } else {
                DBLoader.loadHypersonic(con, this._sqlDir + "/" + this._fileName);
            }
            try (Statement statement = con.createStatement();){
                statement.execute("SHUTDOWN COMPACT");
            }
        }
        String content = _fileUtil.read(this._sqlDir + "/" + this._databaseName + ".script");
        content = StringUtil.replace((String)content, (String)"\\u005cu", (String)"\\u");
        _fileUtil.write(this._sqlDir + "/" + this._databaseName + ".script", content);
    }
}

