/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.ToolDependencies;
import java.io.IOException;
import java.util.Map;

public class DBBuilder {
    private final String _databaseName;
    private final String[] _databaseTypes;

    public static void main(String[] args) {
        ToolDependencies.wireBasic();
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String databaseName = arguments.get("db.database.name");
        String databaseTypesString = arguments.get("db.database.types");
        String[] databaseTypes = null;
        databaseTypes = databaseTypesString == null ? DB.TYPE_ALL : StringUtil.split((String)databaseTypesString);
        String sqlDir = arguments.get("db.sql.dir");
        new DBBuilder(databaseName, databaseTypes, sqlDir);
    }

    public DBBuilder(String databaseName, String[] databaseTypes, String sqlDir) {
        this._databaseName = databaseName;
        this._databaseTypes = databaseTypes;
        try {
            if (!sqlDir.endsWith("/WEB-INF/sql")) {
                this._buildSQLFile(sqlDir, "portal");
                this._buildSQLFile(sqlDir, "portal-tables");
            } else {
                this._buildSQLFile(sqlDir, "tables");
            }
            this._buildSQLFile(sqlDir, "indexes");
            this._buildSQLFile(sqlDir, "sequences");
            this._buildSQLFile(sqlDir, "update-5.0.1-5.1.0");
            this._buildSQLFile(sqlDir, "update-5.1.1-5.1.2");
            this._buildSQLFile(sqlDir, "update-5.1.2-5.2.0");
            this._buildSQLFile(sqlDir, "update-5.2.0-5.2.1");
            this._buildSQLFile(sqlDir, "update-5.2.2-5.2.3");
            this._buildSQLFile(sqlDir, "update-5.2.3-6.0.0");
            this._buildSQLFile(sqlDir, "update-5.2.5-6.0.0");
            this._buildSQLFile(sqlDir, "update-5.2.7-6.0.0");
            this._buildSQLFile(sqlDir, "update-5.2.8-6.0.5");
            this._buildSQLFile(sqlDir, "update-6.0.0-6.0.1");
            this._buildSQLFile(sqlDir, "update-6.0.1-6.0.2");
            this._buildSQLFile(sqlDir, "update-6.0.2-6.0.3");
            this._buildSQLFile(sqlDir, "update-6.0.4-6.0.5");
            this._buildSQLFile(sqlDir, "update-6.0.5-6.0.6");
            this._buildSQLFile(sqlDir, "update-6.0.6-6.1.0");
            this._buildSQLFile(sqlDir, "update-6.0.12-6.1.0");
            this._buildSQLFile(sqlDir, "update-6.1.0-6.1.1");
            this._buildSQLFile(sqlDir, "update-6.1.1-6.2.0");
            this._buildCreateFile(sqlDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _buildCreateFile(String sqlDir) throws IOException {
        for (String databaseType : this._databaseTypes) {
            DB db;
            if (databaseType.equals("hypersonic") || databaseType.equals("interbase") || databaseType.equals("jdatastore") || databaseType.equals("sap") || (db = DBFactoryUtil.getDB((String)databaseType)) == null) continue;
            if (!sqlDir.endsWith("/WEB-INF/sql")) {
                db.buildCreateFile(sqlDir, this._databaseName);
                continue;
            }
            db.buildCreateFile(sqlDir, this._databaseName, 1);
        }
    }

    private void _buildSQLFile(String sqlDir, String fileName) throws IOException {
        if (!FileUtil.exists((String)(sqlDir + "/" + fileName + ".sql"))) {
            return;
        }
        for (String _databaseType : this._databaseTypes) {
            DB db = DBFactoryUtil.getDB((String)_databaseType);
            if (db == null) continue;
            db.buildSQLFile(sqlDir, fileName);
        }
    }
}

