/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

public class ServiceLocator {
    private static Log _log = LogFactoryUtil.getLog(ServiceLocator.class);
    private static ServiceLocator _instance = new ServiceLocator();

    public static ServiceLocator getInstance() {
        return _instance;
    }

    public Object findService(String serviceName) {
        Object bean = null;
        try {
            bean = PortalBeanLocatorUtil.locate((String)this._getServiceName(serviceName));
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return bean;
    }

    public Object findService(String servletContextName, String serviceName) {
        Object bean = null;
        try {
            bean = PortletBeanLocatorUtil.locate((String)servletContextName, (String)this._getServiceName(serviceName));
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return bean;
    }

    private ServiceLocator() {
    }

    private String _getServiceName(String serviceName) {
        if (!serviceName.endsWith(".velocity")) {
            serviceName = serviceName + ".velocity";
        }
        return serviceName;
    }
}

