/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import java.io.Writer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.http.HttpServletRequest;

public class PrivilegedTemplateWrapper
implements Template {
    private AccessControlContext _accessControlContext;
    private Template _template;

    public PrivilegedTemplateWrapper(AccessControlContext accessControlContext, Template template) {
        this._accessControlContext = accessControlContext;
        this._template = template;
    }

    public void doProcessTemplate(Writer writer) throws Exception {
        AccessController.doPrivileged(new ProcessTemplatePrivilegedExceptionAction(this._template, writer), this._accessControlContext);
    }

    public Object get(String key) {
        return this._template.get(key);
    }

    public String[] getKeys() {
        return this._template.getKeys();
    }

    public void prepare(HttpServletRequest request) {
        this._template.prepare(request);
    }

    public void processTemplate(Writer writer) throws TemplateException {
        try {
            this.doProcessTemplate(writer);
        }
        catch (PrivilegedActionException pae) {
            throw (TemplateException)((Object)pae.getException());
        }
        catch (Exception e) {
            throw new TemplateException();
        }
    }

    public void put(String key, Object value) {
        this._template.put(key, value);
    }

    private static class ProcessTemplatePrivilegedExceptionAction
    implements PrivilegedExceptionAction<Void> {
        private Template _template;
        private Writer _writer;

        public ProcessTemplatePrivilegedExceptionAction(Template template, Writer writer) {
            this._template = template;
            this._writer = writer;
        }

        @Override
        public Void run() throws Exception {
            this._template.processTemplate(this._writer);
            return null;
        }
    }
}

