/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.struts.StrutsPortletAction;
import com.liferay.portal.struts.ActionAdapter;
import com.liferay.portal.struts.PortletActionAdapter;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.StringServiceRegistrationMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.struts.action.Action;

public class StrutsActionRegistryUtil {
    private static StrutsActionRegistryUtil _instance = new StrutsActionRegistryUtil();
    private Map<String, Action> _actions = new ConcurrentHashMap<String, Action>();
    private ServiceTracker<?, Action> _serviceTracker;
    private StringServiceRegistrationMap<StrutsAction> _strutsActionServiceRegistrations = new StringServiceRegistrationMap();
    private StringServiceRegistrationMap<StrutsPortletAction> _strutsPortletActionServiceRegistrations = new StringServiceRegistrationMap();

    public static Action getAction(String path) {
        return _instance._getAction(path);
    }

    public static Map<String, Action> getActions() {
        return _instance._getActions();
    }

    public static void register(String path, StrutsAction strutsAction) {
        _instance._register(path, strutsAction);
    }

    public static void register(String path, StrutsPortletAction strutsPortletAction) {
        _instance._register(path, strutsPortletAction);
    }

    public static void unregister(String path) {
        _instance._unregister(path);
    }

    private StrutsActionRegistryUtil() {
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter("(&(|(objectClass=" + StrutsAction.class.getName() + ")(objectClass=" + StrutsPortletAction.class.getName() + "))(path=*))");
        this._serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new ActionServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private Action _getAction(String path) {
        Action action = this._actions.get(path);
        if (action != null) {
            return action;
        }
        for (Map.Entry<String, Action> entry : this._actions.entrySet()) {
            if (!path.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private Map<String, Action> _getActions() {
        return this._actions;
    }

    private void _register(String path, StrutsAction strutsAction) {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("path", path);
        ServiceRegistration serviceRegistration = registry.registerService(StrutsAction.class, (Object)strutsAction, properties);
        this._strutsActionServiceRegistrations.put((Object)path, (Object)serviceRegistration);
    }

    private void _register(String path, StrutsPortletAction strutsPortletAction) {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("path", path);
        ServiceRegistration serviceRegistration = registry.registerService(StrutsPortletAction.class, (Object)strutsPortletAction, properties);
        this._strutsPortletActionServiceRegistrations.put((Object)path, (Object)serviceRegistration);
    }

    private void _unregister(String path) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)this._strutsActionServiceRegistrations.remove((Object)path);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
        if ((serviceRegistration = (ServiceRegistration)this._strutsPortletActionServiceRegistrations.remove((Object)path)) != null) {
            serviceRegistration.unregister();
        }
    }

    private class ActionServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, Action> {
        private ActionServiceTrackerCustomizer() {
        }

        public Action addingService(ServiceReference<Object> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            Object service = registry.getService(serviceReference);
            Action action = null;
            if (service instanceof StrutsAction) {
                action = new ActionAdapter((StrutsAction)service);
            } else if (service instanceof StrutsPortletAction) {
                action = new PortletActionAdapter((StrutsPortletAction)service);
            }
            String path = (String)serviceReference.getProperty("path");
            StrutsActionRegistryUtil.this._actions.put(path, action);
            return action;
        }

        public void modifiedService(ServiceReference<Object> serviceReference, Action service) {
        }

        public void removedService(ServiceReference<Object> serviceReference, Action service) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            String path = (String)serviceReference.getProperty("path");
            StrutsActionRegistryUtil.this._actions.remove(path);
        }
    }
}

