/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.impl.VirtualLayout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.sites.util.SitesUtil;
import javax.portlet.PortletMode;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class FindAction
extends Action {
    private static Log _log = LogFactoryUtil.getLog(FindAction.class);
    private String[] _portletIds = this.initPortletIds();

    public FindAction() {
        if (ArrayUtil.isEmpty((Object[])this._portletIds)) {
            throw new RuntimeException("Portlet IDs cannot be null or empty");
        }
    }

    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            long groupId;
            long primaryKey;
            block11: {
                primaryKey = ParamUtil.getLong((HttpServletRequest)request, (String)this.getPrimaryKeyParameterName());
                groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId", (long)themeDisplay.getScopeGroupId());
                if (primaryKey > 0L) {
                    try {
                        long overrideGroupId = this.getGroupId(primaryKey);
                        if (overrideGroupId > 0L) {
                            groupId = overrideGroupId;
                        }
                    }
                    catch (Exception e) {
                        if (!_log.isDebugEnabled()) break block11;
                        _log.debug((Object)e, (Throwable)e);
                    }
                }
            }
            Object[] plidAndPortletId = FindAction.getPlidAndPortletId(themeDisplay, groupId, themeDisplay.getPlid(), this._portletIds);
            long plid = (Long)plidAndPortletId[0];
            Layout layout = FindAction.setTargetLayout(request, groupId, plid);
            LayoutPermissionUtil.check((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (boolean)true, (String)"VIEW");
            String portletId = (String)plidAndPortletId[1];
            LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)portletId, (long)plid, (String)"RENDER_PHASE");
            portletURL.setParameter("struts_action", this.getStrutsAction(request, portletId));
            boolean inheritRedirect = ParamUtil.getBoolean((HttpServletRequest)request, (String)"inheritRedirect");
            String redirect = null;
            if (inheritRedirect) {
                String noSuchEntryRedirect = ParamUtil.getString((HttpServletRequest)request, (String)"noSuchEntryRedirect");
                redirect = HttpUtil.getParameter((String)noSuchEntryRedirect, (String)"redirect", (boolean)false);
                redirect = HttpUtil.decodeURL((String)redirect);
            } else {
                redirect = ParamUtil.getString((HttpServletRequest)request, (String)"redirect");
            }
            if (Validator.isNotNull((String)redirect)) {
                portletURL.setParameter("redirect", redirect);
            }
            this.setPrimaryKeyParameter((PortletURL)portletURL, primaryKey);
            portletURL.setPortletMode(PortletMode.VIEW);
            portletURL.setWindowState(WindowState.NORMAL);
            portletURL = this.processPortletURL(request, (PortletURL)portletURL);
            response.sendRedirect(portletURL.toString());
            return null;
        }
        catch (Exception e) {
            String noSuchEntryRedirect = ParamUtil.getString((HttpServletRequest)request, (String)"noSuchEntryRedirect");
            noSuchEntryRedirect = PortalUtil.escapeRedirect((String)noSuchEntryRedirect);
            if (Validator.isNotNull((String)noSuchEntryRedirect) && (e instanceof NoSuchLayoutException || e instanceof PrincipalException)) {
                response.sendRedirect(noSuchEntryRedirect);
            } else {
                PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
            }
            return null;
        }
    }

    protected static Object[] fetchPlidAndPortletId(PermissionChecker permissionChecker, long groupId, String[] portletIds) throws Exception {
        for (String portletId : portletIds) {
            Layout layout;
            long plid = PortalUtil.getPlidFromPortletId((long)groupId, (String)portletId);
            if (plid == 0L || !LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)(layout = LayoutLocalServiceUtil.getLayout((long)plid)), (String)"VIEW")) continue;
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            portletId = FindAction.getPortletId(layoutTypePortlet, portletId);
            return new Object[]{plid, portletId};
        }
        return null;
    }

    protected static Object[] getPlidAndPortletId(ThemeDisplay themeDisplay, long groupId, long plid, String[] portletIds) throws Exception {
        Object[] plidAndPortletId;
        if (plid != 0L && groupId == themeDisplay.getScopeGroupId()) {
            try {
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                for (String portletId : portletIds) {
                    if (!layoutTypePortlet.hasPortletId(portletId, false) || !LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"VIEW")) continue;
                    portletId = FindAction.getPortletId(layoutTypePortlet, portletId);
                    return new Object[]{plid, portletId};
                }
            }
            catch (NoSuchLayoutException nsle) {
                // empty catch block
            }
        }
        if ((plidAndPortletId = FindAction.fetchPlidAndPortletId(themeDisplay.getPermissionChecker(), groupId, portletIds)) == null && SitesUtil.isUserGroupLayoutSetViewable((PermissionChecker)themeDisplay.getPermissionChecker(), (Group)themeDisplay.getScopeGroup())) {
            plidAndPortletId = FindAction.fetchPlidAndPortletId(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), portletIds);
        }
        if (plidAndPortletId != null) {
            return plidAndPortletId;
        }
        StringBundler sb = new StringBundler(portletIds.length * 2 + 5);
        sb.append("{groupId=");
        sb.append(groupId);
        sb.append(", plid=");
        sb.append(plid);
        for (String portletId : portletIds) {
            sb.append(", portletId=");
            sb.append(portletId);
        }
        sb.append("}");
        throw new NoSuchLayoutException(sb.toString());
    }

    protected static String getPortletId(LayoutTypePortlet layoutTypePortlet, String portletId) {
        for (String curPortletId : layoutTypePortlet.getPortletIds()) {
            String curRootPortletId = PortletConstants.getRootPortletId((String)curPortletId);
            if (!portletId.equals(curRootPortletId)) continue;
            return curPortletId;
        }
        return portletId;
    }

    protected static Layout setTargetLayout(HttpServletRequest request, long groupId, long plid) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        Object layout = LayoutLocalServiceUtil.getLayout((long)plid);
        if (groupId == layout.getGroupId() || group.getParentGroupId() == layout.getGroupId() || layout.isPrivateLayout() && !SitesUtil.isUserGroupLayoutSetViewable((PermissionChecker)permissionChecker, (Group)layout.getGroup())) {
            return layout;
        }
        layout = new VirtualLayout((Layout)layout, group);
        request.setAttribute("LAYOUT", layout);
        return layout;
    }

    protected abstract long getGroupId(long var1) throws Exception;

    protected abstract String getPrimaryKeyParameterName();

    protected abstract String getStrutsAction(HttpServletRequest var1, String var2);

    protected abstract String[] initPortletIds();

    protected PortletURL processPortletURL(HttpServletRequest request, PortletURL portletURL) throws Exception {
        return portletURL;
    }

    protected void setPrimaryKeyParameter(PortletURL portletURL, long primaryKey) throws Exception {
        portletURL.setParameter(this.getPrimaryKeyParameterName(), String.valueOf(primaryKey));
    }
}

