/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.staging.permission;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.staging.permission.StagingPermission;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;

@DoPrivileged
public class StagingPermissionImpl
implements StagingPermission {
    private static Log _log = LogFactoryUtil.getLog(StagingPermissionImpl.class);

    public Boolean hasPermission(PermissionChecker permissionChecker, Group group, String className, long classPK, String portletId, String actionId) {
        try {
            return this.doHasPermission(permissionChecker, group, className, classPK, portletId, actionId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public Boolean hasPermission(PermissionChecker permissionChecker, long groupId, String className, long classPK, String portletId, String actionId) {
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            return this.doHasPermission(permissionChecker, group, className, classPK, portletId, actionId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    protected Boolean doHasPermission(PermissionChecker permissionChecker, Group group, String className, long classPK, String portletId, String actionId) throws Exception {
        if (!(actionId.equals("ACCESS_IN_CONTROL_PANEL") || actionId.equals("ADD_TO_PAGE") || actionId.equals("CONFIGURATION") || actionId.equals("CUSTOMIZE") || actionId.equals("DELETE") || actionId.equals("VIEW") || !group.hasLocalOrRemoteStagingGroup() || !Validator.isNull((String)portletId) && !group.isStagedPortlet(portletId))) {
            return false;
        }
        return null;
    }
}

