/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.staging;

import com.liferay.portal.DuplicateLockException;
import com.liferay.portal.LARFileException;
import com.liferay.portal.LARFileSizeException;
import com.liferay.portal.LARTypeException;
import com.liferay.portal.LayoutPrototypeException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.MissingReferenceException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchLayoutBranchException;
import com.liferay.portal.NoSuchLayoutRevisionException;
import com.liferay.portal.PortletIdException;
import com.liferay.portal.RemoteExportException;
import com.liferay.portal.RemoteOptionsException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ExportImportDateUtil;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.MissingReference;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.lar.exportimportconfiguration.ExportImportConfigurationSettingsMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.staging.Staging;
import com.liferay.portal.kernel.staging.StagingConstants;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManagerUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.lar.backgroundtask.BackgroundTaskContextMapFactory;
import com.liferay.portal.lar.backgroundtask.LayoutRemoteStagingBackgroundTaskExecutor;
import com.liferay.portal.lar.backgroundtask.LayoutStagingBackgroundTaskExecutor;
import com.liferay.portal.lar.backgroundtask.PortletStagingBackgroundTaskExecutor;
import com.liferay.portal.model.ExportImportConfiguration;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutBranch;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.model.User;
import com.liferay.portal.model.WorkflowInstanceLink;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.auth.RemoteAuthException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.BackgroundTaskLocalServiceUtil;
import com.liferay.portal.service.ExportImportConfigurationLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutBranchLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.LockLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.StagingLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.WorkflowInstanceLinkLocalServiceUtil;
import com.liferay.portal.service.http.GroupServiceHttp;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.SessionClicks;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.FileExtensionException;
import com.liferay.portlet.documentlibrary.FileNameException;
import com.liferay.portlet.documentlibrary.FileSizeException;
import com.liferay.portlet.layoutsadmin.lar.StagedTheme;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

@DoPrivileged
public class StagingImpl
implements Staging {
    private static Log _log = LogFactoryUtil.getLog(StagingImpl.class);

    public String buildRemoteURL(String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, boolean privateLayout) {
        StringBundler sb = new StringBundler(remoteGroupId > 0L ? 4 : 9);
        if (secureConnection) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        sb.append(remoteAddress);
        if (remotePort > 0) {
            sb.append(":");
            sb.append(remotePort);
        }
        if (Validator.isNotNull((String)remotePathContext)) {
            sb.append(remotePathContext);
        }
        if (remoteGroupId > 0L) {
            sb.append("/c/my_sites/view?");
            sb.append("groupId=");
            sb.append(remoteGroupId);
            sb.append("&amp;privateLayout=");
            sb.append(privateLayout);
        }
        return sb.toString();
    }

    public String buildRemoteURL(UnicodeProperties typeSettingsProperties) {
        String remoteAddress = typeSettingsProperties.getProperty("remoteAddress");
        int remotePort = GetterUtil.getInteger((String)typeSettingsProperties.getProperty("remotePort"));
        String remotePathContext = typeSettingsProperties.getProperty("remotePathContext");
        boolean secureConnection = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("secureConnection"));
        return this.buildRemoteURL(remoteAddress, remotePort, remotePathContext, secureConnection, 0L, false);
    }

    @Deprecated
    public void checkDefaultLayoutSetBranches(long userId, Group liveGroup, boolean branchingPublic, boolean branchingPrivate, boolean remote, ServiceContext serviceContext) throws PortalException {
        StagingLocalServiceUtil.checkDefaultLayoutSetBranches((long)userId, (Group)liveGroup, (boolean)branchingPublic, (boolean)branchingPrivate, (boolean)remote, (ServiceContext)serviceContext);
    }

    public void copyFromLive(PortletRequest portletRequest) throws PortalException {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group stagingGroup = GroupLocalServiceUtil.getGroup((long)stagingGroupId);
        long liveGroupId = stagingGroup.getLiveGroupId();
        Map<String, String[]> parameterMap = this.getStagingParameters(portletRequest);
        this.publishLayouts(portletRequest, liveGroupId, stagingGroupId, parameterMap, false);
    }

    public void copyFromLive(PortletRequest portletRequest, Portlet portlet) throws PortalException {
        long plid = ParamUtil.getLong((PortletRequest)portletRequest, (String)"plid");
        Layout targetLayout = LayoutLocalServiceUtil.getLayout((long)plid);
        Group stagingGroup = targetLayout.getGroup();
        Group liveGroup = stagingGroup.getLiveGroup();
        Layout sourceLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)targetLayout.getUuid(), (long)liveGroup.getGroupId(), (boolean)targetLayout.isPrivateLayout());
        this.copyPortlet(portletRequest, liveGroup.getGroupId(), stagingGroup.getGroupId(), sourceLayout.getPlid(), targetLayout.getPlid(), portlet.getPortletId());
    }

    public void copyPortlet(PortletRequest portletRequest, long sourceGroupId, long targetGroupId, long sourcePlid, long targetPlid, String portletId) throws PortalException {
        long userId = PortalUtil.getUserId((PortletRequest)portletRequest);
        Map<String, String[]> parameterMap = this.getStagingParameters(portletRequest);
        DateRange dateRange = ExportImportDateUtil.getDateRange((PortletRequest)portletRequest, (long)sourceGroupId, (boolean)false, (long)sourcePlid, (String)portletId, (String)"fromLastPublishDate");
        Map<String, Serializable> taskContextMap = BackgroundTaskContextMapFactory.buildTaskContextMap(userId, sourceGroupId, false, null, parameterMap, "publish_to_live", dateRange.getStartDate(), dateRange.getEndDate(), "");
        taskContextMap.put("sourceGroupId", Long.valueOf(sourceGroupId));
        taskContextMap.put("sourcePlid", Long.valueOf(sourcePlid));
        taskContextMap.put("portletId", (Serializable)((Object)portletId));
        taskContextMap.put("targetGroupId", Long.valueOf(targetGroupId));
        taskContextMap.put("targetPlid", Long.valueOf(targetPlid));
        BackgroundTaskLocalServiceUtil.addBackgroundTask((long)userId, (long)sourceGroupId, (String)portletId, null, PortletStagingBackgroundTaskExecutor.class, taskContextMap, (ServiceContext)new ServiceContext());
    }

    public void copyRemoteLayouts(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long remoteGroupId = MapUtil.getLong((Map)settingsMap, (String)"remoteGroupId");
        String remoteAddress = MapUtil.getString((Map)settingsMap, (String)"remoteAddress");
        int remotePort = MapUtil.getInteger((Map)settingsMap, (String)"remotePort");
        String remotePathContext = MapUtil.getString((Map)settingsMap, (String)"remotePathContext");
        boolean secureConnection = MapUtil.getBoolean((Map)settingsMap, (String)"secureConnection");
        this.validateRemoteGroup(exportImportConfiguration.getGroupId(), remoteGroupId, remoteAddress, remotePort, remotePathContext, secureConnection);
        boolean remotePrivateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"remotePrivateLayout");
        this.doCopyRemoteLayouts(exportImportConfiguration, remoteAddress, remotePort, remotePathContext, secureConnection, remotePrivateLayout);
    }

    public void copyRemoteLayouts(long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.getExportImportConfiguration((long)exportImportConfigurationId);
        this.copyRemoteLayouts(exportImportConfiguration);
    }

    public void copyRemoteLayouts(long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout, Date startDate, Date endDate) throws PortalException {
        this.validateRemoteGroup(sourceGroupId, remoteGroupId, remoteAddress, remotePort, remotePathContext, secureConnection);
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        Map settingsMap = ExportImportConfigurationSettingsMapFactory.buildSettingsMap((long)user.getUserId(), (long)sourceGroupId, (boolean)privateLayout, layoutIdMap, parameterMap, (String)remoteAddress, (int)remotePort, (String)remotePathContext, (boolean)secureConnection, (long)remoteGroupId, (boolean)remotePrivateLayout, (Date)startDate, (Date)endDate, (Locale)user.getLocale(), (TimeZone)user.getTimeZone());
        ServiceContext serviceContext = new ServiceContext();
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.addExportImportConfiguration((long)user.getUserId(), (long)sourceGroupId, (String)"", (String)"", (int)2, (Map)settingsMap, (int)2, (ServiceContext)serviceContext);
        this.doCopyRemoteLayouts(exportImportConfiguration, remoteAddress, remotePort, remotePathContext, secureConnection, remotePrivateLayout);
    }

    public void deleteLastImportSettings(Group liveGroup, boolean privateLayout) throws PortalException {
        List layouts = LayoutLocalServiceUtil.getLayouts((long)liveGroup.getGroupId(), (boolean)privateLayout);
        for (Layout layout : layouts) {
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            HashSet<String> keys = new HashSet<String>();
            for (String key : typeSettingsProperties.keySet()) {
                if (!key.startsWith("last-import-")) continue;
                keys.add(key);
            }
            if (keys.isEmpty()) continue;
            for (String key : keys) {
                typeSettingsProperties.remove((Object)key);
            }
            LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.getPrivateLayout(), (long)layout.getLayoutId(), (String)typeSettingsProperties.toString());
        }
    }

    public void deleteRecentLayoutRevisionId(HttpServletRequest request, long layoutSetBranchId, long plid) {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
        this.deleteRecentLayoutRevisionId(portalPreferences, layoutSetBranchId, plid);
    }

    public void deleteRecentLayoutRevisionId(User user, long layoutSetBranchId, long plid) {
        PortalPreferences portalPreferences = this.getPortalPreferences(user);
        this.deleteRecentLayoutRevisionId(portalPreferences, layoutSetBranchId, plid);
    }

    @Deprecated
    public void disableStaging(Group scopeGroup, Group liveGroup, ServiceContext serviceContext) throws Exception {
        this.disableStaging((PortletRequest)null, liveGroup, serviceContext);
    }

    @Deprecated
    public void disableStaging(Group liveGroup, ServiceContext serviceContext) throws Exception {
        this.disableStaging((PortletRequest)null, liveGroup, serviceContext);
    }

    @Deprecated
    public void disableStaging(PortletRequest portletRequest, Group scopeGroup, Group liveGroup, ServiceContext serviceContext) throws Exception {
        this.disableStaging(portletRequest, liveGroup, serviceContext);
    }

    @Deprecated
    public void disableStaging(PortletRequest portletRequest, Group liveGroup, ServiceContext serviceContext) throws Exception {
        StagingLocalServiceUtil.disableStaging((PortletRequest)portletRequest, (Group)liveGroup, (ServiceContext)serviceContext);
    }

    @Deprecated
    public void enableLocalStaging(long userId, Group scopeGroup, Group liveGroup, boolean branchingPublic, boolean branchingPrivate, ServiceContext serviceContext) throws Exception {
        StagingLocalServiceUtil.enableLocalStaging((long)userId, (Group)liveGroup, (boolean)branchingPublic, (boolean)branchingPrivate, (ServiceContext)serviceContext);
    }

    @Deprecated
    public void enableRemoteStaging(long userId, Group scopeGroup, Group liveGroup, boolean branchingPublic, boolean branchingPrivate, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, ServiceContext serviceContext) throws Exception {
        StagingLocalServiceUtil.enableRemoteStaging((long)userId, (Group)liveGroup, (boolean)branchingPublic, (boolean)branchingPrivate, (String)remoteAddress, (int)remotePort, (String)remotePathContext, (boolean)secureConnection, (long)remoteGroupId, (ServiceContext)serviceContext);
    }

    public JSONArray getErrorMessagesJSONArray(Locale locale, Map<String, MissingReference> missingReferences, Map<String, Serializable> contextMap) {
        JSONArray errorMessagesJSONArray = JSONFactoryUtil.createJSONArray();
        for (String missingReferenceDisplayName : missingReferences.keySet()) {
            MissingReference missingReference = missingReferences.get(missingReferenceDisplayName);
            JSONObject errorMessageJSONObject = JSONFactoryUtil.createJSONObject();
            String className = missingReference.getClassName();
            Map referrers = missingReference.getReferrers();
            if (className.equals(StagedTheme.class.getName())) {
                errorMessageJSONObject.put("info", LanguageUtil.format((Locale)locale, (String)"the-referenced-theme-x-is-not-deployed-in-the-current-environment", (Object)missingReference.getClassPK(), (boolean)false));
            } else if (referrers.size() == 1) {
                Set referrerDisplayNames = referrers.entrySet();
                Iterator iterator = referrerDisplayNames.iterator();
                Map.Entry entry = iterator.next();
                String referrerDisplayName = (String)entry.getKey();
                String referrerClassName = (String)entry.getValue();
                if (referrerClassName.equals(Portlet.class.getName())) {
                    referrerDisplayName = PortalUtil.getPortletTitle((String)referrerDisplayName, (Locale)locale);
                }
                errorMessageJSONObject.put("info", LanguageUtil.format((Locale)locale, (String)"referenced-by-a-x-x", (Object[])new String[]{ResourceActionsUtil.getModelResource((Locale)locale, (String)referrerClassName), referrerDisplayName}, (boolean)false));
            } else {
                errorMessageJSONObject.put("info", LanguageUtil.format((Locale)locale, (String)"referenced-by-x-elements", (Object)referrers.size(), (boolean)true));
            }
            errorMessageJSONObject.put("name", missingReferenceDisplayName);
            Group group = GroupLocalServiceUtil.fetchGroup((long)missingReference.getGroupId());
            if (group != null) {
                errorMessageJSONObject.put("site", LanguageUtil.format((Locale)locale, (String)"in-site-x", (Object)missingReference.getGroupId(), (boolean)false));
            }
            errorMessageJSONObject.put("type", ResourceActionsUtil.getModelResource((Locale)locale, (String)missingReference.getClassName()));
            errorMessagesJSONArray.put(errorMessageJSONObject);
        }
        return errorMessagesJSONArray;
    }

    public JSONObject getExceptionMessagesJSONObject(Locale locale, Exception e, Map<String, Serializable> contextMap) {
        String cmd = null;
        if (contextMap != null) {
            cmd = (String)((Object)contextMap.get("cmd"));
        }
        JSONObject exceptionMessagesJSONObject = JSONFactoryUtil.createJSONObject();
        String errorMessage = "";
        JSONArray errorMessagesJSONArray = null;
        int errorType = 0;
        JSONArray warningMessagesJSONArray = null;
        if (e instanceof DuplicateFileException) {
            errorMessage = LanguageUtil.get((Locale)locale, (String)"please-enter-a-unique-document-name");
            errorType = 490;
        } else if (e instanceof FileExtensionException) {
            errorMessage = LanguageUtil.format((Locale)locale, (String)"document-names-must-end-with-one-of-the-following-extensions", (Object)".lar", (boolean)false);
            errorType = 491;
        } else if (e instanceof FileNameException) {
            errorMessage = LanguageUtil.get((Locale)locale, (String)"please-enter-a-file-with-a-valid-file-name");
            errorType = 492;
        } else if (e instanceof FileSizeException || e instanceof LARFileSizeException) {
            long fileMaxSize = PropsValues.DL_FILE_MAX_SIZE;
            try {
                fileMaxSize = PrefsPropsUtil.getLong("dl.file.max.size");
                if (fileMaxSize == 0L) {
                    fileMaxSize = PrefsPropsUtil.getLong("com.liferay.portal.upload.UploadServletRequestImpl.max.size");
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            errorMessage = Validator.equals((Object)cmd, (Object)"publish_to_live") || Validator.equals((Object)cmd, (Object)"publish_to_remote") ? LanguageUtil.get((Locale)locale, (String)"file-size-limit-exceeded.-please-ensure-that-the-file-does-not-exceed-the-file-size-limit-in-both-the-live-environment-and-the-staging-environment") : LanguageUtil.format((Locale)locale, (String)"please-enter-a-file-with-a-valid-file-size-no-larger-than-x", (Object)TextFormatter.formatStorageSize((double)fileMaxSize, (Locale)locale), (boolean)false);
            errorType = 493;
        } else if (e instanceof LARTypeException) {
            LARTypeException lte = (LARTypeException)e;
            errorMessage = LanguageUtil.format((Locale)locale, (String)"please-import-a-lar-file-of-the-correct-type-x-is-not-valid", (Object)lte.getMessage());
            errorType = 499;
        } else if (e instanceof LARFileException) {
            errorMessage = LanguageUtil.get((Locale)locale, (String)"please-specify-a-lar-file-to-import");
            errorType = 499;
        } else if (e instanceof LayoutPrototypeException) {
            LayoutPrototypeException lpe = (LayoutPrototypeException)e;
            StringBundler sb = new StringBundler(4);
            sb.append("the-lar-file-could-not-be-imported-because-it-");
            sb.append("requires-page-templates-or-site-templates-that-could-");
            sb.append("not-be-found.-please-import-the-following-templates-");
            sb.append("manually");
            errorMessage = LanguageUtil.get((Locale)locale, (String)sb.toString());
            errorMessagesJSONArray = JSONFactoryUtil.createJSONArray();
            List missingLayoutPrototypes = lpe.getMissingLayoutPrototypes();
            for (Tuple missingLayoutPrototype : missingLayoutPrototypes) {
                JSONObject errorMessageJSONObject = JSONFactoryUtil.createJSONObject();
                String layoutPrototypeUuid = (String)missingLayoutPrototype.getObject(1);
                errorMessageJSONObject.put("info", layoutPrototypeUuid);
                String layoutPrototypeName = (String)missingLayoutPrototype.getObject(2);
                errorMessageJSONObject.put("name", layoutPrototypeName);
                String layoutPrototypeClassName = (String)missingLayoutPrototype.getObject(0);
                errorMessageJSONObject.put("type", ResourceActionsUtil.getModelResource((Locale)locale, (String)layoutPrototypeClassName));
                errorMessagesJSONArray.put(errorMessageJSONObject);
            }
            errorType = 499;
        } else if (e instanceof LocaleException) {
            LocaleException le = (LocaleException)((Object)e);
            errorMessage = LanguageUtil.format((Locale)locale, (String)"the-available-languages-in-the-lar-file-x-do-not-match-the-site's-available-languages-x", (Object[])new String[]{StringUtil.merge((Object[])le.getSourceAvailableLocales(), (String)", "), StringUtil.merge((Object[])le.getTargetAvailableLocales(), (String)", ")}, (boolean)false);
            errorType = 499;
        } else if (e instanceof MissingReferenceException) {
            MissingReferenceException mre = (MissingReferenceException)e;
            errorMessage = Validator.equals((Object)cmd, (Object)"publish_to_live") || Validator.equals((Object)cmd, (Object)"publish_to_remote") ? LanguageUtil.get((Locale)locale, (String)"there-are-missing-references-that-could-not-be-found-in-the-live-environment") : LanguageUtil.get((Locale)locale, (String)"there-are-missing-references-that-could-not-be-found-in-the-current-site");
            MissingReferences missingReferences = mre.getMissingReferences();
            errorMessagesJSONArray = this.getErrorMessagesJSONArray(locale, missingReferences.getDependencyMissingReferences(), contextMap);
            errorType = 499;
            warningMessagesJSONArray = this.getWarningMessagesJSONArray(locale, missingReferences.getWeakMissingReferences(), contextMap);
        } else if (e instanceof PortletDataException) {
            PortletDataException pde = (PortletDataException)((Object)e);
            StagedModel stagedModel = pde.getStagedModel();
            String referrerClassName = "";
            String referrerDisplayName = "";
            if (stagedModel != null) {
                StagedModelType stagedModelType = stagedModel.getStagedModelType();
                referrerClassName = stagedModelType.getClassName();
                referrerDisplayName = StagedModelDataHandlerUtil.getDisplayName((StagedModel)stagedModel);
            }
            errorMessage = pde.getType() == 4 ? LanguageUtil.format((Locale)locale, (String)"the-x-x-could-not-be-exported-because-it-is-not-in-the-currently-exported-group", (Object[])new String[]{ResourceActionsUtil.getModelResource((Locale)locale, (String)referrerClassName), referrerDisplayName}, (boolean)false) : (pde.getType() == 5 ? LanguageUtil.format((Locale)locale, (String)"the-x-x-has-missing-references-that-could-not-be-found-during-the-export", (Object[])new String[]{ResourceActionsUtil.getModelResource((Locale)locale, (String)referrerClassName), referrerDisplayName}, (boolean)false) : (pde.getType() == 8 ? LanguageUtil.format((Locale)locale, (String)"the-x-x-could-not-be-exported-because-it-is-in-the-recycle-bin", (Object[])new String[]{ResourceActionsUtil.getModelResource((Locale)locale, (String)referrerClassName), referrerDisplayName}, (boolean)false) : (pde.getType() == 9 ? LanguageUtil.format((Locale)locale, (String)"the-x-x-could-not-be-exported-because-its-workflow-status-is-not-exportable", (Object[])new String[]{ResourceActionsUtil.getModelResource((Locale)locale, (String)referrerClassName), referrerDisplayName}, (boolean)false) : e.getLocalizedMessage())));
            errorType = 499;
        } else if (e instanceof PortletIdException) {
            errorMessage = LanguageUtil.get((Locale)locale, (String)"please-import-a-lar-file-for-the-current-portlet");
            errorType = 499;
        } else if (e instanceof RemoteExportException) {
            RemoteExportException ree = (RemoteExportException)e;
            if (ree.getType() == 4) {
                errorMessage = LanguageUtil.get((Locale)locale, (String)"no-pages-are-selected-for-export");
            }
            errorType = 499;
        } else {
            errorMessage = e.getLocalizedMessage();
            errorType = 499;
        }
        exceptionMessagesJSONObject.put("message", errorMessage);
        if (errorMessagesJSONArray != null && errorMessagesJSONArray.length() > 0) {
            exceptionMessagesJSONObject.put("messageListItems", errorMessagesJSONArray);
        }
        exceptionMessagesJSONObject.put("status", errorType);
        if (warningMessagesJSONArray != null && warningMessagesJSONArray.length() > 0) {
            exceptionMessagesJSONObject.put("warningMessages", warningMessagesJSONArray);
        }
        return exceptionMessagesJSONObject;
    }

    public Group getLiveGroup(long groupId) {
        Group group = GroupLocalServiceUtil.fetchGroup((long)groupId);
        if (group == null) {
            return null;
        }
        if (!group.isStagedRemotely() && group.isStagingGroup()) {
            return group.getLiveGroup();
        }
        return group;
    }

    public long getLiveGroupId(long groupId) {
        Group group = this.getLiveGroup(groupId);
        if (group == null) {
            return groupId;
        }
        return group.getGroupId();
    }

    @Deprecated
    public List<Layout> getMissingParentLayouts(Layout layout, long liveGroupId) throws PortalException {
        return ExportImportHelperUtil.getMissingParentLayouts((Layout)layout, (long)liveGroupId);
    }

    public long getRecentLayoutRevisionId(HttpServletRequest request, long layoutSetBranchId, long plid) throws PortalException {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
        return this.getRecentLayoutRevisionId(portalPreferences, layoutSetBranchId, plid);
    }

    public long getRecentLayoutRevisionId(User user, long layoutSetBranchId, long plid) throws PortalException {
        PortalPreferences portalPreferences = this.getPortalPreferences(user);
        return this.getRecentLayoutRevisionId(portalPreferences, layoutSetBranchId, plid);
    }

    public long getRecentLayoutSetBranchId(HttpServletRequest request, long layoutSetId) {
        return GetterUtil.getLong((String)SessionClicks.get((HttpServletRequest)request, (String)Staging.class.getName(), (String)this.getRecentLayoutSetBranchIdKey(layoutSetId)));
    }

    public long getRecentLayoutSetBranchId(User user, long layoutSetId) {
        PortalPreferences portalPreferences = this.getPortalPreferences(user);
        return GetterUtil.getLong((String)portalPreferences.getValue(Staging.class.getName(), this.getRecentLayoutSetBranchIdKey(layoutSetId)));
    }

    public String getSchedulerGroupName(String destinationName, long groupId) {
        return destinationName.concat("/").concat(String.valueOf(groupId));
    }

    public String getStagedPortletId(String portletId) {
        String key = portletId;
        if (key.startsWith("staged-portlet_")) {
            return key;
        }
        return "staged-portlet_".concat(portletId);
    }

    public Group getStagingGroup(long groupId) {
        Group group = GroupLocalServiceUtil.fetchGroup((long)groupId);
        if (group == null) {
            return null;
        }
        Group stagingGroup = group;
        if (!group.isStagedRemotely() && group.hasStagingGroup()) {
            stagingGroup = group.getStagingGroup();
        }
        return stagingGroup;
    }

    public Map<String, String[]> getStagingParameters() {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR_OVERWRITE"});
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("DELETE_PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("IGNORE_LAST_PUBLISH_DATE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("LAYOUT_SET_PROTOTYPE_LINK_ENABLED", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("LAYOUT_SET_SETTINGS", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("LOGO", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_147", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("THEME_REFERENCE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("UPDATE_LAST_PUBLISH_DATE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("USER_ID_STRATEGY", new String[]{"CURRENT_USER_ID"});
        return parameterMap;
    }

    public Map<String, String[]> getStagingParameters(PortletRequest portletRequest) {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>(portletRequest.getParameterMap());
        if (!parameterMap.containsKey("DATA_STRATEGY")) {
            parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR_OVERWRITE"});
        }
        if (!parameterMap.containsKey("DELETE_PORTLET_DATA")) {
            parameterMap.put("DELETE_PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("LAYOUT_SET_PROTOTYPE_LINK_ENABLED")) {
            parameterMap.put("LAYOUT_SET_PROTOTYPE_LINK_ENABLED", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("LAYOUT_SET_SETTINGS")) {
            parameterMap.put("LAYOUT_SET_SETTINGS", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("LOGO")) {
            parameterMap.put("LOGO", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("PORTLET_CONFIGURATION")) {
            parameterMap.put("PORTLET_CONFIGURATION", new String[]{Boolean.TRUE.toString()});
        }
        if (!parameterMap.containsKey("PORTLET_DATA")) {
            parameterMap.put("PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("PORTLET_DATA_ALL")) {
            parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("THEME_REFERENCE")) {
            parameterMap.put("THEME_REFERENCE", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("UPDATE_LAST_PUBLISH_DATE")) {
            parameterMap.put("UPDATE_LAST_PUBLISH_DATE", new String[]{Boolean.TRUE.toString()});
        }
        if (!parameterMap.containsKey("USER_ID_STRATEGY")) {
            parameterMap.put("USER_ID_STRATEGY", new String[]{"CURRENT_USER_ID"});
        }
        return parameterMap;
    }

    public JSONArray getWarningMessagesJSONArray(Locale locale, Map<String, MissingReference> missingReferences, Map<String, Serializable> contextMap) {
        JSONArray warningMessagesJSONArray = JSONFactoryUtil.createJSONArray();
        for (String missingReferenceReferrerClassName : missingReferences.keySet()) {
            MissingReference missingReference = missingReferences.get(missingReferenceReferrerClassName);
            Map referrers = missingReference.getReferrers();
            JSONObject errorMessageJSONObject = JSONFactoryUtil.createJSONObject();
            if (Validator.isNotNull((String)missingReference.getClassName())) {
                errorMessageJSONObject.put("info", LanguageUtil.format((Locale)locale, (String)"the-original-x-does-not-exist-in-the-current-environment", (Object)ResourceActionsUtil.getModelResource((Locale)locale, (String)missingReference.getClassName()), (boolean)false));
            }
            errorMessageJSONObject.put("size", referrers.size());
            errorMessageJSONObject.put("type", ResourceActionsUtil.getModelResource((Locale)locale, (String)missingReferenceReferrerClassName));
            warningMessagesJSONArray.put(errorMessageJSONObject);
        }
        return warningMessagesJSONArray;
    }

    public WorkflowTask getWorkflowTask(long userId, LayoutRevision layoutRevision) throws PortalException {
        WorkflowInstanceLink workflowInstanceLink = WorkflowInstanceLinkLocalServiceUtil.fetchWorkflowInstanceLink((long)layoutRevision.getCompanyId(), (long)layoutRevision.getGroupId(), (String)LayoutRevision.class.getName(), (long)layoutRevision.getLayoutRevisionId());
        if (workflowInstanceLink == null) {
            return null;
        }
        List workflowTasks = WorkflowTaskManagerUtil.getWorkflowTasksByWorkflowInstance((long)layoutRevision.getCompanyId(), (Long)userId, (long)workflowInstanceLink.getWorkflowInstanceId(), (Boolean)false, (int)0, (int)1, null);
        if (!workflowTasks.isEmpty()) {
            return (WorkflowTask)workflowTasks.get(0);
        }
        return null;
    }

    public boolean hasWorkflowTask(long userId, LayoutRevision layoutRevision) throws PortalException {
        WorkflowTask workflowTask = this.getWorkflowTask(userId, layoutRevision);
        return workflowTask != null;
    }

    public boolean isIncomplete(Layout layout, long layoutSetBranchId) {
        LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout);
        if (layoutRevision == null) {
            try {
                layoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)layoutSetBranchId, (long)layout.getPlid(), (boolean)true);
                return false;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            layoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)layoutSetBranchId, (long)layout.getPlid(), (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        return layoutRevision == null || layoutRevision.getStatus() == 6;
    }

    public void lockGroup(long userId, long groupId) throws PortalException {
        if (!PropsValues.STAGING_LOCK_ENABLED) {
            return;
        }
        if (LockLocalServiceUtil.isLocked((String)Staging.class.getName(), (long)groupId)) {
            Lock lock = LockLocalServiceUtil.getLock((String)Staging.class.getName(), (long)groupId);
            throw new DuplicateLockException(lock);
        }
        LockLocalServiceUtil.lock((long)userId, (String)Staging.class.getName(), (String)String.valueOf(groupId), (String)StagingImpl.class.getName(), (boolean)false, (long)StagingConstants.LOCK_EXPIRATION_TIME);
    }

    public void publishLayout(long userId, long plid, long liveGroupId, boolean includeChildren) throws PortalException {
        Map<String, String[]> parameterMap = this.getStagingParameters();
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.FALSE.toString()});
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        layouts.add(layout);
        List parentLayouts = ExportImportHelperUtil.getMissingParentLayouts((Layout)layout, (long)liveGroupId);
        layouts.addAll(parentLayouts);
        if (includeChildren) {
            layouts.addAll(layout.getAllChildren());
        }
        long[] layoutIds = ExportImportHelperUtil.getLayoutIds(layouts);
        this.publishLayouts(userId, layout.getGroupId(), liveGroupId, layout.isPrivateLayout(), layoutIds, parameterMap, null, null);
    }

    public void publishLayouts(long userId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        HashMap<String, Object> taskContextMap = new HashMap<String, Object>();
        taskContextMap.put("cmd", "publish_to_live");
        taskContextMap.put("exportImportConfigurationId", exportImportConfiguration.getExportImportConfigurationId());
        BackgroundTaskLocalServiceUtil.addBackgroundTask((long)userId, (long)exportImportConfiguration.getGroupId(), (String)"", null, LayoutStagingBackgroundTaskExecutor.class, taskContextMap, (ServiceContext)new ServiceContext());
    }

    public void publishLayouts(long userId, long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.getExportImportConfiguration((long)exportImportConfigurationId);
        this.publishLayouts(userId, exportImportConfiguration);
    }

    public void publishLayouts(long userId, long sourceGroupId, long targetGroupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        parameterMap.put("PERFORM_DIRECT_BINARY_IMPORT", new String[]{Boolean.TRUE.toString()});
        User user = UserLocalServiceUtil.getUser((long)userId);
        Map settingsMap = ExportImportConfigurationSettingsMapFactory.buildSettingsMap((long)userId, (long)sourceGroupId, (long)targetGroupId, (boolean)privateLayout, (long[])layoutIds, parameterMap, (Date)startDate, (Date)endDate, (Locale)user.getLocale(), (TimeZone)user.getTimeZone());
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.addExportImportConfiguration((long)userId, (long)sourceGroupId, (String)"", (String)"", (int)1, (Map)settingsMap, (int)2, (ServiceContext)new ServiceContext());
        this.publishLayouts(userId, exportImportConfiguration);
    }

    @Deprecated
    public void publishLayouts(long userId, long sourceGroupId, long targetGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        this.publishLayouts(userId, sourceGroupId, targetGroupId, privateLayout, ExportImportHelperUtil.getLayoutIds(layoutIdMap, (long)targetGroupId), parameterMap, startDate, endDate);
    }

    public void publishLayouts(long userId, long sourceGroupId, long targetGroupId, boolean privateLayout, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        this.publishLayouts(userId, sourceGroupId, targetGroupId, privateLayout, (long[])null, parameterMap, startDate, endDate);
    }

    public void publishToLive(PortletRequest portletRequest) throws PortalException {
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId");
        Group liveGroup = GroupLocalServiceUtil.getGroup((long)groupId);
        Map<String, String[]> parameterMap = this.getStagingParameters(portletRequest);
        if (liveGroup.isStaged()) {
            if (liveGroup.isStagedRemotely()) {
                this.publishToRemote(portletRequest);
            } else {
                Group stagingGroup = liveGroup.getStagingGroup();
                this.publishLayouts(portletRequest, stagingGroup.getGroupId(), groupId, parameterMap, false);
            }
        }
    }

    public void publishToLive(PortletRequest portletRequest, Portlet portlet) throws PortalException {
        long plid = ParamUtil.getLong((PortletRequest)portletRequest, (String)"plid");
        Layout sourceLayout = LayoutLocalServiceUtil.getLayout((long)plid);
        Group stagingGroup = null;
        Group liveGroup = null;
        Layout targetLayout = null;
        long scopeGroupId = PortalUtil.getScopeGroupId((PortletRequest)portletRequest);
        if (sourceLayout.isTypeControlPanel()) {
            stagingGroup = GroupLocalServiceUtil.fetchGroup((long)scopeGroupId);
            liveGroup = stagingGroup.getLiveGroup();
            targetLayout = sourceLayout;
        } else if (sourceLayout.hasScopeGroup() && sourceLayout.getScopeGroup().getGroupId() == scopeGroupId) {
            stagingGroup = sourceLayout.getScopeGroup();
            liveGroup = stagingGroup.getLiveGroup();
            targetLayout = LayoutLocalServiceUtil.getLayout((long)liveGroup.getClassPK());
        } else {
            stagingGroup = sourceLayout.getGroup();
            liveGroup = stagingGroup.getLiveGroup();
            targetLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)sourceLayout.getUuid(), (long)liveGroup.getGroupId(), (boolean)sourceLayout.isPrivateLayout());
        }
        this.copyPortlet(portletRequest, stagingGroup.getGroupId(), liveGroup.getGroupId(), sourceLayout.getPlid(), targetLayout.getPlid(), portlet.getPortletId());
    }

    public void publishToRemote(PortletRequest portletRequest) throws PortalException {
        this.publishToRemote(portletRequest, false);
    }

    public void scheduleCopyFromLive(PortletRequest portletRequest) throws PortalException {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group stagingGroup = GroupLocalServiceUtil.getGroup((long)stagingGroupId);
        long liveGroupId = stagingGroup.getLiveGroupId();
        Map<String, String[]> parameterMap = this.getStagingParameters(portletRequest);
        this.publishLayouts(portletRequest, liveGroupId, stagingGroupId, parameterMap, true);
    }

    public void schedulePublishToLive(PortletRequest portletRequest) throws PortalException {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group stagingGroup = GroupLocalServiceUtil.getGroup((long)stagingGroupId);
        long liveGroupId = stagingGroup.getLiveGroupId();
        Map<String, String[]> parameterMap = this.getStagingParameters(portletRequest);
        this.publishLayouts(portletRequest, stagingGroupId, liveGroupId, parameterMap, true);
    }

    public void schedulePublishToRemote(PortletRequest portletRequest) throws PortalException {
        this.publishToRemote(portletRequest, true);
    }

    public void setRecentLayoutBranchId(HttpServletRequest request, long layoutSetBranchId, long plid, long layoutBranchId) {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
        this.setRecentLayoutBranchId(portalPreferences, layoutSetBranchId, plid, layoutBranchId);
    }

    public void setRecentLayoutBranchId(User user, long layoutSetBranchId, long plid, long layoutBranchId) {
        PortalPreferences portalPreferences = this.getPortalPreferences(user);
        this.setRecentLayoutBranchId(portalPreferences, layoutSetBranchId, plid, layoutBranchId);
    }

    public void setRecentLayoutRevisionId(HttpServletRequest request, long layoutSetBranchId, long plid, long layoutRevisionId) {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
        this.setRecentLayoutRevisionId(portalPreferences, layoutSetBranchId, plid, layoutRevisionId);
    }

    public void setRecentLayoutRevisionId(User user, long layoutSetBranchId, long plid, long layoutRevisionId) {
        PortalPreferences portalPreferences = this.getPortalPreferences(user);
        this.setRecentLayoutRevisionId(portalPreferences, layoutSetBranchId, plid, layoutRevisionId);
    }

    public void setRecentLayoutSetBranchId(HttpServletRequest request, long layoutSetId, long layoutSetBranchId) {
        SessionClicks.put((HttpServletRequest)request, (String)Staging.class.getName(), (String)this.getRecentLayoutSetBranchIdKey(layoutSetId), (String)String.valueOf(layoutSetBranchId));
    }

    public void setRecentLayoutSetBranchId(User user, long layoutSetId, long layoutSetBranchId) {
        PortalPreferences portalPreferences = this.getPortalPreferences(user);
        portalPreferences.setValue(Staging.class.getName(), this.getRecentLayoutSetBranchIdKey(layoutSetId), String.valueOf(layoutSetBranchId));
    }

    public String stripProtocolFromRemoteAddress(String remoteAddress) {
        if (remoteAddress.startsWith("http://")) {
            remoteAddress = remoteAddress.substring("http://".length());
        } else if (remoteAddress.startsWith("https://")) {
            remoteAddress = remoteAddress.substring("https://".length());
        }
        return remoteAddress;
    }

    public void unlockGroup(long groupId) {
        if (!PropsValues.STAGING_LOCK_ENABLED) {
            return;
        }
        LockLocalServiceUtil.unlock((String)Staging.class.getName(), (long)groupId);
    }

    public void unscheduleCopyFromLive(PortletRequest portletRequest) throws PortalException {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        String jobName = ParamUtil.getString((PortletRequest)portletRequest, (String)"jobName");
        String groupName = this.getSchedulerGroupName("liferay/layouts_local_publisher", stagingGroupId);
        LayoutServiceUtil.unschedulePublishToLive((long)stagingGroupId, (String)jobName, (String)groupName);
    }

    public void unschedulePublishToLive(PortletRequest portletRequest) throws PortalException {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group stagingGroup = GroupLocalServiceUtil.getGroup((long)stagingGroupId);
        long liveGroupId = stagingGroup.getLiveGroupId();
        String jobName = ParamUtil.getString((PortletRequest)portletRequest, (String)"jobName");
        String groupName = this.getSchedulerGroupName("liferay/layouts_local_publisher", liveGroupId);
        LayoutServiceUtil.unschedulePublishToLive((long)liveGroupId, (String)jobName, (String)groupName);
    }

    public void unschedulePublishToRemote(PortletRequest portletRequest) throws PortalException {
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId");
        String jobName = ParamUtil.getString((PortletRequest)portletRequest, (String)"jobName");
        String groupName = this.getSchedulerGroupName("liferay/layouts_remote_publisher", groupId);
        LayoutServiceUtil.unschedulePublishToRemote((long)groupId, (String)jobName, (String)groupName);
    }

    public void updateLastImportSettings(Element layoutElement, Layout layout, PortletDataContext portletDataContext) {
        Map parameterMap = portletDataContext.getParameterMap();
        String cmd = MapUtil.getString((Map)parameterMap, (String)"cmd");
        if (!cmd.equals("publish_to_live")) {
            return;
        }
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        typeSettingsProperties.setProperty("last-import-date", String.valueOf(System.currentTimeMillis()));
        String layoutRevisionId = GetterUtil.getString((String)layoutElement.attributeValue("layout-revision-id"));
        typeSettingsProperties.setProperty("last-import-layout-revision-id", layoutRevisionId);
        String layoutSetBranchId = MapUtil.getString((Map)parameterMap, (String)"layoutSetBranchId");
        typeSettingsProperties.setProperty("last-import-layout-set-branch-id", layoutSetBranchId);
        String layoutSetBranchName = MapUtil.getString((Map)parameterMap, (String)"layoutSetBranchName");
        typeSettingsProperties.setProperty("last-import-layout-set-branch-name", layoutSetBranchName);
        String lastImportUserName = MapUtil.getString((Map)parameterMap, (String)"lastImportUserName");
        typeSettingsProperties.setProperty("last-import-user-name", lastImportUserName);
        String lastImportUserUuid = MapUtil.getString((Map)parameterMap, (String)"lastImportUserUuid");
        typeSettingsProperties.setProperty("last-import-user-uuid", lastImportUserUuid);
        String layoutBranchId = GetterUtil.getString((String)layoutElement.attributeValue("layout-branch-id"));
        typeSettingsProperties.setProperty("last-import-layout-branch-id", layoutBranchId);
        String layoutBranchName = GetterUtil.getString((String)layoutElement.attributeValue("layout-branch-name"));
        typeSettingsProperties.setProperty("last-import-layout-branch-name", layoutBranchName);
        layout.setTypeSettingsProperties(typeSettingsProperties);
    }

    public void updateLastPublishDate(long groupId, boolean privateLayout, Date lastPublishDate) throws PortalException {
        if (lastPublishDate == null) {
            lastPublishDate = new Date();
        }
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        settingsProperties.setProperty("last-publish-date", String.valueOf(lastPublishDate.getTime()));
        LayoutSetLocalServiceUtil.updateSettings((long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout(), (String)settingsProperties.toString());
    }

    public void updateLastPublishDate(String portletId, PortletPreferences portletPreferences, Date lastPublishDate) {
        if (lastPublishDate == null) {
            lastPublishDate = new Date();
        }
        try {
            portletPreferences.setValue("last-publish-date", String.valueOf(lastPublishDate.getTime()));
            portletPreferences.store();
        }
        catch (UnsupportedOperationException uoe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not updating the portlet setup for " + portletId + " because no setup was returned for the current " + "page"));
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void updateStaging(PortletRequest portletRequest, Group liveGroup) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        long userId = permissionChecker.getUserId();
        if (!GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)liveGroup, (String)"MANAGE_STAGING")) {
            return;
        }
        int stagingType = this.getStagingType(portletRequest, liveGroup);
        boolean branchingPublic = this.getBoolean(portletRequest, liveGroup, "branchingPublic");
        boolean branchingPrivate = this.getBoolean(portletRequest, liveGroup, "branchingPrivate");
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (stagingType == 0) {
            if (liveGroup.hasStagingGroup() || liveGroup.isStagedRemotely()) {
                StagingLocalServiceUtil.disableStaging((PortletRequest)portletRequest, (Group)liveGroup, (ServiceContext)serviceContext);
            }
        } else if (stagingType == 1) {
            StagingLocalServiceUtil.enableLocalStaging((long)userId, (Group)liveGroup, (boolean)branchingPublic, (boolean)branchingPrivate, (ServiceContext)serviceContext);
        } else if (stagingType == 2) {
            String remoteAddress = this.getString(portletRequest, liveGroup, "remoteAddress");
            remoteAddress = this.stripProtocolFromRemoteAddress(remoteAddress);
            int remotePort = this.getInteger(portletRequest, liveGroup, "remotePort");
            String remotePathContext = this.getString(portletRequest, liveGroup, "remotePathContext");
            boolean secureConnection = this.getBoolean(portletRequest, liveGroup, "secureConnection");
            long remoteGroupId = this.getLong(portletRequest, liveGroup, "remoteGroupId");
            StagingLocalServiceUtil.enableRemoteStaging((long)userId, (Group)liveGroup, (boolean)branchingPublic, (boolean)branchingPrivate, (String)remoteAddress, (int)remotePort, (String)remotePathContext, (boolean)secureConnection, (long)remoteGroupId, (ServiceContext)serviceContext);
        }
    }

    public void validateRemote(long groupId, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId) throws PortalException {
        RemoteOptionsException roe = null;
        if (!Validator.isDomain((String)remoteAddress) && !Validator.isIPAddress((String)remoteAddress)) {
            roe = new RemoteOptionsException(1);
            roe.setRemoteAddress(remoteAddress);
            throw roe;
        }
        if (remotePort < 1 || remotePort > 65535) {
            roe = new RemoteOptionsException(2);
            roe.setRemotePort(remotePort);
            throw roe;
        }
        if (Validator.isNotNull((String)remotePathContext) && (!remotePathContext.startsWith("/") || remotePathContext.endsWith("/"))) {
            roe = new RemoteOptionsException(4);
            roe.setRemotePathContext(remotePathContext);
            throw roe;
        }
        this.validateRemoteGroup(groupId, remoteGroupId, remoteAddress, remotePort, remotePathContext, secureConnection);
    }

    @Deprecated
    public void validateRemote(String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId) {
    }

    protected void deleteRecentLayoutRevisionId(PortalPreferences portalPreferences, long layoutSetBranchId, long plid) {
        portalPreferences.setValue(Staging.class.getName(), this.getRecentLayoutRevisionIdKey(layoutSetBranchId, plid), null);
    }

    protected void doCopyRemoteLayouts(ExportImportConfiguration exportImportConfiguration, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, boolean remotePrivateLayout) throws PortalException {
        HashMap<String, Object> taskContextMap = new HashMap<String, Object>();
        taskContextMap.put("cmd", "publish_to_remote");
        taskContextMap.put("exportImportConfigurationId", exportImportConfiguration.getExportImportConfigurationId());
        String remoteURL = this.buildRemoteURL(remoteAddress, remotePort, remotePathContext, secureConnection, 0L, remotePrivateLayout);
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.getPasswordEncrypted());
        taskContextMap.put("httpPrincipal", httpPrincipal);
        BackgroundTaskLocalServiceUtil.addBackgroundTask((long)user.getUserId(), (long)exportImportConfiguration.getGroupId(), (String)"", null, LayoutRemoteStagingBackgroundTaskExecutor.class, taskContextMap, (ServiceContext)new ServiceContext());
    }

    protected boolean getBoolean(PortletRequest portletRequest, Group group, String param) {
        return ParamUtil.getBoolean((PortletRequest)portletRequest, (String)param, (boolean)GetterUtil.getBoolean((String)group.getTypeSettingsProperty(param)));
    }

    protected int getInteger(PortletRequest portletRequest, Group group, String param) {
        return ParamUtil.getInteger((PortletRequest)portletRequest, (String)param, (int)GetterUtil.getInteger((String)group.getTypeSettingsProperty(param)));
    }

    protected long getLong(PortletRequest portletRequest, Group group, String param) {
        return ParamUtil.getLong((PortletRequest)portletRequest, (String)param, (long)GetterUtil.getLong((String)group.getTypeSettingsProperty(param)));
    }

    protected PortalPreferences getPortalPreferences(User user) {
        boolean signedIn = !user.isDefaultUser();
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((long)user.getUserId(), (boolean)signedIn);
        return portalPreferences;
    }

    protected long getRecentLayoutBranchId(PortalPreferences portalPreferences, long layoutSetBranchId, long plid) {
        return GetterUtil.getLong((String)portalPreferences.getValue(Staging.class.getName(), this.getRecentLayoutBranchIdKey(layoutSetBranchId, plid)));
    }

    protected String getRecentLayoutBranchIdKey(long layoutSetBranchId, long plid) {
        StringBundler sb = new StringBundler(4);
        sb.append("layoutBranchId-");
        sb.append(layoutSetBranchId);
        sb.append("-");
        sb.append(plid);
        return sb.toString();
    }

    protected long getRecentLayoutRevisionId(PortalPreferences portalPreferences, long layoutSetBranchId, long plid) throws PortalException {
        long layoutRevisionId = GetterUtil.getLong((String)portalPreferences.getValue(Staging.class.getName(), this.getRecentLayoutRevisionIdKey(layoutSetBranchId, plid)));
        if (layoutRevisionId > 0L) {
            return layoutRevisionId;
        }
        long layoutBranchId = this.getRecentLayoutBranchId(portalPreferences, layoutSetBranchId, plid);
        if (layoutBranchId > 0L) {
            try {
                LayoutBranchLocalServiceUtil.getLayoutBranch((long)layoutBranchId);
            }
            catch (NoSuchLayoutBranchException nslbe) {
                LayoutBranch layoutBranch = LayoutBranchLocalServiceUtil.getMasterLayoutBranch((long)layoutSetBranchId, (long)plid);
                layoutBranchId = layoutBranch.getLayoutBranchId();
            }
        }
        if (layoutBranchId > 0L) {
            try {
                LayoutRevision layoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)layoutSetBranchId, (long)layoutBranchId, (long)plid);
                if (layoutRevision != null) {
                    layoutRevisionId = layoutRevision.getLayoutRevisionId();
                }
            }
            catch (NoSuchLayoutRevisionException nslre) {
                // empty catch block
            }
        }
        return layoutRevisionId;
    }

    protected String getRecentLayoutRevisionIdKey(long layoutSetBranchId, long plid) {
        StringBundler sb = new StringBundler(4);
        sb.append("layoutRevisionId-");
        sb.append(layoutSetBranchId);
        sb.append("-");
        sb.append(plid);
        return sb.toString();
    }

    protected String getRecentLayoutSetBranchIdKey(long layoutSetId) {
        return "layoutSetBranchId_" + layoutSetId;
    }

    protected int getStagingType(PortletRequest portletRequest, Group liveGroup) {
        String stagingType = portletRequest.getParameter("stagingType");
        if (stagingType != null) {
            return GetterUtil.getInteger((String)stagingType);
        }
        if (liveGroup.isStagedRemotely()) {
            return 2;
        }
        if (liveGroup.hasStagingGroup()) {
            return 1;
        }
        return 0;
    }

    protected String getString(PortletRequest portletRequest, Group group, String param) {
        return ParamUtil.getString((PortletRequest)portletRequest, (String)param, (String)GetterUtil.getString((String)group.getTypeSettingsProperty(param)));
    }

    protected void publishLayouts(PortletRequest portletRequest, long sourceGroupId, long targetGroupId, Map<String, String[]> parameterMap, boolean schedule) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String tabs1 = ParamUtil.getString((PortletRequest)portletRequest, (String)"tabs1");
        boolean privateLayout = true;
        if (tabs1.equals("public-pages")) {
            privateLayout = false;
        }
        String scope = ParamUtil.getString((PortletRequest)portletRequest, (String)"scope");
        long[] layoutIds = null;
        if (scope.equals("selected-pages")) {
            layoutIds = ExportImportHelperUtil.getLayoutIds((PortletRequest)portletRequest, (long)targetGroupId);
        }
        if (schedule) {
            String groupName = this.getSchedulerGroupName("liferay/layouts_local_publisher", targetGroupId);
            int recurrenceType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"recurrenceType");
            Calendar startCalendar = ExportImportDateUtil.getCalendar((PortletRequest)portletRequest, (String)"schedulerStartDate", (boolean)true);
            String cronText = SchedulerEngineHelperUtil.getCronText((PortletRequest)portletRequest, (Calendar)startCalendar, (boolean)true, (int)recurrenceType);
            Date schedulerEndDate = null;
            int endDateType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"endDateType");
            if (endDateType == 1) {
                Calendar endCalendar = ExportImportDateUtil.getCalendar((PortletRequest)portletRequest, (String)"schedulerEndDate", (boolean)true);
                schedulerEndDate = endCalendar.getTime();
            }
            String description = ParamUtil.getString((PortletRequest)portletRequest, (String)"description");
            LayoutServiceUtil.schedulePublishToLive((long)sourceGroupId, (long)targetGroupId, (boolean)privateLayout, (long[])layoutIds, parameterMap, (String)scope, null, null, (String)groupName, (String)cronText, (Date)startCalendar.getTime(), (Date)schedulerEndDate, (String)description);
        } else if (scope.equals("all-pages")) {
            this.publishLayouts(themeDisplay.getUserId(), sourceGroupId, targetGroupId, privateLayout, parameterMap, null, null);
        } else {
            this.publishLayouts(themeDisplay.getUserId(), sourceGroupId, targetGroupId, privateLayout, layoutIds, parameterMap, null, null);
        }
    }

    protected void publishToRemote(PortletRequest portletRequest, boolean schedule) throws PortalException {
        String scope;
        String tabs1 = ParamUtil.getString((PortletRequest)portletRequest, (String)"tabs1");
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId");
        boolean privateLayout = true;
        if (tabs1.equals("public-pages")) {
            privateLayout = false;
        }
        if (Validator.isNull((String)(scope = ParamUtil.getString((PortletRequest)portletRequest, (String)"scope")))) {
            scope = "all-pages";
        }
        Map layoutIdMap = null;
        if (scope.equals("selected-pages")) {
            layoutIdMap = ExportImportHelperUtil.getLayoutIdMap((PortletRequest)portletRequest);
        }
        Map<String, String[]> parameterMap = this.getStagingParameters(portletRequest);
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        UnicodeProperties groupTypeSettingsProperties = group.getTypeSettingsProperties();
        String remoteAddress = ParamUtil.getString((PortletRequest)portletRequest, (String)"remoteAddress", (String)groupTypeSettingsProperties.getProperty("remoteAddress"));
        remoteAddress = this.stripProtocolFromRemoteAddress(remoteAddress);
        int remotePort = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"remotePort", (int)GetterUtil.getInteger((String)groupTypeSettingsProperties.getProperty("remotePort")));
        String remotePathContext = ParamUtil.getString((PortletRequest)portletRequest, (String)"remotePathContext", (String)groupTypeSettingsProperties.getProperty("remotePathContext"));
        boolean secureConnection = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"secureConnection", (boolean)GetterUtil.getBoolean((String)groupTypeSettingsProperties.getProperty("secureConnection")));
        long remoteGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"remoteGroupId", (long)GetterUtil.getLong((String)groupTypeSettingsProperties.getProperty("remoteGroupId")));
        boolean remotePrivateLayout = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"remotePrivateLayout");
        this.validateRemote(groupId, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId);
        if (schedule) {
            String groupName = this.getSchedulerGroupName("liferay/layouts_remote_publisher", groupId);
            int recurrenceType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"recurrenceType");
            Calendar startCalendar = ExportImportDateUtil.getCalendar((PortletRequest)portletRequest, (String)"schedulerStartDate", (boolean)true);
            String cronText = SchedulerEngineHelperUtil.getCronText((PortletRequest)portletRequest, (Calendar)startCalendar, (boolean)true, (int)recurrenceType);
            Date schedulerEndDate = null;
            int endDateType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"endDateType");
            if (endDateType == 1) {
                Calendar endCalendar = ExportImportDateUtil.getCalendar((PortletRequest)portletRequest, (String)"schedulerEndDate", (boolean)true);
                schedulerEndDate = endCalendar.getTime();
            }
            String description = ParamUtil.getString((PortletRequest)portletRequest, (String)"description");
            LayoutServiceUtil.schedulePublishToRemote((long)groupId, (boolean)privateLayout, (Map)layoutIdMap, parameterMap, (String)remoteAddress, (int)remotePort, (String)remotePathContext, (boolean)secureConnection, (long)remoteGroupId, (boolean)remotePrivateLayout, null, null, (String)groupName, (String)cronText, (Date)startCalendar.getTime(), (Date)schedulerEndDate, (String)description);
        } else {
            this.copyRemoteLayouts(groupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, remotePrivateLayout, null, null);
        }
    }

    protected void setRecentLayoutBranchId(PortalPreferences portalPreferences, long layoutSetBranchId, long plid, long layoutBranchId) {
        portalPreferences.setValue(Staging.class.getName(), this.getRecentLayoutBranchIdKey(layoutSetBranchId, plid), String.valueOf(layoutBranchId));
    }

    protected void setRecentLayoutRevisionId(PortalPreferences portalPreferences, long layoutSetBranchId, long plid, long layoutRevisionId) {
        long layoutBranchId;
        block4: {
            layoutBranchId = 0L;
            try {
                LayoutRevision layoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)layoutRevisionId);
                layoutBranchId = layoutRevision.getLayoutBranchId();
                LayoutRevision lastLayoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)layoutSetBranchId, (long)layoutBranchId, (long)plid);
                if (lastLayoutRevision.getLayoutRevisionId() == layoutRevisionId) {
                    this.deleteRecentLayoutRevisionId(portalPreferences, layoutSetBranchId, plid);
                } else {
                    portalPreferences.setValue(Staging.class.getName(), this.getRecentLayoutRevisionIdKey(layoutSetBranchId, plid), String.valueOf(layoutRevisionId));
                }
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)"Unable to set recent layout revision ID", (Throwable)pe);
            }
        }
        portalPreferences.setValue(Staging.class.getName(), this.getRecentLayoutBranchIdKey(layoutSetBranchId, plid), String.valueOf(layoutBranchId));
    }

    protected void validateRemoteGroup(long groupId, long remoteGroupId, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection) throws PortalException {
        if (remoteGroupId <= 0L) {
            RemoteOptionsException roe = new RemoteOptionsException(3);
            roe.setRemoteGroupId(remoteGroupId);
            throw roe;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        String remoteURL = this.buildRemoteURL(remoteAddress, remotePort, remotePathContext, secureConnection, 0L, false);
        HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.getPasswordEncrypted());
        try {
            GroupServiceHttp.checkRemoteStagingGroup(httpPrincipal, remoteGroupId);
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            String groupUuid = group.getUuid();
            Group remoteGroup = GroupServiceHttp.getGroup(httpPrincipal, remoteGroupId);
            if (group.isCompany() ^ remoteGroup.isCompany() || groupUuid.equals(remoteGroup.getUuid())) {
                RemoteExportException ree = new RemoteExportException(2);
                ree.setGroupId(remoteGroupId);
                throw ree;
            }
        }
        catch (NoSuchGroupException nsge) {
            RemoteExportException ree = new RemoteExportException(3);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (PrincipalException pe) {
            RemoteExportException ree = new RemoteExportException(5);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (RemoteAuthException rae) {
            rae.setURL(remoteURL);
            throw rae;
        }
        catch (SystemException se) {
            RemoteExportException ree = new RemoteExportException(1, se.getMessage());
            ree.setURL(remoteURL);
            throw ree;
        }
    }
}

