/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.staging;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.staging.LayoutStaging;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.model.LayoutSetStagingHandler;
import com.liferay.portal.model.LayoutStagingHandler;
import com.liferay.portal.service.LayoutSetBranchLocalServiceUtil;
import java.lang.reflect.InvocationHandler;

@DoPrivileged
public class LayoutStagingImpl
implements LayoutStaging {
    public LayoutRevision getLayoutRevision(Layout layout) {
        LayoutStagingHandler layoutStagingHandler = this.getLayoutStagingHandler(layout);
        if (layoutStagingHandler == null) {
            return null;
        }
        return layoutStagingHandler.getLayoutRevision();
    }

    public LayoutSetBranch getLayoutSetBranch(LayoutSet layoutSet) {
        LayoutSetStagingHandler layoutSetStagingHandler = this.getLayoutSetStagingHandler(layoutSet);
        if (layoutSetStagingHandler == null) {
            return null;
        }
        return layoutSetStagingHandler.getLayoutSetBranch();
    }

    public LayoutSetStagingHandler getLayoutSetStagingHandler(LayoutSet layoutSet) {
        if (!ProxyUtil.isProxyClass(layoutSet.getClass())) {
            return null;
        }
        InvocationHandler invocationHandler = ProxyUtil.getInvocationHandler((Object)layoutSet);
        if (!(invocationHandler instanceof LayoutSetStagingHandler)) {
            return null;
        }
        return (LayoutSetStagingHandler)invocationHandler;
    }

    public LayoutStagingHandler getLayoutStagingHandler(Layout layout) {
        if (!ProxyUtil.isProxyClass(layout.getClass())) {
            return null;
        }
        InvocationHandler invocationHandler = ProxyUtil.getInvocationHandler((Object)layout);
        if (!(invocationHandler instanceof LayoutStagingHandler)) {
            return null;
        }
        return (LayoutStagingHandler)invocationHandler;
    }

    public boolean isBranchingLayout(Layout layout) {
        try {
            return this.isBranchingLayoutSet(layout.getGroup(), layout.isPrivateLayout());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isBranchingLayoutSet(Group group, boolean privateLayout) {
        UnicodeProperties typeSettingsProperties;
        boolean isStagingGroup = false;
        if (group.isStagingGroup() && !group.isStagedRemotely()) {
            isStagingGroup = true;
            group = group.getLiveGroup();
        }
        if ((typeSettingsProperties = group.getTypeSettingsProperties()).isEmpty()) {
            return false;
        }
        boolean branchingEnabled = false;
        branchingEnabled = privateLayout ? GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("branchingPrivate")) : GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("branchingPublic"));
        if (!branchingEnabled || !group.isStaged() || !group.isStagedRemotely() && !isStagingGroup) {
            return false;
        }
        Group stagingGroup = group;
        if (isStagingGroup) {
            stagingGroup = group.getStagingGroup();
        }
        try {
            LayoutSetBranchLocalServiceUtil.getMasterLayoutSetBranch((long)stagingGroup.getGroupId(), (boolean)privateLayout);
            return true;
        }
        catch (PortalException pe) {
            return false;
        }
    }
}

