/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.transaction.TransactionAttribute;
import com.liferay.portal.kernel.transaction.TransactionLifecycleListener;
import com.liferay.portal.kernel.transaction.TransactionStatus;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public class TransactionCommitCallbackUtil {
    public static final TransactionLifecycleListener TRANSACTION_LIFECYCLE_LISTENER = new TransactionLifecycleListener(){

        public void created(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
            TransactionCommitCallbackUtil.pushCallbackList();
        }

        public void committed(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
            List<Callable<?>> callables = TransactionCommitCallbackUtil.popCallbackList();
            for (Callable<?> callable : callables) {
                try {
                    callable.call();
                }
                catch (Exception e) {
                    _log.error((Object)"Unable to execute transaction commit callback", (Throwable)e);
                }
            }
        }

        public void rollbacked(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus, Throwable throwable) {
            TransactionCommitCallbackUtil.popCallbackList();
        }
    };
    private static Log _log = LogFactoryUtil.getLog(TransactionCommitCallbackUtil.class);
    private static ThreadLocal<List<List<Callable<?>>>> _callbackListListThreadLocal = new AutoResetThreadLocal<List<List<Callable<?>>>>(TransactionCommitCallbackUtil.class + "._callbackListListThreadLocal"){

        protected List<List<Callable<?>>> initialValue() {
            return new ArrayList();
        }
    };

    public static void registerCallback(Callable<?> callable) {
        List<List<Callable<?>>> callbackListList = _callbackListListThreadLocal.get();
        if (callbackListList.isEmpty()) {
            try {
                callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            int index = callbackListList.size() - 1;
            List<Callable<?>> callableList = callbackListList.get(index);
            if (callableList == Collections.emptyList()) {
                callableList = new ArrayList();
                callbackListList.set(index, callableList);
            }
            callableList.add(callable);
        }
    }

    protected static List<Callable<?>> popCallbackList() {
        List<List<Callable<?>>> callbackListList = _callbackListListThreadLocal.get();
        return callbackListList.remove(callbackListList.size() - 1);
    }

    protected static void pushCallbackList() {
        List<List<Callable<?>>> callbackListList = _callbackListListThreadLocal.get();
        callbackListList.add(Collections.emptyList());
    }
}

