/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.spring.transaction.BaseTransactionExecutor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class DefaultTransactionExecutor
extends BaseTransactionExecutor {
    private static Log _log = LogFactoryUtil.getLog(DefaultTransactionExecutor.class);

    @Override
    public Object execute(PlatformTransactionManager platformTransactionManager, TransactionAttribute transactionAttribute, MethodInvocation methodInvocation) throws Throwable {
        TransactionStatus transactionStatus = platformTransactionManager.getTransaction((TransactionDefinition)transactionAttribute);
        boolean newTransaction = transactionStatus.isNewTransaction();
        if (newTransaction) {
            this.fireTransactionCreatedEvent(transactionAttribute, transactionStatus);
        }
        Object returnValue = null;
        try {
            returnValue = methodInvocation.proceed();
        }
        catch (Throwable throwable) {
            this.processThrowable(platformTransactionManager, throwable, transactionAttribute, transactionStatus);
        }
        this.processCommit(platformTransactionManager, transactionAttribute, transactionStatus);
        return returnValue;
    }

    protected void processCommit(PlatformTransactionManager platformTransactionManager, TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
        Throwable throwable = null;
        try {
            platformTransactionManager.commit(transactionStatus);
        }
        catch (TransactionSystemException tse) {
            _log.error((Object)"Application exception overridden by commit exception", (Throwable)tse);
            throwable = tse;
            throw tse;
        }
        catch (RuntimeException re) {
            _log.error((Object)"Application exception overridden by commit exception", (Throwable)re);
            throwable = re;
            throw re;
        }
        catch (Error e) {
            _log.error((Object)"Application exception overridden by commit error", (Throwable)e);
            throwable = e;
            throw e;
        }
        finally {
            if (transactionStatus.isNewTransaction()) {
                if (throwable != null) {
                    this.fireTransactionRollbackedEvent(transactionAttribute, transactionStatus, throwable);
                } else {
                    this.fireTransactionCommittedEvent(transactionAttribute, transactionStatus);
                }
            }
        }
    }

    protected void processThrowable(PlatformTransactionManager platformTransactionManager, Throwable throwable, TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) throws Throwable {
        if (transactionAttribute.rollbackOn(throwable)) {
            try {
                platformTransactionManager.rollback(transactionStatus);
            }
            catch (TransactionSystemException tse) {
                _log.error((Object)"Application exception overridden by rollback exception", (Throwable)tse);
                throw tse;
            }
            catch (RuntimeException re) {
                _log.error((Object)"Application exception overridden by rollback exception", (Throwable)re);
                throw re;
            }
            catch (Error e) {
                _log.error((Object)"Application exception overridden by rollback error", (Throwable)e);
                throw e;
            }
            finally {
                if (transactionStatus.isNewTransaction()) {
                    this.fireTransactionRollbackedEvent(transactionAttribute, transactionStatus, throwable);
                }
            }
        } else {
            this.processCommit(platformTransactionManager, transactionAttribute, transactionStatus);
        }
        throw throwable;
    }
}

