/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionAttribute;
import com.liferay.portal.kernel.transaction.TransactionLifecycleManager;
import com.liferay.portal.kernel.transaction.TransactionStatus;
import com.liferay.portal.spring.transaction.TransactionExecutor;
import org.springframework.transaction.interceptor.TransactionAttribute;

public abstract class BaseTransactionExecutor
implements TransactionExecutor {
    protected com.liferay.portal.kernel.transaction.TransactionAttribute createTransactionAttribute(TransactionAttribute transactionAttribute) {
        TransactionAttribute.Builder builder = new TransactionAttribute.Builder();
        builder.setIsolation(Isolation.getIsolation((int)transactionAttribute.getIsolationLevel()));
        builder.setPropagation(Propagation.getPropagation((int)transactionAttribute.getPropagationBehavior()));
        builder.setReadOnly(transactionAttribute.isReadOnly());
        return builder.build();
    }

    protected TransactionStatus createTransactionStatus(org.springframework.transaction.TransactionStatus transactionStatus) {
        return new TransactionStatus(transactionStatus.isNewTransaction(), transactionStatus.isRollbackOnly(), transactionStatus.isCompleted());
    }

    protected void fireTransactionCommittedEvent(TransactionAttribute transactionAttribute, org.springframework.transaction.TransactionStatus transactionStatus) {
        TransactionLifecycleManager.fireTransactionCommittedEvent((com.liferay.portal.kernel.transaction.TransactionAttribute)this.createTransactionAttribute(transactionAttribute), (TransactionStatus)this.createTransactionStatus(transactionStatus));
    }

    protected void fireTransactionCreatedEvent(TransactionAttribute transactionAttribute, org.springframework.transaction.TransactionStatus transactionStatus) {
        TransactionLifecycleManager.fireTransactionCreatedEvent((com.liferay.portal.kernel.transaction.TransactionAttribute)this.createTransactionAttribute(transactionAttribute), (TransactionStatus)this.createTransactionStatus(transactionStatus));
    }

    protected void fireTransactionRollbackedEvent(TransactionAttribute transactionAttribute, org.springframework.transaction.TransactionStatus transactionStatus, Throwable throwable) {
        TransactionLifecycleManager.fireTransactionRollbackedEvent((com.liferay.portal.kernel.transaction.TransactionAttribute)this.createTransactionAttribute(transactionAttribute), (TransactionStatus)this.createTransactionStatus(transactionStatus), (Throwable)throwable);
    }
}

