/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.remoting;

import com.liferay.portal.PwdEncryptorException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.pwd.PasswordEncryptorUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import org.apache.commons.codec.binary.Base64;
import org.springframework.remoting.httpinvoker.SimpleHttpInvokerRequestExecutor;

public class AuthenticatingHttpInvokerRequestExecutor
extends SimpleHttpInvokerRequestExecutor {
    private String _password;
    private long _userId;

    public String getPassword() {
        return this._password;
    }

    public long getUserId() {
        return this._userId;
    }

    public void setPassword(String password) throws PwdEncryptorException {
        this._password = PasswordEncryptorUtil.encrypt(password);
    }

    public void setUserId(long userId) {
        this._userId = userId;
    }

    protected void prepareConnection(HttpURLConnection con, int contentLength) throws IOException {
        super.prepareConnection(con, contentLength);
        if (this.getUserId() > 0L) {
            String password = GetterUtil.getString((String)this.getPassword());
            String base64 = this.getUserId() + ":" + password;
            con.setRequestProperty("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])base64.getBytes())));
        }
    }
}

