/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import com.liferay.portal.dao.orm.hibernate.event.MVCCSynchronizerPostUpdateEventListener;
import com.liferay.portal.dao.orm.hibernate.event.NestableAutoFlushEventListener;
import com.liferay.portal.dao.shard.ShardSpringSessionContext;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import com.liferay.portal.kernel.util.Converter;
import com.liferay.portal.kernel.util.PreloadClassLoader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.hibernate.DialectDetector;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javassist.util.proxy.ProxyFactory;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.event.AutoFlushEventListener;
import org.hibernate.event.EventListeners;
import org.hibernate.event.PostUpdateEventListener;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

public class PortalHibernateConfiguration
extends LocalSessionFactoryBean
implements BeanFactoryAware {
    private static final String[] _PRELOAD_CLASS_NAMES = PropsValues.SPRING_HIBERNATE_CONFIGURATION_PROXY_FACTORY_PRELOAD_CLASSLOADER_CLASSES;
    private static Log _log = LogFactoryUtil.getLog(PortalHibernateConfiguration.class);
    private static Map<ProxyFactory, ClassLoader> _proxyFactoryClassLoaders = new WeakHashMap<ProxyFactory, ClassLoader>();
    private BeanFactory _beanFactory;
    private Converter<String> _hibernateConfigurationConverter;
    private boolean _mvccEnabled = true;
    private boolean _shardEnabled = true;

    public SessionFactory buildSessionFactory() throws Exception {
        this.setBeanClassLoader(this.getConfigurationClassLoader());
        return super.buildSessionFactory();
    }

    public void destroy() throws HibernateException {
        this.setBeanClassLoader(null);
        super.destroy();
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this._beanFactory = beanFactory;
    }

    public void setHibernateConfigurationConverter(Converter<String> hibernateConfigurationConverter) {
        this._hibernateConfigurationConverter = hibernateConfigurationConverter;
    }

    public void setMvccEnabled(boolean mvccEnabled) {
        this._mvccEnabled = mvccEnabled;
    }

    public void setShardEnabled(boolean shardEnabled) {
        this._shardEnabled = shardEnabled;
    }

    protected static Map<String, Class<?>> getPreloadClassLoaderClasses() {
        try {
            HashMap classes = new HashMap();
            for (String className : _PRELOAD_CLASS_NAMES) {
                ClassLoader portalClassLoader = ClassLoaderUtil.getPortalClassLoader();
                Class<?> clazz = portalClassLoader.loadClass(className);
                classes.put(className, clazz);
            }
            return classes;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }

    protected Dialect determineDialect() {
        return DialectDetector.getDialect(this.getDataSource());
    }

    protected ClassLoader getConfigurationClassLoader() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return clazz.getClassLoader();
    }

    protected String[] getConfigurationResources() {
        return PropsUtil.getArray("hibernate.configs");
    }

    protected Configuration newConfiguration() {
        Configuration configuration = new Configuration();
        try {
            DB db;
            String dbType;
            String[] resources;
            for (String resource : resources = this.getConfigurationResources()) {
                try {
                    this.readResource(configuration, resource);
                }
                catch (Exception e2) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)e2, (Throwable)e2);
                }
            }
            Properties properties = PropsUtil.getProperties();
            if (SPIUtil.isSPI()) {
                properties.put("hibernate.cache.use_query_cache", Boolean.FALSE.toString());
                properties.put("hibernate.cache.use_second_level_cache", Boolean.FALSE.toString());
            }
            configuration.setProperties(properties);
            if (Validator.isNull((String)PropsValues.HIBERNATE_DIALECT)) {
                Dialect dialect = this.determineDialect();
                this.setDB(dialect);
                Class<?> clazz = dialect.getClass();
                configuration.setProperty("hibernate.dialect", clazz.getName());
            }
            if ((dbType = (db = DBFactoryUtil.getDB()).getType()).equals("hypersonic")) {
                // empty if block
            }
            if (this._mvccEnabled) {
                EventListeners eventListeners = configuration.getEventListeners();
                eventListeners.setAutoFlushEventListeners(new AutoFlushEventListener[]{NestableAutoFlushEventListener.INSTANCE});
                eventListeners.setPostUpdateEventListeners(new PostUpdateEventListener[]{MVCCSynchronizerPostUpdateEventListener.INSTANCE});
            }
        }
        catch (Exception e1) {
            _log.error((Object)e1, (Throwable)e1);
        }
        Properties hibernateProperties = this.getHibernateProperties();
        if (this._shardEnabled && this._beanFactory.containsBean(ShardUtil.class.getName())) {
            hibernateProperties.setProperty("hibernate.current_session_context_class", ShardSpringSessionContext.class.getName());
        }
        for (Map.Entry<Object, Object> entry : hibernateProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            configuration.setProperty(key, value);
        }
        return configuration;
    }

    protected void postProcessConfiguration(Configuration configuration) {
        String connectionReleaseMode = PropsUtil.get("hibernate.connection.release_mode");
        if (Validator.isNotNull((String)connectionReleaseMode)) {
            configuration.setProperty("hibernate.connection.release_mode", connectionReleaseMode);
        }
    }

    protected void readResource(Configuration configuration, InputStream inputStream) throws Exception {
        if (inputStream == null) {
            return;
        }
        if (this._hibernateConfigurationConverter != null) {
            String configurationString = StringUtil.read((InputStream)inputStream);
            configurationString = (String)this._hibernateConfigurationConverter.convert((Object)configurationString);
            inputStream = new UnsyncByteArrayInputStream(configurationString.getBytes());
        }
        configuration = configuration.addInputStream(inputStream);
        inputStream.close();
    }

    protected void readResource(Configuration configuration, String resource) throws Exception {
        ClassLoader classLoader = this.getConfigurationClassLoader();
        if (resource.startsWith("classpath*:")) {
            String name = resource.substring("classpath*:".length());
            Enumeration<URL> enu = classLoader.getResources(name);
            if (_log.isDebugEnabled() && !enu.hasMoreElements()) {
                _log.debug((Object)("No resources found for " + name));
            }
            while (enu.hasMoreElements()) {
                URL url = enu.nextElement();
                InputStream inputStream = url.openStream();
                this.readResource(configuration, inputStream);
            }
        } else {
            InputStream inputStream = classLoader.getResourceAsStream(resource);
            this.readResource(configuration, inputStream);
        }
    }

    protected void setDB(Dialect dialect) {
        DBFactoryUtil.setDB((Object)dialect);
    }

    static {
        ProxyFactory.classLoaderProvider = new ProxyFactory.ClassLoaderProvider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ClassLoader get(ProxyFactory proxyFactory) {
                Map map = _proxyFactoryClassLoaders;
                synchronized (map) {
                    ClassLoader contextClassLoader;
                    ClassLoader classLoader = (ClassLoader)_proxyFactoryClassLoaders.get(proxyFactory);
                    if (classLoader != null) {
                        return classLoader;
                    }
                    classLoader = ClassLoaderUtil.getPortalClassLoader();
                    if (classLoader != (contextClassLoader = ClassLoaderUtil.getContextClassLoader())) {
                        classLoader = new PreloadClassLoader(contextClassLoader, PortalHibernateConfiguration.getPreloadClassLoaderClasses());
                    }
                    _proxyFactoryClassLoaders.put(proxyFactory, classLoader);
                    return classLoader;
                }
            }
        };
    }
}

