/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.transaction.TransactionAttribute;
import com.liferay.portal.kernel.transaction.TransactionLifecycleListener;
import com.liferay.portal.kernel.transaction.TransactionStatus;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import org.hibernate.Session;

public class LastSessionRecorderUtil {
    public static final TransactionLifecycleListener TRANSACTION_LIFECYCLE_LISTENER = new TransactionLifecycleListener(){

        public void committed(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
        }

        public void created(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
            LastSessionRecorderUtil.syncLastSessionState();
        }

        public void rollbacked(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus, Throwable throwable) {
        }
    };
    private static ThreadLocal<Session> _lastSessionThreadLocal = new AutoResetThreadLocal(LastSessionRecorderUtil.class.getName() + "._lastSessionThreadLocal");

    public static void syncLastSessionState() {
        Session session = _lastSessionThreadLocal.get();
        if (session != null && session.isOpen()) {
            try {
                session.flush();
                session.clear();
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
    }

    protected static void setLastSession(Session session) {
        _lastSessionThreadLocal.set(session);
    }
}

