/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Converter;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.Iterator;
import java.util.Map;

public class HibernateConfigurationConverter
implements Converter<String> {
    private static Log _log = LogFactoryUtil.getLog(HibernateConfigurationConverter.class);
    private Map<String, String> _classNames;

    public String convert(String input) {
        String output = input;
        try {
            output = this.doConvert(input);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return output;
    }

    public void setClassNames(Map<String, String> classNames) {
        this._classNames = classNames;
    }

    protected String doConvert(String input) throws Exception {
        if (this._classNames == null || this._classNames.isEmpty()) {
            return input;
        }
        Document document = SAXReaderUtil.read((String)input);
        Element rootElement = document.getRootElement();
        Iterator itr = rootElement.elementIterator("class");
        while (itr.hasNext()) {
            Element classElement = (Element)itr.next();
            String oldName = classElement.attributeValue("name");
            String newName = this._classNames.get(oldName);
            if (newName == null) continue;
            classElement.addAttribute("name", newName);
        }
        return document.asXML();
    }
}

