/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.FileNotFoundException;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class TunnelApplicationContext
extends XmlWebApplicationContext {
    private static Log _log = LogFactoryUtil.getLog(TunnelApplicationContext.class);

    public void setParent(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            BeanLocatorImpl beanLocatorImpl = (BeanLocatorImpl)PortalBeanLocatorUtil.getBeanLocator();
            applicationContext = beanLocatorImpl.getApplicationContext();
        }
        super.setParent(applicationContext);
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader xmlBeanDefinitionReader) {
        String[] configLocations = this.getConfigLocations();
        if (configLocations == null) {
            return;
        }
        for (String configLocation : configLocations) {
            try {
                xmlBeanDefinitionReader.loadBeanDefinitions(configLocation);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof FileNotFoundException) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)cause.getMessage());
                    continue;
                }
                _log.error((Object)e, (Throwable)e);
            }
        }
    }
}

