/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.cache.ehcache.ClearEhcacheThreadUtil;
import com.liferay.portal.deploy.hot.IndexerPostProcessorRegistry;
import com.liferay.portal.deploy.hot.SchedulerEntryRegistry;
import com.liferay.portal.deploy.hot.ServiceWrapperRegistry;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.cache.ThreadLocalCacheManager;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.deploy.DeployManagerUtil;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.exception.LoggedExceptionInInitializerError;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.servlet.DirectServletRegistryUtil;
import com.liferay.portal.kernel.servlet.SerializableSessionAttributeListener;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.util.CharBufferPool;
import com.liferay.portal.kernel.util.ClassLoaderPool;
import com.liferay.portal.kernel.util.ClearThreadLocalUtil;
import com.liferay.portal.kernel.util.ClearTimerThreadUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.MethodCache;
import com.liferay.portal.kernel.util.PortalLifecycle;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import com.liferay.portal.module.framework.ModuleFrameworkUtilAdapter;
import com.liferay.portal.security.lang.SecurityManagerUtil;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portal.spring.bean.BeanReferenceRefreshUtil;
import com.liferay.portal.spring.context.PortalContextLoaderLifecycleThreadLocal;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portlet.PortletContextBagPool;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class PortalContextLoaderListener
extends ContextLoaderListener {
    private static final Field _FILTERED_PROPERTY_DESCRIPTORS_CACHE_FIELD;
    private static Log _log;
    private static String _portalServletContextName;
    private static String _portalServletContextPath;
    private IndexerPostProcessorRegistry _indexerPostProcessorRegistry;
    private SchedulerEntryRegistry _schedulerEntryRegistry;
    private ServiceWrapperRegistry _serviceWrapperRegistry;

    public static String getPortalServletContextName() {
        return _portalServletContextName;
    }

    public static String getPortalServletContextPath() {
        return _portalServletContextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        PortalContextLoaderLifecycleThreadLocal.setDestroying(true);
        ThreadLocalCacheManager.destroy();
        try {
            ClearThreadLocalUtil.clearThreadLocal();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            ClearTimerThreadUtil.clearTimerThread();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            ClearEhcacheThreadUtil.clearEhcacheReplicationThread();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            DirectServletRegistryUtil.clearServlets();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            HotDeployUtil.reset();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        this._indexerPostProcessorRegistry.close();
        this._schedulerEntryRegistry.close();
        this._serviceWrapperRegistry.close();
        try {
            ModuleFrameworkUtilAdapter.stopRuntime();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            PortalLifecycleUtil.reset();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            SettingsFactoryUtil.clearCache();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            super.contextDestroyed(servletContextEvent);
            try {
                ModuleFrameworkUtilAdapter.stopFramework();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        finally {
            PortalContextLoaderLifecycleThreadLocal.setDestroying(false);
            SecurityManagerUtil.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        SystemProperties.reload();
        DBFactoryUtil.reset();
        DeployManagerUtil.reset();
        InstancePool.reset();
        MethodCache.reset();
        PortalBeanLocatorUtil.reset();
        PortletBagPool.reset();
        ReferenceRegistry.releaseReferences();
        InitUtil.init();
        final ServletContext servletContext = servletContextEvent.getServletContext();
        _portalServletContextName = servletContext.getServletContextName();
        if (_portalServletContextName == null) {
            _portalServletContextName = "";
        }
        if (ServerDetector.isJetty() && _portalServletContextName.equals("/")) {
            _portalServletContextName = "";
        }
        _portalServletContextPath = servletContext.getContextPath();
        if (ServerDetector.isWebSphere() && _portalServletContextPath.isEmpty()) {
            _portalServletContextName = "";
        }
        ClassPathUtil.initializeClassPaths((ServletContext)servletContext);
        CacheRegistryUtil.clear();
        CharBufferPool.cleanUp();
        PortletContextBagPool.clear();
        WebAppPool.clear();
        File tempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        PropsValues.LIFERAY_WEB_PORTAL_CONTEXT_TEMPDIR = tempDir.getAbsolutePath();
        try {
            ModuleFrameworkUtilAdapter.startFramework();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        PortalContextLoaderLifecycleThreadLocal.setInitializing(true);
        try {
            super.contextInitialized(servletContextEvent);
        }
        finally {
            PortalContextLoaderLifecycleThreadLocal.setInitializing(false);
        }
        WebApplicationContext applicationContext = ContextLoader.getCurrentWebApplicationContext();
        try {
            BeanReferenceRefreshUtil.refresh((BeanFactory)applicationContext);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (PropsValues.CACHE_CLEAR_ON_CONTEXT_INITIALIZATION) {
            FinderCacheUtil.clearCache();
            FinderCacheUtil.clearLocalCache();
            EntityCacheUtil.clearCache();
            EntityCacheUtil.clearLocalCache();
            PermissionCacheUtil.clearCache();
            TemplateResourceLoaderUtil.clearCache();
            WikiCacheUtil.clearCache(0L);
            ServletContextPool.clear();
            CacheUtil.clearCache();
            MultiVMPoolUtil.clear();
            SingleVMPoolUtil.clear();
            WebCachePoolUtil.clear();
        }
        ClassLoader portalClassLoader = ClassLoaderUtil.getPortalClassLoader();
        ClassLoaderPool.register((String)_portalServletContextName, (ClassLoader)portalClassLoader);
        ServletContextPool.put((String)_portalServletContextName, (ServletContext)servletContext);
        BeanLocatorImpl beanLocatorImpl = new BeanLocatorImpl(portalClassLoader, (ApplicationContext)applicationContext);
        PortalBeanLocatorUtil.setBeanLocator((BeanLocator)beanLocatorImpl);
        for (ClassLoader classLoader = portalClassLoader; classLoader != null; classLoader = classLoader.getParent()) {
            CachedIntrospectionResults.clearClassLoader((ClassLoader)classLoader);
        }
        AutowireCapableBeanFactory autowireCapableBeanFactory = applicationContext.getAutowireCapableBeanFactory();
        this.clearFilteredPropertyDescriptorsCache(autowireCapableBeanFactory);
        this._indexerPostProcessorRegistry = new IndexerPostProcessorRegistry();
        this._schedulerEntryRegistry = new SchedulerEntryRegistry();
        this._serviceWrapperRegistry = new ServiceWrapperRegistry();
        try {
            PortalLifecycleUtil.register((PortalLifecycle)new PortalLifecycle(){

                public void portalInit() {
                    ModuleFrameworkUtilAdapter.registerContext(servletContext);
                }

                public void portalDestroy() {
                }
            });
            ModuleFrameworkUtilAdapter.registerContext(applicationContext);
            ModuleFrameworkUtilAdapter.startRuntime();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.initListeners(servletContext);
    }

    protected void clearFilteredPropertyDescriptorsCache(AutowireCapableBeanFactory autowireCapableBeanFactory) {
        try {
            Map filteredPropertyDescriptorsCache = (Map)_FILTERED_PROPERTY_DESCRIPTORS_CACHE_FIELD.get(autowireCapableBeanFactory);
            filteredPropertyDescriptorsCache.clear();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void initListeners(ServletContext servletContext) {
        if (PropsValues.SESSION_VERIFY_SERIALIZABLE_ATTRIBUTE) {
            servletContext.addListener(SerializableSessionAttributeListener.class);
        }
    }

    static {
        _log = LogFactoryUtil.getLog(PortalContextLoaderListener.class);
        _portalServletContextName = "";
        _portalServletContextPath = "/";
        try {
            _FILTERED_PROPERTY_DESCRIPTORS_CACHE_FIELD = ReflectionUtil.getDeclaredField(AbstractAutowireCapableBeanFactory.class, (String)"filteredPropertyDescriptorsCache");
        }
        catch (Exception e) {
            throw new LoggedExceptionInInitializerError((Throwable)e);
        }
    }
}

