/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.sharepoint;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.sharepoint.SharepointException;
import com.liferay.portal.sharepoint.SharepointRequest;
import com.liferay.portal.sharepoint.SharepointStorage;
import com.liferay.portal.sharepoint.SharepointUtil;
import com.liferay.portal.sharepoint.methods.Method;
import com.liferay.portal.sharepoint.methods.MethodFactory;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SharepointServlet
extends HttpServlet {
    private static Log _log = LogFactoryUtil.getLog(SharepointServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)(request.getHeader("User-Agent") + " " + request.getMethod() + " " + request.getRequestURI()));
        }
        try {
            String uri = request.getRequestURI();
            if (uri.equals("/_vti_inf.html")) {
                this.vtiInfHtml(response);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String uri = request.getRequestURI();
            if (uri.equals("/_vti_bin/shtml.dll/_vti_rpc") || uri.equals("/sharepoint/_vti_bin/_vti_aut/author.dll")) {
                User user = (User)request.getSession().getAttribute("USER");
                SharepointRequest sharepointRequest = new SharepointRequest(request, response, user);
                Method method = MethodFactory.create(sharepointRequest);
                String rootPath = method.getRootPath(sharepointRequest);
                if (rootPath == null) {
                    throw new SharepointException("Unabled to get root path");
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Original root path " + rootPath));
                }
                rootPath = WebDAVUtil.stripManualCheckInRequiredPath((String)rootPath);
                rootPath = WebDAVUtil.stripOfficeExtension((String)rootPath);
                rootPath = SharepointUtil.stripService(rootPath, true);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Modified root path " + rootPath));
                }
                sharepointRequest.setRootPath(rootPath);
                SharepointStorage storage = SharepointUtil.getStorage(rootPath);
                sharepointRequest.setSharepointStorage(storage);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)(request.getHeader("User-Agent") + " " + method.getMethodName() + " " + uri + " " + rootPath));
                }
                method.process(sharepointRequest);
            } else if (_log.isInfoEnabled()) {
                _log.info((Object)(request.getHeader("User-Agent") + " " + request.getMethod() + " " + uri));
            }
        }
        catch (SharepointException se) {
            _log.error((Object)se, (Throwable)((Object)se));
        }
    }

    protected void vtiInfHtml(HttpServletResponse response) throws Exception {
        StringBundler sb = new StringBundler(13);
        sb.append("<!-- FrontPage Configuration Information");
        sb.append("\n");
        sb.append(" FPVersion=\"6.0.2.9999\"");
        sb.append("\n");
        sb.append("FPShtmlScriptUrl=\"_vti_bin/shtml.dll/_vti_rpc\"");
        sb.append("\n");
        sb.append("FPAuthorScriptUrl=\"_vti_bin/_vti_aut/author.dll\"");
        sb.append("\n");
        sb.append("FPAdminScriptUrl=\"_vti_bin/_vti_adm/admin.dll\"");
        sb.append("\n");
        sb.append("TPScriptUrl=\"_vti_bin/owssvr.dll\"");
        sb.append("\n");
        sb.append("-->");
        ServletResponseUtil.write((HttpServletResponse)response, (String)sb.toString());
    }
}

