/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.setup;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.ListTypeConstants;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.service.AccountLocalServiceUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.Locale;
import org.apache.commons.lang.time.StopWatch;

public class SetupWizardSampleDataUtil {
    private static Object[][] _ORGANIZATION_ARRAYS = new Object[][]{{"Chicago", 19014L, 19L, "location", "ORD"}, {"Consulting", 19005L, 19L, "regular-organization"}, {"Dalian", 0L, 2L, "location", "DLC"}, {"Engineering", 19005L, 19L, "regular-organization"}, {"Frankfurt", 0L, 4L, "location", "FRA"}, {"Hong Kong", 0L, 2L, "location", "HKG"}, {"Kuala Lumpur", 0L, 135L, "location", "KUL"}, {"Los Angeles", 19005L, 19L, "location", "LAX"}, {"Madrid", 0L, 15L, "location", "MAD"}, {"Marketing", 19005L, 19L, "regular-organization"}, {"New York", 19033L, 19L, "location", "NYC"}, {"Saint Paulo", 0L, 48L, "location", "GRU"}, {"Sales", 19005L, 19L, "regular-organization"}, {"San Francisco", 19005L, 19L, "location", "SFO"}, {"Support", 19005L, 19L, "regular-organization"}};
    private static Log _log = LogFactoryUtil.getLog(SetupWizardSampleDataUtil.class);

    public static void addSampleData(long companyId) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Adding sample data");
        }
        Company company = CompanyLocalServiceUtil.getCompanyById((long)companyId);
        Account account = company.getAccount();
        account.setName("Liferay");
        account.setLegalName("Liferay, Inc");
        AccountLocalServiceUtil.updateAccount((Account)account);
        User defaultUser = company.getDefaultUser();
        Organization organization = OrganizationLocalServiceUtil.addOrganization((long)defaultUser.getUserId(), (long)0L, (String)"Liferay, Inc.", (boolean)true);
        GroupLocalServiceUtil.updateFriendlyURL((long)organization.getGroupId(), (String)"/liferay");
        Layout extranetLayout = LayoutLocalServiceUtil.addLayout((long)defaultUser.getUserId(), (long)organization.getGroupId(), (boolean)false, (long)0L, (String)"Liferay, Inc. Extranet", null, null, (String)"portlet", (boolean)false, (String)"/extranet", (ServiceContext)new ServiceContext());
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)extranetLayout.getLayoutType();
        layoutTypePortlet.addPortletId(0L, "3", "column-1", -1, false);
        layoutTypePortlet.addPortletId(0L, "19", "column-2", -1, false);
        LayoutLocalServiceUtil.updateLayout((long)extranetLayout.getGroupId(), (boolean)false, (long)extranetLayout.getLayoutId(), (String)extranetLayout.getTypeSettings());
        Layout intranetLayout = LayoutLocalServiceUtil.addLayout((long)defaultUser.getUserId(), (long)organization.getGroupId(), (boolean)true, (long)0L, (String)"Liferay, Inc. Intranet", null, null, (String)"portlet", (boolean)false, (String)"/intranet", (ServiceContext)new ServiceContext());
        layoutTypePortlet = (LayoutTypePortlet)intranetLayout.getLayoutType();
        layoutTypePortlet.addPortletId(0L, "3", "column-1", -1, false);
        layoutTypePortlet.addPortletId(0L, "19", "column-2", -1, false);
        LayoutLocalServiceUtil.updateLayout((long)intranetLayout.getGroupId(), (boolean)true, (long)intranetLayout.getLayoutId(), (String)intranetLayout.getTypeSettings());
        User user = UserLocalServiceUtil.fetchUserByEmailAddress((long)company.getCompanyId(), (String)"test@liferay.com");
        if (user == null) {
            user = UserLocalServiceUtil.addDefaultAdminUser((long)companyId, (String)"joebloggs", (String)"test@liferay.com", (Locale)LocaleUtil.getDefault(), (String)"Joe", (String)"", (String)"Bloggs");
        } else {
            user.setScreenName("joebloggs");
            user.setGreeting("Welcome Joe Bloggs!");
            user.setFirstName("Joe");
            user.setLastName("Bloggs");
        }
        user.setPasswordReset(false);
        UserLocalServiceUtil.updateUser((User)user);
        OrganizationLocalServiceUtil.addUserOrganization((long)user.getUserId(), (Organization)organization);
        SetupWizardSampleDataUtil.addOrganizations(defaultUser, organization);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Finished adding data in " + stopWatch.getTime() + " ms"));
        }
    }

    protected static void addOrganizations(User defaultUser, Organization parentOrganization) throws Exception {
        for (Object[] organizationArray : _ORGANIZATION_ARRAYS) {
            String name = "Liferay " + organizationArray[0];
            long regionId = (Long)organizationArray[1];
            long countryId = (Long)organizationArray[2];
            String type = (String)organizationArray[3];
            Organization organization = OrganizationLocalServiceUtil.addOrganization((long)defaultUser.getUserId(), (long)parentOrganization.getOrganizationId(), (String)name, (String)type, (long)regionId, (long)countryId, (int)ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, (String)"", (boolean)true, null);
            GroupLocalServiceUtil.updateFriendlyURL((long)organization.getGroupId(), (String)FriendlyURLNormalizerUtil.normalize((String)("/" + organizationArray[0])));
            if (organizationArray.length <= 4) continue;
            String organizationPrefix = (String)organizationArray[4];
            long[] groupIds = new long[]{organization.getGroupId()};
            long[] organizationIds = new long[]{parentOrganization.getOrganizationId(), organization.getOrganizationId()};
            for (int i = 1; i <= 10; ++i) {
                String screenName = organizationPrefix + i;
                StringBundler sb = new StringBundler(4);
                sb.append("test.");
                sb.append(organizationPrefix);
                sb.append(".");
                sb.append(i);
                sb.append("@liferay.com");
                String emailAddress = sb.toString();
                String lastName = organizationPrefix + " " + i;
                User user = UserLocalServiceUtil.addUser((long)0L, (long)defaultUser.getCompanyId(), (boolean)false, (String)"test", (String)"test", (boolean)false, (String)screenName, (String)emailAddress, (long)0L, null, (Locale)LocaleUtil.getDefault(), (String)"Test", null, (String)lastName, (int)0, (int)0, (boolean)true, (int)0, (int)1, (int)1970, null, (long[])groupIds, (long[])organizationIds, null, null, (boolean)false, (ServiceContext)new ServiceContext());
                user.setPasswordReset(false);
                user.setAgreedToTermsOfUse(true);
                UserLocalServiceUtil.updateUser((User)user);
            }
        }
    }
}

