/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.settings;

import com.liferay.portal.NoSuchPortletItemException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.settings.ArchivedSettings;
import com.liferay.portal.kernel.settings.FallbackKeys;
import com.liferay.portal.kernel.settings.FallbackSettings;
import com.liferay.portal.kernel.settings.PortletPreferencesSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletItem;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.PortalPreferencesLocalServiceUtil;
import com.liferay.portal.service.PortletItemLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.settings.ArchivedSettingsImpl;
import com.liferay.portal.settings.PropertiesSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.portlet.PortletPreferences;

@DoPrivileged
public class SettingsFactoryImpl
implements SettingsFactory {
    private ConcurrentMap<String, FallbackKeys> _fallbackKeysMap = new ConcurrentHashMap<String, FallbackKeys>();
    private ConcurrentMap<String, List<String>> _multiValuedKeysMap = new ConcurrentHashMap<String, List<String>>();
    private Map<String, Properties> _propertiesMap = new ConcurrentHashMap<String, Properties>();

    public void clearCache() {
        this._propertiesMap.clear();
    }

    public Settings getCompanyServiceSettings(long companyId, String serviceName) {
        return this.applyFallbackKeys(serviceName, this.getCompanySettings(companyId, serviceName));
    }

    public Settings getGroupServiceCompanyDefaultSettings(long companyId, String serviceName) {
        return this.applyFallbackKeys(serviceName, (Settings)new PortletPreferencesSettings(this.getCompanyPortletPreferences(companyId, serviceName)));
    }

    public Settings getGroupServiceSettings(long groupId, String serviceName) throws PortalException {
        return this.applyFallbackKeys(serviceName, this.getGroupSettings(groupId, serviceName));
    }

    public List<String> getMultiValuedKeys(String settingsId) {
        List multiValuedKeys = (List)this._multiValuedKeysMap.get(settingsId = PortletConstants.getRootPortletId((String)settingsId));
        if (multiValuedKeys == null) {
            throw new IllegalStateException("No multi valued keys found for settings ID " + settingsId);
        }
        return multiValuedKeys;
    }

    public ArchivedSettings getPortletInstanceArchivedSettings(long groupId, String portletId, String name) throws PortalException {
        PortletItem portletItem = null;
        try {
            portletItem = PortletItemLocalServiceUtil.getPortletItem((long)groupId, (String)name, (String)portletId, (String)PortletPreferences.class.getName());
        }
        catch (NoSuchPortletItemException nspie) {
            long userId = PrincipalThreadLocal.getUserId();
            portletItem = PortletItemLocalServiceUtil.updatePortletItem((long)userId, (long)groupId, (String)name, (String)portletId, (String)PortletPreferences.class.getName());
        }
        return new ArchivedSettingsImpl(portletItem);
    }

    public List<ArchivedSettings> getPortletInstanceArchivedSettingsList(long groupId, String portletId) {
        ArrayList<ArchivedSettings> archivedSettingsList = new ArrayList<ArchivedSettings>();
        List portletItems = PortletItemLocalServiceUtil.getPortletItems((long)groupId, (String)portletId, (String)com.liferay.portal.model.PortletPreferences.class.getName());
        for (PortletItem portletItem : portletItems) {
            archivedSettingsList.add(new ArchivedSettingsImpl(portletItem));
        }
        return archivedSettingsList;
    }

    public Settings getPortletInstanceCompanyDefaultSettings(long companyId, String portletId) {
        return this.applyFallbackKeys(PortletConstants.getRootPortletId((String)portletId), (Settings)new PortletPreferencesSettings(this.getCompanyPortletPreferences(companyId, portletId)));
    }

    public Settings getPortletInstanceGroupDefaultSettings(long groupId, String portletId) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        return this.applyFallbackKeys(PortletConstants.getRootPortletId((String)portletId), (Settings)new PortletPreferencesSettings(this.getGroupPortletPreferences(group.getCompanyId(), groupId, portletId)));
    }

    public Settings getPortletInstanceSettings(Layout layout, String portletId) throws PortalException {
        return this.applyFallbackKeys(PortletConstants.getRootPortletId((String)portletId), (Settings)new PortletPreferencesSettings(this.getPortletInstancePortletPreferences(layout, portletId), this.getGroupSettings(layout.getGroupId(), portletId)));
    }

    public void registerSettingsMetadata(String settingsId, FallbackKeys fallbackKeys, String[] multiValuedKeysArray) {
        if (this._multiValuedKeysMap.get(settingsId = PortletConstants.getRootPortletId((String)settingsId)) != null) {
            throw new IllegalStateException("Unable to overwrite multi valued keys for " + settingsId);
        }
        this._fallbackKeysMap.put(settingsId, fallbackKeys);
        List multiValuedKeysList = new ArrayList();
        Collections.addAll(multiValuedKeysList, multiValuedKeysArray);
        multiValuedKeysList = Collections.unmodifiableList(multiValuedKeysList);
        this._multiValuedKeysMap.put(settingsId, multiValuedKeysList);
    }

    protected Settings applyFallbackKeys(String settingsId, Settings settings) {
        if (settings instanceof FallbackKeys) {
            return settings;
        }
        FallbackKeys fallbackKeys = (FallbackKeys)this._fallbackKeysMap.get(settingsId);
        if (fallbackKeys != null) {
            settings = new FallbackSettings(settings, fallbackKeys);
        }
        return settings;
    }

    protected PortletPreferences getCompanyPortletPreferences(long companyId, String settingsId) {
        return PortletPreferencesLocalServiceUtil.getStrictPreferences((long)companyId, (long)companyId, (int)1, (long)0L, (String)settingsId);
    }

    protected Settings getCompanySettings(long companyId, String settingsId) {
        return new PortletPreferencesSettings(this.getCompanyPortletPreferences(companyId, settingsId), (Settings)this.getPortalPreferencesSettings(companyId, settingsId));
    }

    protected PortletPreferences getGroupPortletPreferences(long companyId, long groupId, String settingsId) {
        return PortletPreferencesLocalServiceUtil.getStrictPreferences((long)companyId, (long)groupId, (int)2, (long)0L, (String)settingsId);
    }

    protected Settings getGroupSettings(long groupId, String settingsId) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        long companyId = group.getCompanyId();
        return new PortletPreferencesSettings(this.getGroupPortletPreferences(companyId, groupId, settingsId), this.getCompanySettings(companyId, settingsId));
    }

    protected PortletPreferences getPortalPreferences(long companyId) {
        return PortalPreferencesLocalServiceUtil.getPreferences((long)companyId, (int)1);
    }

    protected PortletPreferencesSettings getPortalPreferencesSettings(long companyId, String settingsId) {
        return new PortletPreferencesSettings(this.getPortalPreferences(companyId), (Settings)this.getPortalPropertiesSettings(settingsId));
    }

    protected Properties getPortalProperties(String settingsId) {
        Properties portalProperties = this._propertiesMap.get(settingsId);
        if (portalProperties != null) {
            return portalProperties;
        }
        portalProperties = PropsUtil.getProperties();
        this._propertiesMap.put(settingsId, portalProperties);
        return portalProperties;
    }

    protected PropertiesSettings getPortalPropertiesSettings(String settingsId) {
        return new PropertiesSettings(this.getPortalProperties(settingsId));
    }

    protected PortletPreferences getPortletInstancePortletPreferences(Layout layout, String portletId) {
        long ownerId = 0L;
        int ownerType = 3;
        if (PortletConstants.hasUserId((String)portletId)) {
            ownerId = PortletConstants.getUserId((String)portletId);
            ownerType = 4;
        }
        return PortletPreferencesLocalServiceUtil.getStrictPreferences((long)layout.getCompanyId(), (long)ownerId, (int)ownerType, (long)layout.getPlid(), (String)portletId);
    }
}

