/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.settings;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.settings.ArchivedSettings;
import com.liferay.portal.kernel.settings.BaseModifiableSettings;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.PortletPreferencesSettings;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletItem;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesServiceUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import javax.portlet.PortletPreferences;
import javax.portlet.ValidatorException;

public class ArchivedSettingsImpl
extends BaseModifiableSettings
implements ArchivedSettings {
    private PortletItem _portletItem;
    private PortletPreferencesSettings _portletPreferencesSettings;

    public ArchivedSettingsImpl(PortletItem portletItem) {
        this._portletItem = portletItem;
    }

    public void delete() throws IOException {
        try {
            PortletPreferencesServiceUtil.deleteArchivedPreferences((long)this._portletItem.getPortletItemId());
        }
        catch (PortalException pe) {
            throw new IOException("Unable to delete archived settings", pe);
        }
        catch (SystemException se) {
            throw new IOException("Unable to delete archived settings", se);
        }
    }

    public Date getModifiedDate() {
        return this._portletItem.getModifiedDate();
    }

    public Collection<String> getModifiedKeys() {
        ModifiableSettings modifiableSettings = this._getModifiableSettings();
        return modifiableSettings.getModifiedKeys();
    }

    public String getName() {
        return this._portletItem.getName();
    }

    public String getUserName() {
        return this._portletItem.getUserName();
    }

    public void reset(String key) {
        ModifiableSettings modifiableSettings = this._getModifiableSettings();
        modifiableSettings.reset(key);
    }

    public ModifiableSettings setValue(String key, String value) {
        ModifiableSettings modifiableSettings = this._getModifiableSettings();
        modifiableSettings.setValue(key, value);
        return this;
    }

    public ModifiableSettings setValues(String key, String[] values) {
        ModifiableSettings modifiableSettings = this._getModifiableSettings();
        modifiableSettings.setValues(key, values);
        return this;
    }

    public void store() throws IOException, ValidatorException {
        ModifiableSettings modifiableSettings = this._getModifiableSettings();
        modifiableSettings.store();
    }

    protected String doGetValue(String key) {
        ModifiableSettings modifiableSettings = this._getModifiableSettings();
        return modifiableSettings.getValue(key, null);
    }

    protected String[] doGetValues(String key) {
        ModifiableSettings modifiableSettings = this._getModifiableSettings();
        return modifiableSettings.getValues(key, null);
    }

    private ModifiableSettings _getModifiableSettings() {
        if (this._portletPreferencesSettings != null) {
            return this._portletPreferencesSettings;
        }
        PortletPreferences portletPreferences = null;
        try {
            long ownerId = this._portletItem.getPortletItemId();
            int ownerType = 5;
            long plid = 0L;
            String portletId = this._portletItem.getPortletId();
            portletPreferences = PortletPreferencesLocalServiceUtil.getPreferences((long)this._portletItem.getCompanyId(), (long)ownerId, (int)ownerType, (long)plid, (String)PortletConstants.getRootPortletId((String)portletId));
        }
        catch (SystemException se) {
            throw new RuntimeException("Unable to load settings", se);
        }
        this._portletPreferencesSettings = new PortletPreferencesSettings(portletPreferences);
        return this._portletPreferencesSettings;
    }
}

