/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.virtualhost;

import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.servlet.I18nServlet;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webserver.WebServerServlet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class VirtualHostFilter
extends BasePortalFilter {
    private static final String _PATH_DOCUMENTS = "/documents/";
    private static final String _PATH_MODULE_SLASH = "/o/";
    private static final String _PRIVATE_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
    private static final String _PRIVATE_GROUP_SERVLET_MAPPING_SLASH = _PRIVATE_GROUP_SERVLET_MAPPING + "/";
    private static final String _PRIVATE_USER_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
    private static final String _PRIVATE_USER_SERVLET_MAPPING_SLASH = _PRIVATE_USER_SERVLET_MAPPING + "/";
    private static final String _PUBLIC_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
    private static final String _PUBLIC_GROUP_SERVLET_MAPPING_SLASH = _PUBLIC_GROUP_SERVLET_MAPPING + "/";
    private static Log _log = LogFactoryUtil.getLog(VirtualHostFilter.class);
    private ServletContext _servletContext;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._servletContext = filterConfig.getServletContext();
    }

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        StringBuffer requestURL = request.getRequestURL();
        return this.isValidRequestURL(requestURL);
    }

    protected boolean isDocumentFriendlyURL(HttpServletRequest request, long groupId, String friendlyURL) throws PortalException {
        if (friendlyURL.startsWith(_PATH_DOCUMENTS) && WebServerServlet.hasFiles(request)) {
            String path = HttpUtil.fixPath((String)request.getPathInfo());
            String[] pathArray = StringUtil.split((String)path, (char)'/');
            if (pathArray.length == 2) {
                try {
                    LayoutLocalServiceUtil.getFriendlyURLLayout((long)groupId, (boolean)false, (String)friendlyURL);
                }
                catch (NoSuchLayoutException nsle) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidFriendlyURL(String friendlyURL) {
        if (PortalInstances.isVirtualHostsIgnorePath(friendlyURL = StringUtil.toLowerCase((String)friendlyURL)) || friendlyURL.startsWith(_PATH_MODULE_SLASH) || friendlyURL.startsWith(_PRIVATE_GROUP_SERVLET_MAPPING_SLASH) || friendlyURL.startsWith(_PRIVATE_USER_SERVLET_MAPPING_SLASH) || friendlyURL.startsWith(_PUBLIC_GROUP_SERVLET_MAPPING_SLASH)) {
            return false;
        }
        if (LayoutImpl.hasFriendlyURLKeyword(friendlyURL)) {
            return false;
        }
        int code = LayoutImpl.validateFriendlyURL(friendlyURL, false);
        return code <= -1 || code == 2;
    }

    protected boolean isValidRequestURL(StringBuffer requestURL) {
        if (requestURL == null) {
            return false;
        }
        String url = requestURL.toString();
        for (String extension : PropsValues.VIRTUAL_HOSTS_IGNORE_EXTENSIONS) {
            if (!url.endsWith(extension)) continue;
            return false;
        }
        return true;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        int pos;
        String originalFriendlyURL;
        long companyId = PortalInstances.getCompanyId(request);
        String contextPath = PortalUtil.getPathContext();
        String friendlyURL = originalFriendlyURL = request.getRequestURI();
        if (Validator.isNotNull((String)contextPath) && friendlyURL.contains(contextPath)) {
            friendlyURL = friendlyURL.substring(contextPath.length());
        }
        if ((pos = friendlyURL.indexOf(";")) != -1) {
            friendlyURL = friendlyURL.substring(0, pos);
        }
        friendlyURL = StringUtil.replace((String)friendlyURL, (String)"//", (String)"/");
        String i18nLanguageId = null;
        Set<String> languageIds = I18nServlet.getLanguageIds();
        for (String languageId : languageIds) {
            if (!StringUtil.startsWith((String)friendlyURL, (String)languageId) || (pos = friendlyURL.indexOf(47, 1)) != -1 && pos != languageId.length() || pos == -1 && !StringUtil.equalsIgnoreCase((String)friendlyURL, (String)languageId)) continue;
            if (pos == -1) {
                i18nLanguageId = languageId;
                friendlyURL = "/";
                break;
            }
            i18nLanguageId = languageId.substring(0, pos);
            friendlyURL = friendlyURL.substring(pos);
            break;
        }
        friendlyURL = StringUtil.replace((String)friendlyURL, (String)PropsValues.WIDGET_SERVLET_MAPPING, (String)"");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Friendly URL " + friendlyURL));
        }
        if (!friendlyURL.equals("/") && !this.isValidFriendlyURL(friendlyURL)) {
            _log.debug((Object)"Friendly URL is not valid");
            this.processFilter(VirtualHostFilter.class, request, response, filterChain);
            return;
        }
        LayoutSet layoutSet = (LayoutSet)request.getAttribute("VIRTUAL_HOST_LAYOUT_SET");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Layout set " + layoutSet));
        }
        if (layoutSet == null) {
            this.processFilter(VirtualHostFilter.class, request, response, filterChain);
            return;
        }
        try {
            long plid;
            LastPath lastPath = new LastPath(contextPath, friendlyURL, request.getParameterMap());
            request.setAttribute("LAST_PATH", (Object)lastPath);
            StringBundler forwardURL = new StringBundler(5);
            if (i18nLanguageId != null) {
                forwardURL.append(i18nLanguageId);
            }
            if (originalFriendlyURL.startsWith(PropsValues.WIDGET_SERVLET_MAPPING)) {
                forwardURL.append(PropsValues.WIDGET_SERVLET_MAPPING);
                friendlyURL = StringUtil.replaceFirst((String)friendlyURL, (String)PropsValues.WIDGET_SERVLET_MAPPING, (String)"");
            }
            if ((plid = PortalUtil.getPlidFromFriendlyURL((long)companyId, (String)friendlyURL)) <= 0L) {
                Group group = GroupLocalServiceUtil.getGroup((long)layoutSet.getGroupId());
                if (this.isDocumentFriendlyURL(request, group.getGroupId(), friendlyURL)) {
                    this.processFilter(VirtualHostFilter.class, request, response, filterChain);
                    return;
                }
                if (group.isGuest() && friendlyURL.equals("/") && !layoutSet.isPrivateLayout()) {
                    String homeURL = PortalUtil.getRelativeHomeURL((HttpServletRequest)request);
                    if (Validator.isNotNull((String)homeURL)) {
                        friendlyURL = homeURL;
                    }
                } else {
                    if (layoutSet.isPrivateLayout()) {
                        if (group.isUser()) {
                            forwardURL.append(_PRIVATE_USER_SERVLET_MAPPING);
                        } else {
                            forwardURL.append(_PRIVATE_GROUP_SERVLET_MAPPING);
                        }
                    } else {
                        forwardURL.append(_PUBLIC_GROUP_SERVLET_MAPPING);
                    }
                    forwardURL.append(group.getFriendlyURL());
                }
            }
            forwardURL.append(friendlyURL);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Forward to " + forwardURL));
            }
            RequestDispatcher requestDispatcher = this._servletContext.getRequestDispatcher(forwardURL.toString());
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            this.processFilter(VirtualHostFilter.class, request, response, filterChain);
        }
    }
}

