/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.monitoring;

import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.monitoring.RequestStatus;
import com.liferay.portal.kernel.monitoring.statistics.DataSample;
import com.liferay.portal.kernel.monitoring.statistics.DataSampleThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.monitoring.statistics.BaseDataSample;
import com.liferay.portal.monitoring.statistics.portal.PortalRequestDataSample;
import com.liferay.portal.monitoring.statistics.service.ServiceMonitorAdvice;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.MonitoringPortlet;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MonitoringFilter
extends BasePortalFilter {
    private static boolean _monitoringPortalRequest = PropsValues.MONITORING_PORTAL_REQUEST;

    public static boolean isMonitoringPortalRequest() {
        return _monitoringPortalRequest;
    }

    public static void setMonitoringPortalRequest(boolean monitoringPortalRequest) {
        _monitoringPortalRequest = monitoringPortalRequest;
    }

    @Override
    public boolean isFilterEnabled() {
        if (!super.isFilterEnabled()) {
            return false;
        }
        return _monitoringPortalRequest || MonitoringPortlet.isMonitoringPortletActionRequest() || MonitoringPortlet.isMonitoringPortletEventRequest() || MonitoringPortlet.isMonitoringPortletRenderRequest() || MonitoringPortlet.isMonitoringPortletResourceRequest() || ServiceMonitorAdvice.isActive();
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        BaseDataSample portalRequestDataSample = null;
        if (_monitoringPortalRequest) {
            portalRequestDataSample = new PortalRequestDataSample(companyId, request.getRemoteUser(), request.getRequestURI(), GetterUtil.getString((Object)request.getRequestURL()));
            DataSampleThreadLocal.initialize();
        }
        try {
            if (portalRequestDataSample != null) {
                portalRequestDataSample.prepare();
            }
            this.processFilter(MonitoringFilter.class, request, response, filterChain);
            if (portalRequestDataSample != null) {
                portalRequestDataSample.capture(RequestStatus.SUCCESS);
            }
        }
        catch (Exception e) {
            if (portalRequestDataSample != null) {
                portalRequestDataSample.capture(RequestStatus.ERROR);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ServletException) {
                throw (ServletException)((Object)e);
            }
            throw new ServletException("Unable to execute request", (Throwable)e);
        }
        finally {
            if (portalRequestDataSample != null) {
                DataSampleThreadLocal.addDataSample((DataSample)portalRequestDataSample);
            }
            MessageBusUtil.sendMessage((String)"liferay/monitoring", (Object)DataSampleThreadLocal.getDataSamples());
        }
    }
}

