/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.etag;

import com.liferay.portal.kernel.servlet.RestrictedByteBufferCacheServletResponse;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.etag.ETagUtil;
import com.liferay.portal.util.PropsValues;
import java.nio.ByteBuffer;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ETagFilter
extends BasePortalFilter {
    public static final String SKIP_FILTER = ETagFilter.class.getName() + "SKIP_FILTER";
    private static final String _ETAG = "etag";

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        return ParamUtil.getBoolean((HttpServletRequest)request, (String)_ETAG, (boolean)true) && !this.isAlreadyFiltered(request);
    }

    protected boolean isAlreadyFiltered(HttpServletRequest request) {
        return request.getAttribute(SKIP_FILTER) != null;
    }

    protected boolean isEligibleForETag(int status) {
        return status >= 200 && status < 300;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        request.setAttribute(SKIP_FILTER, (Object)Boolean.TRUE);
        RestrictedByteBufferCacheServletResponse restrictedByteBufferCacheServletResponse = new RestrictedByteBufferCacheServletResponse(response, PropsValues.ETAG_RESPONSE_SIZE_MAX);
        this.processFilter(ETagFilter.class, request, (HttpServletResponse)restrictedByteBufferCacheServletResponse, filterChain);
        if (!restrictedByteBufferCacheServletResponse.isOverflowed()) {
            ByteBuffer byteBuffer = restrictedByteBufferCacheServletResponse.getByteBuffer();
            if (!this.isEligibleForETag(restrictedByteBufferCacheServletResponse.getStatus()) || !ETagUtil.processETag(request, response, byteBuffer)) {
                restrictedByteBufferCacheServletResponse.finishResponse();
                restrictedByteBufferCacheServletResponse.flushCache();
            }
        }
    }
}

