/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.dynamiccss;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.regex.PatternFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PropsValues;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RTLCSSUtil {
    private static Log _log = LogFactoryUtil.getLog(RTLCSSUtil.class);
    private static String _jsScript;
    private static Pattern[] _patterns;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRtlCss(String fileName, String css) throws Exception {
        Context context = Context.enter();
        String rtlCss = css;
        try {
            ScriptableObject scope = context.initStandardObjects();
            context.evaluateString((Scriptable)scope, _jsScript, "script", 1, null);
            Function function = (Function)scope.get("r2", (Scriptable)scope);
            Object result = function.call(context, (Scriptable)scope, (Scriptable)scope, new Object[]{css});
            rtlCss = (String)Context.jsToJava((Object)result, String.class);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to generate RTL version for " + fileName + ", " + e.getMessage()));
        }
        finally {
            Context.exit();
        }
        return rtlCss;
    }

    public static void init() {
        try {
            _jsScript = StringUtil.read((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (String)"com/liferay/portal/servlet/filters/dynamiccss/dependencies/r2.js");
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public static boolean isExcludedPath(String filePath) {
        for (Pattern pattern : _patterns) {
            Matcher matcher = pattern.matcher(filePath);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    static {
        _patterns = PatternFactory.compile((String[])PropsValues.RTL_CSS_EXCLUDED_PATHS_REGEXP);
    }
}

