/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.aggregate;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletContext;

public class ServletPaths {
    private static Log _log = LogFactoryUtil.getLog(ServletPaths.class);
    private String _resourcePath;
    private ServletContext _servletContext;

    public static String getParentPath(String resourcePath) {
        int pos;
        if (Validator.isNull((String)resourcePath)) {
            throw new IllegalArgumentException("Resource path is null");
        }
        if (resourcePath.charAt(resourcePath.length() - 1) == '/') {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        if ((pos = resourcePath.lastIndexOf(47)) != -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        return resourcePath;
    }

    public ServletPaths(ServletContext servletContext, String resourcePath) throws MalformedURLException {
        if (servletContext == null) {
            throw new NullPointerException("Servlet context is null");
        }
        if (Validator.isNull((String)resourcePath)) {
            throw new IllegalArgumentException("Resource path is null");
        }
        this._servletContext = servletContext;
        String rootPath = ServletContextUtil.getRootPath((ServletContext)this._servletContext);
        if (resourcePath.startsWith(rootPath)) {
            resourcePath = resourcePath.substring(rootPath.length());
        }
        this._resourcePath = resourcePath;
    }

    public ServletPaths down(String path) {
        String normalizedPath = this._normalizePath(path);
        if (normalizedPath.isEmpty()) {
            return this;
        }
        return new ServletPaths(this._resourcePath.concat(normalizedPath), this._servletContext);
    }

    public String getContent() {
        try {
            URL resourceURL = this._servletContext.getResource(this._resourcePath);
            if (resourceURL == null) {
                return null;
            }
            URLConnection urlConnection = resourceURL.openConnection();
            return StringUtil.read((InputStream)urlConnection.getInputStream());
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
            return null;
        }
    }

    public String getResourcePath() {
        return this._resourcePath;
    }

    private ServletPaths(String resourcePath, ServletContext servletContext) {
        this._resourcePath = resourcePath;
        this._servletContext = servletContext;
    }

    private String _normalizePath(String path) {
        if (Validator.isNull((String)path) || "/".equals(path)) {
            return "";
        }
        if (path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        if (path.charAt(0) != '/') {
            path = "/".concat(path);
        }
        return path;
    }
}

