/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.security.ac.AccessControlThreadLocal;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TunnelServlet
extends HttpServlet {
    private static Log _log = LogFactoryUtil.getLog(TunnelServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ObjectInputStream ois;
        try {
            ois = new ObjectInputStream((InputStream)request.getInputStream());
        }
        catch (IOException ioe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)ioe, (Throwable)ioe);
            }
            return;
        }
        Object returnObj = null;
        boolean remoteAccess = AccessControlThreadLocal.isRemoteAccess();
        try {
            AccessControlThreadLocal.setRemoteAccess((boolean)true);
            ObjectValuePair ovp = (ObjectValuePair)ois.readObject();
            MethodHandler methodHandler = (MethodHandler)ovp.getValue();
            if (methodHandler != null) {
                MethodKey methodKey = methodHandler.getMethodKey();
                if (!this.isValidRequest(methodKey.getDeclaringClass())) {
                    return;
                }
                returnObj = methodHandler.invoke();
            }
        }
        catch (InvocationTargetException ite) {
            returnObj = ite.getCause();
            if (!(returnObj instanceof PortalException)) {
                _log.error((Object)ite, (Throwable)ite);
                if (returnObj != null) {
                    Throwable throwable = returnObj;
                    returnObj = new SystemException(throwable.getMessage());
                } else {
                    returnObj = new SystemException();
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        finally {
            AccessControlThreadLocal.setRemoteAccess((boolean)remoteAccess);
        }
        if (returnObj != null) {
            try (ObjectOutputStream oos = new ObjectOutputStream((OutputStream)response.getOutputStream());){
                oos.writeObject(returnObj);
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
                throw ioe;
            }
        }
    }

    protected boolean isValidRequest(Class<?> clazz) {
        String className = clazz.getName();
        return className.contains(".service.") && className.endsWith("ServiceUtil") && !className.endsWith("LocalServiceUtil");
    }
}

