/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.servlet.PortalSessionContext;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.AuthenticatedUserUUIDStoreUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;

public class PortalSessionDestroyer
extends BasePortalLifecycle {
    private static Log _log = LogFactoryUtil.getLog(PortalSessionDestroyer.class);
    private HttpSessionEvent _httpSessionEvent;

    public PortalSessionDestroyer(HttpSessionEvent httpSessionEvent) {
        this._httpSessionEvent = httpSessionEvent;
        this.registerPortalLifecycle(2);
    }

    protected void doPortalDestroy() {
    }

    protected void doPortalInit() {
        if (PropsValues.SESSION_DISABLED) {
            return;
        }
        HttpSession session = this._httpSessionEvent.getSession();
        PortalSessionContext.remove((String)session.getId());
        try {
            String userUUID;
            Long userIdObj = (Long)session.getAttribute("USER_ID");
            if (userIdObj == null && _log.isWarnEnabled()) {
                _log.warn((Object)"User id is not in the session");
            }
            if (userIdObj == null) {
                return;
            }
            session.removeAttribute("org.apache.struts.action.LOCALE");
            if (PropsValues.LIVE_USERS_ENABLED) {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                ClusterNode clusterNode = ClusterExecutorUtil.getLocalClusterNode();
                if (clusterNode != null) {
                    jsonObject.put("clusterNodeId", clusterNode.getClusterNodeId());
                }
                jsonObject.put("command", "signOut");
                long userId = userIdObj;
                long companyId = CompanyLocalServiceUtil.getCompanyIdByUserId((long)userId);
                jsonObject.put("companyId", companyId);
                jsonObject.put("sessionId", session.getId());
                jsonObject.put("userId", userId);
                MessageBusUtil.sendMessage((String)"liferay/live_users", (Object)jsonObject.toString());
            }
            if (Validator.isNotNull((String)(userUUID = (String)session.getAttribute("USER_UUID")))) {
                AuthenticatedUserUUIDStoreUtil.unregister((String)userUUID);
            }
        }
        catch (IllegalStateException ise) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Please upgrade to a Servlet 2.4 compliant container");
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            EventsProcessorUtil.process("servlet.session.destroy.events", PropsValues.SERVLET_SESSION_DESTROY_EVENTS, session);
        }
        catch (ActionException ae) {
            _log.error((Object)ae, (Throwable)ae);
        }
    }
}

