/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.security.auth.TransientTokenUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LuceneServlet
extends HttpServlet {
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathInfo = GetterUtil.getString((String)request.getPathInfo());
        if (!pathInfo.equals("/dump")) {
            response.sendError(404);
            return;
        }
        String transientToken = ParamUtil.getString((HttpServletRequest)request, (String)"transientToken");
        if (Validator.isNull((String)transientToken)) {
            response.sendError(403);
            return;
        }
        if (!TransientTokenUtil.checkToken(transientToken)) {
            response.sendError(401);
            return;
        }
        long companyId = ParamUtil.getLong((HttpServletRequest)request, (String)"companyId");
        if (companyId < 0L) {
            response.sendError(400);
            return;
        }
        if (companyId != 0L) {
            try {
                CompanyLocalServiceUtil.getCompanyById((long)companyId);
            }
            catch (Exception e) {
                response.sendError(400);
                return;
            }
        }
        LuceneHelperUtil.dumpIndex(companyId, (OutputStream)response.getOutputStream());
    }
}

